/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IDataScriptEngine;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.script.IDataSourceInstanceHandle;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.JointDataSetQuery;
import org.eclipse.birt.data.engine.executor.dscache.CandidateQuery;
import org.eclipse.birt.data.engine.executor.dscache.DataSourceQuery;
import org.eclipse.birt.data.engine.expression.CompareHints;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.expression.ExpressionProcessor;
import org.eclipse.birt.data.engine.impl.ColumnBindingMetaData;
import org.eclipse.birt.data.engine.impl.ColumnInfo;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSetDesignHelper;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.eclipse.birt.data.engine.impl.ExecutorHelper;
import org.eclipse.birt.data.engine.impl.FilterByRow;
import org.eclipse.birt.data.engine.impl.GroupComputedColumn;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.IFilterByRow;
import org.eclipse.birt.data.engine.impl.IQueryContextVisitor;
import org.eclipse.birt.data.engine.impl.IQueryExecutor;
import org.eclipse.birt.data.engine.impl.IQueryOptimizeHints;
import org.eclipse.birt.data.engine.impl.IQueryService;
import org.eclipse.birt.data.engine.impl.IServiceForQueryResults;
import org.eclipse.birt.data.engine.impl.ParameterUtil;
import org.eclipse.birt.data.engine.impl.QueryExecutorUtil;
import org.eclipse.birt.data.engine.impl.QueryResults;
import org.eclipse.birt.data.engine.impl.SortingOptimizer;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateTable;
import org.eclipse.birt.data.engine.impl.group.GroupCalculatorFactory;
import org.eclipse.birt.data.engine.odi.ICandidateQuery;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IPreparedDSQuery;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObjectEvent;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.script.JSCubeBindingObject;
import org.eclipse.birt.data.engine.script.OnFetchScriptHelper;
import org.mozilla.javascript.Scriptable;

public abstract class QueryExecutor
implements IQueryExecutor {
    protected IBaseQueryDefinition baseQueryDefn;
    private AggregateTable aggrTable;
    private Scriptable sharedScope;
    private Scriptable parentScope;
    private Scriptable queryScope;
    private boolean isPrepared = false;
    private boolean isExecuted = false;
    protected boolean loadFromCache;
    protected boolean ignoreDataSetFilter = false;
    private Map queryAppContext;
    private int nestedLevel = 1;
    protected DataSourceRuntime dataSource;
    protected DataSetRuntime dataSet;
    protected IDataSource odiDataSource;
    protected IQuery odiQuery;
    protected IQueryService tabularOuterResults;
    private IResultIterator odiResult;
    private IExecutorHelper parentHelper;
    private DataEngineSession session;
    protected List temporaryComputedColumns = new ArrayList();
    private static Logger logger = Logger.getLogger(QueryExecutor.class.getName());
    protected IQueryContextVisitor contextVisitor;

    QueryExecutor(Scriptable sharedScope, IBaseQueryDefinition baseQueryDefn, AggregateTable aggrTable, DataEngineSession session, IQueryContextVisitor contextVisitor) {
        Object[] params = new Object[]{sharedScope, baseQueryDefn, aggrTable, session};
        logger.entering(QueryExecutor.class.getName(), "QueryExecutor", params);
        this.sharedScope = sharedScope;
        this.baseQueryDefn = baseQueryDefn;
        this.aggrTable = aggrTable;
        this.session = session;
        this.contextVisitor = contextVisitor;
        logger.exiting(QueryExecutor.class.getName(), "QueryExecutor");
    }

    @Override
    public IQueryContextVisitor getQueryContextVisitor() {
        return this.contextVisitor;
    }

    protected abstract DataSourceRuntime findDataSource() throws DataException;

    protected abstract DataSetRuntime newDataSetRuntime() throws DataException;

    protected abstract IDataSource createOdiDataSource() throws DataException;

    protected abstract IQuery createOdiQuery() throws DataException;

    protected void prepareOdiQuery() throws DataException {
    }

    protected void dataSourceBeforeOpen() throws DataException {
        if (!this.loadFromCache) {
            this.dataSource.beforeOpen();
        }
    }

    protected void dataSourceAfterOpen() throws DataException {
        if (!this.loadFromCache) {
            this.dataSource.afterOpen();
        }
    }

    protected void dataSetBeforeOpen() throws DataException {
        if (!this.loadFromCache) {
            this.dataSet.beforeOpen();
        }
    }

    protected void dataSetAfterOpen() throws DataException {
        if (!this.loadFromCache) {
            this.dataSet.afterOpen();
        }
    }

    protected void dataSetBeforeClose() throws DataException {
        if (!this.loadFromCache) {
            this.dataSet.beforeClose();
        }
    }

    protected void dataSetAfterClose() throws DataException {
        if (!this.loadFromCache) {
            this.dataSet.afterClose();
        }
    }

    protected abstract IResultIterator executeOdiQuery(IEventHandler var1) throws DataException;

    void setAppContext(Map context) {
        this.queryAppContext = context;
    }

    void prepareExecution(IBaseQueryResults outerRts, Scriptable targetScope) throws DataException {
        if (this.isPrepared) {
            return;
        }
        this.parentScope = targetScope;
        this.dataSource = this.findDataSource();
        if (outerRts != null && (outerRts instanceof IQueryService || outerRts instanceof ICubeQueryResults)) {
            IExecutorHelper helper;
            if (outerRts instanceof IQueryService) {
                this.tabularOuterResults = (IQueryService)((Object)outerRts);
                if (this.tabularOuterResults.isClosed()) {
                    throw new DataException("data.engine.ResultClosed");
                }
                this.nestedLevel = this.tabularOuterResults.getNestedLevel();
                helper = this.tabularOuterResults.getExecutorHelper();
                this.setParentExecutorHelper(helper);
            } else if (outerRts instanceof ICubeQueryResults) {
                helper = new ExecutorHelper(null);
                helper.setScriptable((Scriptable)new JSCubeBindingObject(((ICubeQueryResults)outerRts).getCubeCursor()));
                this.setParentExecutorHelper(helper);
            }
        }
        this.dataSet = this.newDataSetRuntime();
        assert (this.dataSet != null);
        this.initializeCollator();
        this.loadFromCache = this.loadFromCache();
        this.dataSet.setFromCache(this.loadFromCache);
        this.openDataSource();
        this.dataSetBeforeOpen();
        this.odiQuery = this.createOdiQuery();
        this.odiQuery.setDistinctValueFlag(this.dataSet.needDistinctValue());
        this.odiQuery.setQueryDefinition(this.baseQueryDefn);
        this.odiQuery.setExprProcessor(new ExpressionProcessor(this.dataSet));
        this.populateOdiQuery();
        if (this.dataSet.getDesign() != null) {
            BaseQuery bq;
            List fetchEvents;
            boolean filterPresent = false;
            if (this.odiQuery instanceof BaseQuery && (fetchEvents = (bq = (BaseQuery)this.odiQuery).getFetchEvents()) != null) {
                for (Object e : fetchEvents) {
                    if (!(e instanceof IFilterByRow)) continue;
                    filterPresent = true;
                    break;
                }
            }
            if (!filterPresent) {
                this.odiQuery.setRowFetchLimit(this.dataSet.getDesign().getRowFetchLimit());
            }
        }
        try {
            this.prepareOdiQuery();
        }
        catch (DataException e) {
            throw new DataException("data.engine.fail.prepareExecution", (Throwable)((Object)e), this.dataSet.getName());
        }
        this.isPrepared = true;
    }

    protected abstract String getDataSetName();

    private void initializeCollator() throws DataException {
        IBaseDataSetDesign design;
        if (this.session != null && (design = ((DataEngineImpl)this.session.getEngine()).getDataSetDesign(this.getDataSetName())) != null) {
            String nullOrdering = design.getNullsOrdering();
            Collator collator = design.getCompareLocale() == null ? null : Collator.getInstance((ULocale)design.getCompareLocale());
            this.dataSet.setCompareLocale(collator);
            this.dataSet.setNullest(nullOrdering);
            this.dataSet.getScriptScope().put("compare_locale", this.dataSet.getScriptScope(), (Object)collator);
        }
    }

    private boolean loadFromCache() throws DataException {
        if (this.dataSource == null) {
            return false;
        }
        if (!(this.baseQueryDefn instanceof IQueryDefinition)) {
            return false;
        }
        return this.session.getDataSetCacheManager().doesLoadFromCache(((DataEngineImpl)this.session.getEngine()).getDataSourceDesign(this.dataSet.getDesign().getDataSourceName()), this.dataSet.getDesign(), new ParameterUtil(this.tabularOuterResults == null ? null : this.tabularOuterResults.getQueryScope(), this.dataSet, (IQueryDefinition)this.baseQueryDefn, this.getQueryScope(), this.session.getEngineContext().getScriptContext()).resolveDataSetParameters(true), this.queryAppContext);
    }

    protected void openDataSource() throws DataException {
        assert (this.odiDataSource == null);
        if (this.dataSource != null) {
            if (!this.dataSource.isOpen()) {
                this.dataSourceBeforeOpen();
                this.odiDataSource = this.createOdiDataSource();
                this.odiDataSource.setAppContext(this.queryAppContext);
                this.dataSource.openOdiDataSource(this.odiDataSource);
                this.dataSourceAfterOpen();
            } else if (this.session.getDataSetCacheManager().needsToCache()) {
                this.odiDataSource = this.createOdiDataSource();
                this.odiDataSource.setAppContext(this.queryAppContext);
                this.dataSource.openOdiDataSource(this.odiDataSource);
            } else {
                this.odiDataSource = this.dataSource.getOdiDataSource();
                this.odiDataSource.setAppContext(this.queryAppContext);
            }
        }
    }

    protected void populateOdiQuery() throws DataException {
        assert (this.odiQuery != null);
        assert (this.baseQueryDefn != null);
        SortingOptimizer opt = new SortingOptimizer(this.dataSet.getDesign(), this.baseQueryDefn);
        this.populateGrouping(this.session.getEngineContext().getScriptContext(), opt);
        this.populateSorting(opt);
        this.populateFetchEvent(this.session.getEngineContext().getScriptContext());
        this.odiQuery.setMaxRows(this.baseQueryDefn.getMaxRows());
        this.prepareCacheQuery(this.odiQuery);
    }

    protected void prepareCacheQuery(IQuery odiQuery) {
        if (this.temporaryComputedColumns != null && this.temporaryComputedColumns.size() > 0) {
            if (odiQuery instanceof DataSourceQuery) {
                ((DataSourceQuery)odiQuery).setTempComputedColumn(this.temporaryComputedColumns);
            } else if (odiQuery instanceof CandidateQuery) {
                ((CandidateQuery)odiQuery).setTempComputedColumn(this.temporaryComputedColumns);
            }
        }
    }

    private void populateGrouping(ScriptContext cx, SortingOptimizer opt) throws DataException {
        List groups = this.baseQueryDefn.getGroups();
        if (groups != null && !groups.isEmpty()) {
            IQuery.GroupSpec[] groupSpecs = new IQuery.GroupSpec[groups.size()];
            Iterator it = groups.iterator();
            int i = 0;
            while (it.hasNext()) {
                IQuery.GroupSpec dest;
                IGroupDefinition src = (IGroupDefinition)it.next();
                this.validateGroupExpression(src);
                String expr = this.getDataSetGroupKeyExpression(src);
                String groupName = this.populateGroupName(i, expr);
                int dataType = this.getColumnDataType(cx, this.getGroupKeyExpression(src));
                boolean doGroupSorting = false;
                doGroupSorting = this.session.getEngineContext().getMode() == 4 ? true : (src.getSortDirection() == -1 ? false : this.baseQueryDefn.getQueryExecutionHints().doSortBeforeGrouping());
                groupSpecs[i] = dest = QueryExecutorUtil.groupDefnToSpec(cx, src, expr, groupName, -1, dataType, doGroupSorting);
                this.temporaryComputedColumns.add(this.getComputedColumnInstance(cx, groupSpecs[i].getInterval(), src, expr, groupName, dest, dataType));
                ++i;
            }
            if (opt.acceptGroupSorting()) {
                i = 0;
                while (i < groupSpecs.length) {
                    IQuery.GroupSpec spec = groupSpecs[i];
                    spec.setSortDirection(-1);
                    ++i;
                }
            }
            this.odiQuery.setGrouping(Arrays.asList(groupSpecs));
        }
    }

    private void validateGroupExpression(IGroupDefinition src) throws DataException {
        if (!(src.getKeyColumn() != null && src.getKeyColumn().trim().length() != 0 || src.getKeyExpression() != null && src.getKeyExpression().trim().length() != 0)) {
            throw new DataException("data.engine.BadGroupExpr");
        }
    }

    private String populateGroupName(int i, String expr) {
        String groupName = expr.trim().equalsIgnoreCase("row[0]") || expr.trim().equalsIgnoreCase("row._rowPosition") || expr.trim().equalsIgnoreCase("dataSetRow[0]") || expr.trim().equalsIgnoreCase("dataSetRow._rowPosition") ? "_{$TEMP_GROUP_" + i + "ROWID$}_" : "_{$TEMP_GROUP_" + i + "$}_";
        return groupName;
    }

    private IComputedColumn getComputedColumnInstance(ScriptContext cx, int interval, IGroupDefinition src, String expr, String groupName, IQuery.GroupSpec dest, int dataType) throws DataException {
        if (dest.getInterval() != 0) {
            return new GroupComputedColumn(groupName, expr, dataType == 4 ? dataType : QueryExecutorUtil.getTempComputedColumnType(interval), GroupCalculatorFactory.getGroupCalculator(src.getInterval(), src.getIntervalStart(), src.getIntervalRange(), dataType, this.session.getEngineContext().getLocale(), this.session.getEngineContext().getTimeZone()));
        }
        return new ComputedColumn(groupName, expr, dataType);
    }

    private void populateSorting(SortingOptimizer opt) throws DataException {
        if (opt.acceptQuerySorting()) {
            return;
        }
        this.populateQuerySorting();
    }

    private void populateQuerySorting() throws DataException {
        List sorts = this.baseQueryDefn.getSorts();
        if (sorts != null && !sorts.isEmpty()) {
            IQuery.SortSpec[] sortSpecs = new IQuery.SortSpec[sorts.size()];
            Iterator it = sorts.iterator();
            int i = 0;
            while (it.hasNext()) {
                IQuery.SortSpec dest;
                ISortDefinition src = (ISortDefinition)it.next();
                int sortIndex = -1;
                String sortKey = src.getColumn();
                sortKey = sortKey == null ? src.getExpression().getText() : this.getColumnRefExpression(sortKey);
                String dataSetExpr = this.getDataSetExpr(sortKey);
                this.temporaryComputedColumns.add(new ComputedColumn("_{$TEMP_SORT_" + i + "$}_", dataSetExpr == null ? sortKey : dataSetExpr, this.getExpressionDataType(sortKey)));
                sortIndex = -1;
                sortKey = String.valueOf("_{$TEMP_SORT_" + i + "$}_");
                sortSpecs[i] = dest = new IQuery.SortSpec(sortIndex, sortKey, src.getSortDirection() == 0, (Comparator)this.createCollator(src));
                ++i;
            }
            this.odiQuery.setOrdering(Arrays.asList(sortSpecs));
        }
    }

    private Collator createCollator(ISortDefinition sd) {
        if (sd.getSortStrength() != -1) {
            Collator c = Collator.getInstance((ULocale)(sd.getSortLocale() == null ? this.session.getEngineContext().getLocale() : sd.getSortLocale()));
            c.setStrength(sd.getSortStrength());
            return c;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDataSetExpr(String rowExpr) throws DataException {
        Object binding;
        String dataSetExpr;
        block3: {
            dataSetExpr = null;
            try {
                String bindingName = ExpressionUtil.getColumnBindingName((String)rowExpr);
                binding = this.baseQueryDefn.getBindings().get(bindingName);
                if (binding == null) return dataSetExpr;
                if (((IBinding)binding).getAggrFunction() == null) break block3;
                return null;
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
        IBaseExpression expr = ((IBinding)binding).getExpression();
        if (expr == null) return dataSetExpr;
        if (!(expr instanceof IScriptExpression)) return dataSetExpr;
        return ((IScriptExpression)expr).getText();
    }

    private int getExpressionDataType(String expression) throws DataException {
        Object binding;
        block10: {
            String bindingName;
            block9: {
                block8: {
                    block7: {
                        try {
                            if (expression != null) break block7;
                            return 0;
                        }
                        catch (BirtException e) {
                            throw DataException.wrap(e);
                        }
                    }
                    bindingName = ExpressionUtil.getColumnBindingName((String)expression);
                    if (bindingName != null) break block8;
                    return 0;
                }
                if (!bindingName.equals("__rownum")) break block9;
                return 2;
            }
            binding = this.baseQueryDefn.getBindings().get(bindingName);
            if (binding != null) break block10;
            return 0;
        }
        int dataType = ((IBinding)binding).getDataType();
        if (dataType != -1) {
            return dataType;
        }
        return 0;
    }

    private void populateFetchEvent(ScriptContext cx) throws DataException {
        IResultObjectEvent objectEvent;
        List<IColumnDefinition> trimmedColumns;
        List filters;
        ArrayList<IFilterDefinition> dataSetFilters = new ArrayList<IFilterDefinition>();
        ArrayList<IFilterDefinition> queryFilters = new ArrayList<IFilterDefinition>();
        ArrayList<IFilterDefinition> aggrFilters = new ArrayList<IFilterDefinition>();
        ArrayList<IFilterDefinition> aggrNoUpdateFilters = new ArrayList<IFilterDefinition>();
        ArrayList<IFilterDefinition> dataSetAggrFilters = new ArrayList<IFilterDefinition>();
        if (this.dataSet.getFilters() != null && !this.ignoreDataSetFilter) {
            Map<String, IBinding> bindings = this.createBindingFromComputedColumn(this.dataSet.getComputedColumns());
            int i = 0;
            while (i < this.dataSet.getFilters().size()) {
                if (((IFilterDefinition)this.dataSet.getFilters().get(i)).updateAggregation()) {
                    if (QueryExecutorUtil.isAggrFilter((IFilterDefinition)this.dataSet.getFilters().get(i), bindings)) {
                        dataSetAggrFilters.add((IFilterDefinition)this.dataSet.getFilters().get(i));
                    } else {
                        dataSetFilters.add((IFilterDefinition)this.dataSet.getFilters().get(i));
                    }
                }
                ++i;
            }
        }
        if ((filters = this.baseQueryDefn.getFilters()) != null) {
            Map bindings = this.baseQueryDefn.getBindings();
            int i = 0;
            while (i < filters.size()) {
                IFilterDefinition filter = (IFilterDefinition)filters.get(i);
                if (!this.ignoreDataSetFilter || !IFilterDefinition.FilterTarget.DATASET.equals((Object)filter.getFilterTarget())) {
                    if (!QueryExecutorUtil.isValidFilterExpression(filter.getExpression(), bindings, this.session.getEngineContext().getScriptContext())) {
                        String expression = filter.getExpression().toString();
                        if (filter.getExpression() instanceof IScriptExpression) {
                            expression = ((IScriptExpression)filter.getExpression()).getText();
                        } else if (filter.getExpression() instanceof IConditionalExpression) {
                            expression = ((IConditionalExpression)filter.getExpression()).getExpression().getText();
                        }
                        throw new DataException("data.engine.BadFilterDefn", new Object[]{expression});
                    }
                    if (!filter.updateAggregation()) {
                        aggrNoUpdateFilters.add(filter);
                    } else if (QueryExecutorUtil.isAggrFilter(filter, bindings)) {
                        aggrFilters.add(filter);
                    } else {
                        queryFilters.add(filter);
                    }
                }
                ++i;
            }
        }
        List multipassFilters = this.prepareFilters(cx, dataSetFilters, queryFilters, this.temporaryComputedColumns);
        ArrayList computedColumns = null;
        computedColumns = this.dataSet.getComputedColumns();
        if (computedColumns == null) {
            computedColumns = new ArrayList();
        }
        if (computedColumns.size() > 0 && this.getAppContext() != null && this.getAppContext().containsKey("org.eclipse.birt.data.internal.optimize.hints") && (trimmedColumns = ((IQueryOptimizeHints)this.getAppContext().get("org.eclipse.birt.data.internal.optimize.hints")).getTrimmedColumns().get(this.dataSet.getName())) != null) {
            HashSet<String> trimmedNames = new HashSet<String>();
            for (IColumnDefinition col : trimmedColumns) {
                trimmedNames.add(col.getColumnName());
            }
            ArrayList toBeRemovedComputedColumns = new ArrayList();
            int i = 0;
            while (i < computedColumns.size()) {
                if (trimmedNames.contains(((IComputedColumn)computedColumns.get(i)).getName())) {
                    toBeRemovedComputedColumns.add(computedColumns.get(i));
                }
                ++i;
            }
            computedColumns.removeAll(toBeRemovedComputedColumns);
        }
        if (computedColumns.size() > 0 || this.temporaryComputedColumns.size() > 0) {
            objectEvent = new ComputedColumnHelper(this.dataSet, computedColumns, this.temporaryComputedColumns, cx);
            this.odiQuery.addOnFetchEvent(objectEvent);
            this.dataSet.getComputedColumns().addAll(this.temporaryComputedColumns);
        }
        if (this.dataSet.getEventHandler() != null) {
            OnFetchScriptHelper event = new OnFetchScriptHelper(this.dataSet);
            this.odiQuery.addOnFetchEvent(event);
        }
        if (dataSetFilters.size() + queryFilters.size() + multipassFilters.size() + aggrFilters.size() + dataSetAggrFilters.size() + aggrNoUpdateFilters.size() > 0) {
            objectEvent = new FilterByRow(dataSetFilters, queryFilters, multipassFilters, aggrFilters, dataSetAggrFilters, aggrNoUpdateFilters, this.dataSet);
            this.odiQuery.addOnFetchEvent(objectEvent);
        }
    }

    private Map<String, IBinding> createBindingFromComputedColumn(List computedColumns) throws DataException {
        HashMap<String, IBinding> result = new HashMap<String, IBinding>();
        if (computedColumns == null || computedColumns.size() == 0) {
            return result;
        }
        for (Object computedColumn : computedColumns) {
            IComputedColumn cc = (IComputedColumn)computedColumn;
            Binding binding = new Binding(cc.getName());
            binding.setExpression(cc.getExpression());
            binding.setAggrFunction(cc.getAggregateFunction());
            result.put(cc.getName(), binding);
        }
        return result;
    }

    private int getColumnDataType(ScriptContext cx, String expr) throws DataException {
        String columnName = QueryExecutorUtil.getColInfoFromJSExpr(cx, expr).getColumnName();
        if (columnName == null) {
            return -1;
        }
        if (columnName.equals("__rownum")) {
            return 2;
        }
        Object baseExpr = this.baseQueryDefn.getBindings().get(columnName);
        if (baseExpr == null) {
            return -1;
        }
        int dataType = ((IBinding)baseExpr).getDataType();
        if (dataType == -1) {
            return 0;
        }
        return dataType;
    }

    private String getDataSetGroupKeyExpression(IGroupDefinition src) {
        String dataSetExpr;
        String expr = this.getGroupKeyExpression(src);
        try {
            dataSetExpr = this.getDataSetExpr(expr);
        }
        catch (DataException dataException) {
            dataSetExpr = null;
        }
        try {
            if ("dataSetRow._rowPosition".equals(dataSetExpr)) {
                return expr;
            }
            if (dataSetExpr != null && ExpressionUtil.getColumnName((String)dataSetExpr) != null) {
                return dataSetExpr;
            }
        }
        catch (BirtException birtException) {}
        return expr;
    }

    private String getGroupKeyExpression(IGroupDefinition src) {
        String expr = src.getKeyColumn();
        expr = expr == null ? src.getKeyExpression() : this.getColumnRefExpression(expr);
        return expr;
    }

    private String getColumnRefExpression(String expr) {
        return ExpressionUtil.createJSRowExpression((String)expr);
    }

    void setParentExecutorHelper(IExecutorHelper helper) {
        this.parentHelper = helper;
    }

    private List prepareFilters(ScriptContext cx, List dataSetFilters, List queryFilters, List temporaryComputedColumns) throws DataException {
        ArrayList result = new ArrayList();
        this.prepareFilter(cx, dataSetFilters, temporaryComputedColumns, result);
        this.prepareFilter(cx, queryFilters, temporaryComputedColumns, result);
        return result;
    }

    private void prepareFilter(ScriptContext cx, List dataSetFilters, List temporaryComputedColumns, List result) throws DataException {
        if (dataSetFilters != null && !dataSetFilters.isEmpty()) {
            Iterator it = dataSetFilters.iterator();
            while (it.hasNext()) {
                IFilterDefinition src = (IFilterDefinition)it.next();
                IBaseExpression expr = src.getExpression();
                if (!this.isGroupFilter(src)) continue;
                ConditionalExpression ce = (ConditionalExpression)expr;
                String exprText = ce.getExpression().getText();
                ColumnInfo columnInfo = QueryExecutorUtil.getColInfoFromJSExpr(cx, exprText);
                int index = columnInfo.getColumnIndex();
                String name = columnInfo.getColumnName();
                if (name != null || index >= 0) continue;
                int currentIndex = result.size();
                temporaryComputedColumns.add(new ComputedColumn("_{$TEMP_FILTER_" + currentIndex + "$}_", exprText, 0));
                it.remove();
                result.add(new FilterDefinition(new ConditionalExpression(new ScriptExpression(String.valueOf("dataSetRow[\"_{$TEMP_FILTER_" + currentIndex + "$}_\"]")), ce.getOperator(), ce.getOperand1(), ce.getOperand2())));
            }
        }
    }

    private boolean isGroupFilter(IFilterDefinition filter) throws DataException {
        IBaseExpression expr = filter.getExpression();
        if (expr instanceof IConditionalExpression) {
            if (!ExpressionCompilerUtil.isValidExpressionInQueryFilter(expr, this.session.getEngineContext().getScriptContext())) {
                throw new DataException("data.engine.BadFilterDefn", new Object[]{((IConditionalExpression)expr).getExpression().getText()});
            }
            try {
                if (this.odiQuery instanceof BaseQuery) {
                    return ((BaseQuery)this.odiQuery).getExprProcessor().hasAggregation(expr);
                }
            }
            catch (DataException dataException) {
                return true;
            }
        }
        return false;
    }

    @Override
    public IResultMetaData getResultMetaData() throws DataException {
        assert (this.odiQuery instanceof IPreparedDSQuery || this.odiQuery instanceof ICandidateQuery || this.odiQuery instanceof JointDataSetQuery);
        if (this.odiQuery instanceof IPreparedDSQuery) {
            if (((IPreparedDSQuery)((Object)this.odiQuery)).getResultClass() != null) {
                return new ColumnBindingMetaData(this.baseQueryDefn, ((IPreparedDSQuery)((Object)this.odiQuery)).getResultClass());
            }
            return null;
        }
        if (this.odiQuery instanceof JointDataSetQuery) {
            return new ColumnBindingMetaData(this.baseQueryDefn, ((JointDataSetQuery)this.odiQuery).getResultClass());
        }
        IResultMetaData meta = DataSetDesignHelper.getResultMetaData(this.baseQueryDefn, this.odiQuery);
        if (meta == null) {
            return new ColumnBindingMetaData(this.baseQueryDefn, ((ICandidateQuery)this.odiQuery).getResultClass());
        }
        return meta;
    }

    @Override
    public IResultClass getOdiResultClass() throws DataException {
        assert (this.odiQuery instanceof IPreparedDSQuery || this.odiQuery instanceof ICandidateQuery || this.odiQuery instanceof JointDataSetQuery);
        if (this.odiQuery instanceof IPreparedDSQuery) {
            return ((IPreparedDSQuery)((Object)this.odiQuery)).getResultClass();
        }
        if (this.odiQuery instanceof JointDataSetQuery) {
            return ((JointDataSetQuery)this.odiQuery).getResultClass();
        }
        IResultClass resultClass = DataSetDesignHelper.getResultClass(this.odiQuery);
        if (resultClass != null) {
            return resultClass;
        }
        return ((ICandidateQuery)this.odiQuery).getResultClass();
    }

    @Override
    public void execute(IEventHandler eventHandler) throws DataException {
        logger.logp(Level.FINER, QueryExecutor.class.getName(), "execute", "Start to execute");
        if (this.isExecuted) {
            return;
        }
        ExecutorHelper helper = new ExecutorHelper(this.parentHelper);
        eventHandler.setExecutorHelper(helper);
        if (eventHandler.getAppContext() != null && this.dataSet.getDesign() != null && this.dataSet.getSession() != null) {
            String nullOrdering = this.dataSet.getDesign().getNullsOrdering();
            Collator collator = this.dataSet.getDesign().getCompareLocale() == null ? null : Collator.getInstance((ULocale)this.dataSet.getDesign().getCompareLocale());
            eventHandler.getAppContext().put("org.eclipse.birt.data.engine.expression.compareHints", new CompareHints((Comparator)collator, nullOrdering));
        }
        this.odiResult = this.executeOdiQuery(eventHandler);
        helper.setScriptable(this.dataSet.getJSResultRowObject());
        this.resetComputedColumns();
        this.dataSet.setResultSet(this.odiResult, false);
        this.isExecuted = true;
        logger.logp(Level.FINER, QueryExecutor.class.getName(), "execute", "Finish executing");
    }

    private void resetComputedColumns() {
        List l = this.getDataSet().getComputedColumns();
        if (l != null) {
            l.removeAll(this.temporaryComputedColumns);
        }
    }

    @Override
    public void close() {
        if (this.odiQuery == null) {
            logger.logp(Level.FINER, QueryExecutor.class.getName(), "close", "executor closed ");
            return;
        }
        try {
            this.dataSetBeforeClose();
        }
        catch (DataException e) {
            logger.logp(Level.FINE, QueryExecutor.class.getName(), "close", e.getMessage(), (Throwable)((Object)e));
        }
        if (this.odiResult != null) {
            try {
                this.odiResult.close();
            }
            catch (DataException e1) {
                e1.printStackTrace();
            }
        }
        this.odiQuery.close();
        try {
            this.dataSet.close();
        }
        catch (DataException e) {
            logger.logp(Level.FINE, QueryExecutor.class.getName(), "close", e.getMessage(), (Throwable)((Object)e));
        }
        this.odiQuery = null;
        this.odiDataSource = null;
        this.odiResult = null;
        this.queryScope = null;
        this.isPrepared = false;
        this.isExecuted = false;
        try {
            this.dataSetAfterClose();
        }
        catch (DataException e) {
            logger.logp(Level.FINE, QueryExecutor.class.getName(), "close", e.getMessage(), (Throwable)((Object)e));
        }
        this.dataSet = null;
        this.dataSource = null;
        logger.logp(Level.FINER, QueryExecutor.class.getName(), "close", "executor closed ");
    }

    @Override
    public DataSetRuntime getDataSet() {
        return this.dataSet;
    }

    @Override
    public Scriptable getSharedScope() {
        return this.sharedScope;
    }

    @Override
    public Scriptable getQueryScope() throws DataException {
        try {
            if (this.queryScope == null) {
                this.queryScope = this.newSubScope(this.parentScope);
                this.queryScope.setPrototype(this.dataSet.getJSDataSetObject());
            }
            return this.queryScope;
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    private Scriptable newSubScope(Scriptable parentAndProtoScope) throws BirtException {
        if (parentAndProtoScope == null) {
            parentAndProtoScope = this.sharedScope;
        }
        Scriptable scope = ((IDataScriptEngine)this.session.getEngineContext().getScriptContext().getScriptEngine("javascript")).getJSContext(this.session.getEngineContext().getScriptContext()).newObject(parentAndProtoScope);
        scope.setParentScope(parentAndProtoScope);
        scope.setPrototype(parentAndProtoScope);
        return scope;
    }

    @Override
    public int getNestedLevel() {
        return this.nestedLevel;
    }

    @Override
    public IDataSourceInstanceHandle getDataSourceInstanceHandle() {
        return this.dataSource;
    }

    @Override
    public Scriptable getJSAggrValueObject() {
        return this.aggrTable.getJSAggrValueObject();
    }

    @Override
    public DataSetRuntime[] getNestedDataSets(int nestedCount) {
        return this.tabularOuterResults == null ? null : this.tabularOuterResults.getDataSetRuntime(nestedCount);
    }

    @Override
    public IResultIterator getOdiResultSet() {
        return this.odiResult;
    }

    protected Collection resolveDataSetParameters(boolean evaluateValue) throws DataException {
        return new ParameterUtil(this.tabularOuterResults == null ? null : this.tabularOuterResults.getQueryScope(), this.getDataSet(), (IQueryDefinition)this.baseQueryDefn, this.getQueryScope(), this.session.getEngineContext().getScriptContext()).resolveDataSetParameters(evaluateValue);
    }

    @Override
    public Map getAppContext() {
        return this.queryAppContext;
    }

    @Override
    public DataEngineSession getSession() {
        return this.session;
    }

    public QueryResults buildQueryResults(IServiceForQueryResults serviceForQueryResults) {
        return null;
    }
}

