/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.ICombinedOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.expression.NamedExpression;
import org.eclipse.birt.data.engine.impl.CombinedOdaDataSetAdapter;
import org.eclipse.birt.data.engine.impl.ConfigFileParser;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataSetDesignHelper;
import org.eclipse.birt.data.engine.impl.DummyPreparedQuery;
import org.eclipse.birt.data.engine.impl.FilterPrepareUtil;
import org.eclipse.birt.data.engine.impl.IIncreCacheDataSetDesign;
import org.eclipse.birt.data.engine.impl.IQueryContextVisitor;
import org.eclipse.birt.data.engine.impl.IQueryOptimizeHints;
import org.eclipse.birt.data.engine.impl.IncreCacheDataSetAdapter;
import org.eclipse.birt.data.engine.impl.JointDataSetAdapter;
import org.eclipse.birt.data.engine.impl.OdaDataSetAdapter;
import org.eclipse.birt.data.engine.impl.PreparedCombinedOdaDSQuery;
import org.eclipse.birt.data.engine.impl.PreparedDummyQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVDataExtractionQuery;
import org.eclipse.birt.data.engine.impl.PreparedIncreCacheDSQuery;
import org.eclipse.birt.data.engine.impl.PreparedJointDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedOdaDSQuery;
import org.eclipse.birt.data.engine.impl.PreparedScriptDSQuery;
import org.eclipse.birt.data.engine.impl.QueryCompUtil;
import org.eclipse.birt.data.engine.impl.QueryContextVisitorUtil;
import org.eclipse.birt.data.engine.impl.QueryDefinitionUtil;
import org.eclipse.birt.data.engine.impl.QueryPrepareUtil;
import org.eclipse.birt.data.engine.impl.ScriptDataSetAdapter;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDLoad;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

public class PreparedQueryUtil {
    private static final int BASED_ON_DATASET = 2;
    private static final int BASED_ON_PRESENTATION = 3;
    private static Logger logger = Logger.getLogger(PreparedQueryUtil.class.getName());

    public static IPreparedQuery newInstance(DataEngineImpl dataEngine, IQueryDefinition queryDefn, Map appContext) throws DataException {
        assert (dataEngine != null);
        assert (queryDefn != null);
        if (queryDefn.getDistinctValue()) {
            PreparedQueryUtil.addAllBindingAsSortKey(queryDefn);
        }
        PreparedQueryUtil.optimizeForTransientQuery(appContext, queryDefn);
        PreparedQueryUtil.validateQuery(dataEngine, queryDefn);
        FilterPrepareUtil.prepareFilters(queryDefn, dataEngine.getContext().getScriptContext());
        IQueryContextVisitor contextVisitor = QueryContextVisitorUtil.createQueryContextVisitor(queryDefn, appContext);
        if (queryDefn.getSourceQuery() != null) {
            IBaseDataSetDesign dset;
            IPreparedQuery preparedQuery;
            if (queryDefn.getSourceQuery() instanceof IQueryDefinition && (preparedQuery = QueryPrepareUtil.preparePresentationQuery(dataEngine, queryDefn, dset = PreparedQueryUtil.cloneDataSetDesign(dataEngine.getDataSetDesign(((IQueryDefinition)queryDefn.getSourceQuery()).getDataSetName()), appContext), appContext, contextVisitor)) != null) {
                return preparedQuery;
            }
            return new PreparedIVDataExtractionQuery(dataEngine, queryDefn, appContext, contextVisitor);
        }
        IPreparedQuery preparedQuery = null;
        IBaseDataSetDesign dset = PreparedQueryUtil.cloneDataSetDesign(dataEngine.getDataSetDesign(queryDefn.getDataSetName()), appContext);
        if (queryDefn.getQueryResultsID() != null && !dataEngine.getContext().isDashBoardEnabled()) {
            if (dataEngine.getSession().getEngineContext().getMode() == 2) {
                preparedQuery = QueryPrepareUtil.preparePresentationQuery(dataEngine, queryDefn, dset, appContext, contextVisitor);
            }
            if (preparedQuery != null) {
                return preparedQuery;
            }
            if (dataEngine.getContext().getMode() == 1 || dataEngine.getContext().getMode() == 3) {
                return new DummyPreparedQuery(queryDefn, dataEngine.getSession(), appContext);
            }
            if (dataEngine.getContext().getMode() == 2) {
                return new DummyPreparedQuery(queryDefn, dataEngine.getSession(), dataEngine.getContext(), queryDefn.getQueryExecutionHints() != null ? queryDefn.getQueryExecutionHints().getTargetGroupInstances() : null);
            }
            return QueryPrepareUtil.prepareIVGenerationQuery(dataEngine, queryDefn, dset, appContext, contextVisitor);
        }
        if (dset != null) {
            FilterPrepareUtil.prepareFilters(dset.getFilters(), dataEngine.getContext().getScriptContext());
            QueryContextVisitorUtil.populateDataSet(contextVisitor, dset, appContext);
            preparedQuery = QueryPrepareUtil.prepareQuery(dataEngine, queryDefn, dset, appContext, contextVisitor);
            if (preparedQuery != null) {
                return preparedQuery;
            }
        }
        if (dset == null && queryDefn.getQueryResultsID() == null) {
            return new PreparedDummyQuery(queryDefn, dataEngine.getSession());
        }
        if (dset instanceof IScriptDataSetDesign) {
            preparedQuery = new PreparedScriptDSQuery(dataEngine, queryDefn, dset, appContext, contextVisitor);
        } else if (dset instanceof IOdaDataSetDesign) {
            if (dset instanceof IIncreCacheDataSetDesign) {
                preparedQuery = new PreparedIncreCacheDSQuery(dataEngine, queryDefn, dset, appContext);
            } else {
                ((BaseDataSetDesign)dataEngine.getDataSetDesign(queryDefn.getDataSetName())).setQueryContextVisitor(contextVisitor);
                preparedQuery = dset instanceof ICombinedOdaDataSetDesign ? new PreparedCombinedOdaDSQuery(dataEngine, queryDefn, dset, appContext, contextVisitor) : new PreparedOdaDSQuery(dataEngine, queryDefn, dset, appContext, contextVisitor);
            }
        } else if (dset instanceof IJointDataSetDesign) {
            preparedQuery = new PreparedJointDataSourceQuery(dataEngine, queryDefn, dset, appContext, contextVisitor);
        } else {
            preparedQuery = DataSetDesignHelper.createPreparedQueryInstance(dset, dataEngine, queryDefn, appContext);
            if (preparedQuery == null) {
                throw new DataException("data.engine.UnsupportedDataSetType", dset.getName());
            }
        }
        return preparedQuery;
    }

    private static void optimizeForTransientQuery(Map appContext, IQueryDefinition query) throws DataException {
        if (appContext != null) {
            IQueryOptimizeHints hints = (IQueryOptimizeHints)appContext.get("org.eclipse.birt.data.internal.optimize.hints");
            if (hints == null || !(query instanceof QueryDefinition)) {
                return;
            }
            query.getQueryExecutionHints().setEnablePushDown(hints.enablePushDownForTransientQuery());
            Map<String, List<IFilterDefinition>> filters = hints.getFiltersInAdvance();
            if (filters != null && filters.get(query.getDataSetName()) != null) {
                query.getFilters().addAll((Collection)filters.get(query.getDataSetName()));
            }
        }
    }

    private static void addAllBindingAsSortKey(IQueryDefinition queryDefn) throws DataException {
        if (!(queryDefn instanceof BaseQueryDefinition)) {
            return;
        }
        HashSet<String> sortedBinding = new HashSet<String>();
        List sorts = queryDefn.getSorts();
        if (sorts != null) {
            for (ISortDefinition sd : sorts) {
                List<String> bindingNames = ExpressionCompilerUtil.extractColumnExpression((IBaseExpression)sd.getExpression(), "row");
                if (bindingNames != null && bindingNames.size() > 0) {
                    for (String bindingName : bindingNames) {
                        sortedBinding.add(bindingName);
                    }
                    continue;
                }
                if (sd.getColumn() == null) continue;
                sortedBinding.add(sd.getColumn());
            }
        }
        Iterator bindings = queryDefn.getBindings().values().iterator();
        BaseQueryDefinition queryDefinition = (BaseQueryDefinition)((Object)queryDefn);
        while (bindings.hasNext()) {
            IBinding binding = (IBinding)bindings.next();
            if (sortedBinding.contains(binding.getBindingName())) continue;
            SortDefinition sd = new SortDefinition();
            sd.setExpression(ExpressionUtil.createJSRowExpression((String)binding.getBindingName()));
            queryDefinition.addSort(sd);
        }
    }

    private static void validateQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn) throws DataException {
        try {
            if (dataEngine.getContext().getMode() == 2) {
                return;
            }
            String dataSetName = queryDefn.getDataSetName();
            IBaseDataSetDesign dataSet = dataEngine.getDataSetDesign(dataSetName);
            if (dataSet != null) {
                PreparedQueryUtil.validateComputedColumns(dataSet);
            }
            PreparedQueryUtil.validateSort(queryDefn, dataSet);
        }
        catch (Exception e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    private static void validateSort(IQueryDefinition queryDefn, IBaseDataSetDesign dataSet) throws BirtException {
        Map bindings = PreparedQueryUtil.populateValidBinding(queryDefn);
        ArrayList<ISortDefinition> toBeRemoved = new ArrayList<ISortDefinition>();
        List sorts = queryDefn.getSorts();
        block0: for (ISortDefinition sort : sorts) {
            IScriptExpression sortExpr = sort.getExpression();
            if (sort.getColumn() != null) continue;
            if (sortExpr == null) {
                toBeRemoved.add(sort);
                continue;
            }
            List referedColumns = ExpressionUtil.extractColumnExpressions((String)sortExpr.getText());
            int i = 0;
            while (i < referedColumns.size()) {
                boolean shouldBeRemoved;
                IColumnBinding cb = (IColumnBinding)referedColumns.get(i);
                boolean bl = shouldBeRemoved = !bindings.containsKey(cb.getResultSetColumnName()) && !"__rownum".equals(cb.getResultSetColumnName());
                if (queryDefn.needAutoBinding() && shouldBeRemoved && dataSet != null) {
                    List resultSetHint = dataSet.getResultSetHints();
                    int j = 0;
                    while (j < resultSetHint.size()) {
                        IColumnDefinition hint;
                        if (resultSetHint.get(j) instanceof IColumnDefinition && (ScriptEvalUtil.compare((hint = (IColumnDefinition)resultSetHint.get(j)).getColumnName(), cb.getResultSetColumnName()) == 0 || ScriptEvalUtil.compare(hint.getAlias(), cb.getResultSetColumnName()) == 0)) {
                            shouldBeRemoved = false;
                            break;
                        }
                        ++j;
                    }
                    if (shouldBeRemoved) {
                        List computedColumns = dataSet.getComputedColumns();
                        int j2 = 0;
                        while (j2 < computedColumns.size()) {
                            IComputedColumn cc;
                            if (computedColumns.get(j2) instanceof IComputedColumn && ScriptEvalUtil.compare((cc = (IComputedColumn)computedColumns.get(j2)).getName(), cb.getResultSetColumnName()) == 0) {
                                shouldBeRemoved = false;
                                break;
                            }
                            ++j2;
                        }
                    }
                    System.out.println();
                }
                if (shouldBeRemoved) {
                    toBeRemoved.add(sort);
                    continue block0;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < toBeRemoved.size()) {
            IScriptExpression expr = ((ISortDefinition)toBeRemoved.get(i)).getExpression();
            if (expr != null) {
                logger.log(Level.WARNING, "Sort Definition:" + expr.getText() + " is removed because it refers to an inexist column binding.");
            } else {
                logger.log(Level.WARNING, "Empty Sort Definition is removed.");
            }
            ++i;
        }
        queryDefn.getSorts().removeAll(toBeRemoved);
    }

    private static Map populateValidBinding(IQueryDefinition queryDefn) {
        HashMap bindings = new HashMap();
        IQueryDefinition temp = queryDefn;
        while (temp != null) {
            bindings.putAll(temp.getBindings());
            temp = temp.getSourceQuery() instanceof IQueryDefinition ? (IQueryDefinition)temp.getSourceQuery() : null;
        }
        return bindings;
    }

    private static void validateSummaryQuery(IQueryDefinition queryDefn) throws DataException {
        if (queryDefn.isSummaryQuery()) {
            String lastGroupName = null;
            if (queryDefn.getGroups().size() > 0) {
                IGroupDefinition group = (IGroupDefinition)queryDefn.getGroups().get(queryDefn.getGroups().size() - 1);
                lastGroupName = group.getName();
            }
            Map bindings = queryDefn.getBindings();
            for (IBinding binding : bindings.values()) {
                if (binding.getAggrFunction() == null || binding.getAggregatOns().size() == 0 && lastGroupName == null || binding.getAggregatOns().size() == 1 && binding.getAggregatOns().get(0).toString().equals(lastGroupName)) continue;
                throw new DataException("data.engine.InvalidAggrLevelKeyInSummaryQuery", binding.getBindingName());
            }
        }
    }

    public static boolean hasSortOnAggregat(IBaseQueryDefinition iBaseQueryDefinition) throws DataException {
        List sorts = iBaseQueryDefinition.getSorts();
        Map bindings = iBaseQueryDefinition.getBindings();
        if (sorts != null) {
            for (ISortDefinition sd : sorts) {
                List<String> bindingNames = ExpressionCompilerUtil.extractColumnExpression((IBaseExpression)sd.getExpression(), "row");
                if (bindingNames == null) continue;
                for (String bindingName : bindingNames) {
                    IBinding binding = (IBinding)bindings.get(bindingName);
                    if (binding == null) continue;
                    if (binding.getAggrFunction() != null) {
                        return true;
                    }
                    List<String> refBindingName = ExpressionCompilerUtil.extractColumnExpression(binding.getExpression(), "row");
                    if (refBindingName.size() <= 0 || !PreparedQueryUtil.existAggregationBinding(refBindingName, bindings)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean existAggregationBinding(Collection<String> bindingNames, Map bindings) throws DataException {
        for (String bindingName : bindingNames) {
            Object binding = bindings.get(bindingName);
            if (binding == null) continue;
            if (OlapExpressionUtil.isAggregationBinding((IBinding)binding)) {
                return true;
            }
            if (!PreparedQueryUtil.existAggregationBinding(ExpressionCompilerUtil.extractColumnExpression(((IBinding)binding).getExpression(), "row"), bindings)) continue;
            return true;
        }
        return false;
    }

    private static void validateComputedColumns(IBaseDataSetDesign bdsd) throws DataException {
        List ccs = bdsd.getComputedColumns();
        if (ccs != null) {
            HashSet<NamedExpression> namedExpressions = new HashSet<NamedExpression>();
            for (IComputedColumn cc : ccs) {
                String name = cc.getName();
                if (name == null || name.equals("")) {
                    throw new DataException("data.engine.EmptyCustomFieldName");
                }
                IBaseExpression expr = cc.getExpression();
                namedExpressions.add(new NamedExpression(name, expr));
            }
            String nameInvolvedInCycle = ExpressionCompilerUtil.getFirstFoundNameInCycle(namedExpressions, "row");
            if (nameInvolvedInCycle != null) {
                throw new DataException("data.engine.ComputedColumnCycle", nameInvolvedInCycle);
            }
        }
    }

    private static IBaseDataSetDesign cloneDataSetDesign(IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        if (dataSetDesign instanceof IScriptDataSetDesign) {
            return new ScriptDataSetAdapter(dataSetDesign);
        }
        if (dataSetDesign instanceof IOdaDataSetDesign) {
            return PreparedQueryUtil.adaptOdaDataSetDesign(dataSetDesign, appContext);
        }
        if (dataSetDesign instanceof IJointDataSetDesign) {
            return new JointDataSetAdapter(dataSetDesign);
        }
        IBaseDataSetDesign design = DataSetDesignHelper.createAdapter(dataSetDesign);
        return design;
    }

    private static IBaseDataSetDesign adaptOdaDataSetDesign(IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        OdaDataSetAdapter adaptedDesign = null;
        URL configFileUrl = IncreCacheDataSetAdapter.getConfigFileURL(appContext);
        if (configFileUrl != null) {
            try {
                InputStream is = configFileUrl.openStream();
                ConfigFileParser parser = new ConfigFileParser(is);
                String id = dataSetDesign.getName();
                if (parser.containDataSet(id)) {
                    final String mode = parser.getModeByID(id);
                    if ("incremental".equalsIgnoreCase(mode)) {
                        String queryTemplate = parser.getQueryTextByID(id);
                        String timestampColumn = parser.getTimeStampColumnByID(id);
                        String formatPattern = parser.getTSFormatByID(id);
                        IncreCacheDataSetAdapter pscDataSet = new IncreCacheDataSetAdapter((IOdaDataSetDesign)dataSetDesign);
                        pscDataSet.setCacheMode(1);
                        pscDataSet.setConfigFileUrl(configFileUrl);
                        pscDataSet.setQueryTemplate(queryTemplate);
                        pscDataSet.setTimestampColumn(timestampColumn);
                        pscDataSet.setFormatPattern(formatPattern);
                        adaptedDesign = pscDataSet;
                    } else {
                        String message = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                return MessageFormat.format("data.cache.UnsupportedIncrementalCacheMode", mode);
                            }
                        });
                        throw new UnsupportedOperationException(message);
                    }
                }
                is.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (adaptedDesign == null) {
            adaptedDesign = dataSetDesign instanceof ICombinedOdaDataSetDesign ? new CombinedOdaDataSetAdapter((ICombinedOdaDataSetDesign)dataSetDesign) : new OdaDataSetAdapter((IOdaDataSetDesign)dataSetDesign);
        }
        return adaptedDesign;
    }

    private static int runQueryOnRS(DataEngineImpl dataEngine, IQueryDefinition queryDefn) throws DataException {
        String queryResultID = queryDefn.getQueryResultsID();
        String rootQueryResultID = QueryResultIDUtil.get1PartID(queryResultID);
        String parentQueryResultID = null;
        if (rootQueryResultID != null) {
            parentQueryResultID = QueryResultIDUtil.get2PartID(queryResultID);
        } else {
            rootQueryResultID = queryResultID;
        }
        QueryResultInfo queryResultInfo = new QueryResultInfo(rootQueryResultID, parentQueryResultID, null, null, -1);
        RDLoad rdLoad = RDUtil.newLoad(dataEngine.getSession().getTempDir(), dataEngine.getContext(), queryResultInfo);
        IBaseQueryDefinition previousQueryDefn = rdLoad.loadQueryDefn(0, 1);
        if (QueryCompUtil.isIVQueryDefnEqual(dataEngine.getContext().getMode(), previousQueryDefn, queryDefn)) {
            return 3;
        }
        if (queryDefn.isSummaryQuery()) {
            IResultClass rsMeta = rdLoad.loadResultClass();
            PreparedQueryUtil.populateSummaryBinding(queryDefn, rsMeta);
        }
        return 2;
    }

    public static void populateSummaryBinding(IQueryDefinition queryDefn, IResultClass rsMeta) throws DataException {
        HashSet<String> nameSet = new HashSet<String>();
        int i = 1;
        while (i <= rsMeta.getFieldCount()) {
            nameSet.add(rsMeta.getFieldName(i));
            ++i;
        }
        Iterator bindingIt = queryDefn.getBindings().values().iterator();
        HashSet<String> modifiedAggrBinding = new HashSet<String>();
        while (bindingIt.hasNext()) {
            IBinding binding = (IBinding)bindingIt.next();
            if (!nameSet.contains(binding.getBindingName())) continue;
            if (binding.getAggrFunction() != null) {
                modifiedAggrBinding.add(binding.getBindingName());
            }
            binding.setAggrFunction(null);
            binding.getAggregatOns().clear();
            binding.getArguments().clear();
            binding.setExpression(new ScriptExpression(ExpressionUtil.createDataSetRowExpression((String)binding.getBindingName())));
        }
        for (IGroupDefinition group : queryDefn.getGroups()) {
            Iterator filters = group.getFilters().iterator();
            ArrayList<IFilterDefinition> removedFilter = new ArrayList<IFilterDefinition>();
            while (filters.hasNext()) {
                IFilterDefinition filter = (IFilterDefinition)filters.next();
                List<String> list = ExpressionCompilerUtil.extractColumnExpression(filter.getExpression(), "row");
                int i2 = 0;
                while (i2 < list.size()) {
                    if (modifiedAggrBinding.contains(list.get(i2))) {
                        removedFilter.add(filter);
                    }
                    ++i2;
                }
            }
            if (removedFilter.isEmpty()) continue;
            queryDefn.getFilters().addAll(removedFilter);
            group.getFilters().removeAll(removedFilter);
        }
    }

    public static void mappingParentColumnBinding(IBaseQueryDefinition baseQueryDefn) throws DataException {
        IBaseQueryDefinition queryDef = baseQueryDefn;
        while (queryDef instanceof ISubqueryDefinition) {
            queryDef = queryDef.getParentQuery();
            Map parentBindings = queryDef.getBindings();
            PreparedQueryUtil.addParentBindings(baseQueryDefn, parentBindings);
        }
    }

    static void addParentBindings(IBaseQueryDefinition baseQueryDefn, Map parentBindings) throws DataException {
        Map<String, Boolean> aggrInfo = QueryDefinitionUtil.parseAggregations(parentBindings);
        for (Map.Entry entry : parentBindings.entrySet()) {
            if (aggrInfo.get(entry.getKey()).booleanValue()) continue;
            IBinding b = (IBinding)parentBindings.get(entry.getKey());
            if (baseQueryDefn.getBindings().get(entry.getKey()) != null) continue;
            Binding binding = new Binding((String)entry.getKey());
            binding.setDataType(b.getDataType());
            binding.setExpression(PreparedQueryUtil.copyScriptExpr(b.getExpression()));
            baseQueryDefn.addBinding(binding);
        }
    }

    private static ScriptExpression copyScriptExpr(IBaseExpression expr) {
        if (expr == null) {
            return null;
        }
        ScriptExpression se = new ScriptExpression(((IScriptExpression)expr).getText(), ((IScriptExpression)expr).getDataType());
        return se;
    }
}

