/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.pass;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.aggregation.AggrDefnRoundManager;
import org.eclipse.birt.data.engine.executor.aggregation.AggregationHelper;
import org.eclipse.birt.data.engine.executor.cache.SortSpec;
import org.eclipse.birt.data.engine.executor.transform.IComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.IExpressionProcessor;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.group.IncrementalUpdateGroupFilter;
import org.eclipse.birt.data.engine.executor.transform.pass.ComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.pass.NoUpdateFilterCalculator;
import org.eclipse.birt.data.engine.executor.transform.pass.PassStatusController;
import org.eclipse.birt.data.engine.executor.transform.pass.PassUtil;
import org.eclipse.birt.data.engine.executor.transform.pass.RowProcessUtil;
import org.eclipse.birt.data.engine.expression.ExpressionCompiler;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.FilterByRow;
import org.eclipse.birt.data.engine.impl.PreparedQueryUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;

class ResultSetProcessUtil
extends RowProcessUtil {
    private List cachedSort;
    private boolean groupingDone;

    private ResultSetProcessUtil(ResultSetPopulator populator, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, FilterByRow filterByRow, PassStatusController psController) {
        super(populator, iccState, computedColumnHelper, filterByRow, psController);
    }

    public static void doPopulate(ResultSetPopulator populator, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, FilterByRow filterByRow, PassStatusController psController, List sortList) throws DataException {
        ResultSetProcessUtil instance = new ResultSetProcessUtil(populator, iccState, computedColumnHelper, filterByRow, psController);
        instance.cachedSort = sortList;
        instance.populateResultSet();
    }

    public static void doPopulateAggregation(ResultSetPopulator populator, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, FilterByRow filterByRow, PassStatusController psController, List sortList) throws DataException {
        ResultSetProcessUtil instance = new ResultSetProcessUtil(populator, iccState, computedColumnHelper, filterByRow, psController);
        instance.cachedSort = sortList;
        instance.populateAggregation();
    }

    public static void doPopulateNoUpdateAggrFiltering(ResultSetPopulator populator, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, FilterByRow filterByRow, PassStatusController psController, List sortList) throws DataException {
        ResultSetProcessUtil instance = new ResultSetProcessUtil(populator, iccState, computedColumnHelper, filterByRow, psController);
        instance.cachedSort = sortList;
        instance.groupingDone = true;
        instance.populateNoUpdateAggrFiltering();
    }

    private void populateResultSet() throws DataException {
        List aggCCList = this.prepareComputedColumns(1);
        this.doRowFiltering();
        this.populateTempComputedColumns(this.getAggrComputedColumns(aggCCList, false));
        List aggrDefns = this.populator.getEventHandler().getAggrDefinitions();
        this.prepareAggregations(aggrDefns);
        this.doGroupFiltering();
        if (this.needDoGroupFiltering() && this.psController.needDoOperation(6)) {
            this.prepareAggregations(aggrDefns);
        }
        this.doAggrRowFiltering();
        this.doRowSorting();
        this.doGroupSorting();
        if (!this.groupingDone) {
            PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), true);
            this.groupingDone = true;
        }
        this.clearTemporaryComputedColumns(this.iccState);
        this.populateAggregation();
        this.doNoUpdateAggrGroupFilter();
        this.doNoUpdateAggrRowFilter();
    }

    private void populateNoUpdateAggrFiltering() throws DataException {
        this.doNoUpdateAggrGroupFilter();
        this.doNoUpdateAggrRowFilter();
    }

    private void populateAggregation() throws DataException {
        this.calculateAggregationsInColumnBinding();
        ExpressionCompiler compiler = new ExpressionCompiler();
        compiler.setDataSetMode(false);
        Iterator it = this.populator.getEventHandler().getColumnBindings().values().iterator();
        while (it.hasNext()) {
            try {
                IBinding binding = (IBinding)it.next();
                compiler.compile(binding.getExpression(), this.populator.getSession().getEngineContext().getScriptContext());
            }
            catch (DataException dataException) {}
        }
        this.populateAggregationInBinding();
    }

    private void calculateAggregationsInColumnBinding() throws DataException {
        IExpressionProcessor ep = this.populator.getExpressionProcessor();
        Map results = this.populator.getEventHandler().getColumnBindings();
        DummyICCState iccState = new DummyICCState(results);
        ep.setResultIterator(this.populator.getResultIterator());
        while (!iccState.isFinish()) {
            ep.evaluateMultiPassExprOnCmp(iccState, false);
        }
    }

    private void populateAggregationInBinding() throws DataException {
        this.populator.getExpressionProcessor().setResultIterator(this.populator.getResultIterator());
        this.populator.getResultIterator().clearAggrValueHolder();
        List aggrDefns = this.populator.getEventHandler().getAggrDefinitions();
        AggrDefnRoundManager factory = new AggrDefnRoundManager(aggrDefns);
        int i = 0;
        while (i < factory.getRound()) {
            AggregationHelper helper = new AggregationHelper(factory.getAggrDefnManager(i), this.populator);
            this.populator.getResultIterator().addAggrValueHolder(helper);
            ++i;
        }
    }

    private void prepareAggregations(List aggrDefns) throws DataException {
        boolean needGroupFiltering = this.needDoGroupFiltering();
        boolean needGroupSorting = this.needDoGroupSorting();
        boolean needRowSortOnAggregation = this.needRowSortOnAggregation();
        boolean needAggrFiltering = this.psController.needDoOperation(6);
        if (this.needPreCalculateForGroupFilterSort(needGroupFiltering, needGroupSorting) || needAggrFiltering || needRowSortOnAggregation) {
            if (needRowSortOnAggregation && this.computedColumnHelper != null) {
                this.computedColumnHelper.suppressException(true);
            }
            if (!this.groupingDone) {
                PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), true);
            }
            this.populator.getExpressionProcessor().setResultIterator(this.populator.getResultIterator());
            AggrDefnRoundManager factory = new AggrDefnRoundManager(aggrDefns);
            this.populator.getResultIterator().clearAggrValueHolder();
            int i = 0;
            while (i < factory.getRound()) {
                AggregationHelper helper = new AggregationHelper(factory.getAggrDefnManager(i), this.populator);
                this.populator.getResultIterator().addAggrValueHolder(helper);
                ++i;
            }
            if (this.computedColumnHelper != null) {
                this.computedColumnHelper.suppressException(false);
            }
        }
    }

    private boolean needPreCalculateForGroupFilterSort(boolean needGroupFiltering, boolean needGroupSorting) {
        return needGroupFiltering || needGroupSorting;
    }

    private boolean needDoGroupFiltering() {
        int i = 0;
        while (i < this.populator.getQuery().getGrouping().length) {
            List groupFilters = this.populator.getQuery().getGrouping()[i].getFilters();
            if (groupFilters != null && groupFilters.size() > 0) {
                int k = 0;
                while (k < groupFilters.size()) {
                    if (((IFilterDefinition)groupFilters.get(k)).updateAggregation()) {
                        return true;
                    }
                    ++k;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean needRowSortOnAggregation() throws DataException {
        return PreparedQueryUtil.hasSortOnAggregat(this.populator.getQuery().getQueryDefinition());
    }

    private boolean needDoGroupSorting() {
        int i = 0;
        while (i < this.populator.getQuery().getGrouping().length) {
            List groupFilters = this.populator.getQuery().getGrouping()[i].getSorts();
            if (groupFilters != null && groupFilters.size() > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void populateTempComputedColumns(List aggCCList) throws DataException {
        if (this.psController.needDoOperation(4)) {
            if (aggCCList.size() != 0 || this.psController.needDoOperation(5)) {
                PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), true);
                this.groupingDone = true;
            }
            if (aggCCList.size() != 0) {
                this.computedColumnHelper.getComputedColumnList().clear();
                this.computedColumnHelper.getComputedColumnList().addAll(aggCCList);
                this.computedColumnHelper.setRePrepare(true);
                IExpressionProcessor ep = this.populator.getExpressionProcessor();
                ep.setResultIterator(this.populator.getResultIterator());
                while (!this.isICCStateFinish()) {
                    ep.evaluateMultiPassExprOnCmp(this.iccState, false);
                }
            }
            this.doGroupRowFilter();
        }
    }

    private void doGroupSorting() throws DataException {
        if (!this.needDoGroupSorting()) {
            return;
        }
        if (!this.groupingDone) {
            PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), true);
            this.groupingDone = true;
        }
        if (this.needDoGroupFiltering() || this.psController.needDoOperation(6)) {
            this.prepareAggregations(this.populator.getEventHandler().getAggrDefinitions());
        }
        this.populator.getGroupProcessorManager().doGroupSorting(this.populator.getCache(), this.populator.getExpressionProcessor());
    }

    private void doRowSorting() throws DataException {
        this.populator.getQuery().setOrdering(this.cachedSort);
        SortSpec spec = this.populator.getGroupProcessorManager().getGroupCalculationUtil().getSortSpec();
        if (spec != null && spec.length() > 0) {
            PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), true);
            this.groupingDone = true;
        }
    }

    private void doGroupFiltering() throws DataException {
        if (!this.needDoGroupFiltering()) {
            return;
        }
        if (!this.groupingDone) {
            PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), true);
            this.groupingDone = true;
        }
        this.populator.getGroupProcessorManager().doGroupFiltering(this.populator.getCache(), this.populator.getExpressionProcessor());
    }

    private void doRowFiltering() throws DataException {
        if (!this.psController.needDoOperation(3)) {
            return;
        }
        if (this.needRowSortOnAggregation() && this.computedColumnHelper != null) {
            this.computedColumnHelper.suppressException(true);
        }
        boolean changeMaxRows = this.filterByRow.getFilterList(5).size() + this.filterByRow.getFilterList(6).size() > 0;
        this.applyFilters(2, changeMaxRows);
        this.filterByRow.setWorkingFilterSet(4);
        if (this.computedColumnHelper != null) {
            this.computedColumnHelper.suppressException(false);
        }
    }

    private void doAggrRowFiltering() throws DataException {
        if (!this.psController.needDoOperation(6)) {
            return;
        }
        this.applyFilters(6, false);
        this.filterByRow.setWorkingFilterSet(4);
    }

    private boolean isICCStateFinish() {
        int i = 0;
        while (i < this.iccState.getCount()) {
            if (!this.iccState.isValueAvailable(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void doGroupRowFilter() throws DataException {
        if (!this.psController.needDoOperation(5)) {
            return;
        }
        this.filterByRow.setWorkingFilterSet(5);
        PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), true);
        this.filterByRow.setWorkingFilterSet(4);
    }

    private void clearTemporaryComputedColumns(ComputedColumnsState iccState) throws DataException {
        if (!this.psController.needDoOperation(4)) {
            return;
        }
        iccState.setModel(2);
        this.populator.getExpressionProcessor().clear();
        this.computedColumnHelper.setModel(4);
        this.cleanTempColumns();
    }

    private void cleanTempColumns() throws DataException {
        IResultClass newMeta = ResultSetProcessUtil.rebuildResultClass(this.populator.getResultSetMetadata());
        this.populator.setResultSetMetadata(newMeta);
        this.populator.getCache().setResultClass(newMeta);
        PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), false);
        this.populator.getCache().reset();
        this.populator.getCache().next();
        this.populator.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().setLeaveGroupIndex(0);
    }

    private static IResultClass rebuildResultClass(IResultClass meta) throws DataException {
        ArrayList<ResultFieldMetadata> projectedColumns = new ArrayList<ResultFieldMetadata>();
        int i = 1;
        while (i <= meta.getFieldCount()) {
            if (!PassUtil.isTemporaryResultSetComputedColumn(meta.getFieldName(i))) {
                ResultFieldMetadata field = new ResultFieldMetadata(0, meta.getFieldName(i), meta.getFieldAlias(i), meta.getFieldBindings(i), meta.getFieldValueClass(i), meta.getFieldNativeTypeName(i), meta.isCustomField(i), meta.getAnalysisType(i), meta.getAnalysisColumn(i), meta.isIndexColumn(i), meta.isCompressedColumn(i));
                field.setAlias(meta.getFieldAlias(i));
                projectedColumns.add(field);
            }
            ++i;
        }
        ResultClass result = new ResultClass(projectedColumns);
        return result;
    }

    private void doNoUpdateAggrRowFilter() throws DataException {
        if (this.filterByRow == null) {
            return;
        }
        if (!this.psController.needDoOperation(8)) {
            return;
        }
        NoUpdateFilterCalculator.applyFilters(this.populator, this.filterByRow);
    }

    private void doNoUpdateAggrGroupFilter() throws DataException {
        if (!this.needNoUpdateAggrGroupFiltering()) {
            return;
        }
        if (!this.groupingDone) {
            PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), true);
            this.groupingDone = true;
        }
        new IncrementalUpdateGroupFilter(this.populator).doFilters();
    }

    private boolean needNoUpdateAggrGroupFiltering() {
        int i = 0;
        while (i < this.populator.getQuery().getGrouping().length) {
            List groupFilters = this.populator.getQuery().getGrouping()[i].getFilters();
            if (groupFilters != null && groupFilters.size() > 0) {
                int k = 0;
                while (k < groupFilters.size()) {
                    if (!((IFilterDefinition)groupFilters.get(k)).updateAggregation()) {
                        return true;
                    }
                    ++k;
                }
            }
            ++i;
        }
        return false;
    }

    private static class DummyICCState
    implements IComputedColumnsState {
        private Object[] exprs;
        private Object[] names;
        private boolean[] isValueAvailable;

        DummyICCState(Map columnMappings) throws DataException {
            this.exprs = columnMappings.values().toArray();
            this.names = columnMappings.keySet().toArray();
            this.isValueAvailable = new boolean[this.exprs.length];
        }

        @Override
        public boolean isValueAvailable(int index) {
            return this.isValueAvailable[index];
        }

        @Override
        public String getName(int index) {
            return this.names[index].toString();
        }

        @Override
        public IBaseExpression getExpression(int index) throws DataException {
            return ((IBinding)this.exprs[index]).getExpression();
        }

        @Override
        public void setValueAvailable(int index) {
            this.isValueAvailable[index] = true;
        }

        @Override
        public int getCount() {
            return this.isValueAvailable.length;
        }

        @Override
        public IComputedColumn getComputedColumn(int index) {
            return null;
        }

        @Override
        public void setModel(int model) {
        }

        public boolean isFinish() {
            int i = 0;
            while (i < this.isValueAvailable.length) {
                if (!this.isValueAvailable[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

