/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.timeFunction.BaseTimeFunction;
import org.eclipse.birt.report.data.adapter.api.timeFunction.IArgumentInfo;
import org.eclipse.birt.report.data.adapter.api.timeFunction.ITimeFunction;
import org.eclipse.birt.report.designer.data.ui.actions.NewDataSetAction;
import org.eclipse.birt.report.designer.data.ui.dataset.AppContextPopulator;
import org.eclipse.birt.report.designer.data.ui.dataset.AppContextResourceReleaser;
import org.eclipse.birt.report.designer.data.ui.dataset.ExternalUIUtil;
import org.eclipse.birt.report.designer.data.ui.function.layout.ArgumentLayout;
import org.eclipse.birt.report.designer.data.ui.providers.DistinctValueSelector;
import org.eclipse.birt.report.designer.internal.ui.data.IDataServiceProvider;
import org.eclipse.birt.report.designer.internal.ui.data.function.layout.IArgumentLayout;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;

public class DefaultDataServiceProvider
implements IDataServiceProvider {
    public void createDataSet() {
        new NewDataSetAction().run();
    }

    public List getSelectValueList(Expression expression, DataSetHandle dataSetHandle, boolean useDataSetFilter) throws BirtException {
        return DistinctValueSelector.getSelectValueList(expression, dataSetHandle, useDataSetFilter);
    }

    public List getSelectValueList(Expression expression, DataSetHandle dataSetHandle, DataEngineContext.DataEngineFlowMode flowMode) throws BirtException {
        return DistinctValueSelector.getSelectValueList(expression, dataSetHandle, flowMode);
    }

    public List getSelectValueFromBinding(Expression expression, DataSetHandle dataSetHandle, Iterator binding, Iterator groupIterator, boolean useDataSetFilter) throws BirtException {
        return DistinctValueSelector.getSelectValueFromBinding(expression, dataSetHandle, binding, groupIterator, useDataSetFilter);
    }

    public List getSelectValueFromBinding(Expression expression, ModuleHandle moduleHandle, DataSetHandle dataSetHandle, Iterator binding, Iterator groupIterator, boolean useDataSetFilter) throws BirtException {
        return DistinctValueSelector.getSelectValueFromBinding(expression, moduleHandle, dataSetHandle, binding, groupIterator, useDataSetFilter);
    }

    public List getSelectValueList(Expression expression, ModuleHandle moduleHandle, DataSetHandle dataSetHandle, boolean useDataSetFilter) throws BirtException {
        return DistinctValueSelector.getSelectValueList(expression, moduleHandle, dataSetHandle, useDataSetFilter);
    }

    public void registerSession(DataSetHandle handle, DataRequestSession session) throws BirtException {
        AppContextPopulator.populateApplicationContext(handle, session);
    }

    public void registerSession(CubeHandle handle, DataRequestSession session) throws BirtException {
        if (session.getDataSessionContext().getAppContext() == null) {
            session.getDataSessionContext().setAppContext(new HashMap());
        }
        AppContextPopulator.populateApplicationContext(handle, session.getDataSessionContext().getAppContext());
    }

    public void registerSession(DataSourceHandle handle, DataRequestSession session) throws BirtException {
        if (session.getDataSessionContext().getAppContext() == null) {
            session.getDataSessionContext().setAppContext(new HashMap());
        }
        AppContextPopulator.populateApplicationContext(handle, session.getDataSessionContext().getAppContext());
    }

    public void unRegisterSession(DataRequestSession session) throws BirtException {
        if (session != null) {
            AppContextResourceReleaser.release(session.getDataSessionContext().getAppContext());
        }
    }

    public void updateColumnCache(DataSetHandle dataSetHandle, boolean holdEvent) throws BirtException {
        ExternalUIUtil.updateColumnCache(dataSetHandle, holdEvent);
    }

    public List<IArgumentLayout> getArgumentLayout(ITimeFunction function, List<IArgumentInfo> infos) {
        ArrayList<IArgumentLayout> layoutarguments = new ArrayList<IArgumentLayout>();
        new ArgumentLayout("Period1", 18);
        function = (BaseTimeFunction)function;
        if (function.getName().equals("PREVIOUS MONTH")) {
            layoutarguments.add(new ArgumentLayout("N for Period1"));
        } else if (function.getName().equals("PREVIOUS QUARTER")) {
            layoutarguments.add(new ArgumentLayout("N for Period1"));
        } else if (function.getName().equals("PREVIOUS YEAR")) {
            layoutarguments.add(new ArgumentLayout("N for Period1"));
        } else if (function.getName().equals("WEEK TO DATE LAST YEAR")) {
            layoutarguments.add(new ArgumentLayout("N for Period1"));
        } else if (function.getName().equals("MONTH TO DATE LAST YEAR")) {
            layoutarguments.add(new ArgumentLayout("N for Period1"));
        } else if (function.getName().equals("QUARTER TO DATE LAST YEAR")) {
            layoutarguments.add(new ArgumentLayout("N for Period1"));
        } else if (function.getName().equals("PREVIOUS WEEK TO DATE")) {
            layoutarguments.add(new ArgumentLayout("N for Period1"));
        } else if (function.getName().equals("PREVIOUS MONTH TO DATE")) {
            layoutarguments.add(new ArgumentLayout("N for Period1"));
        } else if (function.getName().equals("PREVIOUS QUARTER TO DATE")) {
            layoutarguments.add(new ArgumentLayout("N for Period1"));
        } else if (function.getName().equals("PREVIOUS YEAR TO DATE")) {
            layoutarguments.add(new ArgumentLayout("N for Period1"));
        } else if (function.getName().equals("CURRENT PERIOD FROM N PERIODS AGO")) {
            layoutarguments.add(new ArgumentLayout("N for Period1"));
            layoutarguments.add(new ArgumentLayout("N for Period2", 16));
            layoutarguments.add(new ArgumentLayout("Period2", 17));
        } else if (function.getName().equals("PERIOD TO DATE FROM N PERIODS AGO")) {
            layoutarguments.add(new ArgumentLayout("N for Period1"));
            layoutarguments.add(new ArgumentLayout("N for Period2", 16));
            layoutarguments.add(new ArgumentLayout("Period2", 17));
        } else if (function.getName().equals("TRAILING N MONTHS")) {
            layoutarguments.add(new ArgumentLayout("N for Period1"));
        } else if (function.getName().equals("TRAILING N DAYS")) {
            layoutarguments.add(new ArgumentLayout("N for Period1"));
        } else if (function.getName().equals("TRAILING N PERIODS FROM N PERIODS AGO")) {
            layoutarguments.add(new ArgumentLayout("N for Period1", 16));
            layoutarguments.add(new ArgumentLayout("Period1", 18));
            layoutarguments.add(new ArgumentLayout("N for Period2", 16));
            layoutarguments.add(new ArgumentLayout("Period2", 17));
        } else if (function.getName().equals("NEXT_N_PERIODS")) {
            layoutarguments.add(new ArgumentLayout("N for Period1", 16));
            layoutarguments.add(new ArgumentLayout("Period1", 18));
        }
        return layoutarguments;
    }
}

