/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.report.data.adapter.impl.DataSetMetaDataHelper;
import org.eclipse.birt.report.designer.data.ui.dataset.AppContextPopulator;
import org.eclipse.birt.report.designer.data.ui.dataset.AppContextResourceReleaser;
import org.eclipse.birt.report.designer.data.ui.dataset.CellValue;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetPreviewer;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.dataset.ResultSetTableAction;
import org.eclipse.birt.report.designer.data.ui.dataset.ResultSetTableActionFactory;
import org.eclipse.birt.report.designer.data.ui.util.DTPUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataSetExceptionHandler;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedDataModelUIAdapterHelper;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.properties.AbstractPropertyPage;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class ResultSetPreviewPage
extends AbstractPropertyPage
implements Listener {
    private TableViewer resultSetTableViewer = null;
    private transient Table resultSetTable = null;
    private boolean modelChanged = true;
    private boolean needsUpdateUI = true;
    private List recordList = null;
    private IResultMetaData metaData;
    private List errorList = new ArrayList();
    private String[] columnBindingNames;
    private int previousMaxRow = -1;
    private CLabel promptLabel;
    private DataSetHandle dataSetHandle;

    public Control createPageControl(Composite parent) {
        Composite resultSetComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 15;
        resultSetComposite.setLayout((Layout)layout);
        resultSetComposite.setLayoutData((Object)new GridData(1808));
        this.resultSetTable = new Table(resultSetComposite, 268503042);
        this.resultSetTable.setHeaderVisible(true);
        this.resultSetTable.setLinesVisible(true);
        this.resultSetTable.setLayoutData((Object)new GridData(1808));
        ((DataSetHandle)this.getContainer().getModel()).addListener((Listener)this);
        this.resultSetTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button != 1) {
                    MenuManager menuManager = new MenuManager();
                    ResultSetTableAction copyAction = ResultSetTableActionFactory.createResultSetTableAction(ResultSetPreviewPage.this.resultSetTable, 1);
                    ResultSetTableAction selectAllAction = ResultSetTableActionFactory.createResultSetTableAction(ResultSetPreviewPage.this.resultSetTable, 2);
                    menuManager.add((IAction)copyAction);
                    menuManager.add((IAction)selectAllAction);
                    menuManager.update();
                    copyAction.update();
                    selectAllAction.update();
                    Menu contextMenu = menuManager.createContextMenu((Control)ResultSetPreviewPage.this.resultSetTable);
                    contextMenu.setEnabled(true);
                    contextMenu.setVisible(true);
                }
            }
        });
        this.createResultSetTableViewer();
        this.promptLabel = new CLabel(resultSetComposite, 64);
        GridData labelData = new GridData(768);
        this.promptLabel.setLayoutData((Object)labelData);
        return resultSetComposite;
    }

    private void createResultSetTableViewer() {
        this.resultSetTableViewer = new TableViewer(this.resultSetTable);
        this.resultSetTableViewer.setSorter(null);
        this.resultSetTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.resultSetTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof CellValue[] && ((CellValue[])element).length > 0) {
                    return ((CellValue[])element)[columnIndex].getDisplayValue();
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    public void pageActivated() {
        this.getContainer().setMessage(Messages.getString((String)"dataset.editor.preview"), 0);
        if (this.modelChanged) {
            this.modelChanged = false;
            this.dataSetHandle = ((DataSetEditor)this.getContainer()).getHandle();
            int maxRow = this.getMaxRowPreference();
            if (this.dataSetHandle.getRowFetchLimit() <= 0) {
                ModuleHandle moduleHandle = ((Module)this.dataSetHandle.getRoot().copy()).getModuleHandle();
                SlotHandle dataSets = moduleHandle.getDataSets();
                int i = 0;
                while (i < dataSets.getCount()) {
                    if (this.dataSetHandle.getName().equals(dataSets.get(i).getName())) {
                        this.dataSetHandle = (DataSetHandle)dataSets.get(i);
                        try {
                            this.dataSetHandle.setRowFetchLimit(maxRow);
                        }
                        catch (SemanticException semanticException) {}
                        break;
                    }
                    ++i;
                }
            }
            new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ResultSetPreviewPage.this.updateResultsProcess();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    protected final void clearResultSetTable() {
        if (this.recordList == null) {
            this.recordList = new ArrayList();
        } else {
            this.recordList.clear();
        }
        this.resultSetTable.removeAll();
        if (this.errorList != null) {
            this.errorList.clear();
        }
        TableColumn[] columns = this.resultSetTable.getColumns();
        int n = 0;
        while (n < columns.length) {
            columns[n].dispose();
            ++n;
        }
    }

    private int getMaxRowPreference() {
        int maxRow;
        Preferences preferences = ReportPlugin.getDefault().getPluginPreferences();
        if (preferences.contains("user_maxrow")) {
            maxRow = preferences.getInt("user_maxrow");
        } else {
            maxRow = 500;
            preferences.setValue("user_maxrow", maxRow);
        }
        return maxRow;
    }

    private void updateResultsProcess() {
        this.needsUpdateUI = true;
        this.clearResultSetTable();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("", -1);
                if (ResultSetPreviewPage.this.resultSetTable != null && !ResultSetPreviewPage.this.resultSetTable.isDisposed()) {
                    ModuleHandle handle = null;
                    DataSetHandle dsHandle = ResultSetPreviewPage.this.dataSetHandle;
                    handle = dsHandle.getModuleHandle();
                    DataSetPreviewer previewer = new DataSetPreviewer(dsHandle, ResultSetPreviewPage.this.getMaxRowPreference(), DataSetPreviewer.PreviewType.RESULTSET);
                    HashMap dataSetBindingMap = new HashMap();
                    HashMap dataSourceBindingMap = new HashMap();
                    HashMap<String, ResourceIdentifiers> appContext = new HashMap<String, ResourceIdentifiers>();
                    try {
                        try {
                            ResultSetPreviewPage.this.clearProperyBindingMap(dataSetBindingMap, dataSourceBindingMap);
                            ResourceIdentifiers identifiers = new ResourceIdentifiers();
                            String resouceIDs = "org.eclipse.datatools.connectivity.oda.util_consumerResourceIds";
                            identifiers.setApplResourceBaseURI(DTPUtil.getInstance().getBIRTResourcePath());
                            identifiers.setDesignResourceBaseURI(DTPUtil.getInstance().getReportDesignPath());
                            appContext.put(resouceIDs, identifiers);
                            if (ExtendedDataModelUIAdapterHelper.getInstance().getAdapter() != null) {
                                appContext.putAll(ExtendedDataModelUIAdapterHelper.getInstance().getAdapter().getAppContext());
                            }
                            AppContextPopulator.populateApplicationContext(dsHandle, appContext);
                            previewer.open(appContext, ResultSetPreviewPage.this.getEngineConfig(handle));
                            IResultIterator itr = previewer.preview();
                            ResultSetPreviewPage.this.metaData = itr.getResultMetaData();
                            ResultSetPreviewPage.this.populateRecords(itr);
                            monitor.done();
                        }
                        catch (BirtException e) {
                            ResultSetPreviewPage.this.metaData = null;
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        try {
                            AppContextResourceReleaser.release(appContext);
                            previewer.close();
                        }
                        catch (BirtException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell()){

                protected void cancelPressed() {
                    super.cancelPressed();
                    ResultSetPreviewPage.this.needsUpdateUI = false;
                }
            }.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            DataSetExceptionHandler.handle((String)Messages.getString((String)"ExceptionDialog.title"), (String)e.getCause().getLocalizedMessage(), (Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            DataSetExceptionHandler.handle((String)Messages.getString((String)"ExceptionDialog.title"), (String)e.getCause().getLocalizedMessage(), (Throwable)e);
        }
        this.updateResultSetTableUI();
    }

    private EngineConfig getEngineConfig(ModuleHandle handle) {
        EngineConfig ec = new EngineConfig();
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = ((Object)((Object)this)).getClass().getClassLoader();
        }
        DataSetProvider.getCustomScriptClassLoader((ClassLoader)parent, (ModuleHandle)handle);
        return ec;
    }

    private void populateRecords(IResultIterator iter) {
        try {
            if (iter != null) {
                IResultMetaData meta = iter.getResultMetaData();
                if (meta.getColumnCount() > 0) {
                    while (iter.next()) {
                        CellValue[] record = new CellValue[meta.getColumnCount()];
                        int n = 0;
                        while (n < record.length) {
                            CellValue cv = new CellValue();
                            Object value = iter.getValue(meta.getColumnName(n + 1));
                            String disp = null;
                            disp = value instanceof Number ? value.toString() : iter.getString(meta.getColumnName(n + 1));
                            cv.setDisplayValue(disp);
                            cv.setRealValue(value);
                            record[n] = cv;
                            ++n;
                        }
                        this.recordList.add(record);
                    }
                }
                this.setPromptLabelText();
                iter.close();
            }
        }
        catch (RuntimeException e) {
            this.errorList.add(e);
        }
        catch (BirtException e) {
            this.errorList.add(e);
        }
    }

    private void setPromptLabelText() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String prompt = "";
                prompt = Messages.getFormattedString((String)"dataset.resultset.preview.promptMessage.recordsNum", (Object[])new Object[]{ResultSetPreviewPage.this.recordList.size()});
                if (ResultSetPreviewPage.this.recordList != null && ResultSetPreviewPage.this.recordList.size() >= ResultSetPreviewPage.this.getMaxRowPreference()) {
                    prompt = String.valueOf(prompt) + " " + Messages.getString((String)"dataset.resultset.preview.promptMessage.MoreRecordsExist");
                }
                if (ResultSetPreviewPage.this.promptLabel != null) {
                    ResultSetPreviewPage.this.promptLabel.setText(prompt);
                }
            }
        });
    }

    private void updateResultSetTableUI() {
        if (!this.needsUpdateUI) {
            return;
        }
        if (!this.errorList.isEmpty()) {
            this.setPromptLabelText();
            org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler.handle((Throwable)((Exception)this.errorList.get(0)));
        } else {
            if (this.metaData != null) {
                this.createColumns(this.metaData);
            }
            this.insertRecords();
        }
    }

    private void createColumns(IResultMetaData rsMd) {
        TableColumn column = null;
        TableLayout layout = new TableLayout();
        int n = 1;
        while (n <= rsMd.getColumnCount()) {
            column = new TableColumn(this.resultSetTable, 16384);
            try {
                column.setText(rsMd.getColumnLabel(n));
            }
            catch (BirtException e) {
                ExceptionHandler.showException((Shell)this.resultSetTable.getShell(), (String)Messages.getString((String)"CssErrDialog.Error"), (String)e.getLocalizedMessage(), (Throwable)e);
            }
            column.setResizable(true);
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(120, true));
            this.addColumnSortListener(column, n);
            column.pack();
            ++n;
        }
        this.resultSetTable.setLayout((Layout)layout);
        this.resultSetTable.layout(true);
    }

    private void insertRecords() {
        this.resultSetTableViewer.setInput((Object)this.recordList);
    }

    private String getColumnDisplayName(DataSetViewData[] columnsModel, int index) {
        if (columnsModel == null || columnsModel.length == 0 || index < 0 || index > columnsModel.length) {
            return "";
        }
        String externalizedName = columnsModel[index].getExternalizedName();
        if (externalizedName != null && !externalizedName.equals("")) {
            return externalizedName;
        }
        return columnsModel[index].getDisplayName();
    }

    private void addColumnSortListener(TableColumn column, final int index) {
        assert (index > 0);
        column.addSelectionListener(new SelectionListener(){
            private boolean asc = false;

            public void widgetSelected(SelectionEvent e) {
                ResultSetPreviewPage.this.sort(index - 1, this.asc);
                this.asc = !this.asc;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void sort(final int columnIndex, final boolean asc) {
        this.resultSetTable.setSortColumn(this.resultSetTable.getColumn(columnIndex));
        this.resultSetTable.setSortDirection(asc ? 1024 : 128);
        this.resultSetTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                CellValue cv1 = ((CellValue[])e1)[columnIndex];
                CellValue cv2 = ((CellValue[])e2)[columnIndex];
                int result = 0;
                if (cv1 == null && cv2 != null) {
                    result = -1;
                } else if (cv2 == null && cv1 != null) {
                    result = 1;
                } else if (cv1 != null) {
                    result = cv1.compareTo(cv2);
                }
                if (!asc) {
                    return result;
                }
                return result * -1;
            }
        });
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (focus.equals(this.getContainer().getModel()) || ((DataSetEditor)this.getContainer()).modelChanged()) {
            this.modelChanged = true;
        }
    }

    public boolean performCancel() {
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performCancel();
    }

    public boolean performOk() {
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performOk();
    }

    public String getToolTip() {
        return Messages.getString((String)"dataset.resultset.preview.tooltip");
    }

    private void resetPropertyBinding(final Map dataSetBindingMap, final Map dataSourceBindingMap) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DataSetHandle dsHandle = ((DataSetEditor)ResultSetPreviewPage.this.getContainer()).getHandle();
                    DataSetMetaDataHelper.resetPropertyBinding((DataSetHandle)dsHandle, (Map)dataSetBindingMap, (Map)dataSourceBindingMap);
                }
                catch (SemanticException e) {
                    org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler.handle((Throwable)e);
                }
            }
        });
    }

    private void clearProperyBindingMap(final Map dataSetBindingMap, final Map dataSourceBindingMap) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DataSetMetaDataHelper.clearPropertyBindingMap((DataSetHandle)ResultSetPreviewPage.this.dataSetHandle, (Map)dataSetBindingMap, (Map)dataSourceBindingMap);
                }
                catch (SemanticException e) {
                    DataSetExceptionHandler.handle((Throwable)e);
                }
            }
        });
    }
}

