/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.datafeed;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.datafeed.DataSetAdapter;
import org.eclipse.birt.chart.datafeed.IResultSetDataSet;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.DateTimeDataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.impl.DataSetImpl;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.NullDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.util.BigNumber;
import org.eclipse.birt.chart.util.NumberUtil;

public class DataSetProcessorImpl
extends DataSetAdapter {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/datafeed");

    public Object getMaximum(DataSet ds) throws ChartException {
        DataSetIterator dsi = null;
        try {
            dsi = new DataSetIterator(ds);
            dsi.reset();
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, (Throwable)uiex);
        }
        if (dsi.size() == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
        }
        if (ds instanceof NumberDataSet) {
            boolean bAnyNonNull = false;
            double dMax = 0.0;
            Number bnMax = null;
            while (dsi.hasNext()) {
                Object o = dsi.next();
                if (o == null) continue;
                if (NumberUtil.isBigNumber((Object)o)) {
                    if (!bAnyNonNull) {
                        bnMax = (BigNumber)o;
                        bAnyNonNull = true;
                        continue;
                    }
                    bnMax = ((BigNumber)bnMax).max((BigNumber)o);
                    continue;
                }
                if (o instanceof com.ibm.icu.math.BigDecimal) {
                    if (!bAnyNonNull) {
                        bnMax = (com.ibm.icu.math.BigDecimal)o;
                        bAnyNonNull = true;
                        continue;
                    }
                    bnMax = ((com.ibm.icu.math.BigDecimal)bnMax).max((com.ibm.icu.math.BigDecimal)o);
                    continue;
                }
                if (o instanceof BigDecimal) {
                    if (!bAnyNonNull) {
                        bnMax = (BigDecimal)o;
                        bAnyNonNull = true;
                        continue;
                    }
                    bnMax = ((BigDecimal)bnMax).max((BigDecimal)o);
                    continue;
                }
                double d = ((Number)o).doubleValue();
                if (Double.isNaN(d) || Double.isInfinite(dMax)) continue;
                if (!bAnyNonNull) {
                    dMax = d;
                    bAnyNonNull = true;
                    continue;
                }
                if (!(dMax < d)) continue;
                dMax = d;
            }
            if (!bAnyNonNull) {
                logger.log((Exception)new ChartException("org.eclipse.birt.chart.engine.extension", 20, "exception.null.values", Messages.getResourceBundle(this.getULocale())));
                return null;
            }
            return bnMax == null ? new Double(dMax) : bnMax;
        }
        if (ds instanceof DateTimeDataSet) {
            boolean bAnyNonNull = false;
            Calendar cal = null;
            Calendar calMax = Calendar.getInstance((ULocale)this.getULocale());
            while (dsi.hasNext()) {
                cal = (Calendar)dsi.next();
                if (cal == null) continue;
                if (!bAnyNonNull) {
                    calMax = cal;
                    bAnyNonNull = true;
                    continue;
                }
                if (!calMax.before((Object)cal)) continue;
                calMax = cal;
            }
            if (!bAnyNonNull) {
                logger.log((Exception)new ChartException("org.eclipse.birt.chart.engine.extension", 20, "exception.null.values", Messages.getResourceBundle(this.getULocale())));
            }
            return calMax;
        }
        return null;
    }

    public Object getMinimum(DataSet ds) throws ChartException {
        DataSetIterator dsi = null;
        try {
            dsi = new DataSetIterator(ds);
            dsi.reset();
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, (Throwable)uiex);
        }
        if (dsi.size() == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
        }
        if (ds instanceof NumberDataSet) {
            boolean bAnyNonNull = false;
            double dMin = 0.0;
            Number bnMin = null;
            while (dsi.hasNext()) {
                Object o = dsi.next();
                if (o == null) continue;
                if (NumberUtil.isBigNumber((Object)o)) {
                    if (!bAnyNonNull) {
                        bnMin = (BigNumber)o;
                        bAnyNonNull = true;
                        continue;
                    }
                    bnMin = ((BigNumber)bnMin).min((BigNumber)o);
                    continue;
                }
                if (o instanceof com.ibm.icu.math.BigDecimal) {
                    if (!bAnyNonNull) {
                        bnMin = (com.ibm.icu.math.BigDecimal)o;
                        bAnyNonNull = true;
                        continue;
                    }
                    bnMin = ((com.ibm.icu.math.BigDecimal)bnMin).min((com.ibm.icu.math.BigDecimal)o);
                    continue;
                }
                if (o instanceof BigDecimal) {
                    if (!bAnyNonNull) {
                        bnMin = (BigDecimal)o;
                        bAnyNonNull = true;
                        continue;
                    }
                    bnMin = ((BigDecimal)bnMin).min((BigDecimal)o);
                    continue;
                }
                double d = ((Number)o).doubleValue();
                if (Double.isNaN(d) || Double.isInfinite(d)) continue;
                if (!bAnyNonNull) {
                    dMin = d;
                    bAnyNonNull = true;
                    continue;
                }
                if (!(dMin > d)) continue;
                dMin = d;
            }
            if (!bAnyNonNull) {
                logger.log((Exception)new ChartException("org.eclipse.birt.chart.engine.extension", 20, "exception.null.values", Messages.getResourceBundle(this.getULocale())));
                return null;
            }
            return bnMin == null ? new Double(dMin) : bnMin;
        }
        if (ds instanceof DateTimeDataSet) {
            boolean bAnyNonNull = false;
            Calendar cal = null;
            Calendar calMin = Calendar.getInstance((ULocale)this.getULocale());
            while (dsi.hasNext()) {
                cal = (Calendar)dsi.next();
                if (cal == null) continue;
                if (!bAnyNonNull) {
                    calMin = cal;
                    bAnyNonNull = true;
                    continue;
                }
                if (!calMin.after((Object)cal)) continue;
                calMin = cal;
            }
            if (!bAnyNonNull) {
                logger.log((Exception)new ChartException("org.eclipse.birt.chart.engine.extension", 20, "exception.null.values", Messages.getResourceBundle(this.getULocale())));
            }
            return calMin;
        }
        return null;
    }

    public DataSet populate(Object oResultSetDef, DataSet ds) throws ChartException {
        if (oResultSetDef instanceof IResultSetDataSet) {
            IResultSetDataSet rsds = (IResultSetDataSet)oResultSetDef;
            long lRowCount = rsds.getSize();
            if (lRowCount <= 0L) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 16, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
            }
            int i = 0;
            switch (rsds.getDataType()) {
                case 16: {
                    String[] saDataSet = new String[(int)lRowCount];
                    while (rsds.hasNext()) {
                        Object o = rsds.next()[0];
                        saDataSet[i++] = (String)o;
                    }
                    if (ds == null) {
                        ds = TextDataSetImpl.create((Object)saDataSet);
                        break;
                    }
                    ds.setValues((Object)saDataSet);
                    break;
                }
                case 1: {
                    boolean isBigDecimal = false;
                    Number[] doaDataSet = new Number[(int)lRowCount];
                    while (rsds.hasNext()) {
                        Object next = rsds.next()[0];
                        if (next instanceof Number || next == null) {
                            doaDataSet[i] = NumberUtil.convertNumber((Object)next);
                            if (!isBigDecimal && NumberUtil.isBigDecimal((Object)doaDataSet[i])) {
                                isBigDecimal = true;
                            }
                            ++i;
                            continue;
                        }
                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 21, Messages.getString("DataSetProcessorImpl_exception.dataset.receivednumeric"), Messages.getResourceBundle(this.getULocale()));
                    }
                    if (ds == null) {
                        ds = NumberDataSetImpl.create((Object)doaDataSet);
                    } else {
                        ds.setValues((Object)doaDataSet);
                    }
                    ((DataSetImpl)ds).setIsBigNumber(isBigDecimal);
                    break;
                }
                case 8: {
                    Calendar[] caDataSet = new Calendar[(int)lRowCount];
                    while (rsds.hasNext()) {
                        caDataSet[i++] = Methods.asDateTime((Object)rsds.next()[0]);
                    }
                    if (ds == null) {
                        ds = DateTimeDataSetImpl.create((Object)caDataSet);
                        break;
                    }
                    ds.setValues((Object)caDataSet);
                    break;
                }
                default: {
                    boolean allNullValues = true;
                    while (rsds.hasNext()) {
                        if (rsds.next()[0] == null) continue;
                        allNullValues = false;
                        break;
                    }
                    if (!allNullValues) {
                        if (rsds.getDataType() == 17) {
                            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.dataset.booleantype", Messages.getResourceBundle(this.getULocale()));
                        }
                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.unknown.datatype", Messages.getResourceBundle(this.getULocale()));
                    }
                    ds = NullDataSetImpl.create((int)((int)lRowCount));
                    break;
                }
            }
        } else {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.unknown.custom.dataset", Messages.getResourceBundle(this.getULocale()));
        }
        return ds;
    }

    public DataSet fromString(String sDataSetRepresentation, DataSet ds) throws ChartException {
        if (sDataSetRepresentation == null) {
            return ds;
        }
        ArrayList<Object> vData = new ArrayList<Object>();
        String[] strTok = this.getStringTokens(sDataSetRepresentation);
        int iType = 0;
        int i = 0;
        while (i < strTok.length) {
            String strDataElement = strTok[i];
            if (strDataElement.startsWith("'")) {
                iType = 3;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            NumberFormat nf = NumberFormat.getNumberInstance();
            switch (iType) {
                case 0: {
                    Calendar cal;
                    Date dateElement;
                    try {
                        dateElement = sdf.parse(strDataElement);
                        cal = Calendar.getInstance();
                        cal.setTime(dateElement);
                        ds = DateTimeDataSetImpl.create(null);
                        vData.add(cal);
                        iType = 1;
                    }
                    catch (ParseException parseException) {
                        try {
                            Number numberElement = nf.parse(strDataElement);
                            ds = NumberDataSetImpl.create(null);
                            vData.add(new Double(numberElement.doubleValue()));
                            iType = 2;
                        }
                        catch (ParseException parseException2) {
                            ds = TextDataSetImpl.create(null);
                            vData.add(strDataElement);
                            iType = 3;
                        }
                    }
                    break;
                }
                case 1: {
                    if (ds == null) {
                        ds = DateTimeDataSetImpl.create(null);
                    }
                    Date dateElement = null;
                    try {
                        dateElement = sdf.parse(strDataElement);
                    }
                    catch (ParseException parseException) {
                        dateElement = new Date();
                    }
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(dateElement);
                    vData.add(cal);
                    break;
                }
                case 2: {
                    if (ds == null) {
                        ds = NumberDataSetImpl.create(null);
                    }
                    Number numberElement = null;
                    try {
                        numberElement = nf.parse(strDataElement);
                    }
                    catch (ParseException parseException) {
                        numberElement = null;
                    }
                    vData.add(numberElement == null ? null : new Double(numberElement.doubleValue()));
                    break;
                }
                case 3: {
                    if (ds == null) {
                        ds = TextDataSetImpl.create(null);
                    }
                    if (strDataElement.startsWith("'")) {
                        strDataElement = strDataElement.substring(1, strDataElement.length() - 1);
                    }
                    vData.add(strDataElement);
                }
            }
            ++i;
        }
        if (ds == null) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.cannot.parse.sample", Messages.getResourceBundle(this.getULocale()));
        }
        ds.setValues(vData);
        return ds;
    }

    protected String[] getStringTokens(String str) {
        if (str.indexOf("\\,") < 0) {
            return str.split(",");
        }
        ArrayList<String> list = new ArrayList<String>();
        char[] charArray = (String.valueOf(str) + ",").toCharArray();
        int startIndex = 0;
        int i = 0;
        while (i < charArray.length) {
            char c = charArray[i];
            if (c == ',' && charArray[i - 1] != '\\' && i > 0) {
                list.add(str.substring(startIndex, i).replaceAll("\\\\,", ",").trim());
                startIndex = i + 1;
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public String getExpectedStringFormat() {
        return Messages.getString("info.sample.formats", this.getULocale());
    }
}

