/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.config.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import org.eclipse.birt.core.framework.IBundle;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.util.CommonUtil;
import org.eclipse.birt.report.engine.emitter.config.AbstractEmitterDescriptor;
import org.eclipse.birt.report.engine.emitter.config.IDefaultConfigLoader;
import org.eclipse.birt.report.engine.emitter.config.IEmitterDescriptor;
import org.eclipse.birt.report.engine.emitter.config.RenderOptionDefn;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JarConfigLoader
implements IDefaultConfigLoader {
    private static final Logger logger = Logger.getLogger(JarConfigLoader.class.getName());
    private static final String OPTIONS_CONFIG_FILE = "RenderDefaults.cfg";
    private static final String RENDER_OPTIONS_FILE = "RenderOptions.xml";
    private static final String EMITTER_QNAME = "emitter";
    private static final String OPTION_QNAME = "option";
    private static final String OPTION_NAME = "name";
    private static final String OPTION_DEFAULT = "default";
    private static final String OPTION_ENABLED = "enabled";

    @Override
    public Map<String, RenderOptionDefn> loadConfigFor(String bundleName, IEmitterDescriptor descriptor) {
        HashMap<String, RenderOptionDefn> options = new HashMap<String, RenderOptionDefn>();
        try {
            this.parseConfigFor(bundleName, descriptor, options);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "fail to parser config", e);
        }
        return options;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    protected void parseConfigFor(String bundleName, IEmitterDescriptor descriptor, Map<String, RenderOptionDefn> options) throws Exception {
        this.loadCfgFile(this.getResourceURL(bundleName, OPTIONS_CONFIG_FILE), descriptor, options);
        this.loadXMLFile(bundleName, RENDER_OPTIONS_FILE, descriptor, options);
    }

    private void loadCfgFile(URL url, IEmitterDescriptor descriptor, Map<String, RenderOptionDefn> options) throws Exception {
        if (url != null) {
            InputStream in = url.openStream();
            Properties defaultValues = new Properties();
            defaultValues.load(in);
            for (Map.Entry<Object, Object> entry : defaultValues.entrySet()) {
                String name = entry.getKey().toString();
                String value = entry.getValue().toString();
                options.put(name, new RenderOptionDefn(name, value, true));
            }
            in.close();
        }
    }

    protected void loadXMLFile(String bundleName, String fileName, IEmitterDescriptor descriptor, Map<String, RenderOptionDefn> options) throws Exception {
        URL url = this.getResourceURL(bundleName, fileName);
        if (url != null) {
            InputStream in = url.openStream();
            this.parseConfigXML(in, descriptor, options);
            in.close();
        }
    }

    private void parseConfigXML(InputStream in, IEmitterDescriptor descriptor, Map<String, RenderOptionDefn> options) throws Exception {
        SAXParser parser = CommonUtil.createSAXParser();
        try {
            parser.parse(in, (DefaultHandler)new RenderOptionHandler(descriptor, options));
        }
        finally {
            try {
                parser.reset();
            }
            catch (Exception e1) {
                logger.log(Level.WARNING, "failed to parse config", e1);
            }
        }
    }

    private URL getResourceURL(String bundleName, String resourceName) {
        IBundle bundle = Platform.getBundle((String)bundleName);
        if (bundle != null) {
            return bundle.getEntry(resourceName);
        }
        return null;
    }

    private class RenderOptionHandler
    extends DefaultHandler {
        private IEmitterDescriptor descriptor;
        private Map<String, RenderOptionDefn> options;

        RenderOptionHandler(IEmitterDescriptor descriptor, Map<String, RenderOptionDefn> options) {
            this.descriptor = descriptor;
            this.options = options;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String enabledStr;
            String name;
            if (JarConfigLoader.OPTION_QNAME.equalsIgnoreCase(qName) && !this.isEmpty(name = attributes.getValue(JarConfigLoader.OPTION_NAME))) {
                String defualt = attributes.getValue(JarConfigLoader.OPTION_DEFAULT);
                Boolean enabled = Boolean.TRUE;
                String enabledStr2 = attributes.getValue(JarConfigLoader.OPTION_ENABLED);
                if (!this.isEmpty(enabledStr2)) {
                    enabled = Boolean.valueOf(enabledStr2);
                }
                this.options.put(name, new RenderOptionDefn(name, defualt, enabled));
            }
            if (JarConfigLoader.EMITTER_QNAME.equalsIgnoreCase(qName) && !this.isEmpty(enabledStr = attributes.getValue(JarConfigLoader.OPTION_ENABLED))) {
                ((AbstractEmitterDescriptor)this.descriptor).setEnabled(Boolean.valueOf(enabledStr));
            }
        }

        private boolean isEmpty(String str) {
            return str == null || str.length() == 0;
        }
    }
}

