/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.core.vm;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.report.debug.core.i18n.Messages;
import org.eclipse.birt.report.debug.internal.core.vm.ReportVM;
import org.eclipse.birt.report.debug.internal.core.vm.VMBreakPoint;
import org.eclipse.birt.report.debug.internal.core.vm.VMConstants;
import org.eclipse.birt.report.debug.internal.core.vm.VMContextData;
import org.eclipse.birt.report.debug.internal.core.vm.VMException;
import org.eclipse.birt.report.debug.internal.core.vm.VMListener;
import org.eclipse.birt.report.debug.internal.core.vm.VMStackFrame;
import org.eclipse.birt.report.debug.internal.core.vm.VMValue;
import org.eclipse.birt.report.debug.internal.core.vm.VMVariable;
import org.eclipse.birt.report.debug.internal.core.vm.rm.RMStackFrame;
import org.eclipse.birt.report.debug.internal.core.vm.rm.RMValue;
import org.eclipse.birt.report.debug.internal.core.vm.rm.RMVariable;
import org.mozilla.javascript.Context;

public class ReportVMServer
implements VMConstants,
VMListener {
    private static final Logger logger = Logger.getLogger(ReportVMServer.class.getName());
    private ServerSocket serverSocket;
    private ObjectInputStream clientRequestReader;
    private ObjectOutputStream clientRequestWriter;
    private ObjectOutputStream clientEventWriter;
    private Thread requestDispatchThread;
    private ReportVM vm = new ReportVM();
    private boolean isShutdown;
    private List vmListeners;
    private Map id2val;
    private Map val2id;
    private long counter;

    public ReportVMServer() {
        this.vm.addVMListener(this);
        this.vmListeners = new ArrayList();
        this.id2val = new HashMap();
        this.val2id = new HashMap();
    }

    public void addVMListener(VMListener listener) {
        if (!this.vmListeners.contains(listener)) {
            this.vmListeners.add(listener);
        }
    }

    public void removeVMListener(VMListener listener) {
        this.vmListeners.remove(listener);
    }

    public void start(int listenPort, Context cx) throws VMException {
        try {
            this.serverSocket = new ServerSocket(listenPort, 50, null);
            Socket clientRequestSocket = this.serverSocket.accept();
            this.clientRequestReader = new ObjectInputStream(clientRequestSocket.getInputStream());
            this.clientRequestWriter = new ObjectOutputStream(clientRequestSocket.getOutputStream());
            Socket clientEventSocket = this.serverSocket.accept();
            this.clientEventWriter = new ObjectOutputStream(clientEventSocket.getOutputStream());
            logger.info(Messages.getString("ReportVMServer.ClientAccpted"));
            this.isShutdown = false;
            this.vm.attach(cx, true);
            this.startRequestDispatch();
        }
        catch (IOException e) {
            throw new VMException(e);
        }
    }

    public void shutdown(Context cx) {
        this.vm.detach(cx);
        this.terminate();
    }

    public void dispose(Context cx) {
        this.vm.dispose(cx);
        this.terminate();
    }

    private void terminate() {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        try {
            this.clientRequestReader.close();
            this.clientRequestWriter.close();
            this.clientEventWriter.close();
        }
        catch (IOException iOException) {
            logger.warning(Messages.getString("ReportVMServer.ClientDisconnected"));
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.requestDispatchThread.isAlive()) {
            this.requestDispatchThread.interrupt();
        }
        this.counter = 0L;
        this.id2val.clear();
        this.val2id.clear();
        this.requestDispatchThread = null;
        this.clientRequestReader = null;
        this.clientRequestWriter = null;
        this.clientEventWriter = null;
        this.serverSocket = null;
        logger.info(Messages.getString("ReportVMServer.ServerShutDown"));
    }

    private void startRequestDispatch() {
        this.requestDispatchThread = new Thread(new Runnable(){

            @Override
            public void run() {
                logger.info(Messages.getString("ReportVMServer.EnterRequestDispatching"));
                while (!ReportVMServer.this.isShutdown) {
                    try {
                        int op = ReportVMServer.this.clientRequestReader.readInt();
                        logger.info(String.valueOf(Messages.getString("ReportVMServer.ReceivedRequest")) + op);
                        Object arg = null;
                        if ((op & 0x100) != 0) {
                            arg = ReportVMServer.this.clientRequestReader.readObject();
                        }
                        Object rt = ReportVMServer.this.handleRequest(op, arg);
                        if ((op & 0x10) != 0) {
                            logger.info(Messages.getString("ReportVMServer.SendBackResponse"));
                            ReportVMServer.this.clientRequestWriter.writeObject(rt);
                            ReportVMServer.this.clientRequestWriter.flush();
                        }
                        Thread.sleep(50L);
                    }
                    catch (IOException iOException) {
                        logger.warning(Messages.getString("ReportVMServer.ClientDisconnected"));
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        logger.warning(Messages.getString("ReportVMServer.ServerShuttingDown"));
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
        }, "Server Request Dispatcher");
        this.requestDispatchThread.start();
    }

    private Object handleRequest(int op, Object arg) {
        Object rt = null;
        switch (op) {
            case 1: {
                this.vm.resume();
                break;
            }
            case 2: {
                this.vm.suspend();
                break;
            }
            case 3: {
                this.vm.step();
                break;
            }
            case 4: {
                this.vm.stepInto();
                break;
            }
            case 5: {
                this.vm.stepOut();
                break;
            }
            case 6: {
                this.vm.terminate();
                break;
            }
            case 18: {
                rt = Boolean.valueOf(this.vm.isSuspended());
                break;
            }
            case 17: {
                rt = this.vm.isTerminated();
                break;
            }
            case 257: {
                this.op_breakpoint(1, (VMBreakPoint)arg);
                break;
            }
            case 258: {
                this.op_breakpoint(3, (VMBreakPoint)arg);
                break;
            }
            case 259: {
                this.op_breakpoint(2, (VMBreakPoint)arg);
                break;
            }
            case 9: {
                this.vm.clearBreakPoints();
                break;
            }
            case 19: {
                rt = this.wrapVariables(this.vm.getVariables());
                break;
            }
            case 20: {
                rt = this.wrapStackFrames(this.vm.getStackFrames());
                break;
            }
            case 274: {
                rt = this.wrapStackFrame(this.vm.getStackFrame((Integer)arg));
                break;
            }
            case 273: {
                rt = this.wrapValue(this.vm.evaluate((String)arg), false);
                break;
            }
            case 275: {
                rt = this.wrapMembers((Long)arg);
            }
        }
        return rt;
    }

    private void op_breakpoint(int op, VMBreakPoint bp) {
        if (bp != null) {
            switch (op) {
                case 1: {
                    this.vm.addBreakPoint(bp);
                    break;
                }
                case 3: {
                    this.vm.modifyBreakPoint(bp);
                    break;
                }
                case 2: {
                    this.vm.removeBreakPoint(bp);
                }
            }
        }
    }

    private VMStackFrame[] wrapStackFrames(VMStackFrame[] frames) {
        if (frames != null && frames.length > 0) {
            VMStackFrame[] rfs = new RMStackFrame[frames.length];
            int i = 0;
            while (i < frames.length) {
                rfs[i] = this.wrapStackFrame(frames[i]);
                ++i;
            }
            return rfs;
        }
        return NO_FRAMES;
    }

    private VMStackFrame wrapStackFrame(VMStackFrame frame) {
        if (frame != null) {
            VMVariable[] vars = frame.getVariables();
            VMVariable[] rvars = NO_VARS;
            if (vars != null && vars.length > 0) {
                rvars = this.wrapVariables(vars);
            }
            return new RMStackFrame(frame.getName(), rvars, frame.getLineNumber());
        }
        return null;
    }

    private VMVariable[] wrapVariables(VMVariable[] vars) {
        if (vars != null && vars.length > 0) {
            VMVariable[] rvars = new RMVariable[vars.length];
            int i = 0;
            while (i < vars.length) {
                rvars[i] = this.wrapVariable(vars[i]);
                ++i;
            }
            return rvars;
        }
        return NO_VARS;
    }

    private VMVariable wrapVariable(VMVariable var) {
        if (var != null) {
            return new RMVariable(this.wrapValue(var.getValue(), false), var.getName(), var.getTypeName());
        }
        return null;
    }

    private synchronized VMValue wrapValue(VMValue val, boolean wrapMember) {
        if (val != null) {
            Object oid = this.val2id.get(val);
            if (oid != null) {
                return new RMValue((Long)oid, val.getValueString(), val.getTypeName(), wrapMember ? this.wrapMembers(val) : null);
            }
            Long vid = ++this.counter;
            this.id2val.put(vid, val);
            this.val2id.put(val, vid);
            return new RMValue(vid, val.getValueString(), val.getTypeName(), wrapMember ? this.wrapMembers(val) : null);
        }
        return null;
    }

    private VMVariable[] wrapMembers(VMValue val) {
        if (val != null) {
            VMVariable[] nms = NO_CHILD;
            VMVariable[] members = val.getMembers();
            if (members != null && members.length > 0) {
                nms = new RMVariable[members.length];
                int i = 0;
                while (i < members.length) {
                    nms[i] = new RMVariable(this.wrapValue(members[i].getValue(), false), members[i].getName(), members[i].getTypeName());
                    ++i;
                }
            }
            return nms;
        }
        return null;
    }

    private synchronized VMVariable[] wrapMembers(long vid) {
        VMValue val = (VMValue)this.id2val.get(vid);
        if (val != null) {
            return this.wrapMembers(val);
        }
        return NO_CHILD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(int eventCode, VMContextData context) {
        if (this.isShutdown) {
            return;
        }
        ServerSocket serverSocket = this.serverSocket;
        synchronized (serverSocket) {
            try {
                logger.info(String.valueOf(Messages.getString("ReportVMServer.SendVMEvent")) + eventCode + "|" + EVENT_NAMES[eventCode]);
                this.clientEventWriter.writeInt(eventCode);
                this.clientEventWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int i = 0;
        while (i < this.vmListeners.size()) {
            ((VMListener)this.vmListeners.get(i)).handleEvent(eventCode, context);
            ++i;
        }
    }
}

