/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.data.ui.util.SelectValueFetcher;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.IExpressionHelper;
import org.eclipse.birt.report.designer.internal.ui.expressions.ExpressionContextFactoryImpl;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionContextFactory;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.FormatBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SelectParameterDefaultValueDialog;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.FormatValueHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.ParameterValidationUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class CascadingParametersDialog
extends BaseDialog {
    private Composite sorttingArea;
    private Label sortKeyLabel;
    private Label sortDirectionLabel;
    private Combo sortDirectionChooser;
    private Combo sortKeyChooser;
    private static final String LABEL_SORT_GROUP = Messages.getString((String)"ParameterDialog.Label.SortGroup");
    private static final String LABEL_SORT_KEY = Messages.getString((String)"ParameterDialog.Label.SortKey");
    private static final String CHOICE_NONE = Messages.getString((String)"ParameterDialog.Label.None");
    private static final String LABEL_SORT_DIRECTION = Messages.getString((String)"ParameterDialog.Label.SortDirection");
    private static final String CHOICE_ASCENDING = Messages.getString((String)"ParameterDialog.Choice.ASCENDING");
    private static final String CHOICE_DESCENDING = Messages.getString((String)"ParameterDialog.Choice.DESCENDING");
    private static final Image ERROR_ICON = ReportPlatformUIImages.getImage("IMG_OBJS_ERROR_TSK");
    private static final String CHOICE_NULL_VALUE = Messages.getString((String)"CascadingParametersDialog.Choice.NullValue");
    private static final String CHOICE_BLANK_VALUE = Messages.getString((String)"CascadingParametersDialog.Choice.BlankValue");
    private static final String CHOICE_SELECT_VALUE = Messages.getString((String)"CascadingParametersDialog.Choice.SelectValue");
    private static final String LABEL_PARAMTER_PROMPT_TEXT = Messages.getString((String)"CascadingParametersDialog.Label.parameterPromptText");
    private static final String LABEL_VALUES = Messages.getString((String)"CascadingParametersDialog.Label.values");
    private static final String LABEL_GROUP_GENERAL = Messages.getString((String)"CascadingParametersDialog.Label.group.general");
    private static final String LABEL_CASCADING_PARAMETER_NAME = Messages.getString((String)"CascadingParametersDialog.Label.cascadingParam.name");
    private static final String LABEL_GROUP_PROMPT_TEXT = Messages.getString((String)"CascadingParametersDialog.Label.groupPromptText");
    private static final String ERROR_MSG_MISMATCH_DATA_TYPE = Messages.getString((String)"ParameterDialog.ErrorMessage.MismatchDataType");
    private static final String LABEL_PARAMETERS = Messages.getString((String)"CascadingParametersDialog.Label.parameters");
    private static final String LABEL_GROUP_PROPERTIES = Messages.getString((String)"CascadingParametersDialog.Label.group.properties");
    private static final String LABEL_PARAM_NAME = Messages.getString((String)"CascadingParametersDialog.Label.param.name");
    private static final String LABEL_LIST_LIMIT = Messages.getString((String)"CascadingParametersDialog.Label.listLimit");
    private static final String LABEL_DATA_TYPE = Messages.getString((String)"CascadingParametersDialog.Label.dataType");
    private static final String LABEL_DISPLAY_TYPE = Messages.getString((String)"CascadingParametersDialog.Label.displayType");
    private static final String LABEL_DEFAULT_VALUE = Messages.getString((String)"CascadingParametersDialog.Label.defaultValue");
    private static final String LABEL_GROUP_MORE_OPTIONS = Messages.getString((String)"CascadingParametersDialog.Label.group.moreOptions");
    private static final String LABEL_HELP_TEXT = Messages.getString((String)"CascadingParametersDialog.Label.helpText");
    private static final String LABEL_FORMAT_AS = Messages.getString((String)"CascadingParametersDialog.Label.formatAs");
    private static final String LABEL_CHANGE_FORMAT_BUTTON = Messages.getString((String)"CascadingParametersDialog.Label.button.changeFormat");
    private static final String LABEL_PREVIEW_WITH_FORMAT = Messages.getString((String)"CascadingParametersDialog.Label.preview");
    private static final String LABEL_SELECT_DATA_SET = Messages.getString((String)"CascadingParametersDialog.Label.selectDataSet");
    private static final String LABEL_SELECT_DISPLAY_COLUMN = Messages.getString((String)"CascadingParametersDialog.Label.selectDisplayColumn");
    private static final String LABEL_SELECT_VALUE_COLUMN = Messages.getString((String)"CascadingParametersDialog.Label.selectValueColumn");
    private static final String LABEL_NO_COLUMN_AVAILABLE = Messages.getString((String)"CascadingParametersDialog.Label.NoColumnAvailable");
    private static final String BUTTON_IS_REQUIRED = Messages.getString((String)"CascadingParametersDialog.Button.isRequired");
    private static final String RADIO_SINGLE = Messages.getString((String)"CascadingParametersDialog.Radio.Single");
    private static final String RADIO_MULTIPLE = Messages.getString((String)"CascadingParametersDialog.Radio.Mutli");
    private static final String COLUMN_NAME = Messages.getString((String)"CascadingParametersDialog.Label.column.name");
    private static final String COLUMN_DATA_SET = Messages.getString((String)"CascadingParametersDialog.Label.column.dataSet");
    private static final String COLUMN_VALUE = Messages.getString((String)"CascadingParametersDialog.Label.column.value");
    private static final String COLUMN_DISPLAY_TEXT = Messages.getString((String)"CascadingParametersDialog.Label.column.displayText");
    private static final String PARAM_CONTROL_LIST = "list-box/List";
    private static final String PARAM_CONTROL_COMBO = "list-box/Combo";
    private static final String DISPLAY_NAME_CONTROL_LIST = Messages.getString((String)"CascadingParametersDialog.display.controlType.listBox");
    private static final String DISPLAY_NAME_CONTROL_COMBO = Messages.getString((String)"CascadingParametersDialog.display.controlType.comboBox");
    private static final double DEFAULT_PREVIEW_NUMBER = Double.parseDouble("1234.56");
    private static final int DEFAULT_PREVIEW_INTEGER_NUMBER = 123456;
    private static final String STANDARD_DATE_TIME_PATTERN = "MM/dd/yyyy hh:mm:ss a";
    private static final String DEFAULT_PREVIEW_STRING = Messages.getString((String)"CascadingParametersDialog.default.preview.string");
    private static final String ERROR_TITLE_INVALID_LIST_LIMIT = Messages.getString((String)"ParameterDialog.ErrorTitle.InvalidListLimit");
    private static final String ERROR_MSG_INVALID_LIST_LIMIT = Messages.getString((String)"ParameterDialog.ErrorMessage.InvalidListLimit");
    private Group optionsGroup;
    private Group propertiesGroup;
    private Text cascadingNameEditor;
    private Text promptTextEditor;
    private Text paramNameEditor;
    private Text helpTextEditor;
    private Combo defaultValueChooser;
    private Text formatField;
    private Text listLimit;
    private Text promptText;
    private Combo dataTypeChooser;
    private Combo displayTypeChooser;
    private Button changeFormat;
    private Button singleDataSet;
    private Button multiDataSet;
    private CLabel previewLable;
    private Table table;
    private TableViewer valueTable;
    private Button addBtn;
    private Button editBtn;
    private Button delBtn;
    private List<Expression> defaultValueList;
    private static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getElement("ScalarParameter").getProperty("dataType").getAllowedChoices();
    private CascadingParameterGroupHandle inputParameterGroup;
    private ScalarParameterHandle selectedParameter;
    private String formatPattern;
    private String formatCategroy;
    private ULocale formatLocale;
    private Button isRequired;
    private int maxStrLengthProperty;
    private int maxStrLengthOption;
    private String[] PROPERTY_LABEL_STRING = new String[]{LABEL_PARAM_NAME, LABEL_GROUP_PROMPT_TEXT, LABEL_PARAMTER_PROMPT_TEXT, LABEL_DATA_TYPE, LABEL_DISPLAY_TYPE, LABEL_DEFAULT_VALUE};
    CLabel errorMessageLine;
    private String[] OPTION_LABEL_STRING = new String[]{LABEL_HELP_TEXT, LABEL_FORMAT_AS, LABEL_LIST_LIMIT};
    private Button isMultiple;
    protected IStructuredContentProvider tableContentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };
    protected ITableLabelProvider tableLableProvier = new ITableLabelProvider(){

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof Expression) {
                    return ((Expression)element).getStringExpression();
                }
                return element.toString();
            }
            return "";
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public Object[] getElements(Object inputElement) {
            ArrayList elementsList = new ArrayList(CascadingParametersDialog.this.inputParameterGroup.getParameters().getContents());
            for (ScalarParameterHandle handle : elementsList) {
                String[] columns = CascadingParametersDialog.this.getDataSetColumns(handle, false);
                boolean found = false;
                int i = 0;
                while (i < columns.length) {
                    if (DEUtil.getColumnExpression((String)columns[i]).equals(handle.getValueExpr()) || DEUtil.getResultSetColumnExpression((String)columns[i]).equals(handle.getValueExpr())) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (found) continue;
                try {
                    handle.setValueExpr(null);
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                }
            }
            return elementsList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };
    private ITableLabelProvider labelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String value = null;
            ScalarParameterHandle paramHandle = null;
            if (element instanceof ScalarParameterHandle) {
                paramHandle = (ScalarParameterHandle)element;
            }
            switch (columnIndex) {
                case 0: {
                    String paramName = paramHandle != CascadingParametersDialog.this.selectedParameter ? paramHandle.getName() : CascadingParametersDialog.this.paramNameEditor.getText().trim();
                    value = String.valueOf(this.getDummyText(paramHandle)) + paramName;
                    break;
                }
                case 1: {
                    DataSetHandle dataSet = null;
                    if (CascadingParametersDialog.this.isSingle()) {
                        if (paramHandle != CascadingParametersDialog.this.getFirstParameter()) break;
                        dataSet = CascadingParametersDialog.this.inputParameterGroup.getDataSet();
                    } else {
                        dataSet = CascadingParametersDialog.this.getDataSet(paramHandle);
                    }
                    if (dataSet == null) {
                        value = LABEL_SELECT_DATA_SET;
                        break;
                    }
                    value = dataSet.getName();
                    break;
                }
                case 2: {
                    if (paramHandle.getValueExpr() != null) {
                        value = CascadingParametersDialog.this.getColumnName(paramHandle, COLUMN_VALUE);
                        break;
                    }
                    if (CascadingParametersDialog.this.getDataSetColumns(paramHandle, true).length > 0) {
                        value = LABEL_SELECT_VALUE_COLUMN;
                        break;
                    }
                    value = LABEL_NO_COLUMN_AVAILABLE;
                    break;
                }
                case 3: {
                    value = CascadingParametersDialog.this.getColumnName(paramHandle, COLUMN_DISPLAY_TEXT);
                    if (value != null) break;
                    value = CascadingParametersDialog.this.getDataSetColumns(paramHandle, false).length > 0 ? LABEL_SELECT_DISPLAY_COLUMN : LABEL_NO_COLUMN_AVAILABLE;
                }
            }
            if (value == null) {
                value = "";
            }
            return value;
        }

        private String getDummyText(Object element) {
            StringBuffer buffer = new StringBuffer();
            int index = CascadingParametersDialog.this.getTableIndex(element);
            int i = 0;
            while (i < index) {
                buffer.append("    ");
                ++i;
            }
            return buffer.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private Composite mainContent;
    private TableViewer defaultValueViewer;
    private Button addValueButton;
    private Button editValueBtn;
    private Button delValueBtn;
    private Button delAllValuesBtn;
    private ExpressionButton expressionButton;
    private Composite rightButtonsPart;

    protected int getMaxStrLength(String[] string, Control control) {
        int len = UIUtil.getMaxStringWidth(string, control);
        return len;
    }

    public CascadingParametersDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public CascadingParametersDialog(String title) {
        super(title);
    }

    protected Control createDialogArea(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite((Composite)super.createDialogArea(parent), 768);
        sc.setLayout((Layout)new FillLayout());
        sc.setLayoutData((Object)new GridData(1808));
        CascadingParametersDialog.applyDialogFont((Control)sc);
        this.mainContent = new Composite((Composite)sc, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.mainContent.setLayout((Layout)layout);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.CascadingParametersDialog_ID");
        GridData data = new GridData(1808);
        this.maxStrLengthProperty = this.getMaxStrLength(this.PROPERTY_LABEL_STRING, (Control)this.mainContent);
        this.maxStrLengthOption = this.getMaxStrLength(this.OPTION_LABEL_STRING, (Control)this.mainContent);
        this.mainContent.setLayoutData((Object)data);
        this.createGeneralPart(this.mainContent);
        this.createChoicePart(this.mainContent);
        this.createDynamicParamsPart(this.mainContent);
        this.createPropertiesPart(this.mainContent);
        this.createSortingArea(this.mainContent);
        this.createOptionsPart(this.mainContent);
        this.createLabel(this.mainContent, null);
        this.errorMessageLine = new CLabel(this.mainContent, 0);
        GridData msgLineGridData = new GridData(768);
        msgLineGridData.horizontalSpan = 2;
        this.errorMessageLine.setLayoutData((Object)msgLineGridData);
        sc.setContent((Control)this.mainContent);
        sc.setExpandHorizontal(true);
        sc.setMinWidth(500);
        Point size = this.mainContent.computeSize(-1, -1);
        this.mainContent.setSize(size);
        return sc;
    }

    private String validateDefaultValue() {
        if (this.selectedParameter == null) {
            return null;
        }
        String tempDefaultValue = this.defaultValueChooser.getText();
        String tempType = DATA_TYPE_CHOICE_SET.findChoiceByDisplayName(this.dataTypeChooser.getText()).getName();
        if ("string".endsWith(tempType) || "boolean".endsWith(tempType)) {
            return null;
        }
        if (tempDefaultValue.length() > 0) {
            try {
                if (!"string".endsWith(this.getSelectedDataType()) && !"boolean".endsWith(this.getSelectedDataType())) {
                    if ("dateTime".equals(this.getSelectedDataType())) {
                        tempDefaultValue = this.convertToStandardFormat(DataTypeUtil.toDate((Object)tempDefaultValue));
                    } else if ("date".equals(this.getSelectedDataType())) {
                        tempDefaultValue = this.convertToStandardFormat(DataTypeUtil.toSqlDate((Object)tempDefaultValue));
                    } else if ("time".equals(this.getSelectedDataType())) {
                        tempDefaultValue = this.convertToStandardFormat(DataTypeUtil.toSqlTime((Object)tempDefaultValue));
                    }
                    ParameterValidationUtil.validate((String)this.getSelectedDataType(), (String)STANDARD_DATE_TIME_PATTERN, (String)tempDefaultValue, (ULocale)ULocale.getDefault());
                }
            }
            catch (BirtException birtException) {
                return ERROR_MSG_MISMATCH_DATA_TYPE;
            }
        }
        return null;
    }

    private String convertToStandardFormat(Date date) {
        if (date == null) {
            return null;
        }
        return new DateFormatter(STANDARD_DATE_TIME_PATTERN, ULocale.getDefault()).format(date);
    }

    private void updateMessageLine() {
        String errorMessage = this.validateDefaultValue();
        if (errorMessage != null) {
            this.errorMessageLine.setText(errorMessage);
            this.errorMessageLine.setImage(ERROR_ICON);
        } else {
            this.errorMessageLine.setText("");
            this.errorMessageLine.setImage(null);
        }
        this.updateButtons();
    }

    private void createLabel(Composite parent, String content) {
        Label label = new Label(parent, 0);
        if (content != null) {
            label.setText(content);
        }
        GridData gd = new GridData();
        if (label.getText().equals(LABEL_VALUES)) {
            gd.verticalAlignment = 1;
        }
        label.setLayoutData((Object)gd);
    }

    private void createGeneralPart(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(LABEL_GROUP_GENERAL);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        new Label((Composite)group, 0).setText(LABEL_CASCADING_PARAMETER_NAME);
        this.cascadingNameEditor = new Text((Composite)group, 2048);
        this.cascadingNameEditor.setLayoutData((Object)new GridData(768));
        new Label((Composite)group, 0).setText(LABEL_GROUP_PROMPT_TEXT);
        this.promptTextEditor = new Text((Composite)group, 2048);
        this.promptTextEditor.setLayoutData((Object)new GridData(768));
    }

    private void updateDataSets() {
        ArrayList elementsList = new ArrayList(this.inputParameterGroup.getParameters().getContents());
        if (elementsList == null || elementsList.size() == 0) {
            return;
        }
        DataSetHandle dataSet = this.inputParameterGroup.getDataSet();
        for (ScalarParameterHandle handle : elementsList) {
            try {
                handle.setDataSet(dataSet);
            }
            catch (SemanticException semanticException) {}
        }
    }

    private void createChoicePart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(2, true));
        this.singleDataSet = new Button(composite, 16);
        this.singleDataSet.setText(RADIO_SINGLE);
        this.singleDataSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CascadingParametersDialog.this.updateDataSets();
                CascadingParametersDialog.this.refreshValueTable();
                CascadingParametersDialog.this.updateButtons();
            }
        });
        this.multiDataSet = new Button(composite, 16);
        this.multiDataSet.setText(RADIO_MULTIPLE);
        this.multiDataSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CascadingParametersDialog.this.refreshValueTable();
                CascadingParametersDialog.this.updateButtons();
            }
        });
    }

    private void createDynamicParamsPart(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = UIUtil.createGridLayoutWithoutMargin();
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        Label label = new Label(comp, 0);
        label.setText(LABEL_PARAMETERS);
        new Label(comp, 0);
        this.table = new Table(comp, 67584);
        GridData data = new GridData(768);
        data.heightHint = 100;
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    CascadingParametersDialog.this.deleteRow();
                }
            }
        });
        int[] columnWidths = new int[]{120, 100, 120, 135};
        String[] columns = new String[]{COLUMN_NAME, COLUMN_DATA_SET, COLUMN_VALUE, COLUMN_DISPLAY_TEXT};
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(this.table, 16384);
            column.setResizable(true);
            column.setText(columns[i]);
            column.setWidth(columnWidths[i]);
            ++i;
        }
        this.table.setLayoutData((Object)data);
        this.table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                int index = CascadingParametersDialog.this.table.getSelectionIndex();
                boolean setBtnEnable = true;
                if (index == -1) {
                    setBtnEnable = false;
                }
                CascadingParametersDialog.this.editBtn.setEnabled(setBtnEnable);
                CascadingParametersDialog.this.delBtn.setEnabled(setBtnEnable);
            }

            public void focusLost(FocusEvent e) {
                int index = CascadingParametersDialog.this.table.getSelectionIndex();
                boolean setBtnEnable = true;
                if (index == -1) {
                    setBtnEnable = false;
                }
                CascadingParametersDialog.this.editBtn.setEnabled(setBtnEnable);
                CascadingParametersDialog.this.delBtn.setEnabled(setBtnEnable);
            }
        });
        this.valueTable = new TableViewer(this.table);
        this.valueTable.setColumnProperties(columns);
        this.valueTable.setContentProvider((IContentProvider)this.contentProvider);
        this.valueTable.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.valueTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                Object param = ((StructuredSelection)selection).getFirstElement();
                if (param != CascadingParametersDialog.this.selectedParameter && param instanceof ScalarParameterHandle) {
                    try {
                        CascadingParametersDialog.this.saveParameterProperties();
                        CascadingParametersDialog.this.saveSortingProperties();
                        CascadingParametersDialog.this.selectedParameter = (ScalarParameterHandle)param;
                        CascadingParametersDialog.this.defaultValueList = CascadingParametersDialog.this.selectedParameter.getDefaultValueList();
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                        CascadingParametersDialog.this.valueTable.setSelection((ISelection)new StructuredSelection((Object)CascadingParametersDialog.this.selectedParameter));
                    }
                    CascadingParametersDialog.this.refreshParameterProperties();
                    CascadingParametersDialog.this.initSorttingArea();
                    CascadingParametersDialog.this.updateButtons();
                }
            }
        });
        this.valueTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CascadingParametersDialog.this.editParameter(CascadingParametersDialog.this.selectedParameter);
            }
        });
        Composite composite = new Composite(comp, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(2));
        this.addBtn = new Button(composite, 0);
        this.addBtn.setLayoutData((Object)new GridData(768));
        this.addBtn.setText(Messages.getString((String)"CascadingParametersDialog.Button.Add"));
        this.addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddEditCascadingParameterDialog dialog = new AddEditCascadingParameterDialog(Messages.getString((String)"CascadingParametersDialog.Title.AddCascadingParameter"));
                if (dialog.open() != 0) {
                    return;
                }
                try {
                    CascadingParametersDialog.this.inputParameterGroup.getParameters().add((DesignElementHandle)dialog.getParameter());
                    int i = 0;
                    while (i < CascadingParametersDialog.this.inputParameterGroup.getParameters().getCount() - 1) {
                        ScalarParameterHandle parameter = (ScalarParameterHandle)CascadingParametersDialog.this.inputParameterGroup.getParameters().get(i);
                        parameter.setParamType("simple");
                        List valueLisit = parameter.getDefaultValueList();
                        if (valueLisit != null && valueLisit.size() > 0) {
                            Object expression = valueLisit.get(0);
                            valueLisit.clear();
                            valueLisit.add(expression);
                        }
                        parameter.setDefaultValueList(valueLisit);
                        ++i;
                    }
                }
                catch (ContentException e1) {
                    ExceptionHandler.handle(e1);
                }
                catch (NameException e1) {
                    ExceptionHandler.handle(e1);
                }
                catch (SemanticException e1) {
                    ExceptionHandler.handle(e1);
                }
                CascadingParametersDialog.this.refreshValueTable();
                CascadingParametersDialog.this.valueTable.setSelection((ISelection)new StructuredSelection((Object)dialog.getParameter()));
                CascadingParametersDialog.this.updateButtons();
            }
        });
        this.editBtn = new Button(composite, 0);
        this.editBtn.setLayoutData((Object)new GridData(768));
        this.editBtn.setText(Messages.getString((String)"CascadingParametersDialog.Button.Edit"));
        this.editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CascadingParametersDialog.this.editParameter(CascadingParametersDialog.this.selectedParameter);
            }
        });
        this.delBtn = new Button(composite, 0);
        this.delBtn.setLayoutData((Object)new GridData(768));
        this.delBtn.setText(Messages.getString((String)"CascadingParametersDialog.Button.Delete"));
        this.delBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CascadingParametersDialog.this.deleteRow();
                CascadingParametersDialog.this.updateButtons();
            }
        });
    }

    protected void editParameter(ScalarParameterHandle param) {
        if (param == null) {
            return;
        }
        CommandStack cmdStack = SessionHandleAdapter.getInstance().getReportDesignHandle().getCommandStack();
        cmdStack.startTrans(Messages.getString((String)"CascadingParametersDialog.Title.EditCascadingParameter"));
        AddEditCascadingParameterDialog dialog = new AddEditCascadingParameterDialog(Messages.getString((String)"CascadingParametersDialog.Title.EditCascadingParameter"));
        dialog.setParameter(param);
        if (dialog.open() != 0) {
            cmdStack.rollback();
            return;
        }
        cmdStack.commit();
        this.refreshValueTable();
        this.refreshParameterProperties();
        this.initSorttingArea();
        this.updateButtons();
    }

    private void createPropertiesPart(Composite parent) {
        this.propertiesGroup = new Group(parent, 0);
        this.propertiesGroup.setText(LABEL_GROUP_PROPERTIES);
        this.propertiesGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        this.propertiesGroup.setLayoutData((Object)gd);
        this.createLabel((Composite)this.propertiesGroup, LABEL_PARAM_NAME, this.maxStrLengthProperty);
        this.paramNameEditor = new Text((Composite)this.propertiesGroup, 2056);
        this.paramNameEditor.setLayoutData((Object)new GridData(768));
        this.paramNameEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CascadingParametersDialog.this.valueTable.refresh((Object)CascadingParametersDialog.this.selectedParameter);
            }
        });
        this.createLabel((Composite)this.propertiesGroup, LABEL_PARAMTER_PROMPT_TEXT, this.maxStrLengthProperty);
        this.promptText = new Text((Composite)this.propertiesGroup, 2048);
        this.promptText.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)this.propertiesGroup, LABEL_DATA_TYPE, this.maxStrLengthProperty);
        this.dataTypeChooser = new Combo((Composite)this.propertiesGroup, 12);
        this.dataTypeChooser.setVisibleItemCount(30);
        this.dataTypeChooser.setLayoutData((Object)new GridData(768));
        this.dataTypeChooser.setItems(ChoiceSetFactory.getDisplayNamefromChoiceSet(DATA_TYPE_CHOICE_SET));
        this.dataTypeChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CascadingParametersDialog.this.selectedParameter != null) {
                    CascadingParametersDialog.this.changeDataType(DATA_TYPE_CHOICE_SET.findChoiceByDisplayName(CascadingParametersDialog.this.dataTypeChooser.getText()).getName());
                    try {
                        CascadingParametersDialog.this.selectedParameter.setDataType(DATA_TYPE_CHOICE_SET.findChoiceByDisplayName(CascadingParametersDialog.this.dataTypeChooser.getText()).getName());
                    }
                    catch (SemanticException e1) {
                        ExceptionHandler.handle(e1);
                    }
                }
                CascadingParametersDialog.this.updateMessageLine();
            }
        });
        this.createLabel((Composite)this.propertiesGroup, LABEL_DISPLAY_TYPE, this.maxStrLengthProperty);
        this.displayTypeChooser = new Combo((Composite)this.propertiesGroup, 12);
        this.displayTypeChooser.setVisibleItemCount(30);
        this.displayTypeChooser.setLayoutData((Object)new GridData(768));
        this.displayTypeChooser.setItems(new String[]{DISPLAY_NAME_CONTROL_LIST, DISPLAY_NAME_CONTROL_COMBO});
        this.displayTypeChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CascadingParametersDialog.this.selectedParameter != null) {
                    try {
                        String newControlType = CascadingParametersDialog.this.getSelectedDisplayType();
                        if (CascadingParametersDialog.PARAM_CONTROL_COMBO.equals(newControlType)) {
                            newControlType = "list-box";
                            CascadingParametersDialog.this.selectedParameter.setMustMatch(false);
                            CascadingParametersDialog.this.isMultiple.setEnabled(false);
                            CascadingParametersDialog.this.isMultiple.setSelection(false);
                            CascadingParametersDialog.this.selectedParameter.setParamType("simple");
                            CascadingParametersDialog.this.simpleDefaultValueList();
                        } else if (CascadingParametersDialog.PARAM_CONTROL_LIST.equals(newControlType)) {
                            newControlType = "list-box";
                            CascadingParametersDialog.this.selectedParameter.setMustMatch(true);
                            if (CascadingParametersDialog.this.selectedParameter == CascadingParametersDialog.this.inputParameterGroup.getParameters().get(CascadingParametersDialog.this.inputParameterGroup.getParameters().getCount() - 1)) {
                                CascadingParametersDialog.this.isMultiple.setEnabled(true);
                                if (CascadingParametersDialog.this.isMultiple.getSelection()) {
                                    CascadingParametersDialog.this.selectedParameter.setParamType("multi-value");
                                } else {
                                    CascadingParametersDialog.this.selectedParameter.setParamType("simple");
                                    CascadingParametersDialog.this.simpleDefaultValueList();
                                }
                            } else {
                                CascadingParametersDialog.this.isMultiple.setEnabled(false);
                                CascadingParametersDialog.this.isMultiple.setSelection(false);
                                CascadingParametersDialog.this.selectedParameter.setParamType("simple");
                                CascadingParametersDialog.this.simpleDefaultValueList();
                            }
                        } else {
                            CascadingParametersDialog.this.selectedParameter.setProperty("mustMatch", null);
                        }
                        CascadingParametersDialog.this.selectedParameter.setControlType(newControlType);
                        CascadingParametersDialog.this.initDefaultValueViewer();
                    }
                    catch (SemanticException e1) {
                        ExceptionHandler.handle(e1);
                    }
                }
            }
        });
        this.createLabel((Composite)this.propertiesGroup, LABEL_DEFAULT_VALUE, this.maxStrLengthProperty);
        Composite composite = new Composite((Composite)this.propertiesGroup, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.defaultValueChooser = new Combo(composite, 2048);
        this.defaultValueChooser.setVisibleItemCount(30);
        this.defaultValueChooser.setLayoutData((Object)new GridData(768));
        this.defaultValueChooser.add(CHOICE_SELECT_VALUE);
        this.defaultValueChooser.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String selection = e.text;
                if (CascadingParametersDialog.this.defaultValueChooser.indexOf(selection) == -1) {
                    e.doit = true;
                    return;
                }
                e.doit = !selection.equals(CHOICE_SELECT_VALUE);
            }
        });
        this.defaultValueChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CascadingParametersDialog.this.defaultValueChooser.getSelectionIndex() == -1) {
                    return;
                }
                String selection = CascadingParametersDialog.this.defaultValueChooser.getItem(CascadingParametersDialog.this.defaultValueChooser.getSelectionIndex());
                if (selection.equals(CHOICE_SELECT_VALUE)) {
                    String[] selectedValues;
                    List columnValueList = CascadingParametersDialog.this.getColumnValueList();
                    if (columnValueList.isEmpty()) {
                        return;
                    }
                    SelectParameterDefaultValueDialog dialog = new SelectParameterDefaultValueDialog(Display.getCurrent().getActiveShell(), Messages.getString((String)"SelectParameterDefaultValueDialog.Title"));
                    dialog.setColumnValueList(columnValueList, CascadingParametersDialog.this.getSelectedDataType());
                    int status = dialog.open();
                    if (status == 0 && (selectedValues = dialog.getSelectedValue()) != null) {
                        int i = 0;
                        while (i < selectedValues.length) {
                            String selectedValue = selectedValues[i];
                            if ("javascript".equals(CascadingParametersDialog.this.defaultValueChooser.getData("exprType"))) {
                                selectedValue = CascadingParametersDialog.this.getSelectedExprValue(selectedValue);
                            }
                            CascadingParametersDialog.this.defaultValueChooser.setText(DEUtil.resolveNull((String)selectedValue));
                            CascadingParametersDialog.this.addDynamicDefaultValue();
                            ++i;
                        }
                    }
                }
            }
        });
        this.defaultValueChooser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!CascadingParametersDialog.this.isMultiple.isEnabled() || !CascadingParametersDialog.this.isMultiple.getSelection()) {
                    String modelValue;
                    String value = CascadingParametersDialog.this.defaultValueChooser.getText();
                    String type = (String)CascadingParametersDialog.this.defaultValueChooser.getData("exprType");
                    if (CascadingParametersDialog.this.defaultValueList != null) {
                        CascadingParametersDialog.this.defaultValueList.clear();
                    }
                    if ((modelValue = UIUtil.convertToModelString(value, false)) != null) {
                        CascadingParametersDialog.this.setFirstDefaultValue(modelValue, type);
                    }
                } else {
                    CascadingParametersDialog.this.updateDynamicTableButtons();
                }
                CascadingParametersDialog.this.updateMessageLine();
            }
        });
        IExpressionHelper helper = new IExpressionHelper(){

            @Override
            public String getExpression() {
                if (CascadingParametersDialog.this.defaultValueChooser != null) {
                    return CascadingParametersDialog.this.defaultValueChooser.getText();
                }
                return "";
            }

            @Override
            public void setExpression(String expression) {
                if (CascadingParametersDialog.this.defaultValueChooser != null) {
                    CascadingParametersDialog.this.defaultValueChooser.setText(expression);
                }
            }

            @Override
            public void notifyExpressionChangeEvent(String oldExpression, String newExpression) {
                if (CascadingParametersDialog.this.defaultValueChooser != null) {
                    CascadingParametersDialog.this.defaultValueChooser.setFocus();
                }
                if (newExpression != null && newExpression.trim().length() > 0 && !newExpression.equals(oldExpression)) {
                    CascadingParametersDialog.this.addDynamicDefaultValue();
                    CascadingParametersDialog.this.updateDynamicTableButtons();
                }
            }

            public IExpressionProvider getExpressionProvider() {
                return new ExpressionProvider((DesignElementHandle)CascadingParametersDialog.this.selectedParameter);
            }

            @Override
            public String getExpressionType() {
                return (String)CascadingParametersDialog.this.defaultValueChooser.getData("exprType");
            }

            @Override
            public void setExpressionType(String exprType) {
                CascadingParametersDialog.this.defaultValueChooser.setData("exprType", (Object)exprType);
                CascadingParametersDialog.this.defaultValueChooser.notifyListeners(24, new Event());
            }

            @Override
            public Object getContextObject() {
                return CascadingParametersDialog.this.selectedParameter;
            }

            @Override
            public IExpressionContextFactory getExpressionContextFactory() {
                return new ExpressionContextFactoryImpl(CascadingParametersDialog.this.selectedParameter, this.getExpressionProvider());
            }
        };
        this.expressionButton = UIUtil.createExpressionButton(composite, 8);
        this.expressionButton.setExpressionHelper(helper);
        this.defaultValueChooser.setData("exprButton", (Object)this.expressionButton);
        this.defaultValueChooser.setData("exprType", (Object)"constant");
        this.expressionButton.refresh();
        this.addValueButton = new Button(composite, 8);
        this.addValueButton.setText(Messages.getString((String)"CascadingParametersDialog.DefalutValue.Add"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.addValueButton.setLayoutData((Object)gd);
        this.addValueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CascadingParametersDialog.this.addDynamicDefaultValue();
                CascadingParametersDialog.this.updateDynamicTableButtons();
            }
        });
        this.createMulitipleValueListComposite(composite);
        this.initDefaultValueViewer();
    }

    private void createMulitipleValueListComposite(Composite parent) {
        int tableStyle = 68356;
        Table table = new Table(parent, tableStyle);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = 100;
        table.setLayoutData((Object)data);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        String[] columNames = new String[]{Messages.getString((String)"FilterConditionBuilder.list.item1")};
        int[] columLength = new int[]{288};
        int i = 0;
        while (i < columNames.length) {
            TableColumn column = new TableColumn(table, 0, i);
            column.setText(columNames[i]);
            column.setWidth(columLength[i]);
            ++i;
        }
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CascadingParametersDialog.this.updateDynamicTableButtons();
            }
        });
        table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    CascadingParametersDialog.this.delTableValue();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                CascadingParametersDialog.this.editTableValue();
            }
        });
        this.defaultValueViewer = new TableViewer(table);
        this.defaultValueViewer.setUseHashlookup(true);
        this.defaultValueViewer.setColumnProperties(columNames);
        this.defaultValueViewer.setLabelProvider((IBaseLabelProvider)this.tableLableProvier);
        this.defaultValueViewer.setContentProvider((IContentProvider)this.tableContentProvider);
        this.rightButtonsPart = new Composite(parent, 0);
        data = new GridData(1040);
        this.rightButtonsPart.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.rightButtonsPart.setLayout((Layout)layout);
        this.editValueBtn = new Button(this.rightButtonsPart, 8);
        this.editValueBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.edit"));
        this.editValueBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.edit.tooltip"));
        this.setButtonLayoutData(this.editValueBtn);
        this.editValueBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CascadingParametersDialog.this.editTableValue();
            }
        });
        this.delValueBtn = new Button(this.rightButtonsPart, 8);
        this.delValueBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.delete"));
        this.delValueBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.delete.tooltip"));
        this.setButtonLayoutData(this.delValueBtn);
        this.delValueBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CascadingParametersDialog.this.delTableValue();
            }
        });
        this.delAllValuesBtn = new Button(this.rightButtonsPart, 8);
        this.delAllValuesBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.deleteall"));
        this.delAllValuesBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.deleteall.tooltip"));
        this.setButtonLayoutData(this.delAllValuesBtn);
        this.delAllValuesBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int count = CascadingParametersDialog.this.defaultValueList.size();
                if (count > 0) {
                    CascadingParametersDialog.this.defaultValueList.clear();
                    CascadingParametersDialog.this.defaultValueViewer.refresh();
                    CascadingParametersDialog.this.updateDynamicTableButtons();
                } else {
                    CascadingParametersDialog.this.delAllValuesBtn.setEnabled(false);
                }
            }
        });
    }

    protected void delTableValue() {
        int index = this.defaultValueViewer.getTable().getSelectionIndex();
        if (index > -1) {
            this.defaultValueList.remove(index);
            this.defaultValueViewer.refresh();
            if (this.defaultValueList.size() > 0) {
                if (this.defaultValueList.size() <= index) {
                    --index;
                }
                this.defaultValueViewer.getTable().select(index);
            }
            this.updateDynamicTableButtons();
        } else {
            this.delValueBtn.setEnabled(false);
        }
    }

    protected void editTableValue() {
        IStructuredSelection selection = (IStructuredSelection)this.defaultValueViewer.getSelection();
        if (selection.getFirstElement() != null && selection.getFirstElement() instanceof Expression) {
            Expression expression = (Expression)selection.getFirstElement();
            ExpressionProvider provider = new ExpressionProvider((DesignElementHandle)this.selectedParameter);
            ExpressionEditor editor = new ExpressionEditor(Messages.getString((String)"CascadingParametersDialog.ExpressionEditor.Title"));
            editor.setInput(this.selectedParameter, provider, true);
            editor.setExpression(expression);
            if (editor.open() == 0) {
                Expression value = editor.getExpression();
                if (DEUtil.resolveNull((String)value.getStringExpression()).length() == 0) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString((String)"MapRuleBuilderDialog.MsgDlg.Title"), (String)Messages.getString((String)"MapRuleBuilderDialog.MsgDlg.Msg"));
                    return;
                }
                int index = this.defaultValueViewer.getTable().getSelectionIndex();
                this.defaultValueList.remove(index);
                this.defaultValueList.add(index, value);
                this.defaultValueViewer.refresh();
                this.defaultValueViewer.getTable().select(index);
            }
            this.updateDynamicTableButtons();
        } else {
            this.editValueBtn.setEnabled(false);
        }
    }

    private void initDefaultValueViewer() {
        if (this.defaultValueViewer != null) {
            if (this.isMultiple != null && this.isMultiple.isEnabled()) {
                WidgetUtil.setExcludeGridData((Control)this.defaultValueViewer.getTable(), !this.isMultiple.getSelection());
                WidgetUtil.setExcludeGridData((Control)this.rightButtonsPart, !this.isMultiple.getSelection());
                WidgetUtil.setExcludeGridData((Control)this.addValueButton, !this.isMultiple.getSelection());
                if (this.isMultiple.getSelection()) {
                    this.defaultValueViewer.setInput(this.defaultValueList);
                    this.updateDynamicTableButtons();
                }
            } else {
                WidgetUtil.setExcludeGridData((Control)this.defaultValueViewer.getTable(), true);
                WidgetUtil.setExcludeGridData((Control)this.rightButtonsPart, true);
                WidgetUtil.setExcludeGridData((Control)this.addValueButton, true);
            }
            this.addValueButton.getParent().layout();
            this.defaultValueViewer.getTable().getParent().layout();
            Point size = this.mainContent.computeSize(-1, -1);
            this.mainContent.setSize(size);
            this.mainContent.getParent().layout();
            int y = this.getShell().computeSize((int)-1, (int)-1).y;
            int screecY = Display.getDefault().getClientArea().height;
            if (y < screecY && this.isMultiple != null && this.isMultiple.isEnabled() && this.isMultiple.getSelection()) {
                this.getShell().pack();
                int realY = this.getShell().toDisplay((int)this.getShell().getBounds().width, (int)this.getShell().getBounds().height).y;
                if (realY > screecY) {
                    this.getShell().setLocation(this.getShell().getLocation().x, this.getShell().getLocation().y + screecY - realY);
                }
            }
        }
    }

    private List getColumnList() {
        List columnList = new ArrayList();
        DataSetHandle dataSetHandle = this.getDataSet(this.selectedParameter);
        try {
            columnList = DataUtil.getColumnList(dataSetHandle);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        return columnList.isEmpty() ? Collections.EMPTY_LIST : columnList;
    }

    private List getColumnValueList() {
        ArrayList valueList = new ArrayList();
        DataSetHandle dataSet = this.getDataSet(this.selectedParameter);
        try {
            String queryExpr = this.selectedParameter.getValueExpr();
            valueList.addAll(SelectValueFetcher.getSelectValueList(new Expression((Object)queryExpr, "javascript"), dataSet, DataEngineContext.DataEngineFlowMode.PARAM_EVALUATION_FLOW));
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return Collections.EMPTY_LIST;
        }
        Collections.sort(valueList);
        return valueList;
    }

    private void createOptionsPart(Composite parent) {
        this.optionsGroup = new Group(parent, 0);
        this.optionsGroup.setText(LABEL_GROUP_MORE_OPTIONS);
        this.optionsGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        this.optionsGroup.setLayoutData((Object)gd);
        this.createLabel((Composite)this.optionsGroup, LABEL_HELP_TEXT, this.maxStrLengthOption);
        this.helpTextEditor = new Text((Composite)this.optionsGroup, 2048);
        this.helpTextEditor.setLayoutData((Object)new GridData(768));
        Label lable = new Label((Composite)this.optionsGroup, 0);
        lable.setText(LABEL_FORMAT_AS);
        lable.setLayoutData((Object)new GridData(32));
        Composite formatArea = new Composite((Composite)this.optionsGroup, 0);
        formatArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        formatArea.setLayoutData((Object)new GridData(768));
        this.formatField = new Text(formatArea, 2060);
        this.formatField.setLayoutData((Object)new GridData(768));
        this.changeFormat = new Button(formatArea, 8);
        this.changeFormat.setText(LABEL_CHANGE_FORMAT_BUTTON);
        this.setButtonLayoutData(this.changeFormat);
        this.changeFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CascadingParametersDialog.this.popupFormatBuilder(true);
            }
        });
        Group preview = new Group(formatArea, 0);
        preview.setText(LABEL_PREVIEW_WITH_FORMAT);
        preview.setLayoutData((Object)new GridData(768));
        preview.setLayout((Layout)new GridLayout());
        this.previewLable = new CLabel((Composite)preview, 0x11000100);
        this.previewLable.setText("");
        this.previewLable.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)this.optionsGroup, LABEL_LIST_LIMIT, this.maxStrLengthOption);
        Composite composite = new Composite((Composite)this.optionsGroup, 0);
        composite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Composite limitArea = new Composite(composite, 0);
        limitArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        limitArea.setLayoutData((Object)new GridData(768));
        this.listLimit = new Text(limitArea, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 80;
        this.listLimit.setLayoutData((Object)gridData);
        this.listLimit.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = "0123456789\u0000\b\u007f".indexOf(e.character) != -1;
            }
        });
        this.listLimit.addModifyListener(new ModifyListener(){
            private String oldValue = "";

            public void modifyText(ModifyEvent e) {
                try {
                    if (!StringUtil.isBlank((String)CascadingParametersDialog.this.listLimit.getText())) {
                        Integer.parseInt(CascadingParametersDialog.this.listLimit.getText());
                        this.oldValue = CascadingParametersDialog.this.listLimit.getText();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    ExceptionHandler.openErrorMessageBox(ERROR_TITLE_INVALID_LIST_LIMIT, MessageFormat.format(ERROR_MSG_INVALID_LIST_LIMIT, Integer.toString(Integer.MAX_VALUE)));
                    CascadingParametersDialog.this.listLimit.setText(this.oldValue);
                }
            }
        });
        new Label(limitArea, 0).setText(LABEL_VALUES);
        this.isRequired = new Button(composite, 32);
        this.isRequired.setText(BUTTON_IS_REQUIRED);
        this.isRequired.setLayoutData((Object)new GridData(768));
        this.isRequired.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CascadingParametersDialog.this.isRequiredChange(CascadingParametersDialog.this.isRequired.getSelection());
                if (CascadingParametersDialog.this.selectedParameter != null) {
                    try {
                        CascadingParametersDialog.this.selectedParameter.setIsRequired(CascadingParametersDialog.this.isRequired.getSelection());
                    }
                    catch (SemanticException e1) {
                        ExceptionHandler.handle(e1);
                    }
                }
            }
        });
        this.isMultiple = new Button(composite, 32);
        this.isMultiple.setText(Messages.getString((String)"CascadingParametersDialog.Button.IsMultiple"));
        this.isMultiple.setLayoutData((Object)new GridData(768));
        this.isMultiple.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CascadingParametersDialog.this.selectedParameter != null) {
                    try {
                        if (CascadingParametersDialog.this.isMultiple.getSelection()) {
                            CascadingParametersDialog.this.selectedParameter.setParamType("multi-value");
                        } else {
                            CascadingParametersDialog.this.selectedParameter.setParamType("simple");
                        }
                        if (!CascadingParametersDialog.this.isMultiple.getSelection() && CascadingParametersDialog.this.defaultValueList != null && CascadingParametersDialog.this.defaultValueList.size() > 0) {
                            Expression expression = CascadingParametersDialog.this.getFirstDefaultValue();
                            CascadingParametersDialog.this.defaultValueList.clear();
                            CascadingParametersDialog.this.defaultValueList.add(expression);
                        }
                        CascadingParametersDialog.this.initDefaultValueViewer();
                    }
                    catch (SemanticException e1) {
                        ExceptionHandler.handle(e1);
                    }
                }
            }
        });
    }

    private void isRequiredChange(boolean isRequired) {
        if (this.getSelectedDataType().equals("string")) {
            this.clearDefaultValueChooser(isRequired);
        }
    }

    private void clearDefaultValueChooser(boolean isChecked) {
        if (isChecked) {
            this.clearDefaultValueText();
            this.clearDefaultValueChooserSelections();
        } else if (this.defaultValueChooser == null || this.defaultValueChooser.isDisposed() || this.defaultValueChooser.getItemCount() > 0) {
            return;
        }
    }

    private void createLabel(Composite parent, String content, int width) {
        Label label = new Label(parent, 0);
        this.setLabelLayoutData((Control)label, width);
        if (content != null) {
            label.setText(content);
        }
    }

    private void setLabelLayoutData(Control control, int width) {
        GridData gd = new GridData(2);
        gd.widthHint = width;
        control.setLayoutData((Object)gd);
    }

    public void setInput(Object input) {
        Assert.isLegal((boolean)(input instanceof CascadingParameterGroupHandle));
        this.inputParameterGroup = (CascadingParameterGroupHandle)input;
    }

    @Override
    protected boolean initDialog() {
        this.cascadingNameEditor.setText(this.inputParameterGroup.getName());
        this.promptTextEditor.setText(UIUtil.convertToGUIString(this.inputParameterGroup.getPromptText()));
        if ("multiple".equals(this.inputParameterGroup.getDataSetMode())) {
            this.multiDataSet.setSelection(true);
        } else {
            this.singleDataSet.setSelection(true);
        }
        this.valueTable.setInput((Object)this.inputParameterGroup);
        this.initSorttingArea();
        this.updateButtons();
        this.refreshParameterProperties();
        Point size = this.mainContent.computeSize(-1, -1);
        this.mainContent.setSize(size);
        return true;
    }

    private void validateDefaultValues() throws BirtException {
        ArrayList elementsList = new ArrayList(this.inputParameterGroup.getParameters().getContents());
        if (elementsList == null || elementsList.size() == 0) {
            return;
        }
        for (ScalarParameterHandle handle : elementsList) {
            String tempDefaultValue = handle.getDefaultValue();
            String tempType = handle.getDataType();
            if ("string".endsWith(tempType) || "boolean".endsWith(tempType) || "string".endsWith(tempType) || "boolean".endsWith(tempType)) continue;
            if ("dateTime".equals(tempType)) {
                tempDefaultValue = this.convertToStandardFormat(DataTypeUtil.toDate((Object)tempDefaultValue));
            } else if ("date".equals(tempType)) {
                tempDefaultValue = this.convertToStandardFormat(DataTypeUtil.toSqlDate((Object)tempDefaultValue));
            } else if ("time".equals(tempType)) {
                tempDefaultValue = this.convertToStandardFormat(DataTypeUtil.toSqlTime((Object)tempDefaultValue));
            }
            ParameterValidationUtil.validate((String)tempType, (String)STANDARD_DATE_TIME_PATTERN, (String)tempDefaultValue, (ULocale)ULocale.getDefault());
        }
    }

    protected void okPressed() {
        try {
            this.saveParameterProperties();
            this.saveSortingProperties();
            this.validateDefaultValues();
            this.inputParameterGroup.setName(UIUtil.convertToModelString(this.cascadingNameEditor.getText(), true));
            this.inputParameterGroup.setPromptText(this.promptTextEditor.getText());
            if (this.isSingle()) {
                this.inputParameterGroup.setDataSetMode("single");
            } else {
                this.inputParameterGroup.setDataSetMode("multiple");
            }
        }
        catch (BirtException e) {
            ExceptionHandler.handle(e);
            this.refreshParameterProperties();
            this.initSorttingArea();
            return;
        }
        this.setResult(this.inputParameterGroup);
        super.okPressed();
    }

    private void deleteRow() {
        int index = this.valueTable.getTable().getSelectionIndex();
        boolean setBtnEnable = true;
        if (index == -1) {
            setBtnEnable = false;
        }
        this.editBtn.setEnabled(setBtnEnable);
        this.delBtn.setEnabled(setBtnEnable);
        ScalarParameterHandle choice = (ScalarParameterHandle)((IStructuredSelection)this.valueTable.getSelection()).getFirstElement();
        if (choice == null) {
            return;
        }
        try {
            this.inputParameterGroup.getParameters().drop((DesignElementHandle)choice);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return;
        }
        this.refreshValueTable();
        if (--index < 0 && this.valueTable.getTable().getItemCount() > 1) {
            index = 0;
        }
        StructuredSelection selection = null;
        if (index != -1) {
            selection = new StructuredSelection(this.valueTable.getTable().getItem(index).getData());
            this.selectedParameter = (ScalarParameterHandle)((IStructuredSelection)this.valueTable.getSelection()).getFirstElement();
        } else {
            selection = StructuredSelection.EMPTY;
            this.selectedParameter = null;
        }
        this.valueTable.setSelection((ISelection)selection);
        this.refreshParameterProperties();
        this.initSorttingArea();
        this.updateButtons();
    }

    private String[] getDataSetColumns(ScalarParameterHandle handle, boolean needFilter) {
        DataSetHandle dataSet = this.getDataSet(handle);
        if (dataSet == null) {
            return new String[0];
        }
        CachedMetaDataHandle metaHandle = dataSet.getCachedMetaDataHandle();
        if (metaHandle == null) {
            try {
                metaHandle = DataSetUIUtil.getCachedMetaDataHandle(dataSet);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
                return new String[0];
            }
        }
        if (metaHandle == null || metaHandle.getResultSet() == null) {
            return new String[0];
        }
        ArrayList<String> valueList = new ArrayList<String>();
        ArrayList<String> dataTypeList = new ArrayList<String>();
        for (ResultSetColumnHandle columnHandle : metaHandle.getResultSet()) {
            if (needFilter && !this.matchDataType(handle, columnHandle)) continue;
            valueList.add(columnHandle.getColumnName());
            dataTypeList.add(columnHandle.getDataType());
        }
        return valueList.toArray(new String[0]);
    }

    private DataSetHandle getDataSet(ScalarParameterHandle handle) {
        if (!this.isSingle()) {
            if (handle != null && handle.getDataSet() != null) {
                return handle.getDataSet();
            }
            return null;
        }
        return this.inputParameterGroup.getDataSet();
    }

    protected int getTableIndex(Object element) {
        Object[] input = ((IStructuredContentProvider)this.valueTable.getContentProvider()).getElements(this.valueTable.getInput());
        int index = 0;
        int i = 0;
        while (i < input.length) {
            if (element == input[i]) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private void refreshValueTable() {
        if (this.valueTable != null && !this.valueTable.getTable().isDisposed()) {
            this.valueTable.refresh();
        }
    }

    private void refreshParameterProperties() {
        String expressionType;
        if (this.selectedParameter == null) {
            this.clearParamProperties();
            this.setControlEnabled(false);
            this.initDefaultValueViewer();
            return;
        }
        this.setControlEnabled(true);
        this.paramNameEditor.setText(this.selectedParameter.getName());
        if (this.selectedParameter.getPromptText() == null) {
            this.promptText.setText("");
        } else {
            this.promptText.setText(this.selectedParameter.getPromptText());
        }
        this.dataTypeChooser.setText(DATA_TYPE_CHOICE_SET.findChoice(this.selectedParameter.getDataType()).getDisplayName());
        if (this.getInputDisplayName() == null) {
            this.displayTypeChooser.clearSelection();
        } else {
            this.displayTypeChooser.setText(this.getInputDisplayName());
        }
        Expression expression = this.getFirstDefaultValue();
        String defaultValue = expression == null ? null : expression.getStringExpression();
        String string = expressionType = expression == null ? null : expression.getType();
        if (expressionType != null) {
            this.defaultValueChooser.setData("exprType", (Object)expressionType);
            ExpressionButton button = (ExpressionButton)this.defaultValueChooser.getData("exprButton");
            if (button != null) {
                button.refresh();
            }
        }
        if (this.getSelectedDataType().equals("string")) {
            this.defaultValueChooser.setText(DEUtil.resolveNull((String)defaultValue));
        } else if (defaultValue != null) {
            this.defaultValueChooser.setText(defaultValue);
        } else {
            this.defaultValueChooser.setText("");
        }
        this.helpTextEditor.setText(UIUtil.convertToGUIString(this.selectedParameter.getHelpText()));
        if (this.selectedParameter.getPropertyHandle("listLimit").isSet()) {
            this.listLimit.setText(String.valueOf(this.selectedParameter.getListlimit()));
        } else {
            this.listLimit.setText("");
        }
        this.isRequired.setSelection(this.selectedParameter.isRequired());
        if (this.selectedParameter == this.inputParameterGroup.getParameters().get(this.inputParameterGroup.getParameters().getCount() - 1) && this.selectedParameter.isMustMatch()) {
            this.isMultiple.setEnabled(true);
            this.isMultiple.setSelection("multi-value".equals(this.selectedParameter.getParamType()));
        } else {
            this.isMultiple.setEnabled(false);
            this.isMultiple.setSelection(false);
        }
        this.defaultValueList = this.selectedParameter.getDefaultValueList();
        this.initDefaultValueViewer();
        this.changeDataType(this.selectedParameter.getDataType());
        this.formatCategroy = this.selectedParameter.getCategory();
        this.formatPattern = this.selectedParameter.getPattern();
        this.updateFormatField();
    }

    private void clearParamProperties() {
        this.paramNameEditor.setText("");
        this.promptText.setText("");
        this.dataTypeChooser.select(-1);
        this.displayTypeChooser.select(-1);
        this.defaultValueChooser.setText("");
        this.helpTextEditor.setText("");
        this.formatField.setText("");
        this.listLimit.setText("");
        this.previewLable.setText("");
        this.isRequired.setSelection(false);
    }

    private void setControlEnabled(boolean enable) {
        this.paramNameEditor.setEnabled(enable);
        this.promptText.setEnabled(enable);
        this.dataTypeChooser.setEnabled(enable);
        this.displayTypeChooser.setEnabled(enable);
        this.defaultValueChooser.setEnabled(enable);
        this.helpTextEditor.setEnabled(enable);
        this.formatField.setEnabled(enable);
        this.listLimit.setEnabled(enable);
        this.changeFormat.setEnabled(enable);
        this.isRequired.setEnabled(enable);
        this.isMultiple.setEnabled(enable);
        if (!this.isMultiple.isEnabled()) {
            this.isMultiple.setSelection(false);
        }
        this.expressionButton.setEnabled(enable);
    }

    private void changeDataType(String type) {
        if (type.equals("string")) {
            this.clearDefaultValueChooser(this.isRequired.getSelection());
        } else {
            this.clearDefaultValueText();
            this.clearDefaultValueChooserSelections();
        }
        this.initFormatField(type);
        this.refreshValueTable();
        this.updateButtons();
    }

    private void clearDefaultValueText() {
        if (this.defaultValueChooser == null || this.defaultValueChooser.isDisposed()) {
            return;
        }
        String textValue = this.defaultValueChooser.getText();
        if (textValue != null && (textValue.equals(CHOICE_NULL_VALUE) || textValue.equals(CHOICE_BLANK_VALUE))) {
            this.defaultValueChooser.setText("");
        }
    }

    private void clearDefaultValueChooserSelections() {
        if (this.defaultValueChooser == null || this.defaultValueChooser.isDisposed()) {
            return;
        }
        if (this.defaultValueChooser.getItemCount() > 1) {
            this.defaultValueChooser.remove(1, this.defaultValueChooser.getItemCount() - 1);
        }
    }

    private void initFormatField(String selectedDataType) {
        IChoiceSet choiceSet = this.getFormatChoiceSet(selectedDataType);
        if (choiceSet == null) {
            this.formatPattern = null;
            this.formatCategroy = null;
        } else if (this.formatCategroy != null && choiceSet.findChoice(this.formatCategroy) == null || this.selectedParameter.getCategory() == null && this.selectedParameter.getPattern() == null) {
            if ("string".equals(selectedDataType)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("dateTime".equals(selectedDataType)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("date".equals(selectedDataType)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("time".equals(selectedDataType)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("decimal".equals(selectedDataType) || "float".equals(selectedDataType) || "integer".equals(selectedDataType)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            }
            this.formatPattern = null;
        } else {
            this.formatCategroy = this.selectedParameter.getCategory();
            if (this.formatCategroy == null) {
                this.formatCategroy = "Unformatted";
            }
            this.formatPattern = this.selectedParameter.getPattern();
            Object formatValue = this.selectedParameter.getProperty("format");
            if (formatValue instanceof FormatValue) {
                PropertyHandle propHandle = this.selectedParameter.getPropertyHandle("format");
                FormatValue formatValueToSet = (FormatValue)formatValue;
                FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
                this.formatLocale = formatHandle.getLocale();
            }
        }
        this.updateFormatField();
    }

    private String getInputDisplayName() {
        String displayName = null;
        if ("list-box".equals(this.selectedParameter.getControlType())) {
            displayName = this.selectedParameter.isMustMatch() ? DISPLAY_NAME_CONTROL_LIST : DISPLAY_NAME_CONTROL_COMBO;
        }
        return displayName;
    }

    private IChoiceSet getFormatChoiceSet(String type) {
        IChoiceSet choiceSet = null;
        if ("string".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("stringFormat");
        } else if ("dateTime".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("dateTimeFormat");
        } else if ("date".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("dateFormat");
        } else if ("time".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("timeFormat");
        } else if ("decimal".equals(type) || "float".equals(type) || "integer".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("numberFormat");
        }
        return choiceSet;
    }

    private String getSelectedDataType() {
        String type = null;
        if (StringUtil.isBlank((String)this.dataTypeChooser.getText())) {
            type = this.selectedParameter != null ? this.selectedParameter.getDataType() : "string";
        } else {
            IChoice choice = DATA_TYPE_CHOICE_SET.findChoiceByDisplayName(this.dataTypeChooser.getText());
            type = choice.getName();
        }
        return type;
    }

    private String getSelectedDisplayType() {
        String displayText = this.displayTypeChooser.getText();
        if (displayText.length() == 0) {
            return null;
        }
        if (DISPLAY_NAME_CONTROL_COMBO.equals(displayText)) {
            return PARAM_CONTROL_COMBO;
        }
        if (DISPLAY_NAME_CONTROL_LIST.equals(displayText)) {
            return PARAM_CONTROL_LIST;
        }
        return null;
    }

    private void popupFormatBuilder(boolean refresh) {
        String dataType = this.getSelectedDataType();
        if ("boolean".equals(dataType)) {
            return;
        }
        int formatType = "string".equals(dataType) ? 1 : ("dateTime".equals(dataType) ? 3 : ("date".equals(dataType) ? 4 : ("time".equals(dataType) ? 5 : 2)));
        FormatBuilder formatBuilder = new FormatBuilder(formatType);
        formatBuilder.setInputFormat(this.formatCategroy, this.formatPattern, this.formatLocale);
        if (formatBuilder.open() == 0) {
            this.formatCategroy = (String)((Object[])formatBuilder.getResult())[0];
            this.formatPattern = (String)((Object[])formatBuilder.getResult())[1];
            this.formatLocale = (ULocale)((Object[])formatBuilder.getResult())[2];
            this.updateFormatField();
            try {
                this.saveParameterProperties();
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    private void updateFormatField() {
        String displayFormat;
        IChoiceSet choiceSet = this.getFormatChoiceSet(this.getSelectedDataType());
        if (choiceSet == null) {
            displayFormat = DEUtil.getMetaDataDictionary().getChoiceSet("stringFormat").findChoice("Unformatted").getDisplayName();
        } else {
            if (this.formatCategroy == null || choiceSet.findChoice(this.formatCategroy) == null) {
                return;
            }
            displayFormat = choiceSet.findChoice(this.formatCategroy).getDisplayName();
            if (this.isCustom()) {
                displayFormat = String.valueOf(displayFormat) + ":  " + this.formatPattern;
            }
        }
        this.formatField.setText(displayFormat);
        this.changeFormat.setEnabled(choiceSet != null);
        if (this.selectedParameter != null) {
            ULocale locale = this.formatLocale;
            if (locale == null) {
                locale = ULocale.getDefault();
            }
            this.doPreview(this.isCustom() ? this.formatPattern : this.formatCategroy, locale);
        }
    }

    private boolean isCustom() {
        return "Custom".equals(this.formatCategroy) || "Custom".equals(this.formatCategroy) || "Custom".equals(this.formatCategroy) || "Custom".equals(this.formatCategroy) || "Custom".equals(this.formatCategroy) || "Currency".equals(this.formatCategroy);
    }

    private void doPreview(String pattern, ULocale locale) {
        String type = this.getSelectedDataType();
        String formatStr = "";
        if ("string".equals(type)) {
            formatStr = new StringFormatter(pattern, locale).format(DEFAULT_PREVIEW_STRING);
        } else if ("dateTime".equals(type)) {
            pattern = pattern.equals("Unformatted") ? "DateTimeUnformatted" : pattern;
            formatStr = new DateFormatter(pattern, locale).format(new Date());
        } else if ("date".equals(type)) {
            pattern = pattern.equals("Unformatted") ? "DateUnformatted" : pattern;
            formatStr = new DateFormatter(pattern, locale).format(new Date());
        } else if ("time".equals(type)) {
            pattern = pattern.equals("Unformatted") ? "TimeUnformatted" : pattern;
            formatStr = new DateFormatter(pattern, locale).format(new Date());
        } else if ("decimal".equals(type) || "float".equals(type)) {
            formatStr = new NumberFormatter(pattern, locale).format(DEFAULT_PREVIEW_NUMBER);
        } else if ("integer".equals(type)) {
            formatStr = new NumberFormatter(pattern, locale).format(123456L);
        }
        this.previewLable.setText(UIUtil.convertToGUIString(formatStr));
    }

    private String getColumnName(ScalarParameterHandle handle, String column) {
        DataSetHandle dataSet;
        CachedMetaDataHandle cmdh;
        block5: {
            cmdh = null;
            try {
                dataSet = this.getDataSet(handle);
                if (dataSet != null) break block5;
                return null;
            }
            catch (SemanticException semanticException) {}
        }
        cmdh = DataSetUIUtil.getCachedMetaDataHandle(dataSet);
        String value = null;
        value = COLUMN_VALUE.equals(column) ? handle.getValueExpr() : handle.getLabelExpr();
        if (cmdh != null) {
            for (ResultSetColumnHandle element : cmdh.getResultSet()) {
                if (!DEUtil.getColumnExpression((String)element.getColumnName()).equalsIgnoreCase(value) && !DEUtil.getResultSetColumnExpression((String)element.getColumnName()).equalsIgnoreCase(value)) continue;
                return element.getColumnName();
            }
        }
        return null;
    }

    private void updateButtons() {
        Iterator iter;
        int index = this.valueTable.getTable().getSelectionIndex();
        boolean setBtnEnable = true;
        if (index == -1) {
            setBtnEnable = false;
        }
        this.editBtn.setEnabled(setBtnEnable);
        this.delBtn.setEnabled(setBtnEnable);
        boolean okEnable = true;
        if (this.errorMessageLine != null && !this.errorMessageLine.isDisposed()) {
            boolean bl = okEnable = this.errorMessageLine.getImage() == null;
            if (!okEnable) {
                this.getOkButton().setEnabled(okEnable);
                return;
            }
        }
        if (!(iter = this.inputParameterGroup.getParameters().iterator()).hasNext()) {
            okEnable = false;
        } else {
            int count = 0;
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof ScalarParameterHandle)) continue;
                ScalarParameterHandle param = (ScalarParameterHandle)obj;
                ++count;
                if (this.checkParameter(param)) continue;
                okEnable = false;
                break;
            }
            okEnable &= count != 0;
        }
        this.getOkButton().setEnabled(okEnable);
    }

    private boolean matchDataType(ScalarParameterHandle handle, ResultSetColumnHandle columnHandle) {
        String type = handle.getDataType();
        if (handle == this.selectedParameter && this.dataTypeChooser.isEnabled()) {
            type = this.getSelectedDataType();
        }
        if ("string".equals(type) || "any".equals(columnHandle.getDataType())) {
            return true;
        }
        if ("boolean".equals(type)) {
            return "boolean".equals(columnHandle.getDataType());
        }
        if ("dateTime".equals(type)) {
            return "date-time".equals(columnHandle.getDataType());
        }
        if ("decimal".equals(type)) {
            return "decimal".equals(columnHandle.getDataType());
        }
        if ("float".equals(type)) {
            return "float".equals(columnHandle.getDataType());
        }
        if ("integer".equals(type)) {
            return "integer".equals(columnHandle.getDataType());
        }
        if ("date".equals(columnHandle.getDataType())) {
            return "date".equals(type);
        }
        if ("time".equals(columnHandle.getDataType())) {
            return "time".equals(type);
        }
        return false;
    }

    private void saveParameterProperties() throws SemanticException {
        if (this.selectedParameter != null) {
            this.selectedParameter.setPromptText(UIUtil.convertToModelString(this.promptText.getText(), false));
            this.selectedParameter.setHelpText(UIUtil.convertToModelString(this.helpTextEditor.getText(), true));
            this.selectedParameter.setDefaultValueList(this.defaultValueList);
            if (StringUtil.isBlank((String)this.listLimit.getText())) {
                this.selectedParameter.setProperty("listLimit", null);
            } else {
                this.selectedParameter.setListlimit(Integer.parseInt(this.listLimit.getText()));
            }
            this.selectedParameter.setIsRequired(this.isRequired.getSelection());
            this.selectedParameter.setName(UIUtil.convertToModelString(this.paramNameEditor.getText(), true));
            this.selectedParameter.setCategory(this.formatCategroy);
            this.selectedParameter.setPattern(this.formatPattern);
            Object value = this.selectedParameter.getProperty("format");
            if (value instanceof FormatValue) {
                PropertyHandle propHandle = this.selectedParameter.getPropertyHandle("format");
                FormatValue formatValueToSet = (FormatValue)value;
                FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
                formatHandle.setLocale(this.formatLocale);
            }
            this.refreshValueTable();
        }
    }

    private boolean isSingle() {
        return this.singleDataSet.getSelection();
    }

    private ScalarParameterHandle getFirstParameter() {
        if (this.inputParameterGroup.getParameters().getCount() > 0) {
            return (ScalarParameterHandle)this.inputParameterGroup.getParameters().get(0);
        }
        return null;
    }

    private boolean checkParameter(ScalarParameterHandle paramHandle) {
        return paramHandle.getValueExpr() != null && this.getColumnName(paramHandle, COLUMN_VALUE) != null;
    }

    private void createSortingArea(Composite parent) {
        this.sorttingArea = new Composite(parent, 0);
        GridData sorttingAreaGridData = new GridData(776);
        sorttingAreaGridData.horizontalSpan = 2;
        this.sorttingArea.setLayoutData((Object)sorttingAreaGridData);
        this.sorttingArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(1, false));
        Group sortGroup = new Group(this.sorttingArea, 0);
        sortGroup.setText(LABEL_SORT_GROUP);
        sortGroup.setLayout((Layout)new GridLayout(2, false));
        sortGroup.setLayoutData((Object)new GridData(768));
        Composite sortKeyArea = new Composite((Composite)sortGroup, 0);
        sortKeyArea.setLayoutData((Object)new GridData(768));
        sortKeyArea.setLayout((Layout)new GridLayout(2, false));
        this.sortKeyLabel = new Label(sortKeyArea, 0);
        this.sortKeyLabel.setText(LABEL_SORT_KEY);
        this.sortKeyChooser = new Combo(sortKeyArea, 2056);
        this.sortKeyChooser.setLayoutData((Object)new GridData(768));
        this.sortKeyChooser.setVisibleItemCount(30);
        this.sortKeyChooser.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!((Combo)e.widget).getText().equals(CHOICE_NONE)) {
                    CascadingParametersDialog.this.sortDirectionLabel.setEnabled(true);
                    CascadingParametersDialog.this.sortDirectionChooser.setEnabled(true);
                } else {
                    CascadingParametersDialog.this.sortDirectionLabel.setEnabled(false);
                    CascadingParametersDialog.this.sortDirectionChooser.setEnabled(false);
                }
            }
        });
        Composite sortDirectionArea = new Composite((Composite)sortGroup, 0);
        sortDirectionArea.setLayoutData((Object)new GridData(768));
        sortDirectionArea.setLayout((Layout)new GridLayout(2, false));
        this.sortDirectionLabel = new Label(sortDirectionArea, 0);
        this.sortDirectionLabel.setText(LABEL_SORT_DIRECTION);
        this.sortDirectionChooser = new Combo(sortDirectionArea, 2056);
        this.sortDirectionChooser.setLayoutData((Object)new GridData(768));
        this.sortDirectionChooser.setVisibleItemCount(30);
        this.sortDirectionChooser.add(CHOICE_ASCENDING);
        this.sortDirectionChooser.add(CHOICE_DESCENDING);
        this.sortDirectionChooser.setText(CHOICE_ASCENDING);
    }

    private void setSortingDefault() {
        this.sortKeyChooser.setText(CHOICE_NONE);
        this.sortDirectionChooser.setText(CHOICE_ASCENDING);
    }

    private void initSorttingArea() {
        this.refreshSortItems();
        if (this.selectedParameter == null) {
            this.setSortingDefault();
            this.sortKeyLabel.setEnabled(false);
            this.sortKeyChooser.setEnabled(false);
            this.sortDirectionLabel.setEnabled(false);
            this.sortDirectionChooser.setEnabled(false);
            return;
        }
        if (!this.selectedParameter.isFixedOrder()) {
            this.sortKeyLabel.setEnabled(true);
            this.sortKeyChooser.setEnabled(true);
            this.sortDirectionLabel.setEnabled(true);
            this.sortDirectionChooser.setEnabled(true);
            String columnExp = this.selectedParameter.getSortByColumn();
            String columnName = this.getColumnName(columnExp);
            if (columnName != null && this.sortKeyChooser.indexOf(columnName) >= 0) {
                this.sortKeyChooser.setText(columnName);
            } else {
                this.sortKeyChooser.select(0);
            }
            String sortDirection = this.selectedParameter.getSortDirection();
            if (sortDirection == null || sortDirection.equals("asc")) {
                this.sortDirectionChooser.setText(CHOICE_ASCENDING);
            } else {
                this.sortDirectionChooser.setText(CHOICE_DESCENDING);
            }
        } else {
            this.setSortingDefault();
            this.sortKeyLabel.setEnabled(true);
            this.sortKeyChooser.setEnabled(true);
            this.sortDirectionLabel.setEnabled(false);
            this.sortDirectionChooser.setEnabled(false);
        }
    }

    private void saveSortingProperties() {
        if (this.selectedParameter == null) {
            return;
        }
        if (this.sorttingArea != null && !this.sorttingArea.isDisposed() && this.sorttingArea.isVisible()) {
            try {
                if (this.sortKeyChooser.getText().equals(CHOICE_NONE)) {
                    this.selectedParameter.setFixedOrder(true);
                    this.selectedParameter.setSortBy(null);
                    this.selectedParameter.setSortDirection(null);
                    this.selectedParameter.setSortByColumn(null);
                } else {
                    this.selectedParameter.setFixedOrder(false);
                    this.selectedParameter.setSortBy(null);
                    this.selectedParameter.setSortByColumn(this.getExpression(this.sortKeyChooser.getText()));
                    if (this.sortDirectionChooser.getText().equals(CHOICE_ASCENDING)) {
                        this.selectedParameter.setSortDirection("asc");
                    } else if (this.sortDirectionChooser.getText().equals(CHOICE_DESCENDING)) {
                        this.selectedParameter.setSortDirection("desc");
                    }
                }
            }
            catch (SemanticException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.selectedParameter.setProperty("fixedOrder", null);
            }
            catch (SemanticException e) {
                e.printStackTrace();
            }
        }
    }

    private String getExpression(String columnName) {
        if (columnName.equals(CHOICE_NONE)) {
            return null;
        }
        List columnList = this.getColumnList();
        for (ResultSetColumnHandle cachedColumn : columnList) {
            if (!cachedColumn.getColumnName().equals(columnName)) continue;
            return DEUtil.getExpression((Object)cachedColumn);
        }
        return columnName;
    }

    protected void refreshSortItems() {
        if (this.sortDirectionChooser == null || this.sortDirectionChooser.isDisposed()) {
            return;
        }
        this.sortKeyChooser.removeAll();
        this.sortKeyChooser.add(CHOICE_NONE);
        List columnList = this.getColumnList();
        for (ResultSetColumnHandle cachedColumn : columnList) {
            this.sortKeyChooser.add(cachedColumn.getColumnName());
        }
    }

    private String getColumnName(String expression) {
        List columnList = this.getColumnList();
        for (ResultSetColumnHandle cachedColumn : columnList) {
            if (!DEUtil.getExpression((Object)cachedColumn).equals(expression)) continue;
            return cachedColumn.getColumnName();
        }
        return expression;
    }

    public String getSelectedExprValue(String value) {
        String exprValue = null;
        if (value == null) {
            return "null";
        }
        String dataType = this.getSelectedDataType();
        if (dataType == null) {
            return "null";
        }
        exprValue = "boolean".equals(dataType) || "integer".equals(dataType) || "float".equals(dataType) ? value : ("decimal".equals(dataType) ? "new java.math.BigDecimal(\"" + value + "\")" : "\"" + JavascriptEvalUtil.transformToJsConstants((String)value) + "\"");
        return exprValue;
    }

    private void addDynamicDefaultValue() {
        if (this.isMultiple.isEnabled() && this.isMultiple.getSelection()) {
            String type = (String)this.defaultValueChooser.getData("exprType");
            String value = UIUtil.convertToModelString(this.defaultValueChooser.getText(), false);
            this.setFirstDefaultValue(value, type);
            this.refreshDynamicValueTable();
            this.defaultValueChooser.setFocus();
            this.defaultValueChooser.setText("");
        }
    }

    private void updateDynamicTableButtons() {
        StructuredSelection selection = (StructuredSelection)this.defaultValueViewer.getSelection();
        boolean enable = selection.size() == 1;
        this.editValueBtn.setEnabled(enable);
        this.delValueBtn.setEnabled(!selection.isEmpty());
        this.delAllValuesBtn.setEnabled(this.defaultValueViewer.getTable().getItemCount() > 0);
        Expression expression = ExpressionButtonUtil.getExpression((Control)this.defaultValueChooser);
        if (this.defaultValueChooser.getText().trim().length() == 0) {
            this.addValueButton.setEnabled(false);
        } else if (this.defaultValueList != null && this.defaultValueList.contains(expression)) {
            this.addValueButton.setEnabled(false);
        } else {
            this.addValueButton.setEnabled(true);
        }
    }

    private void refreshDynamicValueTable() {
        if (this.defaultValueViewer != null && !this.defaultValueViewer.getTable().isDisposed()) {
            this.defaultValueViewer.refresh();
            this.updateDynamicTableButtons();
        }
    }

    private Expression getFirstDefaultValue() {
        if (this.defaultValueList != null && this.defaultValueList.size() > 0) {
            return this.defaultValueList.get(0);
        }
        return null;
    }

    private void setFirstDefaultValue(String value, String type) {
        if (this.defaultValueList == null) {
            this.defaultValueList = new ArrayList<Expression>();
            this.initDefaultValueViewer();
        }
        Expression expression = null;
        if (value != null) {
            expression = new Expression((Object)value, type);
        }
        if (!this.defaultValueList.contains(expression)) {
            this.defaultValueList.add(0, expression);
        }
        this.updateMessageLine();
        this.updateFormatField();
    }

    private void simpleDefaultValueList() {
        if (this.defaultValueList != null && this.defaultValueList.size() > 0) {
            Expression expression = this.getFirstDefaultValue();
            this.defaultValueList.clear();
            this.defaultValueList.add(expression);
        }
    }

    class AddEditCascadingParameterDialog
    extends BaseDialog {
        public final String DATASET_NONE;
        public final String DISPLAY_TEXT_NONE;
        private final String ERROR_MSG_DUPLICATED_NAME;
        Text name;
        Combo dataset;
        Combo value;
        Combo displayText;
        private String[] dataTypes;
        protected ScalarParameterHandle parameter;
        protected CLabel editErrorMessage;

        public ScalarParameterHandle getParameter() {
            return this.parameter;
        }

        protected AddEditCascadingParameterDialog(String title) {
            super(title);
            this.DATASET_NONE = Messages.getString((String)"CascadingParametersDialog.items.None");
            this.DISPLAY_TEXT_NONE = Messages.getString((String)"CascadingParametersDialog.items.None");
            this.ERROR_MSG_DUPLICATED_NAME = Messages.getString((String)"ParameterDialog.ErrorMessage.DuplicatedName");
            this.parameter = null;
        }

        protected AddEditCascadingParameterDialog(Shell parentShell, String title) {
            super(parentShell, title);
            this.DATASET_NONE = Messages.getString((String)"CascadingParametersDialog.items.None");
            this.DISPLAY_TEXT_NONE = Messages.getString((String)"CascadingParametersDialog.items.None");
            this.ERROR_MSG_DUPLICATED_NAME = Messages.getString((String)"ParameterDialog.ErrorMessage.DuplicatedName");
            this.parameter = null;
        }

        protected void updateButtons() {
            if (this.editErrorMessage != null && !this.editErrorMessage.isDisposed() && this.editErrorMessage.getImage() != null) {
                this.getOkButton().setEnabled(false);
                return;
            }
            if (this.dataset.getItemCount() == 1 && this.dataset.getItem(0).equals(this.DATASET_NONE) || this.value.getText().length() == 0) {
                this.getOkButton().setEnabled(false);
            } else {
                this.getOkButton().setEnabled(true);
            }
        }

        protected void okPressed() {
            if (this.name.getText().trim().length() != 0) {
                try {
                    this.parameter.setName(this.name.getText().trim());
                }
                catch (NameException e) {
                    ExceptionHandler.handle(e);
                }
            }
            super.okPressed();
        }

        public void setParameter(ScalarParameterHandle param) {
            this.parameter = param;
        }

        protected Control createDialogArea(Composite parent) {
            UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.AddEditCascadingParametersDialog_ID");
            Composite topComposite = (Composite)super.createDialogArea(parent);
            Composite composite = new Composite(topComposite, 0);
            composite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
            composite.setLayoutData((Object)new GridData(1808));
            Label labelName = new Label(composite, 0);
            labelName.setText(Messages.getString((String)"AddEditCascadingParameterDialog.label.name"));
            this.name = new Text(composite, 2048);
            GridData gd = new GridData(768);
            gd.minimumWidth = 250;
            this.name.setLayoutData((Object)gd);
            this.name.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddEditCascadingParameterDialog.this.updateEditErrorMsg();
                    AddEditCascadingParameterDialog.this.updateButtons();
                }
            });
            Label labelDataset = new Label(composite, 0);
            labelDataset.setText(Messages.getString((String)"AddEditCascadingParameterDialog.label.dataset"));
            this.dataset = new Combo(composite, 8);
            this.dataset.setVisibleItemCount(30);
            this.dataset.setLayoutData((Object)new GridData(768));
            this.dataset.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AddEditCascadingParameterDialog.this.dataset.getSelectionIndex() == -1 || AddEditCascadingParameterDialog.this.dataset.getItemCount() == 1 && AddEditCascadingParameterDialog.this.dataset.getText().equals(AddEditCascadingParameterDialog.this.DATASET_NONE)) {
                        AddEditCascadingParameterDialog.this.value.setEnabled(false);
                        AddEditCascadingParameterDialog.this.displayText.setEnabled(false);
                    } else {
                        try {
                            AddEditCascadingParameterDialog.this.parameter.setDataSet(DataUtil.findDataSet(AddEditCascadingParameterDialog.this.dataset.getText()));
                            if (AddEditCascadingParameterDialog.this.parameter.getDataSet() != null) {
                                if (CascadingParametersDialog.this.getFirstParameter() == null || AddEditCascadingParameterDialog.this.parameter == CascadingParametersDialog.this.getFirstParameter()) {
                                    CascadingParametersDialog.this.inputParameterGroup.setDataSet(AddEditCascadingParameterDialog.this.parameter.getDataSet());
                                }
                                AddEditCascadingParameterDialog.this.updateComboFromDataSet();
                            }
                        }
                        catch (SemanticException semanticException) {}
                    }
                    AddEditCascadingParameterDialog.this.updateButtons();
                }
            });
            Label labelValue = new Label(composite, 0);
            labelValue.setText(Messages.getString((String)"AddEditCascadingParameterDialog.label.value"));
            this.value = new Combo(composite, 8);
            this.value.setLayoutData((Object)new GridData(768));
            this.value.setVisibleItemCount(30);
            this.value.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        AddEditCascadingParameterDialog.this.parameter.setValueExpr(DEUtil.getColumnExpression((String)AddEditCascadingParameterDialog.this.value.getText()));
                        if (AddEditCascadingParameterDialog.this.dataTypes.length == AddEditCascadingParameterDialog.this.value.getItemCount() && AddEditCascadingParameterDialog.this.value.getSelectionIndex() > -1) {
                            AddEditCascadingParameterDialog.this.parameter.setDataType(AddEditCascadingParameterDialog.this.dataTypes[AddEditCascadingParameterDialog.this.value.getSelectionIndex()]);
                        }
                    }
                    catch (SemanticException semanticException) {}
                    AddEditCascadingParameterDialog.this.updateButtons();
                }
            });
            Label labelDisplayText = new Label(composite, 0);
            labelDisplayText.setText(Messages.getString((String)"AddEditCascadingParameterDialog.label.displaytext"));
            this.displayText = new Combo(composite, 8);
            this.displayText.setLayoutData((Object)new GridData(768));
            this.displayText.setVisibleItemCount(30);
            this.displayText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        if (AddEditCascadingParameterDialog.this.displayText.getSelectionIndex() == 0) {
                            AddEditCascadingParameterDialog.this.parameter.setLabelExpr(null);
                        } else {
                            AddEditCascadingParameterDialog.this.parameter.setLabelExpr(DEUtil.getColumnExpression((String)AddEditCascadingParameterDialog.this.displayText.getText()));
                        }
                    }
                    catch (SemanticException e1) {
                        ExceptionHandler.handle(e1);
                    }
                    AddEditCascadingParameterDialog.this.updateButtons();
                }
            });
            CascadingParametersDialog.this.createLabel(composite, null);
            this.editErrorMessage = new CLabel(composite, 0);
            GridData msgLineGridData = new GridData(768);
            msgLineGridData.horizontalSpan = 2;
            this.editErrorMessage.setLayoutData((Object)msgLineGridData);
            return topComposite;
        }

        protected void updateEditErrorMsg() {
            String errorMsg = null;
            String paraName = this.name.getText().trim();
            if (!paraName.equals(this.parameter.getName()) && this.parameter.getModuleHandle().findParameter(paraName) != null) {
                errorMsg = this.ERROR_MSG_DUPLICATED_NAME;
            }
            if (errorMsg != null) {
                this.editErrorMessage.setText(errorMsg);
                this.editErrorMessage.setImage(ERROR_ICON);
            } else {
                this.editErrorMessage.setText("");
                this.editErrorMessage.setImage(null);
            }
        }

        @Override
        protected boolean initDialog() {
            this.dataset.setItems(ChoiceSetFactory.getDataSets());
            if (this.dataset.getItemCount() == 0) {
                this.dataset.add(this.DATASET_NONE);
                this.dataset.select(0);
            }
            if (CascadingParametersDialog.this.isSingle() && CascadingParametersDialog.this.getFirstParameter() != null && CascadingParametersDialog.this.getFirstParameter() != this.parameter && CascadingParametersDialog.this.inputParameterGroup.getDataSet() != null) {
                this.dataset.select(this.dataset.indexOf(CascadingParametersDialog.this.inputParameterGroup.getDataSet().getName()));
                this.dataset.setEnabled(false);
            }
            this.updateComboFromDataSet();
            if (this.parameter.getName().trim().length() != 0) {
                this.name.setText(this.parameter.getName());
            }
            this.updateButtons();
            return super.initDialog();
        }

        private String[] getDataSetColumns(ScalarParameterHandle handle, boolean needFilter) {
            DataSetHandle dataSet = CascadingParametersDialog.this.getDataSet(handle);
            if (dataSet == null) {
                return new String[0];
            }
            CachedMetaDataHandle metaHandle = dataSet.getCachedMetaDataHandle();
            if (metaHandle == null) {
                try {
                    metaHandle = DataSetUIUtil.getCachedMetaDataHandle(dataSet);
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                    return new String[0];
                }
            }
            if (metaHandle == null || metaHandle.getResultSet() == null) {
                return new String[0];
            }
            ArrayList<String> valueList = new ArrayList<String>();
            ArrayList<String> dataTypeList = new ArrayList<String>();
            for (ResultSetColumnHandle columnHandle : metaHandle.getResultSet()) {
                valueList.add(columnHandle.getColumnName());
                dataTypeList.add(ModuleUtil.convertColumnTypeToParamType((String)columnHandle.getDataType()));
            }
            this.dataTypes = dataTypeList.toArray(new String[0]);
            return valueList.toArray(new String[0]);
        }

        private void updateComboFromDataSet() {
            this.value.setEnabled(false);
            this.displayText.setEnabled(false);
            if (this.parameter != null) {
                DataSetHandle dataSet = CascadingParametersDialog.this.getDataSet(this.parameter);
                if (dataSet != null) {
                    this.dataset.select(this.dataset.indexOf(dataSet.getName()));
                    this.value.setItems(this.getDataSetColumns(this.parameter, true));
                    this.displayText.removeAll();
                    this.displayText.setItems(this.getDataSetColumns(this.parameter, false));
                    this.displayText.add(this.DISPLAY_TEXT_NONE, 0);
                    this.value.setEnabled(true);
                    String temp = CascadingParametersDialog.this.getColumnName(this.parameter, COLUMN_VALUE);
                    if (temp != null) {
                        this.value.select(this.value.indexOf(temp));
                    }
                    this.displayText.setEnabled(true);
                    temp = CascadingParametersDialog.this.getColumnName(this.parameter, COLUMN_DISPLAY_TEXT);
                    if (temp != null) {
                        this.displayText.select(this.displayText.indexOf(temp));
                    } else {
                        this.displayText.select(0);
                    }
                }
            } else {
                this.parameter = DesignElementFactory.getInstance().newScalarParameter(null);
                try {
                    this.parameter.setControlType("list-box");
                    this.parameter.setValueType("dynamic");
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                }
                if (!(CascadingParametersDialog.this.getFirstParameter() == null || CascadingParametersDialog.this.multiDataSet.isEnabled() && CascadingParametersDialog.this.multiDataSet.getSelection())) {
                    try {
                        this.parameter.setDataSet(CascadingParametersDialog.this.inputParameterGroup.getDataSet());
                        this.value.setItems(this.getDataSetColumns(this.parameter, true));
                        this.displayText.setItems(this.getDataSetColumns(this.parameter, false));
                        this.displayText.add(this.DISPLAY_TEXT_NONE, 0);
                        this.value.setEnabled(true);
                        this.displayText.setEnabled(true);
                        String temp = CascadingParametersDialog.this.getColumnName(this.parameter, COLUMN_DISPLAY_TEXT);
                        if (temp != null) {
                            this.displayText.select(this.displayText.indexOf(temp));
                        } else {
                            this.displayText.select(0);
                        }
                    }
                    catch (SemanticException e) {
                        this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
    }
}

