/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.memento;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.designer.util.DEUtil;

public class MementoElement {
    public static final String Type_Element = "Element";
    public static final String Type_Viewer = "Viewer";
    public static final String Type_View = "View";
    public static final String Type_Memento = "Memento";
    public static final String ATTRIBUTE_SELECTED = "Selected";
    private String key;
    private Object value;
    private MementoElement parent;
    private List children = new ArrayList();
    private HashMap attributeMap = new HashMap();
    private String type = "Memento";

    public void setAttribute(String name, Object value) {
        this.attributeMap.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public MementoElement(String key, Object value) {
        this.key = key;
        this.value = value;
    }

    public MementoElement(String key, Object value, String type) {
        this.key = key;
        this.value = value;
        this.type = type;
    }

    public MementoElement(String key) {
        this.key = key;
    }

    public MementoElement() {
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public MementoElement getParent() {
        return this.parent;
    }

    public void setParent(MementoElement parent) {
        this.parent = parent;
        this.parent.addChild(this);
    }

    public MementoElement[] getChildren() {
        MementoElement[] childrenMementos = new MementoElement[this.children.size()];
        this.children.toArray(childrenMementos);
        return childrenMementos;
    }

    public void setChildren(List children) {
        this.children = children;
        int i = 0;
        while (i < children.size()) {
            MementoElement property = (MementoElement)children.get(i);
            property.setParent(this);
            ++i;
        }
    }

    public void addChild(MementoElement child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
            child.setParent(this);
        } else if (child.getParent() != this) {
            child.setParent(this);
        }
    }

    public MementoElement getChild(String key) {
        int i = 0;
        while (i < this.children.size()) {
            MementoElement property = (MementoElement)this.children.get(i);
            if (property.getKey().equals(key)) {
                return property;
            }
            ++i;
        }
        return null;
    }

    public MementoElement getChild(int index) {
        if (index > -1 && index < this.children.size()) {
            return (MementoElement)this.children.get(index);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MementoElement) {
            MementoElement memento = (MementoElement)obj;
            if (this == obj) {
                return true;
            }
            if (memento.getMementoType().equals(Type_Memento)) {
                return true;
            }
            if (memento.getMementoType().equals(Type_View) || memento.getMementoType().equals(Type_Viewer)) {
                return memento.getKey().equals(this.key);
            }
            if (memento.getMementoType().equals(Type_Element)) {
                if (memento.getValue() == null) {
                    return false;
                }
                return memento.getKey().equals(this.key) && memento.getValue().equals(this.value);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getMementoType().equals(Type_Memento)) {
            return this.getMementoType().hashCode();
        }
        if (this.getMementoType().equals(Type_View) || this.getMementoType().equals(Type_Viewer)) {
            return this.getMementoType().hashCode() * 13 + DEUtil.resolveNull((String)this.getKey()).hashCode();
        }
        if (this.getMementoType().equals(Type_Element)) {
            return this.getMementoType().hashCode() * 13 + DEUtil.resolveNull((String)this.getKey()).hashCode() * 7 + (this.getValue() == null ? "" : this.getValue()).hashCode();
        }
        return super.hashCode();
    }

    public void removeChild(MementoElement child) {
        this.children.remove(child);
        child.dispose();
    }

    public void dispose() {
        int i = 0;
        while (i < this.children.size()) {
            MementoElement property = (MementoElement)this.children.get(i);
            property.dispose();
            ++i;
        }
        this.children.clear();
    }

    public String getMementoType() {
        return this.type;
    }

    public void setMementoType(String type) {
        this.type = type;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(Object value) {
        this.value = value;
    }
}

