/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.border;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.CellBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.TableBorder;
import org.eclipse.birt.report.designer.internal.ui.layout.ITableLayoutCell;
import org.eclipse.birt.report.designer.internal.ui.layout.ITableLayoutOwner;
import org.eclipse.birt.report.designer.util.TableBorderCollisionArbiter;
import org.eclipse.draw2d.geometry.Insets;

public class TableBorderHelper {
    private ITableLayoutOwner owner;
    private int[][] heights;
    private int[][] widths;
    private int[][] borderData;

    public TableBorderHelper(ITableLayoutOwner owner) {
        this.owner = owner;
    }

    private void initialize() {
        int rowCount = this.owner.getRowCount();
        int colCount = this.owner.getColumnCount();
        this.heights = new int[colCount][rowCount + 1];
        this.widths = new int[rowCount][colCount + 1];
        this.borderData = new int[2 * colCount * rowCount + colCount + rowCount][6];
        int i = 0;
        while (i < rowCount) {
            int j = 0;
            while (j < colCount) {
                this.borderData[i * (2 * colCount + 1) + j][3] = -1;
                this.borderData[i * (2 * colCount + 1) + j][4] = -1;
                this.borderData[i * (2 * colCount + 1) + j][5] = -1;
                this.borderData[(i + 1) * (2 * colCount + 1) + j][3] = -1;
                this.borderData[(i + 1) * (2 * colCount + 1) + j][4] = -1;
                this.borderData[(i + 1) * (2 * colCount + 1) + j][5] = -1;
                this.borderData[i * (2 * colCount + 1) + colCount + j][3] = -1;
                this.borderData[i * (2 * colCount + 1) + colCount + j][4] = -1;
                this.borderData[i * (2 * colCount + 1) + colCount + j][5] = -1;
                this.borderData[i * (2 * colCount + 1) + colCount + j + 1][3] = -1;
                this.borderData[i * (2 * colCount + 1) + colCount + j + 1][4] = -1;
                this.borderData[i * (2 * colCount + 1) + colCount + j + 1][5] = -1;
                ++j;
            }
            ++i;
        }
        TableBorder tableBorder = (TableBorder)this.owner.getFigure().getBorder();
        Insets tableBorderInsets = tableBorder.getTrueBorderInsets();
        int i2 = 0;
        while (i2 < colCount) {
            this.heights[i2][0] = tableBorderInsets.top;
            this.heights[i2][rowCount] = tableBorderInsets.bottom;
            ++i2;
        }
        i2 = 0;
        while (i2 < rowCount) {
            this.widths[i2][0] = tableBorderInsets.left;
            this.widths[i2][colCount] = tableBorderInsets.right;
            ++i2;
        }
        for (ITableLayoutCell cellPart : this.owner.getChildren()) {
            int rowIndex = cellPart.getRowNumber();
            int colIndex = cellPart.getColumnNumber();
            int rowSpan = cellPart.getRowSpan();
            int colSpan = cellPart.getColSpan();
            CellBorder border = (CellBorder)cellPart.getFigure().getBorder();
            Insets ins = border.getTrueBorderInsets();
            int topStyle = border.getTopBorderStyle();
            int topWidth = border.getTopBorderWidth();
            int topColor = border.getTopBorderColor();
            int topFrom = border.getTopFrom();
            int bottomStyle = border.getBottomBorderStyle();
            int bottomWidth = border.getBottomBorderWidth();
            int bottomColor = border.getBottomBorderColor();
            int bottomFrom = border.getBottomFrom();
            int leftStyle = border.getLeftBorderStyle();
            int leftWidth = border.getLeftBorderWidth();
            int leftColor = border.getLeftBorderColor();
            int rightStyle = border.getRightBorderStyle();
            int rightWidth = border.getRightBorderWidth();
            int rightColor = border.getRightBorderColor();
            int i3 = 0;
            while (i3 < colSpan) {
                TableBorderCollisionArbiter.refreshBorderData((int[])this.borderData[(rowIndex - 1) * (2 * colCount + 1) + colIndex - 1 + i3], (int)topStyle, (int)topWidth, (int)topColor, (int)(rowIndex - 1), (int)(colIndex - 1 + i3), (int)topFrom);
                TableBorderCollisionArbiter.refreshBorderData((int[])this.borderData[(rowIndex + rowSpan - 1) * (2 * colCount + 1) + colIndex - 1 + i3], (int)bottomStyle, (int)bottomWidth, (int)bottomColor, (int)(rowIndex - 1 + rowSpan - 1), (int)(colIndex - 1 + i3), (int)bottomFrom);
                this.heights[colIndex - 1 + i3][rowIndex - 1] = Math.max(this.heights[colIndex - 1 + i3][rowIndex - 1], ins.top);
                this.heights[colIndex - 1 + i3][rowIndex + rowSpan - 1] = Math.max(this.heights[colIndex - 1 + i3][rowIndex + rowSpan - 1], ins.bottom);
                ++i3;
            }
            i3 = 0;
            while (i3 < rowSpan) {
                TableBorderCollisionArbiter.refreshBorderData((int[])this.borderData[(rowIndex - 1 + i3) * (2 * colCount + 1) + colCount + colIndex - 1], (int)leftStyle, (int)leftWidth, (int)leftColor, (int)(rowIndex - 1 + i3), (int)(colIndex - 1));
                TableBorderCollisionArbiter.refreshBorderData((int[])this.borderData[(rowIndex - 1 + i3) * (2 * colCount + 1) + colCount + colIndex + colSpan - 1], (int)rightStyle, (int)rightWidth, (int)rightColor, (int)(rowIndex - 1 + i3), (int)(colIndex - 1 + colSpan - 1));
                this.widths[rowIndex - 1 + i3][colIndex - 1] = Math.max(this.widths[rowIndex - 1 + i3][colIndex - 1], ins.left);
                this.widths[rowIndex - 1 + i3][colIndex + colSpan - 1] = Math.max(this.widths[rowIndex - 1 + i3][colIndex + colSpan - 1], ins.right);
                ++i3;
            }
        }
        int tableTopStyle = tableBorder.getTopBorderStyle();
        int tableTopWidth = tableBorder.getTopBorderWidth();
        if (tableTopStyle != 0 && tableTopWidth > 0) {
            int tableTopColor = tableBorder.getTopBorderColor();
            int i4 = 0;
            while (i4 < colCount) {
                this.borderData[i4][0] = tableTopStyle;
                this.borderData[i4][1] = tableTopWidth;
                this.borderData[i4][2] = tableTopColor;
                this.borderData[i4][3] = -2;
                this.borderData[i4][4] = -2;
                ++i4;
            }
        }
        int tableBottomStyle = tableBorder.getBottomBorderStyle();
        int tableBottomWidth = tableBorder.getBottomBorderWidth();
        if (tableBottomStyle != 0 && tableBottomWidth > 0) {
            int tableBottomColor = tableBorder.getBottomBorderColor();
            int i5 = 0;
            while (i5 < colCount) {
                this.borderData[2 * colCount * rowCount + rowCount + i5][0] = tableBottomStyle;
                this.borderData[2 * colCount * rowCount + rowCount + i5][1] = tableBottomWidth;
                this.borderData[2 * colCount * rowCount + rowCount + i5][2] = tableBottomColor;
                this.borderData[2 * colCount * rowCount + rowCount + i5][3] = -2;
                this.borderData[2 * colCount * rowCount + rowCount + i5][4] = -2;
                ++i5;
            }
        }
        int tableLeftStyle = tableBorder.getLeftBorderStyle();
        int tableLeftWidth = tableBorder.getLeftBorderWidth();
        if (tableLeftStyle != 0 && tableLeftWidth > 0) {
            int tableLeftColor = tableBorder.getLeftBorderColor();
            int i6 = 0;
            while (i6 < rowCount) {
                this.borderData[(2 * colCount + 1) * i6 + colCount][0] = tableLeftStyle;
                this.borderData[(2 * colCount + 1) * i6 + colCount][1] = tableLeftWidth;
                this.borderData[(2 * colCount + 1) * i6 + colCount][2] = tableLeftColor;
                this.borderData[(2 * colCount + 1) * i6 + colCount][3] = -2;
                this.borderData[(2 * colCount + 1) * i6 + colCount][4] = -2;
                ++i6;
            }
        }
        int tableRightStyle = tableBorder.getRightBorderStyle();
        int tableRightWidth = tableBorder.getRightBorderWidth();
        if (tableRightStyle != 0 && tableRightWidth > 0) {
            int tableRightColor = tableBorder.getRightBorderColor();
            int i7 = 0;
            while (i7 < rowCount) {
                this.borderData[(2 * colCount + 1) * i7 + 2 * colCount][0] = tableRightStyle;
                this.borderData[(2 * colCount + 1) * i7 + 2 * colCount][1] = tableRightWidth;
                this.borderData[(2 * colCount + 1) * i7 + 2 * colCount][2] = tableRightColor;
                this.borderData[(2 * colCount + 1) * i7 + 2 * colCount][3] = -2;
                this.borderData[(2 * colCount + 1) * i7 + 2 * colCount][4] = -2;
                ++i7;
            }
        }
    }

    public void updateCellBorderInsets() {
        if (this.heights == null || this.widths == null) {
            this.initialize();
        }
        int rowCount = this.owner.getRowCount();
        int colCount = this.owner.getColumnCount();
        for (ITableLayoutCell cellPart : this.owner.getChildren()) {
            int lw;
            int rw;
            int th;
            int bh;
            int i;
            int bh2;
            int th2;
            int rowIndex = cellPart.getRowNumber();
            int colIndex = cellPart.getColumnNumber();
            int rowSpan = cellPart.getRowSpan();
            int colSpan = cellPart.getColSpan();
            CellBorder border = (CellBorder)cellPart.getFigure().getBorder();
            Insets borderInsets = new Insets();
            if (rowIndex == 1 && rowIndex + rowSpan - 1 == rowCount) {
                th2 = 0;
                bh2 = 0;
                i = 0;
                while (i < colSpan) {
                    th2 = Math.max(th2, this.heights[colIndex - 1 + i][rowIndex - 1]);
                    bh2 = Math.max(bh2, this.heights[colIndex - 1 + i][rowIndex + rowSpan - 1]);
                    ++i;
                }
                borderInsets.top = th2;
                borderInsets.bottom = bh2;
            } else if (rowIndex == 1) {
                bh = 0;
                th = 0;
                i = 0;
                while (i < colSpan) {
                    th = Math.max(th, this.heights[colIndex - 1 + i][rowIndex - 1]);
                    bh = Math.max(bh, this.heights[colIndex - 1 + i][rowIndex + rowSpan - 1] / 2 + this.heights[colIndex - 1 + i][rowIndex + rowSpan - 1] % 2);
                    ++i;
                }
                borderInsets.top = th;
                borderInsets.bottom = bh;
            } else if (rowIndex + rowSpan - 1 == rowCount) {
                th2 = 0;
                bh2 = 0;
                i = 0;
                while (i < colSpan) {
                    th2 = Math.max(th2, this.heights[colIndex - 1 + i][rowIndex - 1] / 2);
                    bh2 = Math.max(bh2, this.heights[colIndex - 1 + i][rowIndex + rowSpan - 1]);
                    ++i;
                }
                borderInsets.top = th2;
                borderInsets.bottom = bh2;
            } else {
                bh = 0;
                th = 0;
                i = 0;
                while (i < colSpan) {
                    th = Math.max(th, this.heights[colIndex - 1 + i][rowIndex - 1] / 2);
                    bh = Math.max(bh, this.heights[colIndex - 1 + i][rowIndex + rowSpan - 1] / 2 + this.heights[colIndex - 1 + i][rowIndex + rowSpan - 1] % 2);
                    ++i;
                }
                borderInsets.top = th;
                borderInsets.bottom = bh;
            }
            if (colIndex == 1 && colIndex + colSpan - 1 == colCount) {
                rw = 0;
                lw = 0;
                i = 0;
                while (i < rowSpan) {
                    rw = Math.max(rw, this.widths[rowIndex - 1 + i][colIndex + colSpan - 1]);
                    lw = Math.max(lw, this.widths[rowIndex - 1 + i][colIndex - 1]);
                    ++i;
                }
                borderInsets.left = lw;
                borderInsets.right = rw;
            } else if (colIndex == 1) {
                rw = 0;
                lw = 0;
                i = 0;
                while (i < rowSpan) {
                    lw = Math.max(lw, this.widths[rowIndex - 1 + i][colIndex - 1]);
                    rw = Math.max(rw, this.widths[rowIndex - 1 + i][colIndex + colSpan - 1] / 2 + this.widths[rowIndex - 1 + i][colIndex + colSpan - 1] % 2);
                    ++i;
                }
                borderInsets.left = lw;
                borderInsets.right = rw;
            } else if (colIndex + colSpan - 1 == colCount) {
                int lw2 = 0;
                int rw2 = 0;
                i = 0;
                while (i < rowSpan) {
                    lw2 = Math.max(lw2, this.widths[rowIndex - 1 + i][colIndex - 1] / 2);
                    rw2 = Math.max(rw2, this.widths[rowIndex - 1 + i][colIndex + colSpan - 1]);
                    ++i;
                }
                borderInsets.left = lw2;
                borderInsets.right = rw2;
            } else {
                rw = 0;
                lw = 0;
                i = 0;
                while (i < rowSpan) {
                    rw = Math.max(rw, this.widths[rowIndex - 1 + i][colIndex + colSpan - 1] / 2 + this.widths[rowIndex - 1 + i][colIndex + colSpan - 1] % 2);
                    lw = Math.max(lw, this.widths[rowIndex - 1 + i][colIndex - 1] / 2);
                    ++i;
                }
                borderInsets.left = lw;
                borderInsets.right = rw;
            }
            border.setBorderInsets(borderInsets);
        }
    }

    public int[][] getBorderData() {
        if (this.borderData == null) {
            this.initialize();
        }
        return this.borderData;
    }
}

