/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.impl;

import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.oda.mongodb.impl.MDbConnection;
import org.eclipse.birt.data.oda.mongodb.internal.impl.DriverUtil;
import org.eclipse.birt.data.oda.mongodb.nls.Messages;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.LogConfiguration;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataTypeMapping;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;

public class MongoDBDriver
implements IDriver {
    public static final String ODA_DATA_SOURCE_ID = "org.eclipse.birt.data.oda.mongodb";
    private static final String MONGO_PROP_PREFIX = "";
    private static final String MONGODB_PREFIX = "mongodb://";
    public static final String IGNORE_URI_PROP = "".concat("ignoreURI");
    public static final String MONGO_URI_PROP = "".concat("mongoURI");
    public static final String SERVER_HOST_PROP = "".concat("serverHost");
    public static final String SERVER_PORT_PROP = "".concat("serverPort");
    public static final String DBNAME_PROP = "".concat("databaseName");
    public static final String USERNAME_PROP = "".concat("userName");
    public static final String PASSWORD_PROP = "".concat("password");
    public static final String USE_KERBEROS_PROP = "".concat("useKerberosAuthentication");
    public static final String KERBEROS_PRINCIPAL_PROP = "".concat("kerberosPrincipal");
    public static final String KERBEROS_GSSAPI_SERVICENAME_PROP = "".concat("gssapiServiceName");
    public static final String KERBEROS_KRB5CONFIG_FILE_PROP = "".concat("krb5config");
    public static final String KERBEROS_GSS_JAAS_CONFIG_FILE_PROP = "".concat("gssJAASConfig");
    public static final String KERBEROS_PASSWORD_PROP = "".concat("kerberosPassword");
    public static final String SOCKET_KEEP_ALIVE_PROP = "".concat("socketKeepAlive");
    private static final MongoDBDriver sm_factory = new MongoDBDriver();
    private static ConcurrentMap<ServerNodeKey, MongoClient> sm_mongoServerNodes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ConcurrentMap<ServerNodeKey, MongoClient> getMongoServerNodes() {
        if (sm_mongoServerNodes != null) return sm_mongoServerNodes;
        Class<MongoDBDriver> clazz = MongoDBDriver.class;
        synchronized (MongoDBDriver.class) {
            if (sm_mongoServerNodes != null) return sm_mongoServerNodes;
            sm_mongoServerNodes = new ConcurrentHashMap<ServerNodeKey, MongoClient>();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_mongoServerNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Class<MongoDBDriver> clazz = MongoDBDriver.class;
        synchronized (MongoDBDriver.class) {
            if (sm_mongoServerNodes == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            for (Mongo node : sm_mongoServerNodes.values()) {
                node.close();
            }
            sm_mongoServerNodes.clear();
            sm_mongoServerNodes = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static MongoClient getMongoNodeInstance(ServerNodeKey serverNodeKey) throws OdaException {
        MongoClient mongoNode = (MongoClient)MongoDBDriver.getMongoServerNodes().get(serverNodeKey);
        if (mongoNode != null) {
            return mongoNode;
        }
        mongoNode = MongoDBDriver.createMongoNode(serverNodeKey);
        MongoClient existingNode = MongoDBDriver.getMongoServerNodes().putIfAbsent(serverNodeKey, mongoNode);
        if (existingNode == null) {
            return mongoNode;
        }
        mongoNode.close();
        return existingNode;
    }

    static MongoClient getMongoNode(Properties connProperties) throws OdaException {
        ServerNodeKey nodeKey = MongoDBDriver.createServerNodeKey(connProperties);
        return MongoDBDriver.getMongoNodeInstance(nodeKey);
    }

    public IConnection getConnection(String dataSourceType) throws OdaException {
        return new MDbConnection();
    }

    public void setLogConfiguration(LogConfiguration logConfig) throws OdaException {
    }

    public int getMaxConnections() throws OdaException {
        return 100;
    }

    public void setAppContext(Object context) throws OdaException {
    }

    static ExtensionManifest getManifest() throws OdaException {
        return ManifestExplorer.getInstance().getExtensionManifest(ODA_DATA_SOURCE_ID);
    }

    static String getNativeDataTypeName(int nativeDataTypeCode) throws OdaException {
        DataTypeMapping typeMapping = MongoDBDriver.getManifest().getDataSetType(null).getDataTypeMapping(nativeDataTypeCode);
        if (typeMapping != null) {
            return typeMapping.getNativeType();
        }
        return Messages.mDbDriver_nonDefinedDataType;
    }

    private static MongoClient createMongoNode(ServerNodeKey serverNodeKey) throws OdaException {
        Properties connProperties = serverNodeKey.getConnectionProperties();
        if (connProperties == null) {
            throw new OdaException("ConnectionProperties is null");
        }
        try {
            MongoClient mongoClient = null;
            String useKerberos = MongoDBDriver.getStringPropValue(connProperties, USE_KERBEROS_PROP);
            String kerberosPrincipal = MongoDBDriver.getStringPropValue(connProperties, KERBEROS_PRINCIPAL_PROP);
            String serviceName = MongoDBDriver.getStringPropValue(connProperties, KERBEROS_GSSAPI_SERVICENAME_PROP);
            String kerberosConfig = MongoDBDriver.getStringPropValue(connProperties, KERBEROS_KRB5CONFIG_FILE_PROP);
            String gssapiConfig = MongoDBDriver.getStringPropValue(connProperties, KERBEROS_GSS_JAAS_CONFIG_FILE_PROP);
            MongoDBDriver.getKerberosPassword(connProperties);
            String serverHost = MongoDBDriver.getStringPropValue(connProperties, SERVER_HOST_PROP);
            Integer serverPort = MongoDBDriver.getIntegerPropValue(connProperties, SERVER_PORT_PROP);
            String userName = MongoDBDriver.getUserName(connProperties);
            String databaseName = MongoDBDriver.getDatabaseName(connProperties);
            String password = MongoDBDriver.getPassword(connProperties);
            MongoClientOptions.Builder clientOptionsBuilder = MongoDBDriver.createDefaultClientOptionsBuilder(connProperties);
            MongoClientURI clientURI = MongoDBDriver.getMongoURI(connProperties);
            if (useKerberos.equals("true")) {
                if (kerberosPrincipal == null || kerberosPrincipal.isEmpty()) {
                    throw new OdaException(Messages.mDbConnection_missingValueKrbPrinc);
                }
                if (kerberosConfig == null || kerberosConfig.isEmpty()) {
                    throw new OdaException(Messages.mDbConnection_missingValueKrbConf);
                }
                if (gssapiConfig == null || gssapiConfig.isEmpty()) {
                    throw new OdaException(Messages.mDbConnection_missingValueJaasConf);
                }
                System.setProperty("sun.security.krb5.principal", userName);
                System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                if (gssapiConfig != null && gssapiConfig.trim().length() != 0) {
                    System.setProperty("java.security.auth.login.config", gssapiConfig);
                }
                if (kerberosConfig != null && kerberosConfig.trim().length() != 0) {
                    System.setProperty("java.security.krb5.conf", kerberosConfig);
                }
            }
            if (clientURI != null) {
                mongoClient = new MongoClient(clientURI);
                if (MongoDBDriver.getLogger().isLoggable(Level.FINEST)) {
                    MongoDBDriver.getLogger().finest(Messages.bind((String)"{0}: uri= {1}", (Object[])new Object[]{"createMongoNode", clientURI}));
                }
            } else {
                ServerAddress serverAddr;
                MongoClientOptions clientOptions = clientOptionsBuilder.build();
                ArrayList<MongoCredential> mongoCredentials = new ArrayList<MongoCredential>();
                MongoCredential mongoCredential = null;
                if (useKerberos.equals("true")) {
                    InetAddress.getByName(kerberosPrincipal);
                    mongoCredential = MongoCredential.createGSSAPICredential((String)userName);
                    mongoCredential = serviceName != null && !serviceName.isEmpty() ? mongoCredential.withMechanismProperty("SERVICE_NAME", (Object)serviceName) : mongoCredential.withMechanismProperty("SERVICE_NAME", (Object)"mongodb");
                    mongoCredential = mongoCredential.withMechanismProperty("CANONICALIZE_HOST_NAME", (Object)true);
                } else if (userName != null && !userName.isEmpty()) {
                    mongoCredential = MongoCredential.createCredential((String)userName, (String)databaseName, (char[])(password == null ? null : password.toCharArray()));
                }
                ServerAddress serverAddress = serverAddr = serverPort != null ? new ServerAddress(serverHost, serverPort.intValue()) : new ServerAddress(serverHost);
                if (mongoCredential != null) {
                    mongoCredentials.add(mongoCredential);
                    mongoClient = new MongoClient(serverAddr, mongoCredentials);
                } else {
                    mongoClient = new MongoClient(serverAddr, clientOptions);
                }
                if (MongoDBDriver.getLogger().isLoggable(Level.FINEST)) {
                    MongoDBDriver.getLogger().finest(Messages.bind((String)"{0}: hosts= {1}, port= {2}, user= {3}, database= {4}", (Object[])new Object[]{"createMongoNode", serverHost, serverPort, userName, databaseName}));
                }
            }
            return mongoClient;
        }
        catch (Exception ex) {
            throw new OdaException((Throwable)ex);
        }
    }

    private static ServerNodeKey createServerNodeKey(Properties connProperties) {
        MongoDBDriver mongoDBDriver = sm_factory;
        mongoDBDriver.getClass();
        return mongoDBDriver.new ServerNodeKey(connProperties);
    }

    private static MongoClientOptions.Builder createDefaultClientOptionsBuilder(Properties connProperties) {
        MongoClientOptions.Builder clientOptionsBuilder = new MongoClientOptions.Builder();
        if (connProperties != null && MongoDBDriver.hasKeepSocketAlive(connProperties).booleanValue()) {
            clientOptionsBuilder.socketKeepAlive(true);
        }
        return clientOptionsBuilder;
    }

    private static Boolean hasKeepSocketAlive(Properties connProperties) {
        String keepSocketAlivePropValue = MongoDBDriver.getStringPropValue(connProperties, SOCKET_KEEP_ALIVE_PROP);
        if (keepSocketAlivePropValue == null) {
            return Boolean.FALSE;
        }
        boolean keepSocketAlive = Boolean.valueOf(keepSocketAlivePropValue);
        if (!keepSocketAlive) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    static String getDatabaseName(Properties connProps) {
        MongoClientURI mongoURI = MongoDBDriver.getMongoURI(connProps);
        if (mongoURI != null) {
            return mongoURI.getDatabase();
        }
        return MongoDBDriver.getStringPropValue(connProps, DBNAME_PROP);
    }

    static String getUserName(Properties connProps) {
        return MongoDBDriver.getStringPropValue(connProps, USERNAME_PROP);
    }

    static String getPassword(Properties connProps) {
        return MongoDBDriver.getStringPropValue(connProps, PASSWORD_PROP);
    }

    static String getKerberosPassword(Properties connProps) {
        return MongoDBDriver.getStringPropValue(connProps, KERBEROS_PASSWORD_PROP);
    }

    private static MongoClientURI getMongoURI(Properties connProps) {
        try {
            return MongoDBDriver.getMongoURI(connProps, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static MongoClientURI getMongoURI(Properties connProps, MongoClientOptions.Builder clientOptionsBuilder) throws Exception {
        Boolean ignoreURI = MongoDBDriver.getBooleanPropValue(connProps, IGNORE_URI_PROP);
        if (ignoreURI != null && ignoreURI.booleanValue()) {
            return null;
        }
        String uri = MongoDBDriver.getStringPropValue(connProps, MONGO_URI_PROP);
        if (uri == null || uri.isEmpty()) {
            return null;
        }
        try {
            if (clientOptionsBuilder != null) {
                return new MongoClientURI(uri, clientOptionsBuilder);
            }
            return new MongoClientURI(uri);
        }
        catch (Exception ex) {
            MongoDBDriver.getLogger().log(Level.INFO, Messages.bind((String)"Invalid Mongo Database URI: {0}", (Object)uri), ex);
            throw ex;
        }
    }

    private static String formatMongoURI(Properties connProps) {
        String dbName;
        String serverHost = MongoDBDriver.getStringPropValue(connProps, SERVER_HOST_PROP);
        if (serverHost == null || serverHost.isEmpty()) {
            throw new IllegalArgumentException(Messages.mDbDriver_missingValueServerHost);
        }
        StringBuffer buf = new StringBuffer(MONGODB_PREFIX);
        String username = MongoDBDriver.getUserName(connProps);
        if (username != null && !username.isEmpty()) {
            String passwd = MongoDBDriver.getPassword(connProps);
            buf.append(username);
            buf.append(':');
            buf.append(passwd);
            buf.append('@');
        }
        buf.append(serverHost);
        Integer serverPort = MongoDBDriver.getIntegerPropValue(connProps, SERVER_PORT_PROP);
        if (serverPort != null) {
            buf.append(':');
            buf.append(serverPort);
        }
        if ((dbName = MongoDBDriver.getStringPropValue(connProps, DBNAME_PROP)) != null) {
            buf.append('/');
            buf.append(dbName);
        }
        return buf.toString();
    }

    static String getStringPropValue(Properties props, String propName) {
        String propValue = props.getProperty(propName);
        return propValue != null ? propValue.trim() : null;
    }

    static Boolean getBooleanPropValue(Properties props, String propName) {
        String propValue = MongoDBDriver.getStringPropValue(props, propName);
        if (propValue == null || propValue.isEmpty()) {
            return null;
        }
        return Boolean.valueOf(propValue);
    }

    static Integer getIntegerPropValue(Properties props, String propName) {
        String propValue = MongoDBDriver.getStringPropValue(props, propName);
        if (propValue == null || propValue.isEmpty()) {
            return null;
        }
        try {
            return Integer.valueOf(propValue);
        }
        catch (NumberFormatException ex) {
            MongoDBDriver.getLogger().log(Level.INFO, "MongoDBDriver#getIntegerPropValue ignoring exception: " + ex);
            return null;
        }
    }

    static Logger getLogger() {
        return DriverUtil.getLogger();
    }

    public static enum ReadPreferenceChoice {
        PRIMARY,
        PRIMARY_PREFERRED,
        SECONDARY,
        SECONDARY_PREFERRED,
        NEAREST;

        public static ReadPreferenceChoice DEFAULT;
        public static ReadPreference DEFAULT_PREFERENCE;

        static {
            DEFAULT = PRIMARY;
            DEFAULT_PREFERENCE = ReadPreference.primary();
        }

        public static ReadPreference getMongoReadPreference(String readPrefChoiceLiteral) {
            if (readPrefChoiceLiteral == null || readPrefChoiceLiteral.trim().isEmpty()) {
                return null;
            }
            try {
                return ReadPreference.valueOf((String)readPrefChoiceLiteral.trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return DEFAULT_PREFERENCE;
            }
        }

        public static ReadPreferenceChoice getReadPreferenceChoice(ReadPreference readPref) {
            if (readPref == null) {
                return PRIMARY;
            }
            String readPrefName = readPref.getName();
            if (readPrefName == ReadPreference.primary().getName()) {
                return PRIMARY;
            }
            if (readPrefName == ReadPreference.primaryPreferred().getName()) {
                return PRIMARY_PREFERRED;
            }
            if (readPrefName == ReadPreference.secondary().getName()) {
                return SECONDARY;
            }
            if (readPrefName == ReadPreference.secondaryPreferred().getName()) {
                return SECONDARY_PREFERRED;
            }
            if (readPrefName == ReadPreference.nearest().getName()) {
                return NEAREST;
            }
            return PRIMARY;
        }

        public String displayName() {
            if (this == PRIMARY) {
                return Messages.mDbDriver_readPrefPrimary;
            }
            if (this == PRIMARY_PREFERRED) {
                return Messages.mDbDriver_readPrefPrimaryPreferred;
            }
            if (this == SECONDARY) {
                return Messages.mDbDriver_readPrefSecondary;
            }
            if (this == SECONDARY_PREFERRED) {
                return Messages.mDbDriver_readPrefSecondaryPreferred;
            }
            if (this == NEAREST) {
                return Messages.mDbDriver_readPrefNearest;
            }
            return Messages.mDbDriver_readPrefPrimary;
        }
    }

    private class ServerNodeKey {
        private Properties m_connProperties = new Properties();

        ServerNodeKey(Properties connProperties) {
            String useKerberos = MongoDBDriver.getStringPropValue(connProperties, USE_KERBEROS_PROP);
            String ignoreMongoUri = MongoDBDriver.getStringPropValue(connProperties, IGNORE_URI_PROP);
            if (ignoreMongoUri.equals("false")) {
                connProperties.remove(SERVER_HOST_PROP);
                connProperties.remove(SERVER_PORT_PROP);
                connProperties.remove(DBNAME_PROP);
                connProperties.remove(USERNAME_PROP);
                connProperties.remove(PASSWORD_PROP);
            }
            if (useKerberos.equals("false")) {
                connProperties.remove(KERBEROS_PRINCIPAL_PROP);
                connProperties.remove(KERBEROS_GSSAPI_SERVICENAME_PROP);
                connProperties.remove(KERBEROS_KRB5CONFIG_FILE_PROP);
                connProperties.remove(KERBEROS_GSS_JAAS_CONFIG_FILE_PROP);
                connProperties.remove(KERBEROS_PASSWORD_PROP);
            }
            for (String propertyName : connProperties.stringPropertyNames()) {
                MongoClientURI mongoUri;
                this.m_connProperties.setProperty(propertyName, connProperties.getProperty(propertyName));
                if (!propertyName.equals(MONGO_URI_PROP) || (mongoUri = MongoDBDriver.getMongoURI(connProperties)) == null || mongoUri.getUsername() == null) continue;
                this.m_connProperties.setProperty(USERNAME_PROP, mongoUri.getUsername());
            }
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (!(obj instanceof ServerNodeKey)) {
                return false;
            }
            ServerNodeKey thatKey = (ServerNodeKey)obj;
            if (this.m_connProperties == null && thatKey.m_connProperties != null) {
                return false;
            }
            return this.m_connProperties == null || this.m_connProperties.equals(thatKey.m_connProperties);
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.m_connProperties != null) {
                hashCode = this.m_connProperties.hashCode();
            }
            return hashCode == 0 ? super.hashCode() : hashCode;
        }

        private Properties getConnectionProperties() {
            return this.m_connProperties;
        }
    }
}

