/*
 * Decompiled with CFR 0.152.
 */
package io.eblock.eos4j.utils;

import io.eblock.eos4j.api.vo.BaseVo;
import io.eblock.eos4j.utils.ByteBuffer;
import io.eblock.eos4j.utils.ByteUtils;
import io.eblock.eos4j.utils.Hex;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObjectUtils {
    private static Object getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(o, new Object[0]);
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, Object> Bean2Map(Object obj) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Field[] fields = obj.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            map.put(fields[i].getName(), ObjectUtils.getFieldValueByName(fields[i].getName(), obj));
        }
        return map;
    }

    public static void writeBytes(Object vo, ByteBuffer bf) {
        Object obj;
        Map<String, Object> params = null;
        params = vo instanceof Map ? (Map<String, Object>)vo : ObjectUtils.Bean2Map(vo);
        LinkedHashMap<String, Object> objMap = new LinkedHashMap<String, Object>();
        for (String key : params.keySet()) {
            obj = params.get(key);
            if (obj instanceof BaseVo || obj instanceof List || obj instanceof Map) {
                if ("authorization".equals(key)) {
                    bf.concat(ByteUtils.writerVarint32(String.valueOf(((List)obj).size())));
                    for (Object ob : (List)obj) {
                        ObjectUtils.writeBytes(ob, bf);
                    }
                    continue;
                }
                if ("data".equals(key)) {
                    ByteBuffer databf = new ByteBuffer();
                    ObjectUtils.writeBytes(obj, databf);
                    bf.concat(ByteUtils.writerVarint32(String.valueOf(databf.getBuffer().length)));
                    bf.concat(databf.getBuffer());
                    continue;
                }
                if ("transaction_extensions".equals(key)) continue;
                objMap.put(key, obj);
                continue;
            }
            if ("chain_id".equals(key)) {
                bf.concat(Hex.hexStringToBytes(obj.toString()));
                continue;
            }
            if ("expiration".equals(key)) {
                bf.concat(ByteUtils.writerUnit32(obj.toString()));
                continue;
            }
            if ("ref_block_num".equals(key)) {
                bf.concat(ByteUtils.writerUnit16(obj.toString()));
                continue;
            }
            if ("ref_block_prefix".equals(key)) {
                bf.concat(ByteUtils.writerUnit32(obj.toString()));
                continue;
            }
            if ("net_usage_words".equals(key)) {
                bf.concat(ByteUtils.writerVarint32(obj.toString()));
                continue;
            }
            if ("max_cpu_usage_ms".equals(key)) {
                bf.concat(ByteUtils.writerUnit8(obj.toString()));
                continue;
            }
            if ("delay_sec".equals(key)) {
                bf.concat(ByteUtils.writerVarint32(obj.toString()));
                continue;
            }
            if ("account".equals(key)) {
                bf.concat(ByteUtils.writeName(obj.toString()));
                continue;
            }
            if ("name".equals(key)) {
                bf.concat(ByteUtils.writeName(obj.toString()));
                continue;
            }
            if ("actor".equals(key)) {
                bf.concat(ByteUtils.writeName(obj.toString()));
                continue;
            }
            if ("permission".equals(key)) {
                bf.concat(ByteUtils.writeName(obj.toString()));
                continue;
            }
            if ("from".equals(key)) {
                bf.concat(ByteUtils.writeName(obj.toString()));
                continue;
            }
            if ("to".equals(key)) {
                bf.concat(ByteUtils.writeName(obj.toString()));
                continue;
            }
            if ("quantity".equals(key)) {
                bf.concat(ByteUtils.writerAsset(obj.toString()));
                continue;
            }
            if ("memo".equals(key)) {
                bf.concat(ByteUtils.writerString(obj.toString()));
                continue;
            }
            if ("creator".equals(key)) {
                bf.concat(ByteUtils.writeName(obj.toString()));
                continue;
            }
            if ("owner".equals(key)) {
                bf.concat(ByteUtils.writerKey(obj.toString()));
                continue;
            }
            if ("active".equals(key)) {
                bf.concat(ByteUtils.writerKey(obj.toString()));
                continue;
            }
            if ("payer".equals(key)) {
                bf.concat(ByteUtils.writeName(obj.toString()));
                continue;
            }
            if ("receiver".equals(key)) {
                bf.concat(ByteUtils.writeName(obj.toString()));
                continue;
            }
            if ("bytes".equals(key)) {
                bf.concat(ByteUtils.writerUnit32(obj.toString()));
                continue;
            }
            if ("stake_net_quantity".equals(key)) {
                bf.concat(ByteUtils.writerAsset(obj.toString()));
                continue;
            }
            if ("stake_cpu_quantity".equals(key)) {
                bf.concat(ByteUtils.writerAsset(obj.toString()));
                continue;
            }
            if ("transfer".equals(key)) {
                bf.concat(ByteUtils.writerUnit8(obj.toString()));
                continue;
            }
            if ("voter".equals(key)) {
                bf.concat(ByteUtils.writeName(obj.toString()));
                continue;
            }
            if ("proxy".equals(key)) {
                bf.concat(ByteUtils.writeName(obj.toString()));
                continue;
            }
            if ("producer".equals(key)) {
                bf.concat(ByteUtils.writeName(obj.toString()));
                continue;
            }
            if ("close-owner".equals(key)) {
                bf.concat(ByteUtils.writeName(obj.toString()));
                continue;
            }
            if (!"close-symbol".equals(key)) continue;
            bf.concat(ByteUtils.writerSymbol(obj.toString()));
        }
        for (String key : objMap.keySet()) {
            obj = params.get(key);
            if ("context_free_actions".equals(key)) {
                bf.concat(ByteUtils.writerVarint32(String.valueOf(((List)obj).size())));
                for (Object ob : (List)obj) {
                    ObjectUtils.writeBytes(ob, bf);
                }
                continue;
            }
            if ("actions".equals(key)) {
                bf.concat(ByteUtils.writerVarint32(String.valueOf(((List)obj).size())));
                for (Object ob : (List)obj) {
                    ObjectUtils.writeBytes(ob, bf);
                }
                continue;
            }
            if ("producers".equals(key)) {
                bf.concat(ByteUtils.writerVarint32(String.valueOf(((List)obj).size())));
                for (Object ob : (List)obj) {
                    HashMap mp = new HashMap();
                    mp.put("producer", ob);
                    ObjectUtils.writeBytes(mp, bf);
                }
                continue;
            }
            ObjectUtils.writeBytes(obj, bf);
        }
    }
}

