/*
 * Decompiled with CFR 0.152.
 */
package io.eblock.eos4j.ese;

import io.eblock.eos4j.ese.Action;
import io.eblock.eos4j.ese.DataParam;
import io.eblock.eos4j.ese.DataType;
import io.eblock.eos4j.utils.ByteUtils;
import io.eblock.eos4j.utils.Hex;
import java.util.ArrayList;
import java.util.List;

public class Ese {
    public static String parseTransferData(String from, String to, String quantity, String memo) {
        DataParam[] datas = new DataParam[]{new DataParam(from, DataType.name, Action.transfer), new DataParam(to, DataType.name, Action.transfer), new DataParam(quantity, DataType.asset, Action.transfer), new DataParam(memo, DataType.string, Action.transfer)};
        byte[] allbyte = new byte[]{};
        for (DataParam value : datas) {
            allbyte = ByteUtils.concat(allbyte, value.seria());
        }
        return Hex.bytesToHexString(allbyte);
    }

    public static String parseVoteProducerData(String voter, String proxy, List<String> producers) {
        ArrayList<DataParam> datas = new ArrayList<DataParam>();
        datas.add(new DataParam(voter, DataType.name, Action.voteproducer));
        datas.add(new DataParam(proxy, DataType.name, Action.voteproducer));
        datas.add(new DataParam(String.valueOf(producers.size()), DataType.varint32, Action.voteproducer));
        for (String producer : producers) {
            datas.add(new DataParam(producer, DataType.name, Action.voteproducer));
        }
        byte[] allbyte = new byte[]{};
        for (DataParam value : datas) {
            allbyte = ByteUtils.concat(allbyte, value.seria());
        }
        return Hex.bytesToHexString(allbyte);
    }

    public static String parseAccountData(String creator, String name, String onwer, String active) {
        DataParam[] datas = new DataParam[]{new DataParam(creator, DataType.name, Action.account), new DataParam(name, DataType.name, Action.account), new DataParam(onwer, DataType.key, Action.account), new DataParam(active, DataType.key, Action.account)};
        byte[] allbyte = new byte[]{};
        for (DataParam value : datas) {
            allbyte = ByteUtils.concat(allbyte, value.seria());
        }
        return Hex.bytesToHexString(allbyte);
    }

    public static String parseDelegateData(String from, String receiver, String stakeNetQuantity, String stakeCpuQuantity, int transfer) {
        DataParam[] datas = new DataParam[]{new DataParam(from, DataType.name, Action.delegate), new DataParam(receiver, DataType.name, Action.delegate), new DataParam(stakeNetQuantity, DataType.asset, Action.delegate), new DataParam(stakeCpuQuantity, DataType.asset, Action.delegate), new DataParam(String.valueOf(transfer), DataType.varint32, Action.delegate)};
        byte[] allbyte = new byte[]{};
        for (DataParam value : datas) {
            allbyte = ByteUtils.concat(allbyte, value.seria());
        }
        return Hex.bytesToHexString(allbyte);
    }

    public static String parseBuyRamData(String payer, String receiver, Long bytes) {
        DataParam[] datas = new DataParam[]{new DataParam(payer, DataType.name, Action.ram), new DataParam(receiver, DataType.name, Action.ram), new DataParam(String.valueOf(bytes), DataType.unit32, Action.ram)};
        byte[] allbyte = new byte[]{};
        for (DataParam value : datas) {
            allbyte = ByteUtils.concat(allbyte, value.seria());
        }
        return Hex.bytesToHexString(allbyte);
    }

    public static String parseCloseData(String owner, String symbol) {
        DataParam[] datas = new DataParam[]{new DataParam(owner, DataType.name, Action.close), new DataParam(symbol, DataType.symbol, Action.close)};
        byte[] allbyte = new byte[]{};
        for (DataParam value : datas) {
            allbyte = ByteUtils.concat(allbyte, value.seria());
        }
        return Hex.bytesToHexString(allbyte);
    }
}

