/*
 * Decompiled with CFR 0.152.
 */
package io.eblock.eos4j.ese;

import io.eblock.eos4j.ese.Action;
import io.eblock.eos4j.ese.DataType;
import io.eblock.eos4j.utils.ByteUtils;
import io.eblock.eos4j.utils.EException;

public class DataParam {
    private String value;
    private DataType type;

    /*
     * Enabled aggressive block sorting
     */
    public DataParam(String value, DataType type, Action action) {
        String[] vs;
        this.value = value;
        this.type = type;
        if (type != DataType.asset) {
            if (type != DataType.symbol) return;
        }
        if (action != Action.transfer) {
            if (action != Action.delegate) {
                if (action != Action.close) {
                    this.value = value;
                    return;
                }
            }
        }
        if ((vs = value.split(" ")).length < 2) {
            throw new EException("error", "quantity error");
        }
        String ammount = vs[0];
        String[] ams = ammount.split("[.]");
        int precision = 0;
        if (ams.length > 1) {
            precision = ams[1].length();
        }
        this.value = vs[0] + " " + action.getCode().replace("${precision}", String.valueOf(precision)).replace("${quantity}", vs[1]);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public DataType getType() {
        return this.type;
    }

    public void setType(DataType type) {
        this.type = type;
    }

    public byte[] seria() {
        if (this.type == DataType.name) {
            return ByteUtils.writeName(this.value);
        }
        if (this.type == DataType.asset) {
            return ByteUtils.writerAsset(this.value);
        }
        if (this.type == DataType.symbol) {
            return ByteUtils.writerSymbol(this.value);
        }
        if (this.type == DataType.unit32) {
            return ByteUtils.writerUnit32(this.value);
        }
        if (this.type == DataType.unit16) {
            return ByteUtils.writerUnit16(this.value);
        }
        if (this.type == DataType.key) {
            return ByteUtils.writerKey(this.value);
        }
        if (this.type == DataType.varint32) {
            return ByteUtils.writerVarint32(this.value);
        }
        if (this.type == DataType.unit64) {
            return ByteUtils.writeUint64(this.value);
        }
        return ByteUtils.writerString(this.value);
    }
}

