/*
 * Decompiled with CFR 0.152.
 */
package io.eblock.eos4j;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.eblock.eos4j.Ecc;
import io.eblock.eos4j.api.service.RpcService;
import io.eblock.eos4j.api.utils.Generator;
import io.eblock.eos4j.api.vo.Block;
import io.eblock.eos4j.api.vo.ChainInfo;
import io.eblock.eos4j.api.vo.SignParam;
import io.eblock.eos4j.api.vo.TableRows;
import io.eblock.eos4j.api.vo.TableRowsReq;
import io.eblock.eos4j.api.vo.account.Account;
import io.eblock.eos4j.api.vo.transaction.Transaction;
import io.eblock.eos4j.api.vo.transaction.push.Tx;
import io.eblock.eos4j.api.vo.transaction.push.TxAction;
import io.eblock.eos4j.api.vo.transaction.push.TxRequest;
import io.eblock.eos4j.api.vo.transaction.push.TxSign;
import io.eblock.eos4j.ese.Action;
import io.eblock.eos4j.ese.DataParam;
import io.eblock.eos4j.ese.DataType;
import io.eblock.eos4j.ese.Ese;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TimeZone;

public class Rpc {
    private final RpcService rpcService;
    SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public Rpc(String baseUrl) {
        this.dateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.rpcService = Generator.createService(RpcService.class, baseUrl);
    }

    public ChainInfo getChainInfo() {
        return Generator.executeSync(this.rpcService.getChainInfo());
    }

    public Block getBlock(String blockNumberOrId) {
        return Generator.executeSync(this.rpcService.getBlock(Collections.singletonMap("block_num_or_id", blockNumberOrId)));
    }

    public Account getAccount(String account) {
        return Generator.executeSync(this.rpcService.getAccount(Collections.singletonMap("account_name", account)));
    }

    public TableRows getTableRows(TableRowsReq req) {
        return Generator.executeSync(this.rpcService.getTableRows(req));
    }

    public Transaction pushTransaction(String compression, Tx pushTransaction, String[] signatures) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String mapJakcson = mapper.writeValueAsString((Object)new TxRequest(compression, pushTransaction, signatures));
        System.out.println(mapJakcson);
        return Generator.executeSync(this.rpcService.pushTransaction(new TxRequest(compression, pushTransaction, signatures)));
    }

    public Transaction pushTransaction(String tx) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        TxRequest txObj = (TxRequest)mapper.readValue(tx, TxRequest.class);
        return Generator.executeSync(this.rpcService.pushTransaction(txObj));
    }

    public SignParam getOfflineSignParams(Long exp) {
        SignParam params = new SignParam();
        ChainInfo info = this.getChainInfo();
        Block block = this.getBlock(info.getLastIrreversibleBlockNum().toString());
        params.setChainId(info.getChainId());
        params.setHeadBlockTime(info.getHeadBlockTime());
        params.setLastIrreversibleBlockNum(info.getLastIrreversibleBlockNum());
        params.setRefBlockPrefix(block.getRefBlockPrefix());
        params.setExp(exp);
        return params;
    }

    public Transaction transfer(String pk, String contractAccount, String from, String to, String quantity, String memo) throws Exception {
        ChainInfo info = this.getChainInfo();
        Block block = this.getBlock(info.getLastIrreversibleBlockNum().toString());
        Tx tx = new Tx();
        tx.setExpiration(info.getHeadBlockTime().getTime() / 1000L + 60L);
        tx.setRef_block_num(info.getLastIrreversibleBlockNum());
        tx.setRef_block_prefix(block.getRefBlockPrefix());
        tx.setNet_usage_words(0L);
        tx.setMax_cpu_usage_ms(0L);
        tx.setDelay_sec(0L);
        ArrayList<TxAction> actions = new ArrayList<TxAction>();
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("from", from);
        dataMap.put("to", to);
        dataMap.put("quantity", new DataParam(quantity, DataType.asset, Action.transfer).getValue());
        dataMap.put("memo", memo);
        TxAction action = new TxAction(from, contractAccount, "transfer", dataMap);
        actions.add(action);
        tx.setActions(actions);
        String sign = Ecc.signTransaction(pk, new TxSign(info.getChainId(), tx));
        String data = Ecc.parseTransferData(from, to, quantity, memo);
        action.setData(data);
        tx.setExpiration(this.dateFormatter.format(new Date(1000L * Long.parseLong(tx.getExpiration().toString()))));
        return this.pushTransaction("none", tx, new String[]{sign});
    }

    public Transaction createAccount(String pk, String creator, String newAccount, String owner, String active, Long buyRam) throws Exception {
        ChainInfo info = this.getChainInfo();
        Block block = this.getBlock(info.getLastIrreversibleBlockNum().toString());
        Tx tx = new Tx();
        tx.setExpiration(info.getHeadBlockTime().getTime() / 1000L + 60L);
        tx.setRef_block_num(info.getLastIrreversibleBlockNum());
        tx.setRef_block_prefix(block.getRefBlockPrefix());
        tx.setNet_usage_words(0L);
        tx.setMax_cpu_usage_ms(0L);
        tx.setDelay_sec(0L);
        ArrayList<TxAction> actions = new ArrayList<TxAction>();
        tx.setActions(actions);
        LinkedHashMap<String, String> createMap = new LinkedHashMap<String, String>();
        createMap.put("creator", creator);
        createMap.put("name", newAccount);
        createMap.put("owner", owner);
        createMap.put("active", active);
        TxAction createAction = new TxAction(creator, "eosio", "newaccount", createMap);
        actions.add(createAction);
        LinkedHashMap<String, Object> buyMap = new LinkedHashMap<String, Object>();
        buyMap.put("payer", creator);
        buyMap.put("receiver", newAccount);
        buyMap.put("bytes", buyRam);
        TxAction buyAction = new TxAction(creator, "eosio", "buyrambytes", buyMap);
        actions.add(buyAction);
        String sign = Ecc.signTransaction(pk, new TxSign(info.getChainId(), tx));
        String accountData = Ese.parseAccountData(creator, newAccount, owner, active);
        createAction.setData(accountData);
        String ramData = Ese.parseBuyRamData(creator, newAccount, buyRam);
        buyAction.setData(ramData);
        tx.setExpiration(this.dateFormatter.format(new Date(1000L * Long.parseLong(tx.getExpiration().toString()))));
        return this.pushTransaction("none", tx, new String[]{sign});
    }

    public Transaction createAccount(String pk, String creator, String newAccount, String owner, String active, Long buyRam, String stakeNetQuantity, String stakeCpuQuantity, Long transfer) throws Exception {
        ChainInfo info = this.getChainInfo();
        Block block = this.getBlock(info.getLastIrreversibleBlockNum().toString());
        Tx tx = new Tx();
        tx.setExpiration(info.getHeadBlockTime().getTime() / 1000L + 60L);
        tx.setRef_block_num(info.getLastIrreversibleBlockNum());
        tx.setRef_block_prefix(block.getRefBlockPrefix());
        tx.setNet_usage_words(0L);
        tx.setMax_cpu_usage_ms(0L);
        tx.setDelay_sec(0L);
        ArrayList<TxAction> actions = new ArrayList<TxAction>();
        tx.setActions(actions);
        LinkedHashMap<String, String> createMap = new LinkedHashMap<String, String>();
        createMap.put("creator", creator);
        createMap.put("name", newAccount);
        createMap.put("owner", owner);
        createMap.put("active", active);
        TxAction createAction = new TxAction(creator, "eosio", "newaccount", createMap);
        actions.add(createAction);
        LinkedHashMap<String, Object> buyMap = new LinkedHashMap<String, Object>();
        buyMap.put("payer", creator);
        buyMap.put("receiver", newAccount);
        buyMap.put("bytes", buyRam);
        TxAction buyAction = new TxAction(creator, "eosio", "buyrambytes", buyMap);
        actions.add(buyAction);
        LinkedHashMap<String, Object> delMap = new LinkedHashMap<String, Object>();
        delMap.put("from", creator);
        delMap.put("receiver", newAccount);
        delMap.put("stake_net_quantity", new DataParam(stakeNetQuantity, DataType.asset, Action.delegate).getValue());
        delMap.put("stake_cpu_quantity", new DataParam(stakeCpuQuantity, DataType.asset, Action.delegate).getValue());
        delMap.put("transfer", transfer);
        TxAction delAction = new TxAction(creator, "eosio", "delegatebw", delMap);
        actions.add(delAction);
        String sign = Ecc.signTransaction(pk, new TxSign(info.getChainId(), tx));
        String accountData = Ese.parseAccountData(creator, newAccount, owner, active);
        createAction.setData(accountData);
        String ramData = Ese.parseBuyRamData(creator, newAccount, buyRam);
        buyAction.setData(ramData);
        String delData = Ese.parseDelegateData(creator, newAccount, stakeNetQuantity, stakeCpuQuantity, transfer.intValue());
        delAction.setData(delData);
        tx.setExpiration(this.dateFormatter.format(new Date(1000L * Long.parseLong(tx.getExpiration().toString()))));
        return this.pushTransaction("none", tx, new String[]{sign});
    }

    public Transaction voteproducer(String pk, String voter, String proxy, List<String> producers) throws Exception {
        Comparator comparator = (h1, h2) -> h2.compareTo((String)h1);
        producers.sort(comparator.reversed());
        ChainInfo info = this.getChainInfo();
        Block block = this.getBlock(info.getLastIrreversibleBlockNum().toString());
        Tx tx = new Tx();
        tx.setExpiration(info.getHeadBlockTime().getTime() / 1000L + 60L);
        tx.setRef_block_num(info.getLastIrreversibleBlockNum());
        tx.setRef_block_prefix(block.getRefBlockPrefix());
        tx.setNet_usage_words(0L);
        tx.setMax_cpu_usage_ms(0L);
        tx.setDelay_sec(0L);
        ArrayList<TxAction> actions = new ArrayList<TxAction>();
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("voter", voter);
        dataMap.put("proxy", proxy);
        dataMap.put("producers", producers);
        TxAction action = new TxAction(voter, "eosio", "voteproducer", dataMap);
        actions.add(action);
        tx.setActions(actions);
        String sign = Ecc.signTransaction(pk, new TxSign(info.getChainId(), tx));
        String data = Ecc.parseVoteProducerData(voter, proxy, producers);
        action.setData(data);
        tx.setExpiration(this.dateFormatter.format(new Date(1000L * Long.parseLong(tx.getExpiration().toString()))));
        return this.pushTransaction("none", tx, new String[]{sign});
    }

    public Transaction close(String pk, String contract, String owner, String symbol) throws Exception {
        ChainInfo info = this.getChainInfo();
        Block block = this.getBlock(info.getLastIrreversibleBlockNum().toString());
        Tx tx = new Tx();
        tx.setExpiration(info.getHeadBlockTime().getTime() / 1000L + 60L);
        tx.setRef_block_num(info.getLastIrreversibleBlockNum());
        tx.setRef_block_prefix(block.getRefBlockPrefix());
        tx.setNet_usage_words(0L);
        tx.setMax_cpu_usage_ms(0L);
        tx.setDelay_sec(0L);
        ArrayList<TxAction> actions = new ArrayList<TxAction>();
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("close-owner", owner);
        dataMap.put("close-symbol", new DataParam(symbol, DataType.symbol, Action.close).getValue());
        TxAction action = new TxAction(owner, contract, "close", dataMap);
        actions.add(action);
        tx.setActions(actions);
        String sign = Ecc.signTransaction(pk, new TxSign(info.getChainId(), tx));
        String data = Ecc.parseCloseData(owner, symbol);
        action.setData(data);
        tx.setExpiration(this.dateFormatter.format(new Date(1000L * Long.parseLong(tx.getExpiration().toString()))));
        return this.pushTransaction("none", tx, new String[]{sign});
    }
}

