/*
 * Decompiled with CFR 0.152.
 */
package io.paperdb;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.esotericsoftware.kryo.Serializer;
import io.paperdb.DbStoragePlainFile;
import io.paperdb.PaperDbException;
import java.util.HashMap;
import java.util.List;

public class Book {
    private final DbStoragePlainFile mStorage;

    protected Book(Context context, String dbName, HashMap<Class, Serializer> serializers) {
        this.mStorage = new DbStoragePlainFile(context.getApplicationContext(), dbName, serializers);
    }

    protected Book(String dbPath, String dbName, HashMap<Class, Serializer> serializers) {
        this.mStorage = new DbStoragePlainFile(dbPath, dbName, serializers);
    }

    public void destroy() {
        this.mStorage.destroy();
    }

    @NonNull
    public <T> Book write(@NonNull String key, @NonNull T value) {
        if (value == null) {
            throw new PaperDbException("Paper doesn't support writing null root values");
        }
        this.mStorage.insert(key, value);
        return this;
    }

    @Nullable
    public <T> T read(@NonNull String key) {
        return this.read(key, null);
    }

    @Nullable
    public <T> T read(@NonNull String key, @Nullable T defaultValue) {
        Object value = this.mStorage.select(key);
        return (T)(value == null ? defaultValue : value);
    }

    public boolean contains(@NonNull String key) {
        return this.mStorage.exists(key);
    }

    public boolean exist(@NonNull String key) {
        return this.mStorage.exists(key);
    }

    public long lastModified(@NonNull String key) {
        return this.mStorage.lastModified(key);
    }

    public void delete(@NonNull String key) {
        this.mStorage.deleteIfExists(key);
    }

    @NonNull
    public List<String> getAllKeys() {
        return this.mStorage.getAllKeys();
    }

    public void setLogLevel(int level) {
        this.mStorage.setLogLevel(level);
    }

    @NonNull
    public String getPath() {
        return this.mStorage.getRootFolderPath();
    }

    @NonNull
    public String getPath(@NonNull String key) {
        return this.mStorage.getOriginalFilePath(key);
    }
}

