/*
 * Decompiled with CFR 0.152.
 */
package com.petterp.floatingx.view;

import android.content.Context;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.petterp.floatingx.assist.helper.BasisHelper;
import com.petterp.floatingx.util.FxAdsorbDirection;
import com.petterp.floatingx.util.FxExtKt;
import com.petterp.floatingx.util.FxLog;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J$\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004J\u0006\u0010'\u001a\u00020 J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020\"J\u000e\u0010.\u001a\u00020 2\u0006\u0010-\u001a\u00020\"J\u000e\u0010/\u001a\u00020 2\u0006\u0010%\u001a\u00020\u0004J\u000e\u00100\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0004J\u000e\u00101\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004J\u0016\u00101\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\"J\u000e\u00102\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004J\u0016\u00102\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\"J\u000e\u00103\u001a\u00020)2\u0006\u00104\u001a\u00020 J\u000e\u00105\u001a\u00020 2\u0006\u00106\u001a\u000207J\u001e\u00105\u001a\u00020 2\u0006\u00108\u001a\u00020\u00192\u0006\u00109\u001a\u00020\u00192\u0006\u00106\u001a\u000207R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006:"}, d2={"Lcom/petterp/floatingx/view/FxViewConfigHelper;", "", "()V", "downTouchX", "", "downTouchY", "helper", "Lcom/petterp/floatingx/assist/helper/BasisHelper;", "mParentHeight", "mParentWidth", "maxHBoundary", "getMaxHBoundary", "()F", "setMaxHBoundary", "(F)V", "maxWBoundary", "getMaxWBoundary", "setMaxWBoundary", "minHBoundary", "getMinHBoundary", "setMinHBoundary", "minWBoundary", "getMinWBoundary", "setMinWBoundary", "scaledTouchSlop", "", "touchDownId", "getTouchDownId", "()I", "setTouchDownId", "(I)V", "checkInterceptedEvent", "", "event", "Landroid/view/MotionEvent;", "getAdsorbDirectionLocation", "Lkotlin/Pair;", "x", "y", "hasMainPointerId", "initConfig", "", "context", "Landroid/content/Context;", "initTouchDown", "ev", "isCurrentPointerId", "isNearestLeft", "isNearestTop", "safeX", "safeY", "updateBoundary", "isDownTouchInit", "updateWidgetSize", "view", "Landroid/view/ViewGroup;", "parentW", "parentH", "floatingx_release"})
public final class FxViewConfigHelper {
    private float downTouchX;
    private float downTouchY;
    private float mParentWidth;
    private float mParentHeight;
    private BasisHelper helper;
    private int scaledTouchSlop;
    private float minHBoundary;
    private float maxHBoundary;
    private float minWBoundary;
    private float maxWBoundary;
    private int touchDownId = -1;

    public final float getMinHBoundary() {
        return this.minHBoundary;
    }

    public final void setMinHBoundary(float f) {
        this.minHBoundary = f;
    }

    public final float getMaxHBoundary() {
        return this.maxHBoundary;
    }

    public final void setMaxHBoundary(float f) {
        this.maxHBoundary = f;
    }

    public final float getMinWBoundary() {
        return this.minWBoundary;
    }

    public final void setMinWBoundary(float f) {
        this.minWBoundary = f;
    }

    public final float getMaxWBoundary() {
        return this.maxWBoundary;
    }

    public final void setMaxWBoundary(float f) {
        this.maxWBoundary = f;
    }

    public final int getTouchDownId() {
        return this.touchDownId;
    }

    public final void setTouchDownId(int n) {
        this.touchDownId = n;
    }

    public final void initConfig(@NotNull Context context, @NotNull BasisHelper helper) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        this.helper = helper;
        this.scaledTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    public final float safeX(float x) {
        return FxExtKt.coerceInFx(x, this.minWBoundary, this.maxWBoundary);
    }

    public final float safeY(float y) {
        return FxExtKt.coerceInFx(y, this.minHBoundary, this.maxHBoundary);
    }

    public final float safeX(float x, @NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        return FxExtKt.coerceInFx(x + ev.getX() - this.downTouchX, this.minWBoundary, this.maxWBoundary);
    }

    public final float safeY(float y, @NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        return FxExtKt.coerceInFx(y + ev.getY() - this.downTouchY, this.minHBoundary, this.maxHBoundary);
    }

    public final boolean hasMainPointerId() {
        return this.touchDownId != -1;
    }

    public final boolean isCurrentPointerId(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        if (this.touchDownId == -1) {
            return false;
        }
        return FxExtKt.getPointerId(ev) == this.touchDownId;
    }

    public final void initTouchDown(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        this.touchDownId = FxExtKt.getPointerId(ev);
        this.downTouchX = ev.getX();
        this.downTouchY = ev.getY();
        BasisHelper basisHelper = this.helper;
        if (basisHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
            throw null;
        }
        FxLog fxLog = basisHelper.fxLog;
        if (fxLog != null) {
            fxLog.d(Intrinsics.stringPlus((String)"fxView---newTouchDown:", (Object)this.touchDownId));
        }
    }

    public final boolean updateWidgetSize(@NotNull ViewGroup view) {
        ViewGroup viewGroup;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ViewParent viewParent = view.getParent();
        ViewGroup viewGroup2 = viewGroup = viewParent instanceof ViewGroup ? (ViewGroup)viewParent : null;
        if (viewGroup == null) {
            return false;
        }
        ViewGroup parentGroup = viewGroup;
        return this.updateWidgetSize(parentGroup.getWidth(), parentGroup.getHeight(), view);
    }

    public final boolean updateWidgetSize(int parentW, int parentH, @NotNull ViewGroup view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        float parentWidth = parentW - view.getWidth();
        float parentHeight = parentH - view.getHeight();
        if (!(this.mParentHeight == parentHeight) || !(this.mParentWidth == parentWidth)) {
            BasisHelper basisHelper = this.helper;
            if (basisHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
                throw null;
            }
            FxLog fxLog = basisHelper.fxLog;
            if (fxLog != null) {
                fxLog.d("fxView->updateContainerSize: oldW-(" + this.mParentWidth + "),oldH-(" + this.mParentHeight + "),newW-(" + parentWidth + "),newH-(" + parentHeight + ')');
            }
            this.mParentWidth = parentWidth;
            this.mParentHeight = parentHeight;
            this.updateBoundary(false);
            return true;
        }
        return false;
    }

    public final boolean isNearestLeft(float x) {
        float middle = this.mParentWidth / (float)2;
        return x < middle;
    }

    public final boolean isNearestTop(float y) {
        float middle = this.mParentHeight / (float)2;
        return y < middle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean checkInterceptedEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isCurrentPointerId(event)) {
            return false;
        }
        float f = event.getX() - this.downTouchX;
        boolean bl = false;
        if (Math.abs(f) >= (float)this.scaledTouchSlop) return true;
        f = event.getY() - this.downTouchY;
        bl = false;
        if (!(Math.abs(f) >= (float)this.scaledTouchSlop)) return false;
        return true;
    }

    @Nullable
    public final Pair<Float, Float> getAdsorbDirectionLocation(float x, float y) {
        Pair pair;
        BasisHelper basisHelper = this.helper;
        if (basisHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
            throw null;
        }
        if (basisHelper.enableEdgeAdsorption) {
            basisHelper = this.helper;
            if (basisHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
                throw null;
            }
            if (basisHelper.adsorbDirection == FxAdsorbDirection.LEFT_OR_RIGHT) {
                float moveX = this.isNearestLeft(x) ? this.minWBoundary : this.maxWBoundary;
                float moveY = this.safeY(y);
                pair = TuplesKt.to((Object)Float.valueOf(moveX), (Object)Float.valueOf(moveY));
            } else {
                float moveX = this.safeX(x);
                float moveY = this.isNearestTop(y) ? this.minHBoundary : this.maxHBoundary;
                pair = TuplesKt.to((Object)Float.valueOf(moveX), (Object)Float.valueOf(moveY));
            }
        } else {
            basisHelper = this.helper;
            if (basisHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
                throw null;
            }
            pair = basisHelper.enableEdgeRebound ? TuplesKt.to((Object)Float.valueOf(this.safeX(x)), (Object)Float.valueOf(this.safeY(y))) : (Pair)null;
        }
        return pair;
    }

    public final void updateBoundary(boolean isDownTouchInit) {
        BasisHelper basisHelper = this.helper;
        if (basisHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
            throw null;
        }
        if (basisHelper.enableEdgeRebound) {
            BasisHelper basisHelper2;
            float f;
            float marginLef;
            float f2;
            float marginBto;
            float f3;
            float marginTop;
            float f4;
            float edgeOffset;
            float f5;
            if (isDownTouchInit) {
                f5 = 0.0f;
            } else {
                BasisHelper basisHelper3 = this.helper;
                if (basisHelper3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
                    throw null;
                }
                f5 = edgeOffset = basisHelper3.edgeOffset;
            }
            if (isDownTouchInit) {
                f4 = 0.0f;
            } else {
                BasisHelper basisHelper4 = this.helper;
                if (basisHelper4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
                    throw null;
                }
                f4 = marginTop = basisHelper4.fxBorderMargin.getT() + edgeOffset;
            }
            if (isDownTouchInit) {
                f3 = 0.0f;
            } else {
                BasisHelper basisHelper5 = this.helper;
                if (basisHelper5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
                    throw null;
                }
                f3 = marginBto = basisHelper5.fxBorderMargin.getB() + edgeOffset;
            }
            if (isDownTouchInit) {
                f2 = 0.0f;
            } else {
                BasisHelper basisHelper6 = this.helper;
                if (basisHelper6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
                    throw null;
                }
                f2 = marginLef = basisHelper6.fxBorderMargin.getL() + edgeOffset;
            }
            if (isDownTouchInit) {
                f = 0.0f;
            } else {
                basisHelper2 = this.helper;
                if (basisHelper2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
                    throw null;
                }
                f = basisHelper2.fxBorderMargin.getR() + edgeOffset;
            }
            float marginRig = f;
            this.minWBoundary = marginLef;
            this.maxWBoundary = this.mParentWidth - marginRig;
            basisHelper2 = this.helper;
            if (basisHelper2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
                throw null;
            }
            this.minHBoundary = (float)basisHelper2.statsBarHeight + marginTop;
            basisHelper2 = this.helper;
            if (basisHelper2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
                throw null;
            }
            this.maxHBoundary = this.mParentHeight - (float)basisHelper2.navigationBarHeight - marginBto;
        } else {
            basisHelper = this.helper;
            if (basisHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
                throw null;
            }
            this.minWBoundary = basisHelper.fxBorderMargin.getL();
            basisHelper = this.helper;
            if (basisHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
                throw null;
            }
            this.maxWBoundary = this.mParentWidth - basisHelper.fxBorderMargin.getR();
            basisHelper = this.helper;
            if (basisHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
                throw null;
            }
            basisHelper = this.helper;
            if (basisHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
                throw null;
            }
            this.minHBoundary = (float)basisHelper.statsBarHeight + basisHelper.fxBorderMargin.getT();
            basisHelper = this.helper;
            if (basisHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
                throw null;
            }
            basisHelper = this.helper;
            if (basisHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
                throw null;
            }
            this.maxHBoundary = this.mParentHeight - (float)basisHelper.navigationBarHeight - basisHelper.fxBorderMargin.getB();
        }
    }
}

