/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.CollectionPathBase;
import com.querydsl.core.types.dsl.ComparableEntityPath;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringExpression;
import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import io.github.perplexhub.rsql.RSQLException;
import io.github.perplexhub.rsql.RSQLOperators;
import io.github.perplexhub.rsql.RSQLQueryDslContext;
import io.github.perplexhub.rsql.RSQLQueryDslSupport;
import io.github.perplexhub.rsql.RSQLVisitorBase;
import io.github.perplexhub.rsql.UnknownPropertyException;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSQLQueryDslPredicateConverter
extends RSQLVisitorBase<BooleanExpression, Path> {
    private static final Logger log = LoggerFactory.getLogger(RSQLQueryDslPredicateConverter.class);
    private final Map<String, String> propertyPathMapper;

    public RSQLQueryDslPredicateConverter(Map<String, String> propertyPathMapper) {
        this.propertyPathMapper = propertyPathMapper != null ? propertyPathMapper : Collections.emptyMap();
    }

    RSQLQueryDslContext findPropertyPath(String propertyPath, Path entityClass) {
        String[] properties;
        Path path = entityClass;
        ManagedType classMetadata = this.getManagedType(path.getType());
        Attribute attribute = null;
        Object mappedPropertyPath = "";
        for (String property : properties = propertyPath.split("\\.")) {
            String mappedProperty = this.mapProperty(property, path.getType());
            if (!mappedProperty.equals(property)) {
                RSQLQueryDslContext holder = this.findPropertyPath(mappedProperty, path);
                attribute = holder.getAttribute();
                mappedPropertyPath = (String)mappedPropertyPath + (((String)mappedPropertyPath).length() > 0 ? "." : "") + holder.getPropertyPath();
                continue;
            }
            if (!this.hasPropertyName(mappedProperty, classMetadata)) {
                throw new UnknownPropertyException(mappedProperty, classMetadata.getJavaType());
            }
            if (this.isAssociationType(mappedProperty, classMetadata)) {
                Class associationType = this.findPropertyType(mappedProperty, classMetadata);
                String previousClass = classMetadata.getJavaType().getName();
                classMetadata = this.getManagedType(associationType);
                log.debug("Create a join between [{}] and [{}].", (Object)previousClass, (Object)classMetadata.getJavaType().getName());
                path = (Path)path.getClass().getDeclaredField(mappedProperty).get(path);
                if (path instanceof CollectionPathBase) {
                    path = (Path)((CollectionPathBase)path).any();
                }
                mappedPropertyPath = "";
                continue;
            }
            if (this.isElementCollectionType(mappedProperty, classMetadata)) {
                String previousClass = classMetadata.getJavaType().getName();
                attribute = classMetadata.getAttribute(property);
                if (previousClass.equals((classMetadata = this.getManagedElementCollectionType(mappedProperty, classMetadata)).getJavaType().getName())) {
                    if (!((path = (Path)path.getClass().getDeclaredField(mappedProperty).get(path)) instanceof CollectionPathBase)) continue;
                    path = (Path)((CollectionPathBase)path).any();
                    continue;
                }
                log.debug("Create an element collection join between [{}] and [{}].", (Object)previousClass, (Object)classMetadata.getJavaType().getName());
                path = (Path)path.getClass().getDeclaredField(mappedProperty).get(path);
                if (path instanceof CollectionPathBase) {
                    path = (Path)((CollectionPathBase)path).any();
                }
                mappedPropertyPath = "";
                continue;
            }
            log.debug("Create property path for type [{}] property [{}].", (Object)classMetadata.getJavaType().getName(), (Object)mappedProperty);
            if (this.isEmbeddedType(mappedProperty, classMetadata)) {
                Class embeddedType = this.findPropertyType(mappedProperty, classMetadata);
                classMetadata = this.getManagedType(embeddedType);
            } else {
                attribute = classMetadata.getAttribute(property);
            }
            mappedPropertyPath = (String)mappedPropertyPath + (((String)mappedPropertyPath).length() > 0 ? "." : "") + mappedProperty;
        }
        if (attribute != null) {
            this.accessControl(path.getType(), attribute.getName());
        }
        return RSQLQueryDslContext.of((String)mappedPropertyPath, attribute, path);
    }

    public BooleanExpression visit(ComparisonNode node, Path path) {
        log.debug("visit(node:{},path:{})", (Object)node, (Object)path);
        ComparisonOperator op = node.getOperator();
        RSQLQueryDslContext holder = this.findPropertyPath(this.mapPropertyPath(node.getSelector()), path);
        Attribute<?, ?> attribute = holder.getAttribute();
        String property = holder.getPropertyPath();
        Path<?> entityClass = holder.getEntityClass();
        Class type = attribute.getJavaType();
        if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION) {
            type = this.getElementCollectionGenericType(type, attribute);
        }
        if (type.isPrimitive()) {
            type = (Class)primitiveToWrapper.get(type);
        } else if (RSQLQueryDslSupport.getValueTypeMap().containsKey(type)) {
            type = (Class)RSQLQueryDslSupport.getValueTypeMap().get(type);
        }
        if (node.getArguments().size() > 1) {
            ComparableEntityPath comparableEntityPath;
            ArrayList<Object> listObject = new ArrayList<Object>();
            for (String argument : node.getArguments()) {
                listObject.add(this.convert(argument, type));
            }
            if (op.equals((Object)RSQLOperators.IN)) {
                return Expressions.path((Class)type, entityClass, (String)property).in(listObject);
            }
            if (op.equals((Object)RSQLOperators.NOT_IN)) {
                return Expressions.path((Class)type, entityClass, (String)property).notIn(listObject);
            }
            if (op.equals((Object)RSQLOperators.BETWEEN) && listObject.size() == 2 && listObject.get(0) instanceof Comparable && listObject.get(1) instanceof Comparable) {
                comparableEntityPath = this.getComparableEntityPath(type, entityClass, property);
                return comparableEntityPath.between((Comparable)listObject.get(0), (Comparable)listObject.get(1));
            }
            if (op.equals((Object)RSQLOperators.NOT_BETWEEN) && listObject.size() == 2 && listObject.get(0) instanceof Comparable && listObject.get(1) instanceof Comparable) {
                comparableEntityPath = this.getComparableEntityPath(type, entityClass, property);
                return comparableEntityPath.notBetween((Comparable)listObject.get(0), (Comparable)listObject.get(1));
            }
        } else {
            if (op.equals((Object)RSQLOperators.IS_NULL)) {
                return Expressions.path((Class)type, entityClass, (String)property).isNull();
            }
            if (op.equals((Object)RSQLOperators.NOT_NULL)) {
                return Expressions.path((Class)type, entityClass, (String)property).isNotNull();
            }
            Object argument = this.convert((String)node.getArguments().get(0), type);
            if (op.equals((Object)RSQLOperators.IN)) {
                return Expressions.path((Class)type, entityClass, (String)property).in(new Object[]{argument});
            }
            if (op.equals((Object)RSQLOperators.NOT_IN)) {
                return Expressions.path((Class)type, entityClass, (String)property).notIn(new Object[]{argument});
            }
            if (op.equals((Object)RSQLOperators.LIKE)) {
                StringExpression stringExpression = this.getStringExpression(entityClass, property, this.isEnumPath(entityClass, property));
                return stringExpression.like("%" + argument.toString() + "%");
            }
            if (op.equals((Object)RSQLOperators.NOT_LIKE)) {
                StringExpression stringExpression = this.getStringExpression(entityClass, property, this.isEnumPath(entityClass, property));
                return stringExpression.like("%" + argument.toString() + "%").not();
            }
            if (op.equals((Object)RSQLOperators.IGNORE_CASE)) {
                StringExpression stringExpression = this.getStringExpression(entityClass, property, this.isEnumPath(entityClass, property));
                return stringExpression.equalsIgnoreCase(argument.toString());
            }
            if (op.equals((Object)RSQLOperators.IGNORE_CASE_LIKE)) {
                StringExpression stringExpression = this.getStringExpression(entityClass, property, this.isEnumPath(entityClass, property));
                return stringExpression.likeIgnoreCase("%" + argument.toString() + "%");
            }
            if (op.equals((Object)RSQLOperators.IGNORE_CASE_NOT_LIKE)) {
                StringExpression stringExpression = this.getStringExpression(entityClass, property, this.isEnumPath(entityClass, property));
                return stringExpression.likeIgnoreCase("%" + argument.toString() + "%").not();
            }
            if (op.equals((Object)RSQLOperators.EQUAL)) {
                if (type.equals(String.class)) {
                    StringExpression stringExpression = this.getStringExpression(entityClass, property, this.isEnumPath(entityClass, property));
                    if (argument.toString().contains("*") && argument.toString().contains("^")) {
                        return stringExpression.likeIgnoreCase(argument.toString().replace("*", "%").replace("^", ""));
                    }
                    if (argument.toString().contains("*")) {
                        return stringExpression.like(argument.toString().replace("*", "%"));
                    }
                    if (argument.toString().contains("^")) {
                        return stringExpression.equalsIgnoreCase(argument.toString().replace("^", ""));
                    }
                    return stringExpression.eq((Object)argument.toString());
                }
                if (argument == null) {
                    return Expressions.path((Class)type, entityClass, (String)property).isNull();
                }
                return Expressions.path((Class)type, entityClass, (String)property).eq(argument);
            }
            if (op.equals((Object)RSQLOperators.NOT_EQUAL)) {
                if (type.equals(String.class)) {
                    StringExpression stringExpression = this.getStringExpression(entityClass, property, this.isEnumPath(entityClass, property));
                    if (argument.toString().contains("*") && argument.toString().contains("^")) {
                        return stringExpression.likeIgnoreCase(argument.toString().replace("*", "%").replace("^", "")).not();
                    }
                    if (argument.toString().contains("*")) {
                        return stringExpression.like(argument.toString().replace("*", "%")).not();
                    }
                    if (argument.toString().contains("^")) {
                        return stringExpression.equalsIgnoreCase(argument.toString().replace("^", "")).not();
                    }
                    return stringExpression.eq((Object)argument.toString()).not();
                }
                if (argument == null) {
                    return Expressions.path((Class)type, entityClass, (String)property).isNotNull();
                }
                return Expressions.path((Class)type, entityClass, (String)property).eq(argument).not();
            }
            if (!Comparable.class.isAssignableFrom(type)) {
                log.error("Operator {} can be used only for Comparables", (Object)op);
                throw new RSQLException(String.format("Operator %s can be used only for Comparables", op));
            }
            Comparable comparable = (Comparable)argument;
            ComparableEntityPath comparableEntityPath = this.getComparableEntityPath(type, entityClass, property);
            if (op.equals((Object)RSQLOperators.GREATER_THAN)) {
                return comparableEntityPath.gt(comparable);
            }
            if (op.equals((Object)RSQLOperators.GREATER_THAN_OR_EQUAL)) {
                return comparableEntityPath.goe(comparable);
            }
            if (op.equals((Object)RSQLOperators.LESS_THAN)) {
                return comparableEntityPath.lt(comparable);
            }
            if (op.equals((Object)RSQLOperators.LESS_THAN_OR_EQUAL)) {
                return comparableEntityPath.loe(comparable);
            }
        }
        log.error("Unknown operator: {}", (Object)op);
        throw new RSQLException("Unknown operator: " + op);
    }

    public BooleanExpression visit(AndNode node, Path entityClass) {
        log.debug("visit(node:{},param:{})", (Object)node, (Object)entityClass);
        return (BooleanExpression)node.getChildren().stream().map(n -> (BooleanExpression)n.accept((RSQLVisitor)this, (Object)entityClass)).collect(Collectors.reducing(BooleanExpression::and)).get();
    }

    public BooleanExpression visit(OrNode node, Path entityClass) {
        log.debug("visit(node:{},param:{})", (Object)node, (Object)entityClass);
        return (BooleanExpression)node.getChildren().stream().map(n -> (BooleanExpression)n.accept((RSQLVisitor)this, (Object)entityClass)).collect(Collectors.reducing(BooleanExpression::or)).get();
    }

    ComparableEntityPath getComparableEntityPath(Class type, Path entityClass, String property) {
        return Expressions.comparableEntityPath((Class)type, (Path)entityClass, (String)property);
    }

    StringExpression getStringExpression(Path entityClass, String property, boolean isEnumPath) {
        if (entityClass instanceof StringExpression && (property == null || property.isEmpty())) {
            return (StringExpression)entityClass;
        }
        if (isEnumPath) {
            return ((EnumPath)entityClass.getClass().getDeclaredField(property).get(entityClass)).stringValue();
        }
        return Expressions.stringPath((Path)entityClass, (String)property);
    }

    boolean isEnumPath(Path entityClass, String property) {
        try {
            return entityClass.getClass().getDeclaredField(property).get(entityClass) instanceof EnumPath;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Map<String, String> getPropertyPathMapper() {
        return this.propertyPathMapper;
    }
}

