/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.BooleanExpression;
import cz.jirutka.rsql.parser.RSQLParser;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import io.github.perplexhub.rsql.RSQLJPASupport;
import io.github.perplexhub.rsql.RSQLOperators;
import io.github.perplexhub.rsql.RSQLQueryDslPredicateConverter;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RSQLQueryDslSupport
extends RSQLJPASupport {
    private static final Logger log = LoggerFactory.getLogger(RSQLQueryDslSupport.class);

    public RSQLQueryDslSupport() {
    }

    public RSQLQueryDslSupport(Map<String, EntityManager> entityManagerMap) {
        super(entityManagerMap);
    }

    public static BooleanExpression toPredicate(String rsqlQuery, Path qClazz) {
        return RSQLQueryDslSupport.toPredicate(rsqlQuery, qClazz, null);
    }

    public static BooleanExpression toPredicate(String rsqlQuery, Path qClazz, Map<String, String> propertyPathMapper) {
        log.debug("toPredicate({},qClazz:{},propertyPathMapper:{})", (Object)rsqlQuery, (Object)qClazz);
        if (StringUtils.hasText((String)rsqlQuery)) {
            return (BooleanExpression)new RSQLParser(RSQLOperators.supportedOperators()).parse(rsqlQuery).accept((RSQLVisitor)new RSQLQueryDslPredicateConverter(propertyPathMapper), (Object)qClazz);
        }
        return null;
    }

    protected String getVersion() {
        try {
            Properties prop = new Properties();
            prop.load(((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/io.github.perplexhub/rsql-querydsl/pom.properties"));
            String version = prop.getProperty("version");
            return StringUtils.hasText((String)version) ? "[" + version + "] " : "";
        }
        catch (Exception e) {
            return "";
        }
    }
}

