/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import io.github.perplexhub.rsql.ConversionException;
import io.github.perplexhub.rsql.PathUtils;
import io.github.perplexhub.rsql.PropertyBlacklistedException;
import io.github.perplexhub.rsql.PropertyNotWhitelistedException;
import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.PluralAttribute;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.util.StringUtils;

public abstract class RSQLVisitorBase<R, A>
implements RSQLVisitor<R, A> {
    private static final Logger log = LoggerFactory.getLogger(RSQLVisitorBase.class);
    protected static volatile Map<Class, ManagedType> managedTypeMap;
    protected static volatile Map<String, EntityManager> entityManagerMap;
    protected static volatile Map<EntityManager, Database> entityManagerDatabase;
    protected static final Map<Class, Class> primitiveToWrapper;
    protected static volatile Map<Class<?>, Map<String, String>> propertyRemapping;
    protected static volatile Map<Class<?>, List<String>> globalPropertyWhitelist;
    protected static volatile Map<Class<?>, List<String>> globalPropertyBlacklist;
    protected static volatile ConfigurableConversionService defaultConversionService;
    protected Map<Class<?>, List<String>> propertyWhitelist;
    protected Map<Class<?>, List<String>> propertyBlacklist;

    protected Map<Class, ManagedType> getManagedTypeMap() {
        return managedTypeMap != null ? managedTypeMap : Collections.emptyMap();
    }

    public static Map<String, EntityManager> getEntityManagerMap() {
        return entityManagerMap != null ? entityManagerMap : Collections.emptyMap();
    }

    public static Database getDatabase(EntityManager entityManager) {
        return entityManagerDatabase.get(entityManager);
    }

    protected abstract Map<String, String> getPropertyPathMapper();

    public Map<Class<?>, Map<String, String>> getPropertyRemapping() {
        return propertyRemapping != null ? propertyRemapping : Collections.emptyMap();
    }

    protected Object convert(String source, Class targetType) {
        log.debug("convert(source:{},targetType:{})", (Object)source, (Object)targetType);
        Object object = null;
        try {
            if (defaultConversionService.canConvert(String.class, targetType)) {
                object = defaultConversionService.convert((Object)source, targetType);
            } else if (targetType.equals(String.class)) {
                object = source;
            } else if (targetType.equals(UUID.class)) {
                object = UUID.fromString(source);
            } else if (targetType.equals(java.util.Date.class) || targetType.equals(Date.class)) {
                object = Date.valueOf(LocalDate.parse(source));
            } else if (targetType.equals(LocalDate.class)) {
                object = LocalDate.parse(source);
            } else if (targetType.equals(LocalDateTime.class)) {
                object = LocalDateTime.parse(source);
            } else if (targetType.equals(OffsetDateTime.class)) {
                object = OffsetDateTime.parse(source);
            } else if (targetType.equals(ZonedDateTime.class)) {
                object = ZonedDateTime.parse(source);
            } else if (targetType.equals(Character.class)) {
                object = !StringUtils.hasText((String)source) ? Character.valueOf(source.charAt(0)) : null;
            } else if (targetType.equals(Boolean.TYPE) || targetType.equals(Boolean.class)) {
                object = Boolean.valueOf(source);
            } else if (targetType.isEnum()) {
                object = Enum.valueOf(targetType, source);
            } else if (targetType.equals(Instant.class)) {
                object = Instant.parse(source);
            } else {
                Constructor cons = targetType.getConstructor(String.class);
                object = cons.newInstance(source);
            }
            return object;
        }
        catch (Exception ex) {
            if (targetType.equals(LocalDateTime.class)) {
                try {
                    return ((LocalDate)this.convert(source, LocalDate.class)).atStartOfDay();
                }
                catch (Exception e) {
                    ex.addSuppressed(e);
                }
            }
            log.debug("Parsing [{}] with [{}] causing [{}], add your parser via RSQLSupport.addConverter(Type.class, Type::valueOf)", new Object[]{source, targetType.getName(), ex.getMessage()});
            throw new ConversionException(String.format("Failed to convert %s to %s type", source, targetType.getName()), ex);
        }
    }

    protected void accessControl(Class type, String name) {
        log.debug("accessControl(type:{},name:{})", (Object)type, (Object)name);
        if (this.propertyWhitelist != null && this.propertyWhitelist.containsKey(type)) {
            if (!this.propertyWhitelist.get(type).contains(name)) {
                String msg = "Property " + type.getName() + "." + name + " is not on whitelist";
                log.debug(msg);
                throw new PropertyNotWhitelistedException(name, type, msg);
            }
        } else if (globalPropertyWhitelist != null && globalPropertyWhitelist.containsKey(type) && !globalPropertyWhitelist.get(type).contains(name)) {
            String msg = "Property " + type.getName() + "." + name + " is not on global whitelist";
            log.debug(msg);
            throw new PropertyNotWhitelistedException(name, type, msg);
        }
        if (this.propertyBlacklist != null && this.propertyBlacklist.containsKey(type)) {
            if (this.propertyBlacklist.get(type).contains(name)) {
                String msg = "Property " + type.getName() + "." + name + " is on blacklist";
                log.debug(msg);
                throw new PropertyBlacklistedException(name, type, msg);
            }
        } else if (globalPropertyBlacklist != null && globalPropertyBlacklist.containsKey(type) && globalPropertyBlacklist.get(type).contains(name)) {
            String msg = "Property " + type.getName() + "." + name + " is on global blacklist";
            log.debug(msg);
            throw new PropertyBlacklistedException(name, type, msg);
        }
    }

    protected String mapPropertyPath(String propertyPath) {
        return PathUtils.findMappingOnWhole(propertyPath, this.getPropertyPathMapper()).orElse(propertyPath);
    }

    protected String mapProperty(String selector, Class<?> entityClass) {
        if (!this.getPropertyRemapping().isEmpty()) {
            String property;
            Map<String, String> map = this.getPropertyRemapping().get(entityClass);
            String string = property = map != null ? map.get(selector) : null;
            if (StringUtils.hasText((String)property)) {
                log.debug("Map property [{}] to [{}] for [{}]", new Object[]{selector, property, entityClass});
                return property;
            }
        }
        return selector;
    }

    protected <T> Class<?> findPropertyType(String property, ManagedType<T> classMetadata) {
        Class propertyType = null;
        propertyType = classMetadata.getAttribute(property).isCollection() ? ((PluralAttribute)classMetadata.getAttribute(property)).getBindableJavaType() : classMetadata.getAttribute(property).getJavaType();
        return propertyType;
    }

    protected <T> ManagedType<T> getManagedType(Class<T> cls) {
        Exception ex = null;
        if (RSQLVisitorBase.getEntityManagerMap().size() > 0) {
            ManagedType managedType = this.getManagedTypeMap().get(cls);
            if (managedType != null) {
                log.debug("Found managed type [{}] in cache", cls);
                return managedType;
            }
            for (Map.Entry<String, EntityManager> entityManagerEntry : RSQLVisitorBase.getEntityManagerMap().entrySet()) {
                try {
                    managedType = entityManagerEntry.getValue().getMetamodel().managedType(cls);
                    this.getManagedTypeMap().put(cls, managedType);
                    log.debug("Found managed type [{}] in EntityManager [{}]", cls, (Object)entityManagerEntry.getKey());
                    return managedType;
                }
                catch (Exception e) {
                    if (e != null) {
                        ex = e;
                    }
                    log.debug("[{}] not found in EntityManager [{}] due to [{}]", new Object[]{cls, entityManagerEntry.getKey(), e == null ? "-" : e.getMessage()});
                }
            }
        }
        log.error("[{}] not found in EntityManager{}: [{}]", new Object[]{cls, RSQLVisitorBase.getEntityManagerMap().size() > 1 ? "s" : "", StringUtils.collectionToCommaDelimitedString(RSQLVisitorBase.getEntityManagerMap().keySet())});
        throw ex != null ? ex : new IllegalStateException("No entity manager bean found in application context");
    }

    protected <T> ManagedType<T> getManagedElementCollectionType(String mappedProperty, ManagedType<T> classMetadata) {
        try {
            Class<?> cls = this.findPropertyType(mappedProperty, classMetadata);
            if (!(cls.isPrimitive() || primitiveToWrapper.containsValue(cls) || cls.equals(String.class) || RSQLVisitorBase.getEntityManagerMap().size() <= 0)) {
                ManagedType managedType = this.getManagedTypeMap().get(cls);
                if (managedType != null) {
                    log.debug("Found managed type [{}] in cache", cls);
                    return managedType;
                }
                Iterator<Map.Entry<String, EntityManager>> iterator = RSQLVisitorBase.getEntityManagerMap().entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry<String, EntityManager> entityManagerEntry = iterator.next();
                    managedType = entityManagerEntry.getValue().getMetamodel().managedType(cls);
                    this.getManagedTypeMap().put(cls, managedType);
                    log.info("Found managed type [{}] in EntityManager [{}]", cls, (Object)entityManagerEntry.getKey());
                    return managedType;
                }
            }
        }
        catch (Exception e) {
            log.warn("Unable to get the managed type of [{}]", (Object)mappedProperty, (Object)e);
        }
        return classMetadata;
    }

    protected <T> boolean hasPropertyName(String property, ManagedType<T> classMetadata) {
        try {
            return classMetadata.getAttribute(property) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected static Class getElementCollectionGenericType(Class type, Attribute attribute) {
        Field field;
        Type genericType;
        Member member = attribute.getJavaMember();
        if (member instanceof Field && (genericType = (field = (Field)member).getGenericType()) instanceof ParameterizedType) {
            ParameterizedType rawType = (ParameterizedType)genericType;
            Class<?> elementCollectionClass = Class.forName(rawType.getActualTypeArguments()[0].getTypeName());
            log.info("Map element collection generic type [{}] to [{}]", (Object)attribute.getName(), elementCollectionClass);
            return elementCollectionClass;
        }
        return type;
    }

    protected <T> boolean isEmbeddedType(String property, ManagedType<T> classMetadata) {
        return classMetadata.getAttribute(property).getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED;
    }

    protected <T> boolean isElementCollectionType(String property, ManagedType<T> classMetadata) {
        return classMetadata.getAttribute(property).getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
    }

    protected <T> boolean isAssociationType(String property, ManagedType<T> classMetadata) {
        return classMetadata.getAttribute(property).isAssociation();
    }

    protected <T> boolean isOneToOneAssociationType(String property, ManagedType<T> classMetadata) {
        return classMetadata.getAttribute(property).isAssociation() && Attribute.PersistentAttributeType.ONE_TO_ONE == classMetadata.getAttribute(property).getPersistentAttributeType();
    }

    protected <T> boolean isOneToManyAssociationType(String property, ManagedType<T> classMetadata) {
        return classMetadata.getAttribute(property).isAssociation() && Attribute.PersistentAttributeType.ONE_TO_MANY == classMetadata.getAttribute(property).getPersistentAttributeType();
    }

    protected <T> boolean isManyToManyAssociationType(String property, ManagedType<T> classMetadata) {
        return classMetadata.getAttribute(property).isAssociation() && Attribute.PersistentAttributeType.MANY_TO_MANY == classMetadata.getAttribute(property).getPersistentAttributeType();
    }

    public static void setManagedTypeMap(Map<Class, ManagedType> managedTypeMap) {
        RSQLVisitorBase.managedTypeMap = managedTypeMap;
    }

    public static void setEntityManagerMap(Map<String, EntityManager> entityManagerMap) {
        RSQLVisitorBase.entityManagerMap = entityManagerMap;
    }

    public static void setEntityManagerDatabase(Map<EntityManager, Database> entityManagerDatabase) {
        RSQLVisitorBase.entityManagerDatabase = entityManagerDatabase;
    }

    public static Map<EntityManager, Database> getEntityManagerDatabase() {
        return entityManagerDatabase;
    }

    public static void setPropertyRemapping(Map<Class<?>, Map<String, String>> propertyRemapping) {
        RSQLVisitorBase.propertyRemapping = propertyRemapping;
    }

    public static void setGlobalPropertyWhitelist(Map<Class<?>, List<String>> globalPropertyWhitelist) {
        RSQLVisitorBase.globalPropertyWhitelist = globalPropertyWhitelist;
    }

    public static void setGlobalPropertyBlacklist(Map<Class<?>, List<String>> globalPropertyBlacklist) {
        RSQLVisitorBase.globalPropertyBlacklist = globalPropertyBlacklist;
    }

    public static void setDefaultConversionService(ConfigurableConversionService defaultConversionService) {
        RSQLVisitorBase.defaultConversionService = defaultConversionService;
    }

    public void setPropertyWhitelist(Map<Class<?>, List<String>> propertyWhitelist) {
        this.propertyWhitelist = propertyWhitelist;
    }

    public void setPropertyBlacklist(Map<Class<?>, List<String>> propertyBlacklist) {
        this.propertyBlacklist = propertyBlacklist;
    }

    static {
        entityManagerDatabase = Map.of();
        HashMap<Class<Object>, Class<Void>> map = new HashMap<Class<Object>, Class<Void>>();
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Character.TYPE, Character.class);
        map.put(Double.TYPE, Double.class);
        map.put(Float.TYPE, Float.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Short.TYPE, Short.class);
        map.put(Void.TYPE, Void.class);
        primitiveToWrapper = Collections.unmodifiableMap(map);
    }
}

