/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import cz.jirutka.rsql.parser.RSQLParser;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import io.github.perplexhub.rsql.RSQLComplexConverter;
import io.github.perplexhub.rsql.RSQLOperators;
import io.github.perplexhub.rsql.RSQLSimpleConverter;
import io.github.perplexhub.rsql.RSQLVisitorBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.ManagedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class RSQLCommonSupport {
    private static final Logger log = LoggerFactory.getLogger(RSQLCommonSupport.class);
    private static final Map<String, EntityManager> entityManagerMap = new ConcurrentHashMap<String, EntityManager>();
    private static final Map<Class, ManagedType> managedTypeMap = new ConcurrentHashMap<Class, ManagedType>();
    private static final Map<Class<?>, Map<String, String>> propertyRemapping = new ConcurrentHashMap();
    private static final Map<Class, Class> valueTypeMap = new ConcurrentHashMap<Class, Class>();
    private static final Map<Class<?>, List<String>> propertyWhitelist = new ConcurrentHashMap();
    private static final Map<Class<?>, List<String>> propertyBlacklist = new ConcurrentHashMap();
    private static final ConfigurableConversionService conversionService = new DefaultConversionService();

    public RSQLCommonSupport() {
        this.init();
    }

    public RSQLCommonSupport(Map<String, EntityManager> entityManagerMap) {
        if (entityManagerMap != null) {
            RSQLCommonSupport.entityManagerMap.putAll(entityManagerMap);
            log.info("{} EntityManager bean{} found: {}", new Object[]{entityManagerMap.size(), entityManagerMap.size() > 1 ? "s are" : " is", entityManagerMap});
        } else {
            log.warn("No EntityManager beans are found");
        }
        this.init();
    }

    protected void init() {
        conversionService.removeConvertible(Object.class, Object.class);
        RSQLVisitorBase.setEntityManagerMap(RSQLCommonSupport.getEntityManagerMap());
        RSQLVisitorBase.setManagedTypeMap(RSQLCommonSupport.getManagedTypeMap());
        RSQLVisitorBase.setPropertyRemapping(RSQLCommonSupport.getPropertyRemapping());
        RSQLVisitorBase.setGlobalPropertyWhitelist(RSQLCommonSupport.getPropertyWhitelist());
        RSQLVisitorBase.setGlobalPropertyBlacklist(RSQLCommonSupport.getPropertyBlacklist());
        RSQLVisitorBase.setDefaultConversionService(RSQLCommonSupport.getConversionService());
        log.info("RSQLCommonSupport {} is initialized", (Object)this.getVersion());
    }

    public static void addConverter(Converter<?, ?> converter) {
        conversionService.addConverter(converter);
    }

    public static <T> void addConverter(Class<T> targetType, Converter<String, ? extends T> converter) {
        log.info("Adding entity converter for {}", targetType);
        conversionService.addConverter(String.class, targetType, converter);
    }

    public static <T> void removeConverter(Class<T> targetType) {
        log.info("Removing entity converter for {}", targetType);
        conversionService.removeConvertible(String.class, targetType);
    }

    public static void addPropertyWhitelist(Class<?> entityClass, List<String> propertyList) {
        propertyWhitelist.computeIfAbsent(entityClass, entityClazz -> new ArrayList()).addAll(propertyList);
    }

    public static void addPropertyWhitelist(Class<?> entityClass, String property) {
        propertyWhitelist.computeIfAbsent(entityClass, entityClazz -> new ArrayList()).add(property);
    }

    public static void addPropertyBlacklist(Class<?> entityClass, List<String> propertyList) {
        propertyBlacklist.computeIfAbsent(entityClass, entityClazz -> new ArrayList()).addAll(propertyList);
    }

    public static void addPropertyBlacklist(Class<?> entityClass, String property) {
        propertyBlacklist.computeIfAbsent(entityClass, entityClazz -> new ArrayList()).add(property);
    }

    public static MultiValueMap<String, String> toMultiValueMap(String rsqlQuery) {
        log.debug("toMultiValueMap(rsqlQuery:{})", (Object)rsqlQuery);
        MultiValueMap map = CollectionUtils.toMultiValueMap(new HashMap());
        if (StringUtils.hasText((String)rsqlQuery)) {
            new RSQLParser(RSQLOperators.supportedOperators()).parse(rsqlQuery).accept((RSQLVisitor)new RSQLSimpleConverter(), (Object)map);
        }
        return map;
    }

    public static Map<String, MultiValueMap<String, String>> toComplexMultiValueMap(String rsqlQuery) {
        log.debug("toComplexMultiValueMap(rsqlQuery:{})", (Object)rsqlQuery);
        HashMap<String, MultiValueMap<String, String>> map = new HashMap<String, MultiValueMap<String, String>>();
        if (StringUtils.hasText((String)rsqlQuery)) {
            new RSQLParser(RSQLOperators.supportedOperators()).parse(rsqlQuery).accept((RSQLVisitor)new RSQLComplexConverter(), map);
        }
        return map;
    }

    public static void addMapping(Class<?> entityClass, Map<String, String> mapping) {
        log.info("Adding entity class mapping for {}", entityClass);
        propertyRemapping.put(entityClass, mapping);
    }

    public static void addMapping(Class<?> entityClass, String selector, String property) {
        log.info("Adding entity class mapping for {}, selector {} and property {}", new Object[]{entityClass, selector, property});
        propertyRemapping.computeIfAbsent(entityClass, entityClazz -> new ConcurrentHashMap()).put(selector, property);
    }

    public static <T> void addEntityAttributeParser(Class<T> valueClass, Function<String, ? extends T> function) {
        log.info("Adding entity attribute parser for {}", valueClass);
        if (valueClass != null && function != null) {
            RSQLCommonSupport.addConverter(valueClass, s -> function.apply((String)s));
        }
    }

    public static void addEntityAttributeTypeMap(Class valueClass, Class mappedClass) {
        log.info("Adding entity attribute type map for {} -> {}", (Object)valueClass, (Object)mappedClass);
        if (valueClass != null && mappedClass != null) {
            valueTypeMap.put(valueClass, mappedClass);
        }
    }

    protected String getVersion() {
        try {
            Properties prop = new Properties();
            prop.load(this.getClass().getResourceAsStream("/META-INF/maven/io.github.perplexhub/rsql-common/pom.properties"));
            String version = prop.getProperty("version");
            return StringUtils.hasText((String)version) ? "[" + version + "] " : "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Map<String, EntityManager> getEntityManagerMap() {
        return entityManagerMap;
    }

    public static Map<Class, ManagedType> getManagedTypeMap() {
        return managedTypeMap;
    }

    public static Map<Class<?>, Map<String, String>> getPropertyRemapping() {
        return propertyRemapping;
    }

    public static Map<Class, Class> getValueTypeMap() {
        return valueTypeMap;
    }

    public static Map<Class<?>, List<String>> getPropertyWhitelist() {
        return propertyWhitelist;
    }

    public static Map<Class<?>, List<String>> getPropertyBlacklist() {
        return propertyBlacklist;
    }

    public static ConfigurableConversionService getConversionService() {
        return conversionService;
    }
}

