/*
 * Decompiled with CFR 0.152.
 */
package com.smh_digitalassistant_library.settings;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lcom/smh_digitalassistant_library/settings/SecureAppPrefs;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "masterKeyAlias", "Landroidx/security/crypto/MasterKey;", "securePreferences", "Landroid/content/SharedPreferences;", "getSecurePreferences", "()Landroid/content/SharedPreferences;", "secureToken", "getSecureToken", "SmH-DigitalAssistant-Library_release"})
public final class SecureAppPrefs {
    @NotNull
    private final MasterKey masterKeyAlias;
    @NotNull
    private final SharedPreferences securePreferences;
    @NotNull
    private final SharedPreferences secureToken;

    public SecureAppPrefs(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        MasterKey masterKey = new MasterKey.Builder(context).setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
        Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"Builder(context)\n       \u2026256_GCM)\n        .build()");
        this.masterKeyAlias = masterKey;
        masterKey = EncryptedSharedPreferences.create((Context)context, (String)"LoginData", (MasterKey)this.masterKeyAlias, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"create(\n        context,\u2026onScheme.AES256_GCM\n    )");
        this.securePreferences = masterKey;
        masterKey = EncryptedSharedPreferences.create((Context)context, (String)"OAuthToken", (MasterKey)this.masterKeyAlias, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"create(\n        context,\u2026onScheme.AES256_GCM\n    )");
        this.secureToken = masterKey;
    }

    @NotNull
    public final SharedPreferences getSecurePreferences() {
        return this.securePreferences;
    }

    @NotNull
    public final SharedPreferences getSecureToken() {
        return this.secureToken;
    }
}

