/*
 * Decompiled with CFR 0.152.
 */
package nl.adaptivity.xmlutil.serialization.structure;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import nl.adaptivity.xmlutil.serialization.structure.XmlOrderNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0010\"\u00020\u0000\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0010\"\u00020\u0000\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0019"}, d2={"Lnl/adaptivity/xmlutil/serialization/structure/XmlOrderNode;", "", "elementIdx", "", "(I)V", "getElementIdx", "()I", "predecessors", "", "getPredecessors", "()Ljava/util/List;", "successors", "getSuccessors", "addPredecessors", "", "nodes", "", "([Lnl/adaptivity/xmlutil/serialization/structure/XmlOrderNode;)V", "addSuccessors", "equals", "", "other", "hashCode", "toString", "", "xmlutil-serialization"})
public final class XmlOrderNode {
    private final int elementIdx;
    @NotNull
    private final List<XmlOrderNode> predecessors;
    @NotNull
    private final List<XmlOrderNode> successors;

    public XmlOrderNode(int elementIdx) {
        this.elementIdx = elementIdx;
        this.predecessors = new ArrayList();
        this.successors = new ArrayList();
    }

    public final int getElementIdx() {
        return this.elementIdx;
    }

    @NotNull
    public final List<XmlOrderNode> getPredecessors() {
        return this.predecessors;
    }

    @NotNull
    public final List<XmlOrderNode> getSuccessors() {
        return this.successors;
    }

    public final void addSuccessors(XmlOrderNode ... nodes) {
        Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
        for (XmlOrderNode node : nodes) {
            if (this.successors.contains(node)) continue;
            this.successors.add(node);
            XmlOrderNode[] xmlOrderNodeArray = new XmlOrderNode[]{this};
            node.addPredecessors(xmlOrderNodeArray);
        }
    }

    public final void addPredecessors(XmlOrderNode ... nodes) {
        Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
        for (XmlOrderNode node : nodes) {
            if (this.predecessors.contains(node)) continue;
            this.predecessors.add(node);
            XmlOrderNode[] xmlOrderNodeArray = new XmlOrderNode[]{this};
            node.addSuccessors(xmlOrderNodeArray);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof XmlOrderNode)) {
            return false;
        }
        return this.elementIdx == ((XmlOrderNode)other).elementIdx;
    }

    public int hashCode() {
        return this.elementIdx;
    }

    @NotNull
    public String toString() {
        return "" + '(' + this.elementIdx + ", p=[" + CollectionsKt.joinToString$default((Iterable)this.predecessors, null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null) + "], s=[" + CollectionsKt.joinToString$default((Iterable)this.successors, null, null, null, (int)0, null, (Function1)toString.2.INSTANCE, (int)31, null) + "])";
    }
}

