/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.iq80.leveldb.util.ILRUCache;

public final class LRUCache<K, V>
implements ILRUCache<K, V> {
    private final Cache<K, V> cache;
    private final Weigher<K, V> weigher;

    private LRUCache(int capacity, Weigher<K, V> weigher) {
        this.cache = CacheBuilder.newBuilder().maximumWeight((long)capacity).weigher(weigher).concurrencyLevel(16).build();
        this.weigher = weigher;
    }

    public static <K, V> ILRUCache<K, V> createCache(int capacity, Weigher<K, V> weigher) {
        return new LRUCache<K, V>(capacity, weigher);
    }

    @Override
    public V load(K key, Callable<V> loader) throws ExecutionException {
        return (V)this.cache.get(key, loader);
    }

    @Override
    public long getApproximateMemoryUsage() {
        return this.cache.asMap().entrySet().stream().mapToLong(e -> this.weigher.weigh(e.getKey(), e.getValue())).sum();
    }

    @Override
    public V getIfPresent(K key) {
        return (V)this.cache.getIfPresent(key);
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }
}

