/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import java.util.List;
import org.iq80.leveldb.XFilterPolicy;
import org.iq80.leveldb.table.FilterPolicy;
import org.iq80.leveldb.util.Hash;
import org.iq80.leveldb.util.Slice;

public final class BloomFilterPolicy
implements FilterPolicy,
XFilterPolicy {
    private final int bitsPerKey;
    private final int k;

    public BloomFilterPolicy(int bitsPerKey) {
        this.bitsPerKey = bitsPerKey;
        int k = (int)((double)bitsPerKey * 0.69);
        if (k < 1) {
            k = 1;
        } else if (k > 30) {
            k = 30;
        }
        this.k = k;
    }

    @Override
    public String name() {
        return "leveldb.BuiltinBloomFilter2";
    }

    @Override
    public byte[] createFilter(List<Slice> keys) {
        int bits = keys.size() * this.bitsPerKey;
        if (bits < 64) {
            bits = 64;
        }
        int bytes = (bits + 7) / 8;
        bits = bytes * 8;
        byte[] array = new byte[bytes + 1];
        array[array.length - 1] = (byte)this.k;
        for (Slice key : keys) {
            int h = this.bloomHash(key);
            int delta = h >>> 17 | h << 15;
            for (int j = 0; j < this.k; ++j) {
                int i;
                int bitpos = (int)(this.toLong(h) % (long)bits);
                int n = i = bitpos / 8;
                array[n] = (byte)(array[n] | 1 << bitpos % 8);
                h += delta;
            }
        }
        return array;
    }

    private int bloomHash(Slice data) {
        return Hash.hash(data.getRawArray(), data.getRawOffset(), data.length(), -1130422988);
    }

    @Override
    public boolean keyMayMatch(Slice key, Slice bloomFilter1) {
        int len = bloomFilter1.length();
        byte[] data = bloomFilter1.getRawArray();
        int offset = bloomFilter1.getRawOffset();
        if (len < 2) {
            return false;
        }
        int bits = (len - 1) * 8;
        int k = data[offset + len - 1];
        if (k > 30) {
            return true;
        }
        int h = this.bloomHash(key);
        int delta = h >>> 17 | h << 15;
        for (int j = 0; j < k; ++j) {
            int bitpos = (int)(this.toLong(h) % (long)bits);
            if ((data[offset + bitpos / 8] & 1 << bitpos % 8) == 0) {
                return false;
            }
            h += delta;
        }
        return true;
    }

    private long toLong(int h) {
        return (long)h & 0xFFFFFFFFL;
    }
}

