/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Objects;
import org.iq80.leveldb.iterator.ASeekingIterator;
import org.iq80.leveldb.iterator.SliceIterator;
import org.iq80.leveldb.table.RestartPositions;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.SliceInput;
import org.iq80.leveldb.util.SliceOutput;
import org.iq80.leveldb.util.Slices;
import org.iq80.leveldb.util.VariableLengthQuantity;

public final class BlockIterator
extends ASeekingIterator<Slice, Slice>
implements SliceIterator {
    private final SliceInput data;
    private final RestartPositions restartPositions;
    private final Comparator<Slice> comparator;
    private int current;
    private int restartIndex;
    private Slice key;
    private Slice value;

    public BlockIterator(Slice data, Slice restartPositions, Comparator<Slice> comparator) {
        Objects.requireNonNull(data, "data is null");
        Objects.requireNonNull(restartPositions, "restartPositions is null");
        Objects.requireNonNull(comparator, "comparator is null");
        this.data = Objects.requireNonNull(data.input(), "data input is null");
        this.restartPositions = new RestartPositions(restartPositions);
        Preconditions.checkArgument((this.restartPositions.size() > 0 ? 1 : 0) != 0, (Object)"At least one restart position is expected");
        this.comparator = comparator;
    }

    @Override
    protected Slice internalKey() {
        return this.key;
    }

    @Override
    protected Slice internalValue() {
        return this.value;
    }

    @Override
    protected boolean internalNext(boolean switchDirection) {
        return this.parseNextKey();
    }

    @Override
    protected boolean internalPrev(boolean switchDirection) {
        int original = this.current;
        while (this.restartPositions.get(this.restartIndex) >= original) {
            if (this.restartIndex == 0) {
                this.current = Integer.MAX_VALUE;
                return false;
            }
            --this.restartIndex;
        }
        this.seekToRestartPoint(this.restartIndex);
        while (this.parseNextKey() && this.data.position() < original) {
        }
        return this.valid();
    }

    private void seekToRestartPoint(int index) {
        this.restartIndex = index;
        this.data.setPosition(this.restartPositions.get(this.restartIndex));
        this.key = null;
        this.value = null;
    }

    @Override
    protected boolean internalSeekToFirst() {
        this.seekToRestartPosition(0);
        return this.parseNextKey();
    }

    @Override
    protected boolean internalSeekToLast() {
        boolean valid;
        this.seekToRestartPoint(this.restartPositions.size() - 1);
        while ((valid = this.parseNextKey()) && this.data.isReadable()) {
        }
        return valid;
    }

    @Override
    protected boolean internalSeek(Slice targetKey) {
        int left = 0;
        int right = this.restartPositions.size() - 1;
        while (left < right) {
            int mid = (left + right + 1) / 2;
            this.seekToRestartPosition(mid);
            Slice key = this.readFirstKeyAtRestartPoint();
            if (this.comparator.compare(key, targetKey) < 0) {
                left = mid;
                continue;
            }
            right = mid - 1;
        }
        this.seekToRestartPosition(left);
        while (this.parseNextKey()) {
            if (this.comparator.compare(this.key, targetKey) < 0) continue;
            return true;
        }
        this.current = this.data.position();
        return false;
    }

    private void seekToRestartPosition(int restartPosition) {
        this.restartIndex = restartPosition;
        this.key = null;
        this.value = null;
        int offset = this.restartPositions.get(restartPosition);
        this.data.setPosition(offset);
        this.current = offset;
    }

    private Slice readFirstKeyAtRestartPoint() {
        Preconditions.checkState((VariableLengthQuantity.readVariableLengthInt(this.data) == 0 ? 1 : 0) != 0, (Object)"First restart position can't have a shared ");
        this.current = this.data.position();
        int nonSharedKeyLength = VariableLengthQuantity.readVariableLengthInt(this.data);
        VariableLengthQuantity.readVariableLengthInt(this.data);
        return this.data.readSlice(nonSharedKeyLength);
    }

    private boolean parseNextKey() {
        Slice key;
        this.current = this.data.position();
        if (!this.data.isReadable()) {
            return false;
        }
        int sharedKeyLength = VariableLengthQuantity.readVariableLengthInt(this.data);
        int nonSharedKeyLength = VariableLengthQuantity.readVariableLengthInt(this.data);
        int valueLength = VariableLengthQuantity.readVariableLengthInt(this.data);
        if (sharedKeyLength > 0) {
            key = Slices.allocate(sharedKeyLength + nonSharedKeyLength);
            SliceOutput sliceOutput = key.output();
            Preconditions.checkState((this.key != null ? 1 : 0) != 0, (Object)"Entry has a shared key but no previous entry was provided");
            sliceOutput.writeBytes(this.key, 0, sharedKeyLength);
            sliceOutput.writeBytes(this.data, nonSharedKeyLength);
        } else {
            key = this.data.readSlice(nonSharedKeyLength);
        }
        Slice value = this.data.readSlice(valueLength);
        this.key = key;
        this.value = value;
        return true;
    }

    @Override
    protected void internalClose() {
    }
}

