/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.iterator;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Comparator;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.ValueType;
import org.iq80.leveldb.iterator.ASeekingIterator;
import org.iq80.leveldb.iterator.InternalIterator;
import org.iq80.leveldb.util.Slice;

public final class SnapshotSeekingIterator
extends ASeekingIterator<Slice, Slice> {
    private final InternalIterator iterator;
    private final long sequence;
    private final Comparator<Slice> userComparator;
    private final IRecordBytesListener listener;
    private Slice key;
    private Slice value;

    public SnapshotSeekingIterator(InternalIterator iterator, long sequence, Comparator<Slice> userComparator, IRecordBytesListener listener) {
        this.iterator = iterator;
        this.sequence = sequence;
        this.userComparator = userComparator;
        this.listener = listener;
    }

    @Override
    protected void internalClose() throws IOException {
        this.iterator.close();
    }

    @Override
    protected boolean internalSeekToFirst() {
        return this.iterator.seekToFirst() && this.findNextUserEntry(false, null);
    }

    @Override
    protected boolean internalSeekToLast() {
        return this.iterator.seekToLast() && this.findPrevUserEntry();
    }

    @Override
    protected boolean internalSeek(Slice targetKey) {
        return this.iterator.seek(new InternalKey(targetKey, this.sequence, ValueType.VALUE)) && this.findNextUserEntry(false, null);
    }

    @Override
    protected boolean internalNext(boolean switchDirection) {
        if (switchDirection) {
            boolean valid;
            boolean itrValid = this.iterator.valid();
            itrValid = !itrValid ? this.iterator.seekToFirst() : this.iterator.next();
            boolean bl = valid = itrValid ? this.iterator.next() : this.iterator.seekToFirst();
            if (!valid) {
                this.key = null;
                this.value = null;
                return false;
            }
        }
        return this.findNextUserEntry(true, this.key);
    }

    @Override
    protected boolean internalPrev(boolean switchDirection) {
        if (switchDirection) {
            Preconditions.checkState((boolean)this.iterator.valid(), (Object)"Should be valid");
            do {
                if (this.iterator.prev()) continue;
                return false;
            } while (this.userComparator.compare(((InternalKey)this.iterator.key()).getUserKey(), this.key) >= 0);
        }
        return this.findPrevUserEntry();
    }

    @Override
    protected Slice internalKey() {
        return this.key;
    }

    private boolean findPrevUserEntry() {
        ValueType valueType = ValueType.DELETION;
        if (!this.iterator.valid()) {
            return false;
        }
        do {
            InternalKey key;
            if ((key = (InternalKey)this.iterator.key()).getSequenceNumber() > this.sequence) continue;
            if (valueType != ValueType.DELETION && this.userComparator.compare(key.getUserKey(), this.key) < 0) {
                return true;
            }
            valueType = key.getValueType();
            if (valueType == ValueType.DELETION) {
                this.key = null;
                this.value = null;
                continue;
            }
            this.key = key.getUserKey();
            this.value = (Slice)this.iterator.value();
        } while (this.iterator.prev());
        if (valueType == ValueType.DELETION) {
            this.key = null;
            this.value = null;
            return false;
        }
        return true;
    }

    @Override
    protected Slice internalValue() {
        return this.value;
    }

    private boolean findNextUserEntry(boolean skipping, Slice savedKey) {
        if (!this.iterator.valid()) {
            return false;
        }
        block4: do {
            InternalKey ikey = (InternalKey)this.iterator.key();
            Slice value = (Slice)this.iterator.value();
            this.listener.record(ikey, ikey.size() + value.length());
            if (ikey.getSequenceNumber() > this.sequence) continue;
            switch (ikey.getValueType()) {
                case DELETION: {
                    savedKey = ikey.getUserKey();
                    skipping = true;
                    break;
                }
                case VALUE: {
                    if (skipping && this.userComparator.compare(ikey.getUserKey(), savedKey) <= 0) continue block4;
                    this.key = ikey.getUserKey();
                    this.value = value;
                    return true;
                }
            }
        } while (this.iterator.next());
        this.key = null;
        this.value = null;
        return false;
    }

    public String toString() {
        return "SnapshotSeekingIterator{sequence=" + this.sequence + ", iterator=" + this.iterator + '}';
    }

    public static interface IRecordBytesListener {
        public void record(InternalKey var1, int var2);
    }
}

