/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.impl.Compaction;
import org.iq80.leveldb.impl.FileMetaData;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.InternalKeyComparator;
import org.iq80.leveldb.impl.Level;
import org.iq80.leveldb.impl.LookupKey;
import org.iq80.leveldb.impl.LookupResult;
import org.iq80.leveldb.impl.ReadStats;
import org.iq80.leveldb.impl.TableCache;
import org.iq80.leveldb.impl.ValueType;
import org.iq80.leveldb.impl.VersionSet;
import org.iq80.leveldb.iterator.InternalIterator;
import org.iq80.leveldb.iterator.MergingIterator;
import org.iq80.leveldb.util.SafeListBuilder;
import org.iq80.leveldb.util.Slice;

public class Version {
    private final AtomicInteger retained = new AtomicInteger(1);
    private final VersionSet versionSet;
    private final List<Level> levels;
    private int compactionLevel;
    private double compactionScore;
    private FileMetaData fileToCompact;
    private int fileToCompactLevel;

    public Version(VersionSet versionSet) {
        this.versionSet = versionSet;
        Preconditions.checkArgument((boolean)true, (Object)"levels must be at least 2");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < 7; ++i) {
            ArrayList<FileMetaData> files = new ArrayList<FileMetaData>();
            builder.add((Object)new Level(i, files, this.getTableCache(), this.getInternalKeyComparator()));
        }
        this.levels = builder.build();
    }

    public void assertNoOverlappingFiles(int level) {
        List<FileMetaData> files;
        if (level > 0 && (files = this.getFiles(level)) != null) {
            long previousFileNumber = 0L;
            InternalKey previousEnd = null;
            for (FileMetaData fileMetaData : files) {
                if (previousEnd != null) {
                    Preconditions.checkArgument((this.getInternalKeyComparator().compare(previousEnd, fileMetaData.getSmallest()) < 0 ? 1 : 0) != 0, (String)"Overlapping files %s and %s in level %s", (Object)previousFileNumber, (Object)fileMetaData.getNumber(), (Object)level);
                }
                previousFileNumber = fileMetaData.getNumber();
                previousEnd = fileMetaData.getLargest();
            }
        }
    }

    public VersionSet getVersionSet() {
        return this.versionSet;
    }

    private TableCache getTableCache() {
        return this.versionSet.getTableCache();
    }

    public final InternalKeyComparator getInternalKeyComparator() {
        return this.versionSet.getInternalKeyComparator();
    }

    public int getCompactionLevel() {
        return this.compactionLevel;
    }

    public void setCompactionLevel(int compactionLevel) {
        this.compactionLevel = compactionLevel;
    }

    public double getCompactionScore() {
        return this.compactionScore;
    }

    public void setCompactionScore(double compactionScore) {
        this.compactionScore = compactionScore;
    }

    public MergingIterator iterator(ReadOptions options) throws IOException {
        return new MergingIterator(this.getLevelIterators(options), this.getInternalKeyComparator());
    }

    List<InternalIterator> getLevelIterators(ReadOptions options) throws IOException {
        try (SafeListBuilder<InternalIterator> builder = SafeListBuilder.builder();){
            for (Level level : this.levels) {
                if (level.getFiles().isEmpty()) continue;
                builder.add(level.iterator(options));
            }
            List list = builder.build();
            return list;
        }
    }

    public LookupResult get(ReadOptions options, LookupKey key, ReadStats readStats) {
        Level level;
        LookupResult lookupResult = null;
        ReadStats lastStats = new ReadStats();
        Iterator<Level> iterator = this.levels.iterator();
        while (iterator.hasNext() && (lookupResult = (level = iterator.next()).get(options, key, readStats, lastStats)) == null) {
        }
        return lookupResult;
    }

    int pickLevelForMemTableOutput(Slice smallestUserKey, Slice largestUserKey) {
        int level;
        if (!this.overlapInLevel(0, smallestUserKey, largestUserKey)) {
            long sum;
            InternalKey start = new InternalKey(smallestUserKey, 0xFFFFFFFFFFFFFFL, ValueType.VALUE);
            InternalKey limit = new InternalKey(largestUserKey, 0L, ValueType.DELETION);
            for (level = 0; !(level >= 2 || this.overlapInLevel(level + 1, smallestUserKey, largestUserKey) || level + 2 < 7 && (sum = Compaction.totalFileSize(this.versionSet.getOverlappingInputs(level + 2, start, limit))) > this.versionSet.maxGrandParentOverlapBytes()); ++level) {
            }
        }
        return level;
    }

    public boolean overlapInLevel(int level, Slice smallestUserKey, Slice largestUserKey) {
        Preconditions.checkPositionIndex((int)level, (int)this.levels.size(), (String)"Invalid level");
        return this.levels.get(level).someFileOverlapsRange(level > 0, smallestUserKey, largestUserKey);
    }

    public int numberOfLevels() {
        return this.levels.size();
    }

    public int numberOfFilesInLevel(int level) {
        return this.getFiles(level).size();
    }

    public Multimap<Integer, FileMetaData> getFiles() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder = builder.orderKeysBy((Comparator)Ordering.natural());
        for (Level level : this.levels) {
            builder.putAll((Object)level.getLevelNumber(), level.getFiles());
        }
        return builder.build();
    }

    public List<FileMetaData> getFiles(int level) {
        return this.levels.get(level).getFiles();
    }

    public void addFile(int level, FileMetaData fileMetaData) {
        this.levels.get(level).addFile(fileMetaData);
    }

    public boolean updateStats(ReadStats readStats) {
        int seekFileLevel = readStats.getSeekFileLevel();
        FileMetaData seekFile = readStats.getSeekFile();
        if (seekFile == null) {
            return false;
        }
        seekFile.decrementAllowedSeeks();
        if (seekFile.getAllowedSeeks() <= 0 && this.fileToCompact == null) {
            this.fileToCompact = seekFile;
            this.fileToCompactLevel = seekFileLevel;
            return true;
        }
        return false;
    }

    public FileMetaData getFileToCompact() {
        return this.fileToCompact;
    }

    public int getFileToCompactLevel() {
        return this.fileToCompactLevel;
    }

    public long getApproximateOffsetOf(InternalKey key) {
        long result = 0L;
        block0: for (int level = 0; level < 7; ++level) {
            for (FileMetaData fileMetaData : this.getFiles(level)) {
                if (this.getInternalKeyComparator().compare(fileMetaData.getLargest(), key) <= 0) {
                    result += fileMetaData.getFileSize();
                    continue;
                }
                if (this.getInternalKeyComparator().compare(fileMetaData.getSmallest(), key) > 0) {
                    if (level <= 0) continue;
                    continue block0;
                }
                result += this.getTableCache().getApproximateOffsetOf(fileMetaData, key.encode());
            }
        }
        return result;
    }

    public void retain() {
        int was = this.retained.getAndIncrement();
        assert (was > 0) : "Version was retain after it was disposed.";
    }

    public void release() {
        int now = this.retained.decrementAndGet();
        assert (now >= 0) : "Version was released after it was disposed.";
        if (now == 0) {
            this.versionSet.removeVersion(this);
        }
    }

    public boolean isDisposed() {
        return this.retained.get() <= 0;
    }

    public boolean recordReadSample(InternalKey internalKey) {
        ReadStats readStats = null;
        for (int level = 0; level < 7; ++level) {
            for (FileMetaData file : this.levels.get(level).getFilesForKey(internalKey.getUserKey(), internalKey)) {
                if (readStats != null) {
                    return this.updateStats(readStats);
                }
                readStats = new ReadStats(level, file);
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (Level level : this.levels) {
            r.append("--- level ");
            r.append(level);
            r.append(" ---").append(System.lineSeparator());
            for (FileMetaData file : level.getFiles()) {
                r.append(" ").append(file.getNumber()).append(";");
                r.append(file.getFileSize()).append("[");
                r.append(file.getSmallest());
                r.append(" .. ");
                r.append(file.getLargest());
                r.append("]").append(System.lineSeparator());
            }
        }
        return r.toString();
    }
}

