/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb;

import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DBComparator;
import org.iq80.leveldb.Logger;
import org.iq80.leveldb.XFilterPolicy;

public class Options {
    private boolean createIfMissing = true;
    private boolean errorIfExists;
    private int writeBufferSize = 0x400000;
    private int maxOpenFiles = 1000;
    private int blockRestartInterval = 16;
    private int maxFileSize = 0x200000;
    private int blockSize = 4096;
    private CompressionType compressionType = CompressionType.SNAPPY;
    private boolean paranoidChecks;
    private DBComparator comparator;
    private Logger logger;
    private long cacheSize = 0x800000L;
    private XFilterPolicy filterPolicy;
    private boolean reuseLogs = false;

    public static Options fromOptions(Options options) {
        Options.checkArgNotNull(options, "Options can't be null");
        Options options1 = new Options();
        options1.createIfMissing = options.createIfMissing;
        options1.errorIfExists = options.errorIfExists;
        options1.writeBufferSize = options.writeBufferSize;
        options1.maxOpenFiles = options.maxOpenFiles;
        options1.blockRestartInterval = options.blockRestartInterval;
        options1.maxFileSize = options.maxFileSize;
        options1.blockSize = options.blockSize;
        options1.compressionType = options.compressionType;
        options1.paranoidChecks = options.paranoidChecks;
        options1.comparator = options.comparator;
        options1.logger = options.logger;
        options1.cacheSize = options.cacheSize;
        options1.filterPolicy = options.filterPolicy;
        options1.reuseLogs = options.reuseLogs;
        return options1;
    }

    public static Options newDefaultOptions() {
        return new Options();
    }

    static void checkArgNotNull(Object value, String name) {
        if (value == null) {
            throw new IllegalArgumentException("The " + name + " argument cannot be null");
        }
    }

    public boolean createIfMissing() {
        return this.createIfMissing;
    }

    public Options createIfMissing(boolean createIfMissing) {
        this.createIfMissing = createIfMissing;
        return this;
    }

    public boolean errorIfExists() {
        return this.errorIfExists;
    }

    public Options errorIfExists(boolean errorIfExists) {
        this.errorIfExists = errorIfExists;
        return this;
    }

    public int writeBufferSize() {
        return this.writeBufferSize;
    }

    public Options writeBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        return this;
    }

    public int maxOpenFiles() {
        return this.maxOpenFiles;
    }

    public Options maxOpenFiles(int maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
        return this;
    }

    public int blockRestartInterval() {
        return this.blockRestartInterval;
    }

    public Options blockRestartInterval(int blockRestartInterval) {
        this.blockRestartInterval = blockRestartInterval;
        return this;
    }

    public int maxFileSize() {
        return this.maxFileSize;
    }

    public Options maxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
        return this;
    }

    public int blockSize() {
        return this.blockSize;
    }

    public Options blockSize(int blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    public CompressionType compressionType() {
        return this.compressionType;
    }

    public Options compressionType(CompressionType compressionType) {
        Options.checkArgNotNull((Object)compressionType, "compressionType");
        this.compressionType = compressionType;
        return this;
    }

    public long cacheSize() {
        return this.cacheSize;
    }

    public Options cacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public DBComparator comparator() {
        return this.comparator;
    }

    public Options comparator(DBComparator comparator) {
        this.comparator = comparator;
        return this;
    }

    public Logger logger() {
        return this.logger;
    }

    public Options logger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public boolean paranoidChecks() {
        return this.paranoidChecks;
    }

    public Options paranoidChecks(boolean paranoidChecks) {
        this.paranoidChecks = paranoidChecks;
        return this;
    }

    public Options filterPolicy(XFilterPolicy filterPolicy) {
        this.filterPolicy = filterPolicy;
        return this;
    }

    public XFilterPolicy filterPolicy() {
        return this.filterPolicy;
    }

    public Options reuseLogs(boolean reuseLogs) {
        this.reuseLogs = reuseLogs;
        return this;
    }

    public boolean reuseLogs() {
        return this.reuseLogs;
    }
}

