/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.JoinExpression;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.support.SerializerBase;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.MapExpression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathType;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.Templates;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.util.MathUtils;
import com.querydsl.jpa.JPAQueryMixin;
import com.querydsl.jpa.JPQLOps;
import com.querydsl.jpa.JPQLTemplates;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class JPQLSerializer
extends SerializerBase<JPQLSerializer> {
    private static final Set<? extends Operator> NUMERIC = Collections.unmodifiableSet(EnumSet.of(Ops.ADD, new Ops[]{Ops.SUB, Ops.MULT, Ops.DIV, Ops.LT, Ops.LOE, Ops.GT, Ops.GOE, Ops.BETWEEN}));
    private static final Set<? extends Operator> CASE_OPS = Collections.unmodifiableSet(EnumSet.of(Ops.CASE_WHEN, Ops.CASE_ELSE));
    private static final String COMMA = ", ";
    private static final String DELETE = "delete from ";
    private static final String FROM = "from ";
    private static final String GROUP_BY = "\ngroup by ";
    private static final String HAVING = "\nhaving ";
    private static final String ORDER_BY = "\norder by ";
    private static final String SELECT = "select ";
    private static final String SELECT_COUNT = "select count(";
    private static final String SELECT_COUNT_DISTINCT = "select count(distinct ";
    private static final String SELECT_DISTINCT = "select distinct ";
    private static final String SET = "\nset ";
    private static final String UPDATE = "update ";
    private static final String INSERT = "insert into ";
    private static final String VALUES = "\nvalues ";
    private static final String WHERE = "\nwhere ";
    private static final String WITH = " with ";
    private static final String ON = " on ";
    private static final Map<JoinType, String> joinTypes = new EnumMap<JoinType, String>(JoinType.class);
    private final JPQLTemplates templates;
    private final EntityManager entityManager;
    private boolean inProjection = false;
    private boolean inCaseOperation = false;
    private boolean wrapElements = false;

    public JPQLSerializer(JPQLTemplates templates) {
        this(templates, null);
    }

    public JPQLSerializer(JPQLTemplates templates, EntityManager em) {
        super((Templates)templates);
        this.templates = templates;
        this.entityManager = em;
    }

    private String getEntityName(Class<?> clazz) {
        Entity entityAnnotation = clazz.getAnnotation(Entity.class);
        if (entityAnnotation != null && entityAnnotation.name().length() > 0) {
            return entityAnnotation.name();
        }
        if (clazz.getPackage() != null && clazz.getPackage().getName().length() > 0) {
            String pn = clazz.getPackage().getName();
            return clazz.getName().substring(pn.length() + 1);
        }
        return clazz.getName();
    }

    private void handleJoinTarget(JoinExpression je) {
        if (je.getTarget() instanceof EntityPath) {
            EntityPath pe = (EntityPath)je.getTarget();
            if (pe.getMetadata().isRoot()) {
                this.append(this.getEntityName(pe.getType()));
                this.append(" ");
            }
            this.handle(je.getTarget());
        } else if (je.getTarget() instanceof Operation) {
            Operation op = (Operation)je.getTarget();
            if (op.getOperator() == Ops.ALIAS) {
                Class par;
                boolean treat = false;
                if (Collection.class.isAssignableFrom(op.getArg(0).getType())) {
                    if (op.getArg(0) instanceof CollectionExpression) {
                        par = ((CollectionExpression)op.getArg(0)).getParameter(0);
                        treat = !par.equals(op.getArg(1).getType());
                    }
                } else if (Map.class.isAssignableFrom(op.getArg(0).getType())) {
                    if (op.getArg(0) instanceof MapExpression) {
                        par = ((MapExpression)op.getArg(0)).getParameter(1);
                        treat = !par.equals(op.getArg(1).getType());
                    }
                } else {
                    boolean bl = treat = !op.getArg(0).getType().equals(op.getArg(1).getType());
                }
                if (treat) {
                    Constant entityName = ConstantImpl.create((Object)this.getEntityName(op.getArg(1).getType()));
                    Operation t = ExpressionUtils.operation((Class)op.getType(), (Operator)JPQLOps.TREAT, (Expression[])new Expression[]{op.getArg(0), entityName});
                    op = ExpressionUtils.operation((Class)op.getType(), (Operator)Ops.ALIAS, (Expression[])new Expression[]{t, op.getArg(1)});
                }
            }
            this.handle((Expression)op);
        } else {
            this.handle(je.getTarget());
        }
    }

    public void serialize(QueryMetadata metadata, boolean forCountRow, @Nullable String projection) {
        Expression select = metadata.getProjection();
        List joins = metadata.getJoins();
        Predicate where = metadata.getWhere();
        List groupBy = metadata.getGroupBy();
        Predicate having = metadata.getHaving();
        List orderBy = metadata.getOrderBy();
        boolean inProjectionOrig = this.inProjection;
        this.inProjection = true;
        if (projection != null) {
            ((JPQLSerializer)((JPQLSerializer)this.append(SELECT)).append(projection)).append("\n");
        } else if (forCountRow) {
            if (!groupBy.isEmpty()) {
                this.append(SELECT_COUNT_DISTINCT);
                this.handle(COMMA, groupBy);
            } else {
                if (!metadata.isDistinct()) {
                    this.append(SELECT_COUNT);
                } else {
                    this.append(SELECT_COUNT_DISTINCT);
                }
                if (select != null) {
                    if (select instanceof FactoryExpression) {
                        this.handle(((JoinExpression)joins.get(0)).getTarget());
                    } else {
                        this.handle(select);
                    }
                } else {
                    this.handle(((JoinExpression)joins.get(0)).getTarget());
                }
            }
            this.append(")\n");
        } else if (select != null || !joins.isEmpty()) {
            if (!metadata.isDistinct()) {
                this.append(SELECT);
            } else {
                this.append(SELECT_DISTINCT);
            }
            if (select != null) {
                this.handle(select);
            } else {
                this.handle(((JoinExpression)joins.get(0)).getTarget());
            }
            this.append("\n");
        }
        this.inProjection = inProjectionOrig;
        if (!joins.isEmpty()) {
            this.append(FROM);
            this.serializeSources(forCountRow, joins);
        }
        if (where != null) {
            ((JPQLSerializer)this.append(WHERE)).handle((Expression)where);
        }
        if (!groupBy.isEmpty() && !forCountRow) {
            ((JPQLSerializer)this.append(GROUP_BY)).handle(COMMA, groupBy);
        }
        if (having != null) {
            ((JPQLSerializer)this.append(HAVING)).handle((Expression)having);
        }
        if (!orderBy.isEmpty() && !forCountRow) {
            this.append(ORDER_BY);
            boolean first = true;
            for (OrderSpecifier os : orderBy) {
                if (!first) {
                    this.append(COMMA);
                }
                this.handle(os.getTarget());
                this.append(os.getOrder() == Order.ASC ? " asc" : " desc");
                if (os.getNullHandling() == OrderSpecifier.NullHandling.NullsFirst) {
                    this.append(" nulls first");
                } else if (os.getNullHandling() == OrderSpecifier.NullHandling.NullsLast) {
                    this.append(" nulls last");
                }
                first = false;
            }
        }
    }

    public void serializeForDelete(QueryMetadata md) {
        this.append(DELETE);
        this.handleJoinTarget((JoinExpression)md.getJoins().get(0));
        if (md.getWhere() != null) {
            ((JPQLSerializer)this.append(WHERE)).handle((Expression)md.getWhere());
        }
    }

    private static String relativePathString(Expression<?> root, Path<?> path) {
        StringBuilder pathString = new StringBuilder(path.getMetadata().getName().length());
        while (path.getMetadata().getParent() != null && !path.equals(root)) {
            if (pathString.length() > 0) {
                pathString.insert(0, '.');
            }
            pathString.insert(0, path.getMetadata().getName());
            path = path.getMetadata().getParent();
        }
        return pathString.toString();
    }

    public void serializeForInsert(QueryMetadata md, Collection<Path<?>> columns, List<Object> values, SubQueryExpression<?> query, Map<Path<?>, Expression<?>> inserts) {
        this.append(INSERT);
        JoinExpression root = (JoinExpression)md.getJoins().get(0);
        this.append(this.getEntityName(root.getTarget().getType()));
        this.append(" (");
        boolean first = true;
        for (Path<?> path : columns) {
            if (!first) {
                this.append(COMMA);
            }
            this.append(JPQLSerializer.relativePathString(root.getTarget(), path));
            first = false;
        }
        this.append(")\n");
        if (values != null && values.size() > 0) {
            this.append(VALUES);
            this.append(" (");
            first = true;
            for (Object object : values) {
                if (!first) {
                    this.append(COMMA);
                }
                this.handle(object);
                first = false;
            }
            this.append(")");
        } else if (inserts != null && inserts.entrySet().size() > 0) {
            first = true;
            for (Map.Entry entry : inserts.entrySet()) {
                if (!first) {
                    this.append(COMMA);
                }
                this.handle((Expression)entry.getKey());
                this.append(" = ");
                this.handle((Expression)entry.getValue());
                first = false;
            }
        } else {
            this.serialize(query.getMetadata(), false, null);
        }
    }

    public void serializeForUpdate(QueryMetadata md, Map<Path<?>, Expression<?>> updates) {
        this.append(UPDATE);
        this.handleJoinTarget((JoinExpression)md.getJoins().get(0));
        this.append(SET);
        boolean first = true;
        for (Map.Entry<Path<?>, Expression<?>> entry : updates.entrySet()) {
            if (!first) {
                this.append(COMMA);
            }
            this.handle((Expression)entry.getKey());
            this.append(" = ");
            this.handle(entry.getValue());
            first = false;
        }
        if (md.getWhere() != null) {
            ((JPQLSerializer)this.append(WHERE)).handle((Expression)md.getWhere());
        }
    }

    private void serializeSources(boolean forCountRow, List<JoinExpression> joins) {
        for (int i = 0; i < joins.size(); ++i) {
            JoinExpression je = joins.get(i);
            if (i > 0) {
                this.append(joinTypes.get(je.getType()));
            }
            if (je.hasFlag(JPAQueryMixin.FETCH) && !forCountRow) {
                this.handle(JPAQueryMixin.FETCH);
            }
            this.handleJoinTarget(je);
            if (je.getCondition() == null) continue;
            this.append(this.templates.isWithForOn() ? WITH : ON);
            this.handle((Expression)je.getCondition());
        }
    }

    public void visitConstant(Object constant) {
        if (this.inCaseOperation && constant instanceof Enum) {
            this.visitLiteral(constant);
            return;
        }
        if (this.inCaseOperation && this.templates.isCaseWithLiterals()) {
            if (constant instanceof Collection) {
                this.append("(");
                boolean first = true;
                for (Object o : (Collection)constant) {
                    if (!first) {
                        this.append(COMMA);
                    }
                    this.visitLiteral(o);
                    first = false;
                }
                this.append(")");
            } else {
                this.visitLiteral(constant);
            }
        } else {
            boolean wrap = this.templates.wrapConstant(constant);
            if (wrap) {
                this.append("(");
            }
            super.visitConstant(constant);
            if (wrap) {
                this.append(")");
            }
        }
    }

    public void visitLiteral(Object constant) {
        this.append(this.templates.asLiteral(constant));
    }

    protected void serializeConstant(int parameterIndex, String constantLabel) {
        this.append("?");
        this.append(Integer.toString(parameterIndex));
    }

    public Void visit(SubQueryExpression<?> query, Void context) {
        this.append("(");
        this.serialize(query.getMetadata(), false, null);
        this.append(")");
        return null;
    }

    public Void visit(Path<?> expr, Void context) {
        boolean wrap;
        boolean bl = wrap = this.wrapElements && (Collection.class.isAssignableFrom(expr.getType()) || Map.class.isAssignableFrom(expr.getType())) && expr.getMetadata().getPathType().equals((Object)PathType.PROPERTY);
        if (wrap) {
            this.append("elements(");
        }
        super.visit(expr, context);
        if (wrap) {
            this.append(")");
        }
        return null;
    }

    protected void visitOperation(Class<?> type, Operator operator, List<? extends Expression<?>> args) {
        boolean oldInCaseOperation = this.inCaseOperation;
        this.inCaseOperation = CASE_OPS.contains(operator);
        boolean oldWrapElements = this.wrapElements;
        this.wrapElements = this.templates.wrapElements(operator);
        if (operator == Ops.EQ && args.get(1) instanceof Operation && ((Operation)args.get(1)).getOperator() == Ops.QuantOps.ANY) {
            args = Arrays.asList(args.get(0), ((Operation)args.get(1)).getArg(0));
            this.visitOperation(type, (Operator)Ops.IN, args);
        } else if (operator == Ops.NE && args.get(1) instanceof Operation && ((Operation)args.get(1)).getOperator() == Ops.QuantOps.ANY) {
            args = Arrays.asList(args.get(0), ((Operation)args.get(1)).getArg(0));
            this.visitOperation(type, (Operator)Ops.NOT_IN, args);
        } else if (operator == Ops.IN || operator == Ops.NOT_IN) {
            if (args.get(1) instanceof Path) {
                this.visitAnyInPath(type, operator, args);
            } else if (args.get(0) instanceof Path && args.get(1) instanceof Constant) {
                this.visitPathInCollection(type, operator, args);
            } else {
                super.visitOperation(type, operator, args);
            }
        } else if (operator == Ops.NUMCAST) {
            this.visitNumCast(args);
        } else if (operator == Ops.EXISTS && args.get(0) instanceof SubQueryExpression) {
            SubQueryExpression subQuery = (SubQueryExpression)args.get(0);
            this.append("exists (");
            this.serialize(subQuery.getMetadata(), false, this.templates.getExistsProjection());
            this.append(")");
        } else if (operator == Ops.MATCHES || operator == Ops.MATCHES_IC) {
            super.visitOperation(type, (Operator)Ops.LIKE, Arrays.asList(args.get(0), ExpressionUtils.regexToLike(args.get(1))));
        } else if (operator == Ops.LIKE && args.get(1) instanceof Constant) {
            String escape = String.valueOf(this.templates.getEscapeChar());
            String escaped = args.get(1).toString().replace(escape, escape + escape);
            super.visitOperation(String.class, (Operator)Ops.LIKE, Arrays.asList(args.get(0), ConstantImpl.create((Object)escaped)));
        } else if (NUMERIC.contains(operator)) {
            super.visitOperation(type, operator, this.normalizeNumericArgs(args));
        } else if (operator == Ops.ALIAS) {
            if (args.get(1) instanceof Path && !((Path)args.get(1)).getMetadata().isRoot()) {
                Path path = (Path)args.get(1);
                args = Arrays.asList(args.get(0), ExpressionUtils.path((Class)path.getType(), (String)path.getMetadata().getName()));
            }
            super.visitOperation(type, operator, args);
        } else {
            try {
                super.visitOperation(type, operator, args);
            }
            catch (IllegalArgumentException e) {
                if (operator.getClass().getName().endsWith("SQLOps")) {
                    throw new IllegalArgumentException(String.format("SQL Expressions like %s are not supported in JPQL - the query language for JPA. SQLExpressions.* can only be used in JPQL queries when these functions are registered as custom function in your ORM.%n\tTo fix this issue, you have three options:%n\t1) If you do want to use advanced, dialect specific, SQL functions within JPQL, make sure to make these functions available to your ORM through custom functions and register these with your JPATemplates instance.%n\t2) Use JPASQLQuery instead. This allows you to generate a pure SQL query based on your JPA metamodel.%n\t3) Consider using the Blaze-Persistence QueryDSL integration. Blaze-Persistence is an extension on top of JPA that makes various SQL specific functions like window functions available to JPQL.", operator.name()), e);
                }
                throw e;
            }
        }
        this.inCaseOperation = oldInCaseOperation;
        this.wrapElements = oldWrapElements;
    }

    private void visitNumCast(List<? extends Expression<?>> args) {
        Constant rightArg = (Constant)args.get(1);
        Class targetType = (Class)rightArg.getConstant();
        String typeName = this.templates.getTypeForCast(targetType);
        this.visitOperation(targetType, JPQLOps.CAST, Arrays.asList(args.get(0), ConstantImpl.create((Object)typeName)));
    }

    private void visitPathInCollection(Class<?> type, Operator operator, List<? extends Expression<?>> args) {
        Path lhs = (Path)args.get(0);
        Constant rhs = (Constant)args.get(1);
        if (((Collection)rhs.getConstant()).isEmpty()) {
            operator = operator == Ops.IN ? Ops.EQ : Ops.NE;
            args = Arrays.asList(Expressions.ONE, Expressions.TWO);
        } else if (this.entityManager != null && !this.templates.isPathInEntitiesSupported() && args.get(0).getType().isAnnotationPresent(Entity.class)) {
            Metamodel metamodel = this.entityManager.getMetamodel();
            PersistenceUnitUtil util = this.entityManager.getEntityManagerFactory().getPersistenceUnitUtil();
            EntityType entityType = metamodel.entity(args.get(0).getType());
            if (entityType.hasSingleIdAttribute()) {
                SingularAttribute<?, ?> id = this.getIdProperty(entityType);
                lhs = ExpressionUtils.path((Class)id.getJavaType(), (Path)lhs, (String)id.getName());
                HashSet<Object> ids = new HashSet<Object>();
                for (Object entity : (Collection)rhs.getConstant()) {
                    ids.add(util.getIdentifier(entity));
                }
                rhs = ConstantImpl.create(ids);
                args = Arrays.asList(lhs, rhs);
            }
        }
        super.visitOperation(type, operator, args);
    }

    private SingularAttribute<?, ?> getIdProperty(EntityType entity) {
        Set singularAttributes = entity.getSingularAttributes();
        for (SingularAttribute singularAttribute : singularAttributes) {
            if (!singularAttribute.isId()) continue;
            return singularAttribute;
        }
        return null;
    }

    private void visitAnyInPath(Class<?> type, Operator operator, List<? extends Expression<?>> args) {
        super.visitOperation(type, (Operator)(operator == Ops.IN ? JPQLOps.MEMBER_OF : JPQLOps.NOT_MEMBER_OF), args);
    }

    private List<? extends Expression<?>> normalizeNumericArgs(List<? extends Expression<?>> args) {
        List<Expression<?>> potentialArgs = args;
        boolean hasConstants = false;
        Class numType = null;
        for (Expression<?> arg : potentialArgs) {
            if (!Number.class.isAssignableFrom(arg.getType())) continue;
            if (arg instanceof Constant) {
                hasConstants = true;
                continue;
            }
            numType = arg.getType();
        }
        if (hasConstants && numType != null) {
            ArrayList<Object> newArgs = new ArrayList<Object>(args.size());
            for (Expression<?> arg : potentialArgs) {
                if (arg instanceof Constant && Number.class.isAssignableFrom(arg.getType()) && !arg.getType().equals(numType)) {
                    Number number = (Number)((Constant)arg).getConstant();
                    newArgs.add(ConstantImpl.create((Object)MathUtils.cast((Number)number, (Class)numType)));
                    continue;
                }
                newArgs.add(arg);
            }
            return newArgs;
        }
        return potentialArgs;
    }

    static {
        joinTypes.put(JoinType.DEFAULT, COMMA);
        joinTypes.put(JoinType.FULLJOIN, "\n  full join ");
        joinTypes.put(JoinType.INNERJOIN, "\n  inner join ");
        joinTypes.put(JoinType.JOIN, "\n  inner join ");
        joinTypes.put(JoinType.LEFTJOIN, "\n  left join ");
        joinTypes.put(JoinType.RIGHTJOIN, "\n  right join ");
    }
}

