/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.impl;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.jpa.JPAQueryBase;
import com.querydsl.jpa.JPQLSerializer;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.QueryHandler;
import com.querydsl.jpa.impl.JPAProvider;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJPAQuery<T, Q extends AbstractJPAQuery<T, Q>>
extends JPAQueryBase<T, Q> {
    private static final Logger logger = Logger.getLogger(JPAQuery.class.getName());
    protected final Map<String, Object> hints = new LinkedHashMap<String, Object>();
    protected final EntityManager entityManager;
    protected final QueryHandler queryHandler;
    @Nullable
    protected LockModeType lockMode;
    @Nullable
    protected FlushModeType flushMode;
    @Nullable
    protected FactoryExpression<?> projection;

    public AbstractJPAQuery(EntityManager em) {
        this(em, JPAProvider.getTemplates(em), (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractJPAQuery(EntityManager em, JPQLTemplates templates, QueryMetadata metadata) {
        super(metadata, templates);
        this.queryHandler = templates.getQueryHandler();
        this.entityManager = em;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public long fetchCount() {
        try {
            if (this.getMetadata().getGroupBy().size() > 1 || this.getMetadata().getHaving() != null) {
                logger.warning("Fetchable#fetchCount() was computed in memory! See the Javadoc for AbstractJPAQuery#fetchCount for more details.");
                Query query = this.createQuery(null, false);
                long l = query.getResultList().size();
                return l;
            }
            Query query = this.createQuery(null, true);
            long l = (Long)query.getSingleResult();
            return l;
        }
        finally {
            this.reset();
        }
    }

    public Query createQuery() {
        return this.createQuery(this.getMetadata().getModifiers(), false);
    }

    protected Query createQuery(@Nullable QueryModifiers modifiers, boolean forCount) {
        JPQLSerializer serializer = this.serialize(forCount);
        String queryString = serializer.toString();
        this.logQuery(queryString);
        Query query = this.entityManager.createQuery(queryString);
        JPAUtil.setConstants(query, serializer.getConstants(), this.getMetadata().getParams());
        if (modifiers != null && modifiers.isRestricting()) {
            Integer limit = modifiers.getLimitAsInteger();
            Integer n = modifiers.getOffsetAsInteger();
            if (limit != null) {
                query.setMaxResults(limit.intValue());
            }
            if (n != null) {
                query.setFirstResult(n.intValue());
            }
        }
        if (this.lockMode != null) {
            query.setLockMode(this.lockMode);
        }
        if (this.flushMode != null) {
            query.setFlushMode(this.flushMode);
        }
        for (Map.Entry entry : this.hints.entrySet()) {
            query.setHint((String)entry.getKey(), entry.getValue());
        }
        Expression projection = this.getMetadata().getProjection();
        this.projection = null;
        if (!forCount && projection instanceof FactoryExpression && !this.queryHandler.transform(query, (FactoryExpression)projection)) {
            this.projection = (FactoryExpression)projection;
        }
        return query;
    }

    private List<?> getResultList(Query query) {
        if (this.projection != null) {
            List results = query.getResultList();
            ArrayList<Object> rv = new ArrayList<Object>(results.size());
            for (Object o : results) {
                if (o != null) {
                    if (!o.getClass().isArray()) {
                        o = new Object[]{o};
                    }
                    rv.add(this.projection.newInstance((Object[])o));
                    continue;
                }
                rv.add(this.projection.newInstance(new Object[]{null}));
            }
            return rv;
        }
        return query.getResultList();
    }

    @Nullable
    private Object getSingleResult(Query query) {
        if (this.projection != null) {
            Object[] result = query.getSingleResult();
            if (result != null) {
                if (!result.getClass().isArray()) {
                    result = new Object[]{result};
                }
                return this.projection.newInstance(result);
            }
            return null;
        }
        return query.getSingleResult();
    }

    public CloseableIterator<T> iterate() {
        try {
            Query query = this.createQuery();
            CloseableIterator closeableIterator = this.queryHandler.iterate(query, this.projection);
            return closeableIterator;
        }
        finally {
            this.reset();
        }
    }

    public Stream<T> stream() {
        try {
            Query query = this.createQuery();
            Stream stream = this.queryHandler.stream(query, this.projection);
            return stream;
        }
        finally {
            this.reset();
        }
    }

    public List<T> fetch() {
        try {
            Query query = this.createQuery();
            List<?> list = this.getResultList(query);
            return list;
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public QueryResults<T> fetchResults() {
        try {
            QueryModifiers modifiers = this.getMetadata().getModifiers();
            if (this.getMetadata().getGroupBy().size() > 1 || this.getMetadata().getHaving() != null) {
                logger.warning("Fetchable#fetchResults() was computed in memory! See the Javadoc for AbstractJPAQuery#fetchResults for more details.");
                Query query = this.createQuery(null, false);
                List resultList = query.getResultList();
                int offset = modifiers.getOffsetAsInteger() == null ? 0 : modifiers.getOffsetAsInteger();
                int limit = modifiers.getLimitAsInteger() == null ? resultList.size() : modifiers.getLimitAsInteger().intValue();
                QueryResults queryResults = new QueryResults(resultList.subList(offset, Math.min(resultList.size(), offset + limit)), modifiers, (long)resultList.size());
                return queryResults;
            }
            Query countQuery = this.createQuery(null, true);
            long total = (Long)countQuery.getSingleResult();
            if (total > 0L) {
                Query query = this.createQuery(modifiers, false);
                List<?> list = this.getResultList(query);
                QueryResults queryResults = new QueryResults(list, modifiers, total);
                return queryResults;
            }
            QueryResults queryResults = QueryResults.emptyResults();
            return queryResults;
        }
        finally {
            this.reset();
        }
    }

    protected void logQuery(String queryString) {
        if (logger.isLoggable(Level.FINEST)) {
            String normalizedQuery = queryString.replace('\n', ' ');
            logger.finest(normalizedQuery);
        }
    }

    @Override
    protected void reset() {
    }

    @Nullable
    public T fetchOne() throws com.querydsl.core.NonUniqueResultException {
        try {
            Query query = this.createQuery(this.getMetadata().getModifiers(), false);
            Object object = this.getSingleResult(query);
            return (T)object;
        }
        catch (NoResultException e) {
            logger.log(Level.FINEST, e.getMessage(), e);
            T t = null;
            return t;
        }
        catch (NonUniqueResultException e) {
            throw new com.querydsl.core.NonUniqueResultException((Exception)((Object)e));
        }
        finally {
            this.reset();
        }
    }

    public Q setLockMode(LockModeType lockMode) {
        this.lockMode = lockMode;
        return (Q)this;
    }

    public Q setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
        return (Q)this;
    }

    public Q setHint(String name, Object value) {
        this.hints.put(name, value);
        return (Q)this;
    }

    @Override
    protected JPQLSerializer createSerializer() {
        return new JPQLSerializer(this.getTemplates(), this.entityManager);
    }

    protected void clone(Q query) {
        this.projection = ((AbstractJPAQuery)query).projection;
        this.flushMode = ((AbstractJPAQuery)query).flushMode;
        this.hints.putAll(((AbstractJPAQuery)query).hints);
        this.lockMode = ((AbstractJPAQuery)query).lockMode;
    }

    public abstract Q clone(EntityManager var1);

    public abstract Q clone(EntityManager var1, JPQLTemplates var2);

    @Override
    public Q clone() {
        return this.clone(this.entityManager, this.getTemplates());
    }
}

