/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.support;

import com.querydsl.core.types.dsl.PathBuilderValidator;
import com.querydsl.core.util.PrimitiveUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;

public class JPAPathBuilderValidator
implements PathBuilderValidator {
    private final Metamodel metamodel;

    public JPAPathBuilderValidator(EntityManager entityManager) {
        this.metamodel = entityManager.getMetamodel();
    }

    public JPAPathBuilderValidator(Metamodel metamodel) {
        this.metamodel = metamodel;
    }

    public Class<?> validate(Class<?> parent, String property, Class<?> propertyType) {
        try {
            ManagedType managedType = this.metamodel.managedType(parent);
            Attribute attribute = managedType.getAttribute(property);
            if (attribute instanceof PluralAttribute) {
                return ((PluralAttribute)attribute).getElementType().getJavaType();
            }
            return PrimitiveUtils.wrap((Class)attribute.getJavaType());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

