/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen.utils.model;

import com.querydsl.codegen.utils.model.SimpleType;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.TypeCategory;
import com.querydsl.codegen.utils.support.ClassUtils;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ClassType
implements Type {
    private final TypeCategory category;
    private final Class<?> javaClass;
    private final String className;
    private final List<Type> parameters;
    private Type arrayType;
    private Type componentType;
    private Type enclosingType;

    public ClassType(Class<?> javaClass, Type ... parameters) {
        this(TypeCategory.SIMPLE, javaClass, Arrays.asList(parameters));
    }

    public ClassType(TypeCategory category, Class<?> clazz, Type ... parameters) {
        this(category, clazz, Arrays.asList(parameters));
    }

    public ClassType(TypeCategory category, Class<?> clazz, List<Type> parameters) {
        this.category = category;
        this.javaClass = clazz;
        this.parameters = parameters;
        this.className = ClassUtils.getFullName(this.javaClass);
    }

    @Override
    public Type as(TypeCategory c) {
        if (this.category == c) {
            return this;
        }
        return new ClassType(c, this.javaClass, new Type[0]);
    }

    @Override
    public Type asArrayType() {
        if (this.arrayType == null) {
            String fullName = ClassUtils.getFullName(this.javaClass) + "[]";
            String simpleName = this.javaClass.getSimpleName() + "[]";
            this.arrayType = new SimpleType(TypeCategory.ARRAY, fullName, this.getPackageName(), simpleName, false, false, new Type[0]);
        }
        return this.arrayType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Type) {
            Type t = (Type)o;
            return t.getFullName().equals(this.className) && t.getParameters().equals(this.parameters);
        }
        return false;
    }

    @Override
    public TypeCategory getCategory() {
        return this.category;
    }

    @Override
    public Type getComponentType() {
        Class<?> clazz = this.javaClass.getComponentType();
        if (clazz != null && this.componentType == null) {
            this.componentType = new ClassType(TypeCategory.SIMPLE, clazz, new Type[0]);
        }
        return this.componentType;
    }

    @Override
    public Type getEnclosingType() {
        Class<?> enclosingClass;
        if (this.enclosingType == null && (enclosingClass = this.javaClass.getEnclosingClass()) != null) {
            this.enclosingType = new ClassType(enclosingClass, new Type[0]);
        }
        return this.enclosingType;
    }

    @Override
    public String getFullName() {
        return this.className;
    }

    @Override
    public String getGenericName(boolean asArgType) {
        return this.getGenericName(asArgType, Collections.singleton("java.lang"), Collections.emptySet());
    }

    @Override
    public String getGenericName(boolean asArgType, Set<String> packages, Set<String> classes) {
        if (this.parameters.isEmpty()) {
            return ClassUtils.getName(this.javaClass, packages, classes);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(ClassUtils.getName(this.javaClass, packages, classes));
        builder.append("<");
        boolean first = true;
        for (Type parameter : this.parameters) {
            if (!first) {
                builder.append(", ");
            }
            if (parameter == null || parameter.getFullName().equals(this.getFullName())) {
                builder.append("?");
            } else {
                builder.append(parameter.getGenericName(false, packages, classes));
            }
            first = false;
        }
        builder.append(">");
        return builder.toString();
    }

    @Override
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public String getPackageName() {
        return ClassUtils.getPackageName(this.javaClass);
    }

    @Override
    public List<Type> getParameters() {
        return this.parameters;
    }

    @Override
    public String getRawName(Set<String> packages, Set<String> classes) {
        return ClassUtils.getName(this.javaClass, packages, classes);
    }

    @Override
    public String getSimpleName() {
        return this.javaClass.getSimpleName();
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.javaClass.getModifiers());
    }

    @Override
    public boolean isPrimitive() {
        return this.javaClass.isPrimitive();
    }

    @Override
    public boolean isMember() {
        return this.javaClass.getEnclosingClass() != null;
    }

    public String toString() {
        return this.getGenericName(true);
    }
}

