/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.FeignException;
import feign.InvocationHandlerFactory;
import feign.Target;
import io.vertx.core.Future;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;

final class VertxInvocationHandler
implements InvocationHandler {
    private final Target<?> target;
    private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;

    private VertxInvocationHandler(Target<?> target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        this.target = target;
        this.dispatch = dispatch;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        switch (method.getName()) {
            case "equals": {
                InvocationHandler otherHandler = args.length > 0 && args[0] != null ? Proxy.getInvocationHandler(args[0]) : null;
                return this.equals(otherHandler);
            }
            case "hashCode": {
                return this.hashCode();
            }
            case "toString": {
                return this.toString();
            }
        }
        if (this.isReturnsFuture(method)) {
            return this.invokeRequestMethod(method, args);
        }
        throw new FeignException(String.format("Method %s of contract %s doesn't return io.vertx.core.Future", method.getName(), method.getDeclaringClass().getSimpleName()));
    }

    private Future invokeRequestMethod(Method method, Object[] args) {
        try {
            return (Future)this.dispatch.get(method).invoke(args);
        }
        catch (Throwable throwable) {
            return Future.failedFuture((Throwable)throwable);
        }
    }

    private boolean isReturnsFuture(Method method) {
        return Future.class.isAssignableFrom(method.getReturnType());
    }

    public boolean equals(Object other) {
        if (other instanceof VertxInvocationHandler) {
            VertxInvocationHandler otherHandler = (VertxInvocationHandler)other;
            return this.target.equals(otherHandler.target);
        }
        return false;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public String toString() {
        return this.target.toString();
    }

    static final class Factory
    implements InvocationHandlerFactory {
        Factory() {
        }

        public InvocationHandler create(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
            return new VertxInvocationHandler(target, dispatch);
        }
    }
}

