/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Capability;
import feign.Client;
import feign.Contract;
import feign.DefaultContract;
import feign.DefaultMethodHandler;
import feign.DefaultRetryer;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.Logger;
import feign.MethodMetadata;
import feign.QueryMapEncoder;
import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.RequestTemplateFactoryResolver;
import feign.Retryer;
import feign.Target;
import feign.Util;
import feign.VertxInvocationHandler;
import feign.VertxMethodHandler;
import feign.codec.Decoder;
import feign.codec.DefaultDecoder;
import feign.codec.DefaultEncoder;
import feign.codec.DefaultErrorDecoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.querymap.FieldQueryMapEncoder;
import feign.vertx.VertxDelegatingContract;
import feign.vertx.VertxHttpClient;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClient;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;

public final class VertxFeign
extends Feign {
    private final ParseHandlersByName targetToHandlersByName;
    private final InvocationHandlerFactory factory;

    private VertxFeign(ParseHandlersByName targetToHandlersByName, InvocationHandlerFactory factory) {
        this.targetToHandlersByName = targetToHandlersByName;
        this.factory = factory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> T newInstance(Target<T> target) {
        Util.checkNotNull(target, (String)"Argument target must be not null", (Object[])new Object[0]);
        Map<String, InvocationHandlerFactory.MethodHandler> nameToHandler = this.targetToHandlersByName.apply(target);
        HashMap<Method, Object> methodToHandler = new HashMap<Method, Object>();
        ArrayList<DefaultMethodHandler> defaultMethodHandlers = new ArrayList<DefaultMethodHandler>();
        for (Method method : target.type().getMethods()) {
            if (Util.isDefault((Method)method)) {
                DefaultMethodHandler handler = new DefaultMethodHandler(method);
                defaultMethodHandlers.add(handler);
                methodToHandler.put(method, handler);
                continue;
            }
            methodToHandler.put(method, nameToHandler.get(Feign.configKey((Class)target.type(), (Method)method)));
        }
        InvocationHandler handler = this.factory.create(target, methodToHandler);
        Object proxy = Proxy.newProxyInstance(target.type().getClassLoader(), new Class[]{target.type()}, handler);
        for (DefaultMethodHandler defaultMethodHandler : defaultMethodHandlers) {
            defaultMethodHandler.bindTo(proxy);
        }
        return (T)proxy;
    }

    private static final class ParseHandlersByName {
        private final Contract contract;
        private final Encoder encoder;
        private final Decoder decoder;
        private final QueryMapEncoder queryMapEncoder;
        private final List<Capability> capabilities;
        private final ErrorDecoder errorDecoder;
        private final VertxMethodHandler.Factory factory;

        private ParseHandlersByName(Contract contract, Encoder encoder, Decoder decoder, QueryMapEncoder queryMapEncoder, List<Capability> capabilities, ErrorDecoder errorDecoder, VertxMethodHandler.Factory factory) {
            this.contract = contract;
            this.factory = factory;
            this.encoder = encoder;
            this.decoder = decoder;
            this.queryMapEncoder = queryMapEncoder;
            this.capabilities = capabilities;
            this.errorDecoder = errorDecoder;
        }

        private Map<String, InvocationHandlerFactory.MethodHandler> apply(Target<?> target) {
            List metadata = this.contract.parseAndValidateMetadata(target.type());
            HashMap<String, InvocationHandlerFactory.MethodHandler> result = new HashMap<String, InvocationHandlerFactory.MethodHandler>();
            for (MethodMetadata metadatum : metadata) {
                Object buildTemplate = !metadatum.formParams().isEmpty() && metadatum.template().bodyTemplate() == null ? new RequestTemplateFactoryResolver.BuildFormEncodedTemplateFromArgs(metadatum, this.encoder, this.queryMapEncoder, target) : (metadatum.bodyIndex() != null || metadatum.alwaysEncodeBody() ? new RequestTemplateFactoryResolver.BuildEncodedTemplateFromArgs(metadatum, this.encoder, this.queryMapEncoder, target) : new RequestTemplateFactoryResolver.BuildTemplateByResolvingArgs(metadatum, this.queryMapEncoder, target));
                result.put(metadatum.configKey(), this.factory.create(target, metadatum, (RequestTemplate.Factory)buildTemplate, this.decoder, this.errorDecoder));
            }
            return result;
        }
    }

    public static final class Builder
    extends Feign.Builder {
        private WebClient webClient;
        private final List<RequestInterceptor> requestInterceptors = new ArrayList<RequestInterceptor>();
        private Logger.Level logLevel = Logger.Level.NONE;
        private Contract contract = new VertxDelegatingContract((Contract)new DefaultContract());
        private Retryer retryer = new DefaultRetryer();
        private Logger logger = new Logger.NoOpLogger();
        private Encoder encoder = new DefaultEncoder();
        private Decoder decoder = new DefaultDecoder();
        private QueryMapEncoder queryMapEncoder = new FieldQueryMapEncoder();
        private List<Capability> capabilities = new ArrayList<Capability>();
        private ErrorDecoder errorDecoder = new DefaultErrorDecoder();
        private long timeout = -1L;
        private boolean decode404;
        private UnaryOperator<HttpRequest<Buffer>> requestPreProcessor = UnaryOperator.identity();

        public Builder client(Client client) {
            throw new UnsupportedOperationException();
        }

        public Builder invocationHandlerFactory(InvocationHandlerFactory invocationHandlerFactory) {
            throw new UnsupportedOperationException();
        }

        public Builder webClient(WebClient webClient) {
            this.webClient = (WebClient)Util.checkNotNull((Object)webClient, (String)"Argument webClient must be not null", (Object[])new Object[0]);
            return this;
        }

        public Builder logLevel(Logger.Level logLevel) {
            this.logLevel = (Logger.Level)Util.checkNotNull((Object)logLevel, (String)"Argument logLevel must be not null", (Object[])new Object[0]);
            return this;
        }

        public Builder contract(Contract contract) {
            Util.checkNotNull((Object)contract, (String)"Argument contract must be not null", (Object[])new Object[0]);
            this.contract = new VertxDelegatingContract(contract);
            return this;
        }

        public Builder retryer(Retryer retryer) {
            this.retryer = (Retryer)Util.checkNotNull((Object)retryer, (String)"Argument retryer must be not null", (Object[])new Object[0]);
            return this;
        }

        public Builder logger(Logger logger) {
            this.logger = (Logger)Util.checkNotNull((Object)logger, (String)"Argument logger must be not null", (Object[])new Object[0]);
            return this;
        }

        public Builder encoder(Encoder encoder) {
            this.encoder = (Encoder)Util.checkNotNull((Object)encoder, (String)"Argument encoder must be not null", (Object[])new Object[0]);
            return this;
        }

        public Builder decoder(Decoder decoder) {
            this.decoder = (Decoder)Util.checkNotNull((Object)decoder, (String)"Argument decoder must be not null", (Object[])new Object[0]);
            return this;
        }

        public Builder queryMapEncoder(QueryMapEncoder queryMapEncoder) {
            this.queryMapEncoder = (QueryMapEncoder)Util.checkNotNull((Object)queryMapEncoder, (String)"Argument queryMapEncoder must be not null", (Object[])new Object[0]);
            return this;
        }

        public Builder addCapability(Capability capability) {
            Util.checkNotNull((Object)capability, (String)"Argument capability must be not null", (Object[])new Object[0]);
            this.capabilities.add(capability);
            return this;
        }

        public Builder decode404() {
            this.decode404 = true;
            return this;
        }

        public Builder errorDecoder(ErrorDecoder errorDecoder) {
            this.errorDecoder = (ErrorDecoder)Util.checkNotNull((Object)errorDecoder, (String)"Argument errorDecoder must be not null", (Object[])new Object[0]);
            return this;
        }

        public Builder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder requestPreProcessor(UnaryOperator<HttpRequest<Buffer>> requestPreProcessor) {
            this.requestPreProcessor = (UnaryOperator)Util.checkNotNull(requestPreProcessor, (String)"Argument requestPreProcessor must be not null", (Object[])new Object[0]);
            return this;
        }

        public Builder requestInterceptor(RequestInterceptor requestInterceptor) {
            Util.checkNotNull((Object)requestInterceptor, (String)"Argument requestInterceptor must be not null", (Object[])new Object[0]);
            this.requestInterceptors.add(requestInterceptor);
            return this;
        }

        public Builder requestInterceptors(Iterable<RequestInterceptor> requestInterceptors) {
            Util.checkNotNull(requestInterceptors, (String)"Argument requestInterceptors must be not null", (Object[])new Object[0]);
            this.requestInterceptors.clear();
            for (RequestInterceptor requestInterceptor : requestInterceptors) {
                this.requestInterceptors.add(requestInterceptor);
            }
            return this;
        }

        public <T> T target(Class<T> apiType, String url) {
            Util.checkNotNull(apiType, (String)"Argument apiType must be not null", (Object[])new Object[0]);
            Util.checkNotNull((Object)url, (String)"Argument url must be not null", (Object[])new Object[0]);
            return this.target((Target<T>)new Target.HardCodedTarget(apiType, url));
        }

        public <T> T target(Target<T> target) {
            return (T)((Feign)this.build()).newInstance(target);
        }

        public Feign.Builder options(Request.Options options) {
            throw new UnsupportedOperationException("Options should be provided directly during construction of Vertx WebClient.");
        }

        public VertxFeign internalBuild() {
            Util.checkNotNull((Object)this.webClient, (String)"Vertx WebClient instance wasn't provided in VertxFeign builder", (Object[])new Object[0]);
            VertxHttpClient client = new VertxHttpClient(this.webClient, this.timeout, this.requestPreProcessor);
            VertxMethodHandler.Factory methodHandlerFactory = new VertxMethodHandler.Factory(client, this.retryer, this.requestInterceptors, this.logger, this.logLevel, this.decode404);
            ParseHandlersByName handlersByName = new ParseHandlersByName(this.contract, this.encoder, this.decoder, this.queryMapEncoder, this.capabilities, this.errorDecoder, methodHandlerFactory);
            VertxInvocationHandler.Factory invocationHandlerFactory = new VertxInvocationHandler.Factory();
            return new VertxFeign(handlersByName, invocationHandlerFactory);
        }
    }
}

