/*
 * Decompiled with CFR 0.152.
 */
package feign.ribbon;

import com.netflix.client.ClientException;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import feign.Client;
import feign.Request;
import feign.Response;
import feign.ribbon.LBClient;
import feign.ribbon.LBClientFactory;
import java.io.IOException;
import java.net.URI;

public class RibbonClient
implements Client {
    private final Client delegate;
    private final LBClientFactory lbClientFactory;

    public static RibbonClient create() {
        return RibbonClient.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public RibbonClient() {
        this((Client)new Client.Default(null, null));
    }

    @Deprecated
    public RibbonClient(Client delegate) {
        this(delegate, new LBClientFactory.Default());
    }

    RibbonClient(Client delegate, LBClientFactory lbClientFactory) {
        this.delegate = delegate;
        this.lbClientFactory = lbClientFactory;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        try {
            URI asUri = URI.create(request.url());
            String clientName = asUri.getHost();
            URI uriWithoutHost = RibbonClient.cleanUrl(request.url(), clientName);
            LBClient.RibbonRequest ribbonRequest = new LBClient.RibbonRequest(this.delegate, request, uriWithoutHost);
            return ((LBClient.RibbonResponse)this.lbClient(clientName).executeWithLoadBalancer(ribbonRequest, (IClientConfig)new FeignOptionsClientConfig(options))).toResponse();
        }
        catch (ClientException e) {
            RibbonClient.propagateFirstIOException(e);
            throw new RuntimeException(e);
        }
    }

    static void propagateFirstIOException(Throwable throwable) throws IOException {
        while (throwable != null) {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throwable = throwable.getCause();
        }
    }

    static URI cleanUrl(String originalUrl, String host) {
        return URI.create(originalUrl.replaceFirst(host, ""));
    }

    private LBClient lbClient(String clientName) {
        return this.lbClientFactory.create(clientName);
    }

    public static final class Builder {
        private Client delegate;
        private LBClientFactory lbClientFactory;

        Builder() {
        }

        public Builder delegate(Client delegate) {
            this.delegate = delegate;
            return this;
        }

        public Builder lbClientFactory(LBClientFactory lbClientFactory) {
            this.lbClientFactory = lbClientFactory;
            return this;
        }

        public RibbonClient build() {
            return new RibbonClient((Client)(this.delegate != null ? this.delegate : new Client.Default(null, null)), this.lbClientFactory != null ? this.lbClientFactory : new LBClientFactory.Default());
        }
    }

    static class FeignOptionsClientConfig
    extends DefaultClientConfigImpl {
        public FeignOptionsClientConfig(Request.Options options) {
            this.setProperty(CommonClientConfigKey.ConnectTimeout, options.connectTimeoutMillis());
            this.setProperty(CommonClientConfigKey.ReadTimeout, options.readTimeoutMillis());
        }

        public void loadProperties(String clientName) {
        }

        public void loadDefaultValues() {
        }
    }
}

