/*
 * Decompiled with CFR 0.152.
 */
package feign.reactive;

import feign.InvocationHandlerFactory;
import feign.Target;
import feign.reactive.ReactiveInvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

public class ReactorInvocationHandler
extends ReactiveInvocationHandler {
    private final Scheduler scheduler;

    ReactorInvocationHandler(Target<?> target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch, Scheduler scheduler) {
        super(target, dispatch);
        this.scheduler = scheduler;
    }

    @Override
    protected Publisher invoke(Method method, InvocationHandlerFactory.MethodHandler methodHandler, Object[] arguments) {
        Publisher<?> invocation = this.invokeMethod(methodHandler, arguments);
        if (Flux.class.isAssignableFrom(method.getReturnType())) {
            return Flux.from(invocation).flatMapIterable(e -> (Iterable)e).subscribeOn(this.scheduler);
        }
        if (Mono.class.isAssignableFrom(method.getReturnType())) {
            return Mono.from(invocation).subscribeOn(this.scheduler);
        }
        throw new IllegalArgumentException("Return type " + method.getReturnType().getName() + " is not supported");
    }
}

