/*
 * Decompiled with CFR 0.152.
 */
package feign.reactive;

import feign.FeignException;
import feign.InvocationHandlerFactory;
import feign.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;

public abstract class ReactiveInvocationHandler
implements InvocationHandler {
    private final Target<?> target;
    private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;

    public ReactiveInvocationHandler(Target<?> target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        this.target = target;
        this.dispatch = dispatch;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("equals".equals(method.getName())) {
            try {
                InvocationHandler otherHandler = args.length > 0 && args[0] != null ? Proxy.getInvocationHandler(args[0]) : null;
                return this.equals(otherHandler);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        if ("hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        if ("toString".equals(method.getName())) {
            return this.toString();
        }
        return this.invoke(method, this.dispatch.get(method), args);
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (ReactiveInvocationHandler.class.isAssignableFrom(obj.getClass())) {
            return this.target.equals(obj);
        }
        return false;
    }

    public String toString() {
        return "Target [" + this.target.toString() + "]";
    }

    protected abstract Publisher invoke(Method var1, InvocationHandlerFactory.MethodHandler var2, Object[] var3);

    Callable<?> invokeMethod(InvocationHandlerFactory.MethodHandler methodHandler, Object[] arguments) {
        return () -> {
            try {
                return methodHandler.invoke(arguments);
            }
            catch (Throwable th) {
                if (th instanceof FeignException) {
                    throw (FeignException)th;
                }
                throw new RuntimeException(th);
            }
        };
    }
}

