/*
 * Decompiled with CFR 0.152.
 */
package feign.moshi;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.Moshi;
import feign.Response;
import feign.Util;
import feign.codec.Decoder;
import feign.codec.JsonDecoder;
import feign.moshi.MoshiFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

public class MoshiDecoder
implements Decoder,
JsonDecoder {
    private final Moshi moshi;

    public MoshiDecoder(Moshi moshi) {
        this.moshi = moshi;
    }

    public MoshiDecoder() {
        this.moshi = new Moshi.Builder().build();
    }

    public MoshiDecoder(Iterable<JsonAdapter<?>> adapters) {
        this(MoshiFactory.create(adapters));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object decode(Response response, Type type) throws IOException {
        JsonAdapter jsonAdapter = this.moshi.adapter(type);
        if (response.status() == 404) return Util.emptyValueOf((Type)type);
        if (response.status() == 204) {
            return Util.emptyValueOf((Type)type);
        }
        if (response.body() == null) {
            return null;
        }
        try (BufferedSource source = Okio.buffer((Source)Okio.source((InputStream)response.body().asInputStream()));){
            if (source.exhausted()) {
                Object var6_7 = null;
                return var6_7;
            }
            Object object = jsonAdapter.fromJson(source);
            return object;
        }
        catch (JsonDataException e) {
            if (e.getCause() == null) throw e;
            if (!(e.getCause() instanceof IOException)) throw e;
            throw (IOException)e.getCause();
        }
    }

    public Object convert(Object object, Type type) throws IOException {
        JsonAdapter adapter = this.moshi.adapter(type);
        return adapter.fromJsonValue(object);
    }
}

