/*
 * Decompiled with CFR 0.152.
 */
package feign.micrometer;

import feign.AsyncClient;
import feign.Capability;
import feign.Client;
import feign.InvocationHandlerFactory;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.micrometer.MeteredAsyncClient;
import feign.micrometer.MeteredClient;
import feign.micrometer.MeteredDecoder;
import feign.micrometer.MeteredEncoder;
import feign.micrometer.MeteredInvocationHandleFactory;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.simple.SimpleConfig;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MicrometerCapability
implements Capability {
    private final MeterRegistry meterRegistry;

    public MicrometerCapability() {
        this((MeterRegistry)new SimpleMeterRegistry(SimpleConfig.DEFAULT, Clock.SYSTEM));
        Metrics.addRegistry((MeterRegistry)this.meterRegistry);
    }

    public MicrometerCapability(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public MicrometerCapability(MeterRegistry meterRegistry, List<Tag> tagsList) {
        meterRegistry.config().commonTags(tagsList);
        this.meterRegistry = meterRegistry;
    }

    public MicrometerCapability(MeterRegistry meterRegistry, Map<String, String> tagsMap) {
        List<Tag> tagsList = this.mapTags(tagsMap);
        meterRegistry.config().commonTags(tagsList);
        this.meterRegistry = meterRegistry;
    }

    public Client enrich(Client client) {
        return new MeteredClient(client, this.meterRegistry);
    }

    public AsyncClient<Object> enrich(AsyncClient<Object> client) {
        return new MeteredAsyncClient(client, this.meterRegistry);
    }

    public Encoder enrich(Encoder encoder) {
        return new MeteredEncoder(encoder, this.meterRegistry);
    }

    public Decoder enrich(Decoder decoder) {
        return new MeteredDecoder(decoder, this.meterRegistry);
    }

    public InvocationHandlerFactory enrich(InvocationHandlerFactory invocationHandlerFactory) {
        return new MeteredInvocationHandleFactory(invocationHandlerFactory, this.meterRegistry);
    }

    private List<Tag> mapTags(Map<String, String> tags) {
        return tags.keySet().stream().map(tagKey -> Tag.of((String)tagKey, (String)((String)tags.get(tagKey)))).collect(Collectors.toList());
    }
}

