/*
 * Decompiled with CFR 0.152.
 */
package feign.micrometer;

import feign.FeignException;
import feign.RequestTemplate;
import feign.Response;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.micrometer.FeignMetricName;
import feign.micrometer.MeteredBody;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Optional;

public class MeteredDecoder
implements Decoder {
    private final Decoder decoder;
    private final MeterRegistry meterRegistry;
    private final FeignMetricName metricName;

    public MeteredDecoder(Decoder decoder, MeterRegistry meterRegistry) {
        this.decoder = decoder;
        this.meterRegistry = meterRegistry;
        this.metricName = new FeignMetricName(Decoder.class);
    }

    public Object decode(Response response, Type type) throws IOException, DecodeException, FeignException {
        Object decoded;
        RequestTemplate template = response.request().requestTemplate();
        Optional<MeteredBody> body = Optional.ofNullable(response.body()).map(MeteredBody::new);
        Response meteredResponse = body.map(b -> response.toBuilder().body((Response.Body)b).build()).orElse(response);
        try {
            decoded = this.meterRegistry.timer(this.metricName.name(), this.metricName.tag(template.methodMetadata(), template.feignTarget(), new Tag[0])).recordCallable(() -> this.decoder.decode(meteredResponse, type));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        body.ifPresent(b -> this.meterRegistry.summary(this.metricName.name("response_size"), this.metricName.tag(template.methodMetadata(), template.feignTarget(), new Tag[0])).record((double)b.count()));
        return decoded;
    }
}

