/*
 * Decompiled with CFR 0.152.
 */
package feign.json;

import feign.Response;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonDecoder
implements Decoder,
feign.codec.JsonDecoder {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object decode(Response response, Type type) throws IOException, DecodeException {
        if (response.status() == 404 || response.status() == 204) {
            if (Map.class.equals((Object)type)) {
                return null;
            }
            if (JSONObject.class.isAssignableFrom((Class)type)) {
                return new JSONObject();
            }
            if (JSONArray.class.isAssignableFrom((Class)type)) {
                return new JSONArray();
            }
            if (String.class.equals((Object)type)) {
                return null;
            }
            throw new DecodeException(response.status(), String.format("%s is not a type supported by this decoder.", type), response.request());
        }
        if (response.body() == null) {
            return null;
        }
        try (Reader reader = response.body().asReader(response.charset());){
            Reader bodyReader = reader.markSupported() ? reader : new BufferedReader(reader);
            bodyReader.mark(1);
            if (bodyReader.read() == -1) {
                Object var6_8 = null;
                return var6_8;
            }
            bodyReader.reset();
            Object object = this.decodeBody(response, type, bodyReader);
            return object;
        }
        catch (JSONException jsonException) {
            if (jsonException.getCause() == null) throw new DecodeException(response.status(), jsonException.getMessage(), response.request(), (Throwable)jsonException);
            if (!(jsonException.getCause() instanceof IOException)) throw new DecodeException(response.status(), jsonException.getMessage(), response.request(), (Throwable)jsonException);
            throw (IOException)jsonException.getCause();
        }
    }

    private Object decodeBody(Response response, Type type, Reader reader) throws IOException {
        if (String.class.equals((Object)type)) {
            return Util.toString((Reader)reader);
        }
        JSONTokener tokenizer = new JSONTokener(reader);
        if (Map.class.equals((Object)type)) {
            return new JSONObject(tokenizer).toMap();
        }
        if (JSONObject.class.isAssignableFrom((Class)type)) {
            return new JSONObject(tokenizer);
        }
        if (JSONArray.class.isAssignableFrom((Class)type)) {
            return new JSONArray(tokenizer);
        }
        throw new DecodeException(response.status(), String.format("%s is not a type supported by this decoder.", type), response.request());
    }

    public Object convert(Object object, Type type) throws IOException {
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (cls == JSONObject.class && object instanceof Map) {
                return new JSONObject((Map)object);
            }
            if (cls == String.class) {
                return object.toString();
            }
        }
        if (object instanceof Map) {
            return new JSONObject((Map)object);
        }
        throw new IOException(type.getTypeName() + " is not a type supported by this decoder.");
    }
}

