/*
 * Decompiled with CFR 0.152.
 */
package feign.jaxrs;

import feign.DeclarativeContract;
import feign.MethodMetadata;
import feign.Request;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

public class JAXRSContract
extends DeclarativeContract {
    static final String ACCEPT = "Accept";
    static final String CONTENT_TYPE = "Content-Type";

    protected MethodMetadata parseAndValidateMetadata(Class<?> targetType, Method method) {
        return super.parseAndValidateMetadata(targetType, method);
    }

    public JAXRSContract() {
        super.registerClassAnnotation(Path.class, (path, data) -> {
            if (path != null && !path.value().isEmpty()) {
                String pathValue = path.value();
                if (!pathValue.startsWith("/")) {
                    pathValue = "/" + pathValue;
                }
                if (pathValue.endsWith("/")) {
                    pathValue = pathValue.substring(0, pathValue.length() - 1);
                }
                pathValue = pathValue.replaceAll("\\{\\s*(.+?)\\s*(:.+?)?\\}", "\\{$1\\}");
                data.template().uri(pathValue);
            }
        });
        super.registerClassAnnotation(Consumes.class, this::handleConsumesAnnotation);
        super.registerClassAnnotation(Produces.class, this::handleProducesAnnotation);
        this.registerMethodAnnotation(methodAnnotation -> {
            Class<? extends Annotation> annotationType = methodAnnotation.annotationType();
            HttpMethod http = annotationType.getAnnotation(HttpMethod.class);
            return http != null;
        }, (methodAnnotation, data) -> {
            Class<? extends Annotation> annotationType = methodAnnotation.annotationType();
            HttpMethod http = annotationType.getAnnotation(HttpMethod.class);
            Util.checkState((data.template().method() == null ? 1 : 0) != 0, (String)"Method %s contains multiple HTTP methods. Found: %s and %s", (Object[])new Object[]{data.configKey(), data.template().method(), http.value()});
            data.template().method(Request.HttpMethod.valueOf((String)http.value()));
        });
        super.registerMethodAnnotation(Path.class, (path, data) -> {
            String pathValue = Util.emptyToNull((String)path.value());
            if (pathValue == null) {
                return;
            }
            String methodAnnotationValue = path.value();
            if (!methodAnnotationValue.startsWith("/") && !data.template().url().endsWith("/")) {
                methodAnnotationValue = "/" + methodAnnotationValue;
            }
            methodAnnotationValue = methodAnnotationValue.replaceAll("\\{\\s*(.+?)\\s*(:.+?)?\\}", "\\{$1\\}");
            data.template().uri(methodAnnotationValue, true);
        });
        super.registerMethodAnnotation(Consumes.class, this::handleConsumesAnnotation);
        super.registerMethodAnnotation(Produces.class, this::handleProducesAnnotation);
        this.registerParamAnnotations();
    }

    private void handleProducesAnnotation(Produces produces, MethodMetadata data) {
        String[] serverProduces = (String[])Util.removeValues((Object[])produces.value(), mediaType -> Util.emptyToNull((String)mediaType) == null, String.class);
        Util.checkState((serverProduces.length > 0 ? 1 : 0) != 0, (String)"Produces.value() was empty on %s", (Object[])new Object[]{data.configKey()});
        data.template().header(ACCEPT, Collections.emptyList());
        data.template().header(ACCEPT, serverProduces);
    }

    private void handleConsumesAnnotation(Consumes consumes, MethodMetadata data) {
        String[] serverConsumes = (String[])Util.removeValues((Object[])consumes.value(), mediaType -> Util.emptyToNull((String)mediaType) == null, String.class);
        Util.checkState((serverConsumes.length > 0 ? 1 : 0) != 0, (String)"Consumes.value() was empty on %s", (Object[])new Object[]{data.configKey()});
        data.template().header(CONTENT_TYPE, serverConsumes);
    }

    protected void registerParamAnnotations() {
        this.registerParameterAnnotation(PathParam.class, (param, data, paramIndex) -> {
            String name = param.value();
            Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"PathParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
            this.nameParam(data, name, paramIndex);
        });
        this.registerParameterAnnotation(QueryParam.class, (param, data, paramIndex) -> {
            String name = param.value();
            Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"QueryParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
            String query = this.addTemplatedParam(name);
            data.template().query(name, new String[]{query});
            this.nameParam(data, name, paramIndex);
        });
        this.registerParameterAnnotation(HeaderParam.class, (param, data, paramIndex) -> {
            String name = param.value();
            Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"HeaderParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
            String header = this.addTemplatedParam(name);
            data.template().header(name, new String[]{header});
            this.nameParam(data, name, paramIndex);
        });
        this.registerParameterAnnotation(FormParam.class, (param, data, paramIndex) -> {
            String name = param.value();
            Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"FormParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
            data.formParams().add(name);
            this.nameParam(data, name, paramIndex);
        });
    }

    protected String addTemplatedParam(String name) {
        return String.format("{%s}", name);
    }
}

