/*
 * Decompiled with CFR 0.152.
 */
package feign.jackson3;

import feign.Response;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.ObjectReader;
import tools.jackson.databind.json.JsonMapper;

public final class Jackson3IteratorDecoder
implements Decoder {
    private final JsonMapper mapper;

    Jackson3IteratorDecoder(JsonMapper mapper) {
        this.mapper = mapper;
    }

    public Object decode(Response response, Type type) throws IOException {
        Reader reader;
        block7: {
            if (response.status() == 404 || response.status() == 204) {
                return Util.emptyValueOf((Type)type);
            }
            if (response.body() == null) {
                return null;
            }
            reader = response.body().asReader(Util.UTF_8);
            if (!reader.markSupported()) {
                reader = new BufferedReader(reader, 1);
            }
            try {
                reader.mark(1);
                if (reader.read() != -1) break block7;
                return null;
            }
            catch (JacksonException e) {
                if (e.getCause() != null && e.getCause() instanceof IOException) {
                    throw (IOException)IOException.class.cast(e.getCause());
                }
                throw e;
            }
        }
        reader.reset();
        return new Jackson3Iterator(Jackson3IteratorDecoder.actualIteratorTypeArgument(type), this.mapper, response, reader);
    }

    private static Type actualIteratorTypeArgument(Type type) {
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Not supported type " + type.toString());
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (!Iterator.class.equals((Object)parameterizedType.getRawType())) {
            throw new IllegalArgumentException("Not an iterator type " + parameterizedType.getRawType().toString());
        }
        return ((ParameterizedType)type).getActualTypeArguments()[0];
    }

    public static Jackson3IteratorDecoder create() {
        return Jackson3IteratorDecoder.create(Collections.emptyList());
    }

    public static Jackson3IteratorDecoder create(Iterable<JacksonModule> modules) {
        return new Jackson3IteratorDecoder(((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_TRAILING_TOKENS})).addModules(modules)).build());
    }

    public static Jackson3IteratorDecoder create(JsonMapper jsonMapper) {
        return new Jackson3IteratorDecoder(jsonMapper);
    }

    static final class Jackson3Iterator<T>
    implements Iterator<T>,
    Closeable {
        private final Response response;
        private final JsonParser parser;
        private final ObjectReader objectReader;
        private T current;

        Jackson3Iterator(Type type, JsonMapper mapper, Response response, Reader reader) throws IOException {
            this.response = response;
            this.parser = mapper.createParser(reader);
            this.objectReader = mapper.reader().forType(mapper.constructType(type));
        }

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                this.current = this.readNext();
            }
            return this.current != null;
        }

        private T readNext() {
            block6: {
                JsonToken jsonToken;
                block5: {
                    try {
                        jsonToken = this.parser.nextToken();
                        if (jsonToken != null) break block5;
                    }
                    catch (JacksonException e) {
                        throw new DecodeException(this.response.status(), e.getMessage(), this.response.request(), (Throwable)e);
                    }
                    return null;
                }
                if (jsonToken == JsonToken.START_ARRAY) {
                    jsonToken = this.parser.nextToken();
                }
                if (jsonToken != JsonToken.END_ARRAY) break block6;
                Util.ensureClosed((Closeable)this);
                return null;
            }
            return (T)this.objectReader.readValue(this.parser);
        }

        @Override
        public T next() {
            if (this.current != null) {
                T tmp = this.current;
                this.current = null;
                return tmp;
            }
            T next = this.readNext();
            if (next == null) {
                throw new NoSuchElementException();
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            Util.ensureClosed((Closeable)this.response);
        }
    }
}

