/*
 * Decompiled with CFR 0.152.
 */
package feign.hystrix;

import feign.Client;
import feign.Contract;
import feign.DefaultContract;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.ResponseMapper;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.hystrix.FallbackFactory;
import feign.hystrix.HystrixDelegatingContract;
import feign.hystrix.HystrixInvocationHandler;
import feign.hystrix.SetterFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;

public final class HystrixFeign {
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends Feign.Builder {
        private Contract contract = new DefaultContract();
        private SetterFactory setterFactory = new SetterFactory.Default();

        public Builder setterFactory(SetterFactory setterFactory) {
            this.setterFactory = setterFactory;
            return this;
        }

        public <T> T target(Target<T> target, T fallback) {
            return (T)this.build(fallback != null ? new FallbackFactory.Default<T>(fallback) : null).newInstance(target);
        }

        public <T> T target(Target<T> target, FallbackFactory<? extends T> fallbackFactory) {
            return (T)this.build(fallbackFactory).newInstance(target);
        }

        public <T> T target(Class<T> apiType, String url, T fallback) {
            return this.target((Target<T>)new Target.HardCodedTarget(apiType, url), fallback);
        }

        public <T> T target(Class<T> apiType, String url, FallbackFactory<? extends T> fallbackFactory) {
            return this.target((Target<T>)new Target.HardCodedTarget(apiType, url), fallbackFactory);
        }

        public Feign.Builder invocationHandlerFactory(InvocationHandlerFactory invocationHandlerFactory) {
            throw new UnsupportedOperationException();
        }

        public Builder contract(Contract contract) {
            this.contract = contract;
            return this;
        }

        public Feign internalBuild() {
            return this.build(null);
        }

        Feign build(final FallbackFactory<?> nullableFallbackFactory) {
            super.invocationHandlerFactory(new InvocationHandlerFactory(){

                public InvocationHandler create(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
                    return new HystrixInvocationHandler(target, dispatch, setterFactory, nullableFallbackFactory);
                }
            });
            super.contract((Contract)new HystrixDelegatingContract(this.contract));
            return super.internalBuild();
        }

        public Builder logLevel(Logger.Level logLevel) {
            return (Builder)super.logLevel(logLevel);
        }

        public Builder client(Client client) {
            return (Builder)super.client(client);
        }

        public Builder retryer(Retryer retryer) {
            return (Builder)super.retryer(retryer);
        }

        public Builder logger(Logger logger) {
            return (Builder)super.logger(logger);
        }

        public Builder encoder(Encoder encoder) {
            return (Builder)super.encoder(encoder);
        }

        public Builder decoder(Decoder decoder) {
            return (Builder)super.decoder(decoder);
        }

        public Builder mapAndDecode(ResponseMapper mapper, Decoder decoder) {
            return (Builder)super.mapAndDecode(mapper, decoder);
        }

        public Builder decode404() {
            return (Builder)super.decode404();
        }

        public Builder dismiss404() {
            return (Builder)super.dismiss404();
        }

        public Builder errorDecoder(ErrorDecoder errorDecoder) {
            return (Builder)super.errorDecoder(errorDecoder);
        }

        public Builder options(Request.Options options) {
            return (Builder)super.options(options);
        }

        public Builder requestInterceptor(RequestInterceptor requestInterceptor) {
            return (Builder)super.requestInterceptor(requestInterceptor);
        }

        public Builder requestInterceptors(Iterable<RequestInterceptor> requestInterceptors) {
            return (Builder)super.requestInterceptors(requestInterceptors);
        }
    }
}

