/*
 * Decompiled with CFR 0.152.
 */
package feign.graphql;

import feign.Experimental;
import feign.Response;
import feign.Util;
import feign.codec.Decoder;
import feign.codec.JsonDecoder;
import feign.graphql.GraphqlContract;
import feign.graphql.GraphqlErrorException;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Experimental
public class GraphqlDecoder
implements Decoder {
    private final JsonDecoder jsonDecoder;

    public GraphqlDecoder(JsonDecoder jsonDecoder) {
        this.jsonDecoder = jsonDecoder;
    }

    public Object decode(Response response, Type type) throws IOException {
        Type targetType = type;
        boolean optional = this.isOptionalType(type);
        if (optional) {
            targetType = this.extractOptionalInnerType(type);
        }
        Optional<Object> result = this.doDecode(response, targetType);
        return optional ? Optional.ofNullable(result) : result;
    }

    private Object doDecode(Response response, Type type) throws IOException {
        List errorList;
        if (response.status() == 404 || response.status() == 204) {
            return Util.emptyValueOf((Type)type);
        }
        if (response.body() == null) {
            return null;
        }
        Map root = (Map)this.jsonDecoder.decode(response, Map.class);
        if (root == null) {
            return Util.emptyValueOf((Type)type);
        }
        Object errors = root.get("errors");
        if (errors instanceof List && !(errorList = (List)errors).isEmpty()) {
            String operationField = this.resolveOperationField(root, response);
            throw new GraphqlErrorException(response.status(), operationField, errors.toString(), response.request());
        }
        Object data = root.get("data");
        if (!(data instanceof Map)) {
            return Util.emptyValueOf((Type)type);
        }
        Map dataMap = (Map)data;
        Iterator fieldNames = dataMap.keySet().iterator();
        if (!fieldNames.hasNext()) {
            return Util.emptyValueOf((Type)type);
        }
        String firstField = (String)fieldNames.next();
        Object operationData = dataMap.get(firstField);
        if (operationData == null) {
            return Util.emptyValueOf((Type)type);
        }
        if (operationData instanceof List) {
            List list = (List)operationData;
            if (!this.isCollectionOrArrayType(type)) {
                if (list.isEmpty()) {
                    return Util.emptyValueOf((Type)type);
                }
                operationData = list.get(0);
            }
        }
        return this.jsonDecoder.convert(operationData, type);
    }

    private String resolveOperationField(Map<String, Object> root, Response response) {
        Map dataMap;
        Iterator names;
        Object data = root.get("data");
        if (data instanceof Map && (names = (dataMap = (Map)data).keySet().iterator()).hasNext()) {
            return (String)names.next();
        }
        if (response.request() != null && response.request().body() != null) {
            try {
                Object query;
                Response fakeResponse = Response.builder().status(200).headers(Collections.emptyMap()).request(response.request()).body(response.request().body()).build();
                Map requestBody = (Map)this.jsonDecoder.decode(fakeResponse, Map.class);
                if (requestBody != null && (query = requestBody.get("query")) instanceof String) {
                    String queryStr = (String)query;
                    return GraphqlContract.extractOperationField(queryStr);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "unknown";
    }

    private boolean isOptionalType(Type type) {
        ParameterizedType pt;
        Type type2;
        if (type instanceof ParameterizedType && (type2 = (pt = (ParameterizedType)type).getRawType()) instanceof Class) {
            Class cls = (Class)type2;
            return cls == Optional.class;
        }
        if (type instanceof Class) {
            Class cls = (Class)type;
            return cls == Optional.class;
        }
        return false;
    }

    private Type extractOptionalInnerType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return pt.getActualTypeArguments()[0];
        }
        return Object.class;
    }

    private boolean isCollectionOrArrayType(Type type) {
        ParameterizedType pt;
        Type type2;
        if (type instanceof Class) {
            Class cls = (Class)type;
            return cls.isArray() || Iterable.class.isAssignableFrom(cls);
        }
        if (type instanceof ParameterizedType && (type2 = (pt = (ParameterizedType)type).getRawType()) instanceof Class) {
            Class cls = (Class)type2;
            return Iterable.class.isAssignableFrom(cls);
        }
        return false;
    }
}

