/*
 * Decompiled with CFR 0.152.
 */
package example.wikipedia;

import example.wikipedia.WikipediaClient;
import jakarta.annotation.PostConstruct;
import java.util.Iterator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;

@SpringBootApplication
@EnableFeignClients
public class WikipediaApplication {
    @Autowired
    private WikipediaClient.Wikipedia wikipedia;

    public static void main(String[] args) {
        SpringApplication.run(WikipediaApplication.class, (String[])args).start();
    }

    @PostConstruct
    public void run() {
        System.out.println("Let's search for PTAL!");
        Iterator<WikipediaClient.Page> pages = WikipediaApplication.lazySearch(this.wikipedia, "PTAL");
        while (pages.hasNext()) {
            System.out.println(pages.next().title);
        }
    }

    static Iterator<WikipediaClient.Page> lazySearch(final WikipediaClient.Wikipedia wikipedia, final String query) {
        final WikipediaClient.Response<WikipediaClient.Page> first = wikipedia.search(query);
        if (first.nextOffset == null) {
            return first.iterator();
        }
        return new Iterator<WikipediaClient.Page>(){
            Iterator<WikipediaClient.Page> current;
            Long nextOffset;
            {
                this.current = first.iterator();
                this.nextOffset = first.nextOffset;
            }

            @Override
            public boolean hasNext() {
                while (!this.current.hasNext() && this.nextOffset != null) {
                    System.out.println("Wow.. even more results than " + this.nextOffset);
                    WikipediaClient.Response<WikipediaClient.Page> nextPage = wikipedia.resumeSearch(query, this.nextOffset);
                    this.current = nextPage.iterator();
                    this.nextOffset = nextPage.nextOffset;
                }
                return this.current.hasNext();
            }

            @Override
            public WikipediaClient.Page next() {
                return this.current.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

