/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.FeignException;
import feign.Request;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class RetryableException
extends FeignException {
    private static final long serialVersionUID = 3L;
    private final Long retryAfter;
    private final Request.HttpMethod httpMethod;
    private final String methodKey;

    public RetryableException(int status, String message, Request.HttpMethod httpMethod, Request request) {
        super(status, message, request);
        this.httpMethod = httpMethod;
        this.retryAfter = null;
        this.methodKey = null;
    }

    public RetryableException(int status, String message, Request.HttpMethod httpMethod, Throwable cause, Request request) {
        super(status, message, request, cause);
        this.httpMethod = httpMethod;
        this.retryAfter = null;
        this.methodKey = null;
    }

    public RetryableException(int status, String message, Request.HttpMethod httpMethod, Throwable cause, Long retryAfter, Request request) {
        super(status, message, request, cause);
        this.httpMethod = httpMethod;
        this.retryAfter = retryAfter;
        this.methodKey = null;
    }

    public RetryableException(int status, String message, Request.HttpMethod httpMethod, Throwable cause, Long retryAfter, Request request, String methodKey) {
        super(status, message, request, cause);
        this.httpMethod = httpMethod;
        this.retryAfter = retryAfter;
        this.methodKey = methodKey;
    }

    @Deprecated
    public RetryableException(int status, String message, Request.HttpMethod httpMethod, Throwable cause, Date retryAfter, Request request) {
        super(status, message, request, cause);
        this.httpMethod = httpMethod;
        this.retryAfter = retryAfter != null ? Long.valueOf(retryAfter.getTime()) : null;
        this.methodKey = null;
    }

    public RetryableException(int status, String message, Request.HttpMethod httpMethod, Long retryAfter, Request request) {
        super(status, message, request);
        this.httpMethod = httpMethod;
        this.retryAfter = retryAfter;
        this.methodKey = null;
    }

    @Deprecated
    public RetryableException(int status, String message, Request.HttpMethod httpMethod, Date retryAfter, Request request) {
        super(status, message, request);
        this.httpMethod = httpMethod;
        this.retryAfter = retryAfter != null ? Long.valueOf(retryAfter.getTime()) : null;
        this.methodKey = null;
    }

    public RetryableException(int status, String message, Request.HttpMethod httpMethod, Long retryAfter, Request request, byte[] responseBody, Map<String, Collection<String>> responseHeaders) {
        super(status, message, request, responseBody, responseHeaders);
        this.httpMethod = httpMethod;
        this.retryAfter = retryAfter;
        this.methodKey = null;
    }

    @Deprecated
    public RetryableException(int status, String message, Request.HttpMethod httpMethod, Date retryAfter, Request request, byte[] responseBody, Map<String, Collection<String>> responseHeaders) {
        super(status, message, request, responseBody, responseHeaders);
        this.httpMethod = httpMethod;
        this.retryAfter = retryAfter != null ? Long.valueOf(retryAfter.getTime()) : null;
        this.methodKey = null;
    }

    public Long retryAfter() {
        return this.retryAfter;
    }

    public Request.HttpMethod method() {
        return this.httpMethod;
    }

    public String methodKey() {
        return this.methodKey;
    }
}

