/*
 * Decompiled with CFR 0.152.
 */
package feign.metrics5;

import feign.Feign;
import feign.FeignException;
import feign.InvocationHandlerFactory;
import feign.Target;
import feign.Util;
import feign.metrics5.FeignMetricName;
import feign.metrics5.MetricSuppliers;
import feign.utils.ExceptionUtils;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeteredInvocationHandleFactory
implements InvocationHandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MeteredInvocationHandleFactory.class);
    private static final List<String> JAVA_OBJECT_METHODS = Arrays.asList("equals", "toString", "hashCode");
    private final InvocationHandlerFactory invocationHandler;
    private final MetricRegistry metricRegistry;
    private final FeignMetricName metricName;
    private final MetricSuppliers metricSuppliers;

    public MeteredInvocationHandleFactory(InvocationHandlerFactory invocationHandler, MetricRegistry metricRegistry, MetricSuppliers metricSuppliers) {
        this.invocationHandler = invocationHandler;
        this.metricRegistry = metricRegistry;
        this.metricSuppliers = metricSuppliers;
        this.metricName = new FeignMetricName(Feign.class);
    }

    public InvocationHandler create(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        Class clientClass = target.type();
        InvocationHandler invocationHandle = this.invocationHandler.create(target, dispatch);
        return (proxy, method, args) -> {
            if (JAVA_OBJECT_METHODS.contains(method.getName()) || Util.isDefault((Method)method)) {
                LOG.trace("Skipping metrics for method={}", (Object)method);
                return invocationHandle.invoke(proxy, method, args);
            }
            try (Timer.Context classTimer = this.metricRegistry.timer(this.metricName.metricName(clientClass, method, target.url()), this.metricSuppliers.timers()).time();){
                Object object = invocationHandle.invoke(proxy, method, args);
                return object;
            }
            catch (FeignException e) {
                this.metricRegistry.meter(this.metricName.metricName(clientClass, method, target.url()).resolve(new String[]{"http_error"}).tagged(new String[]{"http_status", String.valueOf(e.status())}).tagged(new String[]{"error_group", e.status() / 100 + "xx"}), this.metricSuppliers.meters()).mark();
                throw e;
            }
            catch (Throwable e) {
                this.metricRegistry.meter(this.metricName.metricName(clientClass, method, target.url()).resolve(new String[]{"exception"}).tagged(new String[]{"exception_name", e.getClass().getSimpleName()}).tagged(new String[]{"root_cause_name", ExceptionUtils.getRootCause((Throwable)e).getClass().getSimpleName()}), this.metricSuppliers.meters()).mark();
                throw e;
            }
        };
    }
}

